/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class TinyIntConverter
extends AbstractNumericConverter {
    protected TinyIntConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getEstimatedColumnSize() {
        return 2;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 2;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Short)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Short value = (Short)data;
        return dataPart.putShortAsTinyInt(value);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(127).length();
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Short.valueOf(this._getValueAsShort(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true) != 0;
    }

    @Override
    public Short setBoolean(boolean value) throws SQLException {
        return (short)(value ? 1 : 0);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setByte(byte value) throws SQLException {
        return value;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setShort(short value) throws SQLException {
        return value;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setInt(int value) throws SQLException {
        return (short)value;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setLong(long value) throws SQLException {
        return (short)value;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setFloat(float value) throws SQLException {
        return (short)value;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsShort(controller, dataPart, true);
    }

    @Override
    public Short setDouble(double value) throws SQLException {
        return (short)value;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : BigDecimal.valueOf(this._getValueAsShort(controller, dataPart, false));
    }

    @Override
    public Short setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? Short.valueOf(value.shortValue()) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsShort(controller, dataPart, false));
    }

    @Override
    public Short setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._normalizeTinyIntString(value);
    }

    @Override
    public Short setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetConversionException(Arrays.toString(value));
        }
        return (short)(value[0] & 0xFF);
    }

    private short _getValueAsShort(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        if (doNullCheck && dataPart.isNull(controller)) {
            return 0;
        }
        return dataPart.getTinyIntAsShort();
    }

    private Short _normalizeTinyIntString(String value) throws SQLException {
        String v = value.trim();
        if (v.equalsIgnoreCase("TRUE")) {
            return (short)1;
        }
        if (v.equalsIgnoreCase("FALSE")) {
            return (short)0;
        }
        if (v.equalsIgnoreCase("UNKNOWN")) {
            return null;
        }
        try {
            return Short.valueOf(v);
        }
        catch (NumberFormatException e) {
            throw this._newSetConversionException(value, "short");
        }
    }
}

