/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class Tracer {
    public static final DummyTracer DUMMY = new DummyTracer();
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final String CURRENT_WRITE_POSITION = "<CURRENT WRITE POSITION>";
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            return decimalFormat;
        }
    };
    private final boolean _isForOneConnection;
    private final TraceControl _traceControl;
    private final AtomicBoolean _isTraceOn;
    private final AtomicBoolean _isPerformanceTraceOn;
    @GuardedBy(value="this")
    private final PacketAnalyzer _packetAnalyzer;
    @GuardedBy(value="this")
    private final TraceConfiguration _traceConfiguration;
    @GuardedBy(value="this")
    private ConnectionSapDB _connection;
    @GuardedBy(value="this")
    private String _traceFileName;
    @GuardedBy(value="this")
    private File _traceFile;
    @GuardedBy(value="this")
    private long _traceSize;
    @GuardedBy(value="this")
    private RandomAccessFile _log;
    @GuardedBy(value="this")
    private boolean _isWritingHeader;
    @GuardedBy(value="this")
    private int _wrapCount;
    @GuardedBy(value="this")
    private Thread _lastThread;

    public Tracer(boolean isForOneConnection) {
        this._isForOneConnection = isForOneConnection;
        this._traceControl = new TraceControl(this);
        this._isTraceOn = new AtomicBoolean(false);
        this._isPerformanceTraceOn = new AtomicBoolean(false);
        this._packetAnalyzer = new PacketAnalyzer();
        this._traceConfiguration = new TraceConfiguration();
        this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        this._setTraceSize(this._traceConfiguration.getTraceSize());
    }

    public boolean isForOneConnection() {
        return this._isForOneConnection;
    }

    public TraceControl getTraceControl() {
        return this._traceControl;
    }

    public boolean on() {
        return this._isTraceOn.get();
    }

    public boolean pon() {
        return this._isPerformanceTraceOn.get();
    }

    public synchronized ConnectionSapDB getConnection() {
        return this._connection;
    }

    public synchronized void setConnection(ConnectionSapDB connection) {
        this._connection = connection;
    }

    public synchronized File getTraceFile() {
        if (this._traceFile != null) {
            return this._traceFile;
        }
        if (this._traceFileName == null || this._traceFileName.isEmpty()) {
            this._traceFileName = "jdbctrace.prt";
        }
        try {
            String fileName = FileUtils.getFileName(this._traceFileName);
            String fileExtension = FileUtils.getFileExtension(this._traceFileName);
            String directoryName = FileUtils.getDirectoryName(this._traceFileName);
            File directory = FileUtils.createDirectoryIfNecessary(directoryName);
            this._traceFile = File.createTempFile(fileName, fileExtension, directory);
            FileUtils.limitAccessToReadWriteByOwner(this._traceFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._traceFile;
    }

    public synchronized boolean setTraceFileName(String traceFileName) {
        boolean wasNameChanged;
        boolean bl = wasNameChanged = !traceFileName.equals(this._traceFileName);
        if (!wasNameChanged) {
            return false;
        }
        this._traceFileName = traceFileName;
        this._traceFile = null;
        return true;
    }

    public synchronized boolean setTraceSize(String traceSize) {
        try {
            return this._setTraceSize(Long.parseLong(traceSize));
        }
        catch (NumberFormatException e) {
            return this._setTraceSize(Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOn() {
        if (this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(true);
            this._traceConfiguration.setTraceEnabled(true);
            this._open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOff() {
        if (!this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(false);
            this._traceConfiguration.setTraceEnabled(false);
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOn() {
        if (this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(true);
            this._traceConfiguration.setPerformanceTraceEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOff() {
        if (!this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(false);
            this._traceConfiguration.setPerformanceTraceEnabled(false);
            TraceRecordPublisher.getInstance().close();
        }
    }

    public synchronized void checkTraceSettings() {
        if (!this._traceConfiguration.hasTraceSettingsChanged()) {
            return;
        }
        this._traceConfiguration.loadTraceSettings();
        boolean wasTraceFileNameChanged = this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        boolean wasTraceSizeChanged = this._setTraceSize(this._traceConfiguration.getTraceSize());
        if (this._traceConfiguration.isTraceEnabled()) {
            if (wasTraceFileNameChanged || wasTraceSizeChanged) {
                this.switchTraceOff();
            }
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this._traceConfiguration.isTraceEnabled()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void printMessage(String message) {
        if (this._log == null) {
            return;
        }
        this._checkThreadChange();
        this._writeln(message);
    }

    public synchronized void printProperties(Map<String, String> properties, String message) {
        if (this._log == null) {
            return;
        }
        this._checkThreadChange();
        if (message != null) {
            this._writeln(message);
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this._writeln(entry.getKey() + "=" + entry.getValue());
        }
    }

    public synchronized void printThrowable(Throwable t, String message) {
        if (this._log == null) {
            return;
        }
        this._checkThreadChange();
        this._writeln("<-!\nTimestamp: " + new Timestamp(System.currentTimeMillis()));
        if (message != null) {
            this._writeln(message);
        }
        this._writeln(this._getStackTraceString(t));
        this._checkStopOnError(t);
    }

    public synchronized void printCurrentStackTrace(String message) {
        if (this._log == null) {
            return;
        }
        this._checkThreadChange();
        if (message != null) {
            this._writeln(message);
        }
        this._writeln("Stack trace:\n" + this._getStackTraceString(new Throwable()));
    }

    public synchronized void printCall(Object caller, String name, Object ... arguments) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writeln(caller + "." + name + "(" + this._getArgumentsString(arguments) + ")");
    }

    public synchronized void printResult(Object result) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writeln("=> " + result);
    }

    public synchronized void printException(SQLException e) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(0)) {
            return;
        }
        this._checkThreadChange();
        this._writeln("<-!\nTimestamp: " + new Timestamp(System.currentTimeMillis()) + "\n" + this._getStackTraceString(e));
        this._checkStopOnError(e);
    }

    public synchronized void printPacket(byte[] packet) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(1)) {
            return;
        }
        this._checkThreadChange();
        this._packetAnalyzer.parse(packet);
        this._writeln("<Packet " + this._packetAnalyzer.getDisplayPacketHeader() + ">");
        while (this._packetAnalyzer.nextSegment()) {
            this._writeln("  <Segment " + this._packetAnalyzer.getDisplaySegmentHeader() + ">");
            while (this._packetAnalyzer.nextPart()) {
                this._writeln("    <Part " + this._packetAnalyzer.getDisplayPartHeader() + ">");
                this._writeln("      <PartBuffer>");
                this._writeln("        " + this._packetAnalyzer.getDisplayPartDataAsBinaryString());
                this._writeln("        " + this._packetAnalyzer.getDisplayPartData());
                this._writeln("      </PartBuffer>");
                this._writeln("    </Part>");
            }
            this._writeln("  </Segment>");
        }
        this._writeln("</Packet>");
    }

    public synchronized void printDistribution(String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(2)) {
            return;
        }
        this._checkThreadChange();
        this._writeln("DISTRIBUTION: " + message);
    }

    public synchronized void printDistributionState(ConnectionSapDB connection, String message) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(2)) {
            return;
        }
        SessionPool sessionPool = connection.getSessionPool();
        Session anchor = sessionPool.getAnchorSession();
        Session primary = sessionPool.getPrimarySession();
        if (anchor == null || primary == null) {
            return;
        }
        this._checkThreadChange();
        this._writeln("DISTRIBUTION: " + (message != null ? message : ""));
        this._writeln("Connection@" + Integer.toHexString(connection.hashCode()) + " ConnectionID " + anchor.getConnectionID() + " SessionID " + anchor.getSessionID());
        for (Session session : sessionPool.getSessions().values()) {
            this._writeln("  |->" + session + (session == anchor ? " anchor" : "") + (session == primary ? " primary" : ""));
        }
    }

    public synchronized void printSessionOpened(Session session, String sid) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(3)) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Session opened: " + session.toString());
        this._writeln("  Location:" + session.getLocation());
        this._writeln("  SID:" + sid);
    }

    public synchronized void printSessionClosed(Session session) {
        if (this._log == null || !this._traceConfiguration.getTraceLevel().get(3)) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Session closed: " + session.toString());
        this._writeln("  Duration:            " + this._getDisplayDuration(System.currentTimeMillis() - session.getInstantiationTime()));
        this._writeln("  SentPacketCount:     " + session.getSentPacketCount() + " TotalTime: " + this._getDisplayMicroseconds(session.getTotalSendTime()));
        this._writeln("  ReceivedPacketCount: " + session.getReceivedPacketCount() + " TotalTime: " + this._getDisplayMicroseconds(session.getTotalReceiveTime()));
        this._writeln("  SentByteCount:       " + this._getDisplayByteCount(session.getSentByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedSentByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getSentCompressionRatio()));
        this._writeln("  ReceivedByteCount:   " + this._getDisplayByteCount(session.getReceivedByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedReceivedByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getReceivedCompressionRatio()));
    }

    private void _open() {
        File traceFile = this.getTraceFile();
        if (traceFile == null) {
            return;
        }
        this._close();
        try {
            this._log = new RandomAccessFile(traceFile, "rw");
            this._wrapCount = 0;
            this._writeHeader();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void _close() {
        if (this._log == null) {
            return;
        }
        try {
            this._log.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this._log = null;
        }
    }

    private boolean _setTraceSize(long traceSize) {
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        if (traceSize == this._traceSize) {
            return false;
        }
        this._traceSize = traceSize;
        return true;
    }

    private void _writeln(String text) {
        try {
            this._log.write(text.getBytes(CHARSET_UTF_8));
            this._log.write(10);
            this._checkFileSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeHeader() {
        try {
            Set<ConnectionSapDB> connections;
            this._isWritingHeader = true;
            this._writeln("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>");
            this._writeln("Java version: " + Driver.getJavaVersion());
            this._writeln("ClassLoader: " + Tracer.class.getClassLoader());
            this._writeln("Process ID: " + Driver.getProcessID());
            this._writeln("Driver version: " + Driver.getVersionInfo().toString() + "\n");
            if (this._wrapCount > 0) {
                this._writeln("Warning: Trace wrapped around " + this._wrapCount + " times.\n");
            }
            Set<ConnectionSapDB> set = connections = this._isForOneConnection && this._connection != null ? Collections.singleton(this._connection) : Driver.getConnections();
            if (!connections.isEmpty()) {
                this._writeln("Object tree begin:");
                for (ConnectionSapDB connectionSapDB : connections) {
                    this._writeln(connectionSapDB.toString());
                    for (StatementSapDB statement : connectionSapDB.getStatements()) {
                        this._writeln("\t" + statement.toString());
                    }
                }
                this._writeln("Object tree end:");
            }
        }
        finally {
            this._isWritingHeader = false;
        }
    }

    private void _checkFileSize() throws IOException {
        if (this._isWritingHeader || this._traceSize == Long.MAX_VALUE) {
            return;
        }
        long offset = this._log.getFilePointer();
        if (offset + (long)CURRENT_WRITE_POSITION.length() > this._traceSize) {
            while (offset < this._traceSize) {
                this._log.write(32);
                ++offset;
            }
            this._log.seek(0L);
            ++this._wrapCount;
            this._writeHeader();
            offset = this._log.getFilePointer();
        }
        this._log.writeBytes(CURRENT_WRITE_POSITION);
        this._log.seek(offset);
    }

    private void _checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread == this._lastThread) {
            return;
        }
        this._lastThread = thread;
        this._writeln("\n---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()));
    }

    private void _checkStopOnError(Throwable t) {
        int stopOnError = this._traceConfiguration.getStopOnError();
        if (stopOnError != 0 && t instanceof SQLException && ((SQLException)t).getErrorCode() == stopOnError) {
            this._close();
        }
    }

    private String _getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String _getArgumentsString(Object[] arguments) {
        switch (arguments.length) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(arguments[0]);
            }
        }
        StringBuilder builder = new StringBuilder(64);
        for (Object arg : arguments) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(String.valueOf(arg));
        }
        return builder.toString();
    }

    private String _getDisplayDuration(long milliseconds) {
        long s = milliseconds / 1000L;
        return String.format("%d hours %d minutes %d seconds", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    private String _getDisplayMicroseconds(long microseconds) {
        return String.valueOf(microseconds / 1000L) + " ms";
    }

    private String _getDisplayByteCount(long byteCount) {
        return DECIMAL_FORMAT.get().format((double)byteCount / 1048576.0) + " MB";
    }

    private String _getDisplayCompressionRatio(double ratio) {
        return DECIMAL_FORMAT.get().format(ratio);
    }

    public static class DummyTracer
    extends Tracer {
        private DummyTracer() {
            super(false);
        }

        @Override
        public boolean on() {
            return false;
        }

        @Override
        public boolean pon() {
            return false;
        }
    }
}

