package com.sap.dbmtk.demo;

import java.awt.Window;
import java.sql.Types;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sap.dbmtk.demo.ui.GTable;

import net.miginfocom.swing.MigLayout;

public class AddOrChangeStore
extends AddOrChangeAbstract
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "Store";

	private int        _store_id         = -1;
	private JLabel     _store_id_lbl     = new JLabel("store_id");
	private JTextField _store_id_txt     = new JTextField(10);
	
	private JLabel     _store_name_lbl   = new JLabel("Store Name");
	private JTextField _store_name_txt   = new JTextField(50);
	
	private JLabel     _address_lbl      = new JLabel("Address");
	private JTextField _address_txt      = new JTextField();
	
	private JLabel     _city_lbl         = new JLabel("City");
	private JTextField _city_txt         = new JTextField();
	
	private JLabel     _state_lbl        = new JLabel("State");
	private JTextField _state_txt        = new JTextField();
	
	private JLabel     _country_lbl      = new JLabel("Country");
	private JTextField _country_txt      = new JTextField();
	
	private JLabel     _postalcode_lbl   = new JLabel("Postal Code");
	private JTextField _postalcode_txt   = new JTextField();
	
	public AddOrChangeStore(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() || isDelete() )
		{
			_store_id_txt.setEnabled(false);
			panel.add(_store_id_lbl, "");
			panel.add(_store_id_txt, "growx, pushx, wrap 20");
		}

		panel.add(_store_name_lbl, "");
		panel.add(_store_name_txt, "growx, pushx, wrap");

		panel.add(_address_lbl,    "");
		panel.add(_address_txt,    "growx, pushx, wrap");

		panel.add(_city_lbl,       "");
		panel.add(_city_txt,       "growx, pushx, wrap");
		
		panel.add(_state_lbl,      "");
		panel.add(_state_txt,      "growx, pushx, wrap");
		
		panel.add(_country_lbl,    "");
		panel.add(_country_txt,    "growx, pushx, wrap");
		
		panel.add(_postalcode_lbl, "");
		panel.add(_postalcode_txt, "growx, pushx, wrap 20");

		if ( isDelete())
		{
			_store_name_txt .setEnabled(false);
			_address_txt    .setEnabled(false);
			_city_txt       .setEnabled(false);
			_state_txt      .setEnabled(false);
			_country_txt    .setEnabled(false);
			_postalcode_txt .setEnabled(false);
		}

		return panel;
	}

	@Override
	public void setFields(GTable table, int vrow)
	{
		_store_id       = table.getValueAsInteger(vrow, "store_id", false);
		_store_id_txt   .setText(""+_store_id);

		_store_name_txt .setText(table.getValueAsString(vrow, "store_name", false));
		_address_txt    .setText(table.getValueAsString(vrow, "address",    false));
		_city_txt       .setText(table.getValueAsString(vrow, "city",       false));
		_state_txt      .setText(table.getValueAsString(vrow, "state",      false));
		_country_txt    .setText(table.getValueAsString(vrow, "country",    false));
		_postalcode_txt .setText(table.getValueAsString(vrow, "postalcode", false));
	}

//	public String getStoreId()    { return _store_id_txt  .getText(); }

	public String getStoreName()  { return getStringValue(_store_name_txt); }
	public String getAddress()    { return getStringValue(_address_txt   ); }
	public String getCity()       { return getStringValue(_city_txt      ); }
	public String getState()      { return getStringValue(_state_txt     ); }
	public String getCountry()    { return getStringValue(_country_txt   ); }
	public String getPostalCode() { return getStringValue(_postalcode_txt); }

	
	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call insert_store(?, ?, ?, ?, ?, ?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("first_name", Types.VARCHAR, getStoreName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("last_name",  Types.VARCHAR, getAddress()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("phone",      Types.VARCHAR, getCity()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("address",    Types.VARCHAR, getState()      ) );
		stmnt.addParam( SqlStatementParam.createInParam("city",       Types.VARCHAR, getCountry()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("state",      Types.VARCHAR, getPostalCode() ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call update_store(?, ?, ?, ?, ?, ?, ?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("store_id",   Types.INTEGER, _store_id) );

		stmnt.addParam( SqlStatementParam.createInParam("first_name", Types.VARCHAR, getStoreName()  ) );
		stmnt.addParam( SqlStatementParam.createInParam("last_name",  Types.VARCHAR, getAddress()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("phone",      Types.VARCHAR, getCity()       ) );
		stmnt.addParam( SqlStatementParam.createInParam("address",    Types.VARCHAR, getState()      ) );
		stmnt.addParam( SqlStatementParam.createInParam("city",       Types.VARCHAR, getCountry()    ) );
		stmnt.addParam( SqlStatementParam.createInParam("state",      Types.VARCHAR, getPostalCode() ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(SqlStatement.Type.CALLABLE, "{call delete_store(?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("store_id",   Types.INTEGER, _store_id) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}

//	public static HashMap<String, Integer> getStoresLookup(Window owner, ConnectionProvider connProvider)
//	{
//		LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
//		
////		String sql = "select store_name, store_id from stores \n";
//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_stores_lookup(?, ?)}");
//		stmnt.addParam( SqlStatementParam.createInParam("store_name", Types.VARCHAR, "") );
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
//
//		try
//		{
//			ResultSet rs = stmnt.executeQuery(connProvider);
//			int rowc = 0;
//			while(rs.next())
//			{
//				rowc++;
//				map.put(rs.getString(1), rs.getInt(2));
//			}
//			SqlTraceWindow.getInstance().addRowcount( rowc );
//
//			SqlStatement.putWarningMessages(connProvider, null, rs);
//			rs.close();
//		}
//		catch (SQLException e)
//		{
//			SqlStatement.showErrorMessage(e, stmnt, owner, "Getting Stores (name,id) <b>failed.</b>");
//		}
//		
//		return map;
//	}
}
