package com.sap.dbmtk.demo;

import com.sap.dbmtk.demo.utils.DbUtils;

public class DbMessageDbmsOutput extends DbMessage
{
	private String _product = null;
	public DbMessageDbmsOutput(String msg, String product)
	{
		super(msg);
		_product = product;
	}

	@Override
	public String toHtml()
	{
		return "<i><font color=\"blue\">"+getLabel()+": </font></i>" + getMsg();
	}

	private String getLabel()
	{
		if (DbUtils.isProductName(_product, DbUtils.DB_PROD_NAME_ORACLE, DbUtils.DB_PROD_NAME_DB2_UX))
			return "DBMS_OUTPUT.GET_LINE";

		if (DbUtils.isProductName(_product, DbUtils.DB_PROD_NAME_SYBASE_ASE, DbUtils.DB_PROD_NAME_SYBASE_ASA, DbUtils.DB_PROD_NAME_SYBASE_IQ ))
			return "DBMTK_GET_BUFFERED_OUTPUT";
		
		return "";
	}
}
