/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Settings;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriverBase;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import com.sybase.util.ds.ldap.SyASEServer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyInterfacesDriver
extends SyInterfacesDriverBase {
    private Hashtable<String, SyInterfacesEntry> _lookup = new Hashtable();

    public SyInterfacesDriver() {
    }

    public SyInterfacesDriver(String string) throws Exception, InterfacesException {
        this(string, false, 0);
    }

    public SyInterfacesDriver(String string, boolean bl) throws Exception, InterfacesException {
        this(string, bl, 0);
    }

    public SyInterfacesDriver(String string, boolean bl, int n) throws Exception, InterfacesException {
        super(string, bl, n);
        this.fetch();
    }

    public void setBundle(String string) {
        this._fileName = string;
    }

    public String getBundle() {
        return this._fileName;
    }

    public void setSaveOnChange(boolean bl) {
        this._saveOnChange = bl;
    }

    public boolean getSaveOnChange() {
        return this._saveOnChange;
    }

    public void open(String string) throws Exception, InterfacesException {
        Serializable serializable;
        String string2 = null;
        if (Utils.isNormalPath(string)) {
            serializable = new File(string);
            if (serializable.isFile()) {
                string2 = string;
            } else if (serializable.isDirectory()) {
                string2 = SyInterfacesDriver.getInterfacesFilePath(string);
            }
        }
        if (string2 == null) {
            this._fileName = null;
            serializable = new InterfacesException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_INTERFACES", "");
            throw serializable;
        }
        super.load(string2, false, 0);
        this.fetch();
    }

    public static String getInterfacesFilePath(String string) {
        String string2 = null;
        string2 = Utils.OS_WINDOWS ? string + System.getProperty("file.separator") + "ini" + System.getProperty("file.separator") + "sql.ini" : string + System.getProperty("file.separator") + "interfaces";
        return string2;
    }

    public void open() throws Exception, InterfacesException {
        if (Settings.getUseDefaultInterfaces()) {
            this.open(Utils.getSybasePath());
        } else {
            this.open(Settings.getCustomInterfacesPath());
        }
    }

    public synchronized void refresh() throws IOException {
        this.loadFile();
        this.parseLines();
        this.fetch();
    }

    public Enumeration<String> servers() {
        return this._lookup.keys();
    }

    public String[] getServers() {
        return this.getServers(0);
    }

    public String[] getServers(int n) {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = this._lookup.keys();
        while (objectArray.hasMoreElements()) {
            vector.addElement(objectArray.nextElement());
        }
        if (vector.size() > 0) {
            if (n != 0) {
                Collections.sort(vector);
            }
            if (n < 0) {
                Collections.reverse(vector);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Enumeration<SyInterfacesEntry> entries() {
        return this._lookup.elements();
    }

    public Vector<SyInterfacesEntry> getEntries() {
        Vector<SyInterfacesEntry> vector = new Vector<SyInterfacesEntry>();
        Enumeration<SyInterfacesEntry> enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyInterfacesEntry syInterfacesEntry = enumeration.nextElement();
            vector.addElement(syInterfacesEntry);
        }
        return vector;
    }

    public Vector<SyASEServer> getASEServers() {
        Vector<SyASEServer> vector = new Vector<SyASEServer>();
        Enumeration<SyInterfacesEntry> enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyInterfacesEntry syInterfacesEntry = enumeration.nextElement();
            vector.addElement(new SyASEServer(syInterfacesEntry));
        }
        return vector;
    }

    public synchronized boolean contains(SyInterfacesEntry syInterfacesEntry) {
        if (syInterfacesEntry == null) {
            return false;
        }
        this.fetch();
        return this.containsServer(syInterfacesEntry.getName());
    }

    public synchronized boolean containsServer(String string) {
        return this._lookup.containsKey(string);
    }

    public SyInterfacesEntry getEntry(String string) {
        return this._lookup.get(string);
    }

    public SyInterfacesEntry getEntryIgnoreCase(String string) {
        Enumeration<String> enumeration = this._lookup.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return this.getEntry(string2);
        }
        return null;
    }

    public synchronized boolean addEntry(SyInterfacesEntry syInterfacesEntry) throws IOException {
        if (syInterfacesEntry == null || syInterfacesEntry.getName() == null) {
            return false;
        }
        if (!this.contains(syInterfacesEntry)) {
            this._lookup.put(syInterfacesEntry.getName(), syInterfacesEntry);
            this.addSubjectLine(syInterfacesEntry.getName());
            List<Service> list = syInterfacesEntry.getServices();
            for (Service service : list) {
                this.setValue(syInterfacesEntry.getName(), service);
            }
            return true;
        }
        return false;
    }

    private void fetch() {
        this._lookup.clear();
        String[] stringArray = this.getSubjects();
        for (int i = 0; i < stringArray.length; ++i) {
            SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(stringArray[i]);
            List<Service> list = this.getServices(stringArray[i]);
            syInterfacesEntry.setServices(list);
            this._lookup.put(stringArray[i], syInterfacesEntry);
        }
    }

    public String toString() {
        Enumeration<SyInterfacesEntry> enumeration = this.entries();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public static String setProperty(String string) throws InterfacesException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                return System.setProperty(string2, string3);
            }
            InterfacesException interfacesException = new InterfacesException("ERR_PARAM_PARSE_ERROR", new String[]{string});
            throw interfacesException;
        }
        InterfacesException interfacesException = new InterfacesException(string);
        throw interfacesException;
    }

    @Override
    public void setLine(String string, Service service) {
        super.setLine(string, service);
    }
}

