/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybBinaryClientLob;
import com.sybase.jdbc4.jdbc.SybBinaryLob;
import com.sybase.jdbc4.jdbc.SybCharClientLob;
import com.sybase.jdbc4.jdbc.SybCharLob;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.tds.SybTimestamp;
import com.sybase.jdbc4.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Convert {
    private static final long LOW_BYTE = 255L;
    public static final char[] DATE_SEPARATORS = new char[]{' ', ',', '-', '/', '\\', '.'};
    private static final char[] MONTH_START_CHAR = new char[]{'a', 'd', 'f', 'j', 'm', 'n', 'o', 's'};
    private static final String DATE_PATTERN_YYYYMMDD = "[0-9]{8}";
    private static final String DATE_PATTERN_YYMMDD = "[0-9]{6}";
    private static final String DATE_PATTERN_YYYY = "[0-9]{4}";
    private static final String DATE_PATTERN_YYYY_MM_DD = "[0-9]{4}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}";
    private static final String DATE_PATTERN_MM_YYYY_DD = "[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{4}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}";
    private static final String DATE_PATTERN_MM_DD_YYYY = "[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,4}";
    private static final String DATE_PATTERN_DD_YYYY_MON = "[0-9]{1,2}[ ]*[ \\.-/]{1}[ ]*[0-9]{1,4}[ ]*[ \\-/.]{1}[ ]*[a-zA-Z]{3,9}";
    private static final String DATE_PATTERN_DD_MON_YYYY = "[0-9]{1,2}[ ]*[ \\.-/]{1}[ ]*[a-zA-Z]{3,9}[ ]*[ \\.-/]{1}[ ]*[0-9]{1,4}";
    private static final String DATE_PATTERN_MON_DD_YYYY = "[a-zA-Z]{3,9}[ \\-/,.]{1}[ ]*[0-9]{1,2}[ ]*[ \\,.-/]{1}[ ]*[0-9]{1,4}";
    private static final String DATE_PATTERN_YYYY_MON_DD = "[0-9]{4}[ ]*[ \\.,-/]{1}[ ]*[a-zA-Z]{3,9}[ ]*[ \\.,-/]{1}[ ]*[0-9]{1,2}";
    private static final String[] DATE_PATTERNS = new String[]{"[0-9]{4}", "[0-9]{6}", "[0-9]{8}", "[0-9]{4}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}", "[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{4}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}", "[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,2}[ ]*[\\-/.]{1}[ ]*[0-9]{1,4}", "[0-9]{1,2}[ ]*[ \\.-/]{1}[ ]*[0-9]{1,4}[ ]*[ \\-/.]{1}[ ]*[a-zA-Z]{3,9}", "[0-9]{1,2}[ ]*[ \\.-/]{1}[ ]*[a-zA-Z]{3,9}[ ]*[ \\.-/]{1}[ ]*[0-9]{1,4}", "[0-9]{4}[ ]*[ \\.,-/]{1}[ ]*[a-zA-Z]{3,9}[ ]*[ \\.,-/]{1}[ ]*[0-9]{1,2}", "[a-zA-Z]{3,9}[ \\-/,.]{1}[ ]*[0-9]{1,2}[ ]*[ \\,.-/]{1}[ ]*[0-9]{1,4}"};
    private static final int MICRO_TO_NANO = 1000;
    private static final int MILLIS_TO_NANO = 1000000;
    private static final int SECONDS_TO_NANO = 1000000000;
    private static final String TIME_PATTERN = "([01]?[0-9]|2[0-3])((([ ]*[:]{1}[ ]*[0-5]?[0-9]){0,2})([ ]*[aApP]{1}[mM]{1})|(([ ]*[:]{1}[ ]*[0-5]?[0-9]){1,2}([ ]*[:.]{1}[ ]*[0-9]{1,9})?)([ ]*[aApP]{1}[mM]{1})?)";

    private Convert() {
    }

    public static final String objectToString(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return HexConverts.hexConvert((byte[])object);
        }
        if (object instanceof Reader) {
            ErrorMessage.raiseError("JZ0IR");
        }
        return object.toString();
    }

    public static final InputStream objectToStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof InputStream) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TE", "String, byte[]");
        return null;
    }

    public static final Reader objectToReader(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        if (object instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])object));
        }
        if (object instanceof InputStream) {
            return new InputStreamReader((InputStream)object);
        }
        if (object instanceof Reader) {
            ErrorMessage.raiseError("JZ0IS");
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static Boolean objectToBoolean(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof String && !((String)object).trim().equals("0") && !((String)object).trim().equals("1")) {
            return new Boolean((String)object);
        }
        double d = Convert.objectToDoubleValue(object);
        return new Boolean(d != 0.0);
    }

    public static Integer objectToUSmallInt(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l = Convert.objectToLongValue(object);
        Convert.checkUSmallIntOflo(l);
        return new Integer((int)l);
    }

    public static Integer objectToUInt(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l = Convert.objectToLongValue(object);
        Convert.checkUintOflo(l);
        return new Integer((int)l);
    }

    public static BigDecimal objectToUBigInt(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
            Convert.checkUBigintOflo(bigDecimal);
            return bigDecimal;
        }
        if (object instanceof String || object instanceof Long) {
            try {
                BigDecimal bigDecimal = new BigDecimal(Convert.numString(object));
                Convert.checkUBigintOflo(bigDecimal);
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
        Convert.checkUBigintOflo(bigDecimal);
        return new BigDecimal(Convert.objectToDoubleValue(object));
    }

    public static Integer objectToInt(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        long l = Convert.objectToLongValue(object);
        Convert.checkIntOflo(l);
        return new Integer((int)l);
    }

    public static Short objectToShort(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        long l = Convert.objectToLongValue(object);
        Convert.checkShortOflo(l);
        return new Short((short)l);
    }

    public static Long objectToLong(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        BigDecimal bigDecimal = Convert.objectToBigDecimal(object);
        Convert.checkLongOflo(bigDecimal);
        long l = Convert.objectToLongValue(object);
        return new Long(l);
    }

    public static Float objectToFloat(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        return new Float(Convert.objectToDoubleValue(object));
    }

    public static Double objectToDouble(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return new Double(Convert.objectToDoubleValue(object));
    }

    public static double objectToDoubleValue(Object object) throws SQLException {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof byte[]) {
            return Convert.bufToDouble((byte[])object);
        }
        if (object instanceof String) {
            try {
                return new Double(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, Short, byte[], String");
        return 0.0;
    }

    public static long objectToLongValue(Object object) throws SQLException {
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Double) {
            return ((Double)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).longValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof byte[]) {
            return Convert.bufToLong((byte[])object);
        }
        if (object instanceof String) {
            try {
                return new Long(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Boolean, Integer, Long, Short, byte[], String");
        return 0L;
    }

    public static BigDecimal objectToBigDecimal(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof String || object instanceof Long) {
            try {
                return new BigDecimal(Convert.numString(object));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            }
        }
        return new BigDecimal(Convert.objectToDoubleValue(object));
    }

    public static byte[] objectToBytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            if (n == 0) {
                return new byte[0];
            }
            if ((n & 1) == 0) {
                byte[] byArray = new byte[string.length() / 2 - 1];
                int n2 = 2;
                int n3 = 0;
                while (n2 < string.length()) {
                    byArray[n3] = (byte)(16 * Convert.hexToDecimal(string.charAt(n2)) + Convert.hexToDecimal(string.charAt(n2 + 1)));
                    n2 += 2;
                    ++n3;
                }
                return byArray;
            }
        }
        if (object instanceof SybBinaryClientLob) {
            return ((SybBinaryClientLob)object).getBytes();
        }
        ErrorMessage.raiseError("JZ0TE", "Double, Float, BigDecimal, Integer, Long");
        return null;
    }

    public static Date objectToDate(Object object, String string) throws SQLException {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof String) {
            object2 = Convert.numString(object);
            int n = ((String)object2).indexOf(" ");
            Object object3 = object2;
            if (n > 0) {
                object3 = ((String)object2).substring(0, n);
            }
            try {
                return Date.valueOf((String)object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    String string2 = Convert.convertToASEAcceptableFullDateTimeFormat((String)object2, string);
                    return Date.valueOf(Convert.getDatePart(string2));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    ErrorMessage.raiseError("JZ009", illegalArgumentException2.toString());
                }
            }
        }
        if (object instanceof Timestamp) {
            object2 = (Timestamp)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime((java.util.Date)object2);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new Date(calendar.getTime().getTime());
        }
        if (object instanceof DateObject) {
            object2 = (Calendar)((DateObject)object).getCalendar().clone();
            ((Calendar)object2).set(11, 0);
            ((Calendar)object2).set(12, 0);
            ((Calendar)object2).set(13, 0);
            ((Calendar)object2).set(14, 0);
            return new Date(((Calendar)object2).getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    private static String getDatePart(String string) {
        int n = string.indexOf(32);
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String getTimePart(String string) {
        String string2 = string.substring(string.indexOf(32) + 1);
        return string2.length() < 8 ? string2 : string2.substring(0, 8);
    }

    private static String convertToASEAcceptableFullDateTimeFormat(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("")) {
            return Convert.getDefaultDate(string2) + " " + Convert.getDefaultTime(string2);
        }
        if (string.matches("^([01]?[0-9]|2[0-3])((([ ]*[:]{1}[ ]*[0-5]?[0-9]){0,2})([ ]*[aApP]{1}[mM]{1})|(([ ]*[:]{1}[ ]*[0-5]?[0-9]){1,2}([ ]*[:.]{1}[ ]*[0-9]{1,9})?)([ ]*[aApP]{1}[mM]{1})?)$")) {
            return Convert.getDefaultDate(string2) + " " + Convert.parseTime(string, string2);
        }
        for (int i = 0; i < DATE_PATTERNS.length; ++i) {
            if (string.matches("^" + DATE_PATTERNS[i] + "$")) {
                return Convert.parseDate(DATE_PATTERNS[i], string, string2) + " " + Convert.getDefaultTime(string2);
            }
            if (string.matches("^" + DATE_PATTERNS[i] + "[ ]*" + TIME_PATTERN + "$")) {
                return Convert.parseDate(DATE_PATTERNS[i], string.split(TIME_PATTERN)[0], string2) + " " + Convert.parseTime(string.split(DATE_PATTERNS[i])[1], string2);
            }
            if (!string.matches("^([01]?[0-9]|2[0-3])((([ ]*[:]{1}[ ]*[0-5]?[0-9]){0,2})([ ]*[aApP]{1}[mM]{1})|(([ ]*[:]{1}[ ]*[0-5]?[0-9]){1,2}([ ]*[:.]{1}[ ]*[0-9]{1,9})?)([ ]*[aApP]{1}[mM]{1})?)[ ]*" + DATE_PATTERNS[i] + "$")) continue;
            return Convert.parseDate(DATE_PATTERNS[i], string.split(TIME_PATTERN)[1], string2) + " " + Convert.parseTime(string.split(DATE_PATTERNS[i])[0], string2);
        }
        return string;
    }

    private static String parseDate(String string, String string2, String string3) {
        string2 = string2.trim();
        if (string.equals(DATE_PATTERN_YYYY)) {
            return Convert.parseDateYYYY(string2, string3);
        }
        if (string.equals(DATE_PATTERN_YYMMDD)) {
            return Convert.parseDateYyMmDdNoSeparator(string2, string3);
        }
        if (string.equals(DATE_PATTERN_YYYYMMDD)) {
            return Convert.parseDateYyyyMmDdNoSeparator(string2, string3);
        }
        if (string.equals(DATE_PATTERN_YYYY_MM_DD)) {
            return Convert.parseDateYyyyMmDd(string2, string3);
        }
        if (string.equals(DATE_PATTERN_MM_YYYY_DD)) {
            return Convert.parseDateMmYyyyDd(string2, string3);
        }
        if (string.equals(DATE_PATTERN_MM_DD_YYYY)) {
            return Convert.parseDateMmDdYyYy(string2, string3);
        }
        if (string.equals(DATE_PATTERN_DD_YYYY_MON)) {
            return Convert.parseDateDdYyYyMon(string2, string3);
        }
        if (string.equals(DATE_PATTERN_DD_MON_YYYY)) {
            return Convert.parseDateDdMonYyyy(string2, string3);
        }
        if (string.equals(DATE_PATTERN_YYYY_MON_DD)) {
            return Convert.parseDateYyyyMondd(string2, string3);
        }
        if (string.equals(DATE_PATTERN_MON_DD_YYYY)) {
            return Convert.parseDateMonDdYyYy(string2, string3);
        }
        if (string.equals("")) {
            return Convert.getDefaultDate(string3);
        }
        return string2;
    }

    private static final String parseDateYYYY(String string, String string2) {
        return Convert.convertToValidYear(string) + "-01-01";
    }

    private static final String parseDateYyMmDdNoSeparator(String string, String string2) {
        return Convert.convertToValidYear(string.substring(0, 2)) + "-" + string.substring(2, 4) + "-" + string.substring(4, 6);
    }

    private static final String parseDateYyyyMmDdNoSeparator(String string, String string2) {
        return Convert.convertToValidYear(string.substring(0, 4)) + "-" + string.substring(4, 6) + "-" + string.substring(6, 8);
    }

    private static final String parseDateYyyyMmDd(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string3 = string.substring(0, 4);
        string3 = Convert.convertToValidYear(string3);
        if (!Character.isDigit((string = string.substring(5).trim()).charAt(0))) {
            string = string.substring(1).trim();
        }
        if (Character.isDigit(string.charAt(1))) {
            string4 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string4 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        if (!Character.isDigit(string.charAt(0))) {
            string = string.substring(1).trim();
        }
        string5 = string.length() > 1 && Character.isDigit(string.charAt(1)) ? string.substring(0, 2) : "0" + string.substring(0, 1);
        return string3 + "-" + string4 + "-" + string5;
    }

    private static final String parseDateMmYyyyDd(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (Character.isDigit(string.charAt(1))) {
            string4 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string4 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        if (!Character.isDigit(string.charAt(0))) {
            string = string.substring(1).trim();
        }
        string3 = string.substring(0, 4);
        string3 = Convert.convertToValidYear(string3);
        if (!Character.isDigit((string = string.substring(5).trim()).charAt(0))) {
            string = string.substring(1).trim();
        }
        string5 = string.length() > 1 && Character.isDigit(string.charAt(1)) ? string.substring(0, 2) : "0" + string.substring(0, 1);
        return string3 + "-" + string4 + "-" + string5;
    }

    private static final String parseDateMmDdYyYy(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (Character.isDigit(string.charAt(1))) {
            string4 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string4 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        if (!Character.isDigit(string.charAt(0))) {
            string = string.substring(1).trim();
        }
        if (Character.isDigit(string.charAt(1))) {
            string5 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string5 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        if (!Character.isDigit(string.charAt(0))) {
            string = string.substring(1).trim();
        }
        string3 = Convert.convertToValidYear(string);
        return string3 + "-" + string4 + "-" + string5;
    }

    private static String convertToValidYear(String string) {
        int n = Integer.parseInt(string);
        if (n < 50) {
            n += 2000;
        } else if (n < 100) {
            n += 1900;
        }
        return "" + n;
    }

    private static final String parseDateDdYyYyMon(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (Character.isDigit(string.charAt(1))) {
            string5 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string5 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        if (!Character.isDigit(string.charAt(0))) {
            string = string.substring(1).trim();
        }
        int n = 0;
        for (n = 0; n < 4 && Character.isDigit(string.charAt(n)); ++n) {
        }
        string3 = Convert.convertToValidYear(string.substring(0, n));
        string4 = (n = Convert.getIndexOfFirstAlphabetOfAMonth(string = string.substring(n + 1).trim())) == -1 ? "00" : Convert.getMonth(string.substring(n).trim());
        return string3 + "-" + string4 + "-" + string5;
    }

    private static final String parseDateDdMonYyyy(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (Character.isDigit(string.charAt(1))) {
            string5 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string5 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        int n = Convert.getIndexOfFirstAlphabetOfAMonth(string);
        string = string.substring(n);
        int n2 = Convert.getIndexOfFirstSeparator(string);
        string4 = Convert.getMonth(string.substring(0, n2));
        int n3 = Convert.getIndexOfNextDigit(string);
        string3 = Convert.convertToValidYear(string.substring(n3));
        return string3 + "-" + string4 + "-" + string5;
    }

    private static final String parseDateYyyyMondd(String string, String string2) {
        int n;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string3 = Convert.convertToValidYear(string.substring(0, 4));
        string = string.substring(5);
        string4 = "";
        int n2 = Convert.getIndexOfFirstAlphabetOfAMonth(string);
        string = string.substring(n2);
        n2 = Convert.getIndexOfFirstSeparator(string);
        string4 = Convert.getMonth(string.substring(0, n2));
        string5 = (string = string.substring(n2 + 1)).substring(n = Convert.getIndexOfNextDigit(string));
        if (string5.length() < 2) {
            string5 = "0" + string5;
        }
        return string3 + "-" + string4 + "-" + string5;
    }

    private static final String parseDateMonDdYyYy(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = Convert.getIndexOfFirstSeparator(string);
        string3 = string.substring(0, n);
        string3 = Convert.getMonth(string3);
        string = string.substring(n + 1).trim();
        int n2 = Convert.getIndexOfNextDigit(string);
        if (Character.isDigit((string = string.substring(n2)).charAt(1))) {
            string4 = string.substring(0, 2);
            string = string.substring(3).trim();
        } else {
            string4 = "0" + string.substring(0, 1);
            string = string.substring(2).trim();
        }
        n2 = Convert.getIndexOfNextDigit(string);
        string5 = Convert.convertToValidYear(string.substring(n2));
        return string5 + "-" + string3 + "-" + string4;
    }

    private static final String parseTime(String string, String string2) {
        string = string.replaceAll(" ", "");
        String string3 = "00";
        String string4 = "00";
        String string5 = "00";
        String string6 = "000000000";
        String[] stringArray = string.toLowerCase().split(":");
        int n = -1;
        int n2 = -1;
        switch (stringArray.length) {
            case 1: {
                n = Math.max(stringArray[0].indexOf(97), stringArray[0].indexOf(112));
                string3 = stringArray[0].substring(0, n);
                break;
            }
            case 2: {
                string3 = stringArray[0];
                n2 = stringArray[1].indexOf(46);
                n = Math.max(stringArray[1].indexOf(97), stringArray[1].indexOf(112));
                if (n2 != -1) {
                    string4 = stringArray[1].substring(0, n2);
                    string6 = n != -1 ? stringArray[1].substring(n2 + 1, n) : stringArray[1].substring(n2 + 1);
                    string6 = Convert.convertMicrosToNanoSeconds(string6);
                    break;
                }
                string4 = n != -1 ? stringArray[1].substring(0, n) : stringArray[1];
                break;
            }
            case 3: {
                string3 = stringArray[0];
                string4 = stringArray[1];
                n2 = stringArray[2].indexOf(46);
                n = Math.max(stringArray[2].indexOf(97), stringArray[2].indexOf(112));
                if (n2 != -1) {
                    string5 = stringArray[2].substring(0, n2);
                    string6 = n != -1 ? stringArray[2].substring(n2 + 1, n) : stringArray[2].substring(n2 + 1);
                    string6 = Convert.convertMicrosToNanoSeconds(string6);
                    break;
                }
                string5 = n != -1 ? stringArray[2].substring(0, n) : stringArray[2];
                break;
            }
            case 4: {
                string3 = stringArray[0];
                string4 = stringArray[1];
                string5 = stringArray[2];
                n = Math.max(stringArray[3].indexOf(97), stringArray[3].indexOf(112));
                string6 = n != -1 ? stringArray[3].substring(0, n) : stringArray[3];
                string6 = Convert.convertMillisToNanoSeconds(string6);
            }
        }
        if (string.toLowerCase().indexOf(112) != -1 && Integer.parseInt(string3) < 12) {
            string3 = "" + (12 + Integer.parseInt(string3));
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return string3 + ":" + string4 + ":" + string5 + "." + string6;
    }

    private static final String convertMillisToNanoSeconds(String string) throws IllegalArgumentException {
        String string2 = "" + Integer.parseInt(string) * 1000000;
        if (Integer.parseInt(string2) >= 1000000000) {
            throw new NumberFormatException("The milli second value " + string + " exceeded the range");
        }
        for (int i = string2.length(); i < 9; ++i) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private static final String convertMicrosToNanoSeconds(String string) throws IllegalArgumentException {
        BigDecimal bigDecimal = new BigDecimal("0." + string);
        bigDecimal = bigDecimal.multiply(new BigDecimal(1000000000));
        bigDecimal = bigDecimal.setScale(9);
        String string2 = "" + bigDecimal.intValue();
        if (Integer.parseInt(string2) >= 1000000000) {
            throw new NumberFormatException("The micro second value " + string + " exceeded the range");
        }
        return string2;
    }

    private static final String getDefaultDate(String string) {
        if (string != null && string.equals("bigdatetime")) {
            return "0001-01-01";
        }
        return "1900-01-01";
    }

    private static final String getDefaultTime(String string) {
        if (string.equals("bigtime")) {
            // empty if block
        }
        return "00:00:00.000000000";
    }

    private static int getIndexOfFirstAlphabetOfAMonth(String string) {
        int n = -1;
        int n2 = -1;
        string = string.toLowerCase();
        for (int i = 0; i < MONTH_START_CHAR.length; ++i) {
            n = string.indexOf(MONTH_START_CHAR[i]);
            if (n == -1) continue;
            if (n2 == -1) {
                n2 = n;
            }
            if (n >= n2) continue;
            n2 = n;
        }
        return n2;
    }

    private static int getIndexOfFirstSeparator(String string) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < DATE_SEPARATORS.length; ++i) {
            n = string.indexOf(DATE_SEPARATORS[i]);
            if (n == -1) continue;
            if (n2 == -1) {
                n2 = n;
            }
            if (n >= n2) continue;
            n2 = n;
        }
        return n2;
    }

    private static int getIndexOfNextDigit(String string) {
        int n;
        for (n = 0; n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
        }
        return n;
    }

    private static String getMonth(String string) {
        if ((string = string.toLowerCase()).equals("jan") || string.equals("january")) {
            return "01";
        }
        if (string.equals("feb") || string.equals("february")) {
            return "02";
        }
        if (string.equals("mar") || string.equals("march")) {
            return "03";
        }
        if (string.equals("apr") || string.equals("april")) {
            return "04";
        }
        if (string.equals("may") || string.equals("may")) {
            return "05";
        }
        if (string.equals("jun") || string.equals("june")) {
            return "06";
        }
        if (string.equals("jul") || string.equals("july")) {
            return "07";
        }
        if (string.equals("aug") || string.equals("august")) {
            return "08";
        }
        if (string.equals("sep") || string.equals("september")) {
            return "09";
        }
        if (string.equals("oct") || string.equals("october")) {
            return "10";
        }
        if (string.equals("nov") || string.equals("november")) {
            return "11";
        }
        if (string.equals("dec") || string.equals("december")) {
            return "12";
        }
        return "00";
    }

    public static Calendar objectToCalendar(Object object, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return (Calendar)object;
        }
        Calendar calendar2 = calendar;
        if (calendar2 == null) {
            calendar2 = Calendar.getInstance();
        }
        if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            if (object instanceof Date) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else if (object instanceof Time) {
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
            }
        } else {
            ErrorMessage.raiseError("JZ0TC");
        }
        return calendar;
    }

    public static Time objectToTime(Object object, String string) throws SQLException {
        Object object2;
        Object object3;
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            object3 = Convert.numString(object);
            object2 = object3;
            int n = ((String)object2).indexOf(" ");
            if (n > 0 && ((String)object2).length() > n + 9) {
                object2 = ((String)object2).substring(n + 1, n + 9);
            }
            try {
                return Time.valueOf((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    String string2 = Convert.convertToASEAcceptableFullDateTimeFormat((String)object3, string);
                    return Time.valueOf(Convert.getTimePart(string2));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    ErrorMessage.raiseError("JZ009", illegalArgumentException2.getMessage());
                }
            }
        }
        if (object instanceof Timestamp) {
            object3 = (Timestamp)object;
            object2 = Calendar.getInstance();
            ((Calendar)object2).clear();
            ((Calendar)object2).setTime((java.util.Date)object3);
            ((Calendar)object2).set(1, 1970);
            ((Calendar)object2).set(2, 0);
            ((Calendar)object2).set(5, 1);
            return new Time(((Calendar)object2).getTime().getTime());
        }
        if (object instanceof DateObject) {
            object3 = (Calendar)((DateObject)object).getCalendar().clone();
            ((Calendar)object3).set(6, 1);
            ((Calendar)object3).set(1, 1970);
            return new Time(((Calendar)object3).getTime().getTime());
        }
        ErrorMessage.raiseError("JZ0TE", "java.sql.Time, java.sql.Timestamp, String");
        return null;
    }

    public static Timestamp objectToTimestamp(Object object, String string) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof String) {
            try {
                return Timestamp.valueOf(Convert.numString(object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return Timestamp.valueOf(Convert.convertToASEAcceptableFullDateTimeFormat((String)object, string));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    ErrorMessage.raiseError("JZ009", illegalArgumentException2.getMessage());
                }
            }
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new SybTimestamp(calendar.getTime().getTime());
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(time);
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            return new SybTimestamp(calendar.getTime().getTime());
        }
        if (object instanceof DateObject) {
            return ((DateObject)object).toSybTimestamp();
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static DateObject objectToDateObject(Object object, String string, Calendar calendar) throws SQLException {
        return Convert.objectToDateObject(object, 93, string, calendar);
    }

    public static DateObject objectToDateObject(Object object, int n, String string, Calendar calendar) throws SQLException {
        Object object2 = object;
        DateObject dateObject = null;
        if (object2 == null) {
            return null;
        }
        if (object instanceof DateObject) {
            return (DateObject)object;
        }
        if (!(object2 instanceof Calendar)) {
            Calendar calendar2 = null;
            switch (n) {
                case 91: {
                    object2 = Convert.objectToDate(object2, string);
                    dateObject = new DateObject(object2, calendar);
                    calendar2 = dateObject.getCalendar();
                    calendar2.set(11, 0);
                    calendar2.set(12, 0);
                    calendar2.set(13, 0);
                    calendar2.set(14, 0);
                    break;
                }
                case 92: {
                    object2 = Convert.objectToTime(object2, string);
                    dateObject = new DateObject(object2, calendar);
                    calendar2 = dateObject.getCalendar();
                    calendar2.set(1, 1970);
                    calendar2.set(2, 0);
                    calendar2.set(5, 1);
                    break;
                }
                case 93: {
                    object2 = Convert.objectToTimestamp(object2, string);
                    dateObject = new DateObject(object2, calendar);
                    break;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                }
            }
            return dateObject;
        }
        return new DateObject(object2, calendar);
    }

    public static SybLob objectToLob(Object object, SybLob.LOB_TYPE lOB_TYPE) throws SQLException {
        if (object == null) {
            return null;
        }
        if (lOB_TYPE == SybLob.LOB_TYPE.IMAGE && (object instanceof SybBinaryLob || object instanceof SybBinaryClientLob)) {
            return (SybLob)object;
        }
        if ((lOB_TYPE == SybLob.LOB_TYPE.TEXT || lOB_TYPE == SybLob.LOB_TYPE.UNITEXT) && (object instanceof SybCharLob || object instanceof SybCharClientLob)) {
            return (SybLob)object;
        }
        ErrorMessage.raiseError("JZ0TC");
        return null;
    }

    public static String numString(Object object) throws SQLException {
        int n;
        String string = Convert.objectToString(object);
        int n2 = string.length();
        block6: for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '+': {
                    continue block6;
                }
            }
        }
        --n2;
        block7: while (n2 > n) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    break block7;
                }
            }
            --n2;
        }
        return string.substring(n, n2 + 1);
    }

    public static byte hexToDecimal(char c) throws SQLException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        ErrorMessage.raiseError("JZ0HC", "" + c);
        return 0;
    }

    public static void checkByteOflo(long l) throws SQLException {
        if (l < -128L || l > 127L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkIntOflo(long l) throws SQLException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkShortOflo(long l) throws SQLException {
        if (l < -32768L || l > 32767L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUSmallIntOflo(long l) throws SQLException {
        if (l < 0L || l > 65535L) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUintOflo(long l) throws SQLException {
        if (l < 0L || l > Long.parseLong("4294967295")) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkUBigintOflo(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal.compareTo(new BigDecimal("0")) == -1 || bigDecimal.compareTo(new BigDecimal("18446744073709551615")) == 1) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkLongOflo(double d) throws SQLException {
        if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static void checkLongOflo(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal.compareTo(new BigDecimal("-9223372036854775808")) == -1 || bigDecimal.compareTo(new BigDecimal("9223372036854775807")) == 1) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) throws SQLException {
        if (bigDecimal != null && n >= 0) {
            try {
                bigDecimal = bigDecimal.setScale(n, 4);
            }
            catch (ArithmeticException arithmeticException) {
                ErrorMessage.raiseError("JZ009", arithmeticException.getMessage());
            }
        }
        return bigDecimal;
    }

    public static long bufToLong(byte[] byArray) throws SQLException {
        long l = 0L;
        switch (byArray.length) {
            case 1: {
                l = 0xFFL & (long)byArray[0];
                break;
            }
            case 2: {
                l = (0xFFL & (long)byArray[0]) << 8 | 0xFFL & (long)byArray[1];
                break;
            }
            case 4: {
                l = (0xFFL & (long)byArray[0]) << 24 | (0xFFL & (long)byArray[1]) << 16 | (0xFFL & (long)byArray[2]) << 8 | 0xFFL & (long)byArray[3];
                break;
            }
            case 8: {
                l = (0xFFL & (long)byArray[0]) << 56 | (0xFFL & (long)byArray[1]) << 48 | (0xFFL & (long)byArray[2]) << 40 | (0xFFL & (long)byArray[3]) << 32 | (0xFFL & (long)byArray[4]) << 24 | (0xFFL & (long)byArray[5]) << 16 | (0xFFL & (long)byArray[6]) << 8 | 0xFFL & (long)byArray[7];
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return l;
    }

    public static double bufToDouble(byte[] byArray) throws SQLException {
        double d = 0.0;
        switch (byArray.length) {
            case 4: {
                d = Float.intBitsToFloat((int)((0xFFL & (long)byArray[0]) << 24 | (0xFFL & (long)byArray[1]) << 16 | (0xFFL & (long)byArray[2]) << 8 | 0xFFL & (long)byArray[3]));
                break;
            }
            case 8: {
                d = Double.longBitsToDouble((0xFFL & (long)byArray[0]) << 56 | (0xFFL & (long)byArray[1]) << 48 | (0xFFL & (long)byArray[2]) << 40 | (0xFFL & (long)byArray[3]) << 32 | (0xFFL & (long)byArray[4]) << 24 | (0xFFL & (long)byArray[5]) << 16 | (0xFFL & (long)byArray[6]) << 8 | 0xFFL & (long)byArray[7]);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return d;
    }
}

