/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ColumnInfo;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.ParameterMetaDataSapDB;
import com.sap.db.jdbc.Parseinfo;
import com.sap.db.jdbc.ParseinfoCache;
import com.sap.db.jdbc.ResultSetMetaDataSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.Transaction;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.PartEnumeration;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.ABAPStreamDescriptor;
import com.sap.db.jdbc.translators.ABAPStreamTranslator;
import com.sap.db.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.db.jdbc.translators.AbstractABAPStreamPutval;
import com.sap.db.jdbc.translators.AbstractProcedurePutval;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.Putval;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.StreamInfo;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.RecordGenerator;
import com.sap.db.util.UniqueID;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CallableStatementSapDB
extends StatementSapDB
implements CallableStatement,
SQLParamController {
    private Vector inputOMSStreams;
    private Vector outputOMSStreams;
    private Vector inputProcedureLongs;
    static final int maxParseAgainCnt = 10;
    Parseinfo parseinfo;
    RecordGenerator recordGenerator;
    boolean lastWasNull;
    DataPart replyMem;
    protected Object[] inputArgs;
    Vector inputLongs;
    Vector batchRows;
    short[] outPutTypes;
    byte[] outPutScale;
    FetchInfo fetchInfo;
    AbstractMap columnMap;
    private final String initialParamValue = "initParam";
    public static final int UNLIMITED_STREAM_LENGTH = -1;
    int[] m_tableLocations;
    UniqueID m_tableLocationCounter;
    private static final PutvalComparator putvalComparator = new PutvalComparator();

    CallableStatementSapDB(ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.constructor(sql);
    }

    public void addBatch() throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(this.inputArgs);
        Object[] nextRow = new Object[this.parseinfo.paramInfos.length];
        DBTechTranslator[] paraminfos = this.parseinfo.paramInfos;
        int paraminfos_length = paraminfos.length;
        for (int i = 0; i < paraminfos_length; ++i) {
            nextRow[i] = paraminfos[i].cloneObjectForBatch(this.inputArgs[i]);
        }
        this.inputArgs = nextRow;
    }

    public void addBatch(String sql) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.addbatch.preparedstatement");
    }

    private int calculateInputRecord() {
        int result = 0;
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            DBTechTranslator currentInfo = this.parseinfo.paramInfos[i];
            if (!currentInfo.isInput()) continue;
            int currentFieldLen = currentInfo.getPhysicalLength();
            result = this.parseinfo.varDataInput ? (currentFieldLen < 250 ? ++result : (result += 3)) : ++result;
            result += currentFieldLen;
        }
        return result;
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.inputArgs.length; ++i) {
            this.inputArgs[i] = "initParam";
        }
    }

    private void constructor(String sql) throws SQLException {
        this.m_tableLocationCounter = new UniqueID(this.connection.UniqueID.getNextID());
        JdbcCommunication session = this.getSession(false, false);
        this.parseinfo = this.doParse(sql, false, session);
        this.recordGenerator = new RecordGenerator();
        this.isPoolable = false;
    }

    private Parseinfo doParse(String sql, boolean parseAgain, JdbcCommunication session) throws SQLException {
        if (sql == null) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.null");
        }
        Parseinfo result = null;
        ParseinfoCache cache = this.connection.parseCache;
        ColumnInfo[] columnNames = null;
        this.fetchInfo = null;
        if (parseAgain) {
            result = this.parseinfo;
        } else if (cache != null) {
            result = cache.findParseinfo(sql);
        }
        if (result == null || parseAgain) {
            ReplyPacket replyPacket;
            try {
                replyPacket = this.sendSQL(sql, this.resultSetType, this.resultSetConcurrency, parseAgain, session);
            }
            catch (InternalReconnectException exc) {
                replyPacket = this.sendSQL(sql, this.resultSetType, this.resultSetConcurrency, parseAgain, session);
            }
            if (!parseAgain) {
                result = new Parseinfo(this.connection, sql, replyPacket.functionCode());
            }
            PartEnumeration enume = replyPacket.partEnumeration();
            DBTechTranslator[] resultSetMetaData = null;
            block15: while (enume.hasMoreElements()) {
                enume.nextElement();
                switch (enume.partKind()) {
                    case 10: {
                        result.setParseIdAndSession(replyPacket.getStatementID(), session);
                        continue block15;
                    }
                    case 46: {
                        replyPacket.parseParameterMetaData(this.connection, result, false, false);
                        continue block15;
                    }
                    case 47: {
                        replyPacket.parseParameterMetaData(this.connection, result, false, false);
                        continue block15;
                    }
                    case 65: {
                        replyPacket.parseParameterMetaData(this.connection, result, true, false);
                        continue block15;
                    }
                    case 66: {
                        replyPacket.parseParameterMetaData(this.connection, result, true, true);
                        continue block15;
                    }
                    case 14: {
                        resultSetMetaData = replyPacket.parseResultSetMetaDataOld(this.connection);
                        result.setResultSetMetaData(resultSetMetaData);
                        continue block15;
                    }
                    case 48: {
                        resultSetMetaData = replyPacket.parseResultSetMetaData(this.connection);
                        result.setResultSetMetaData(resultSetMetaData);
                        continue block15;
                    }
                    case 19: {
                        result.setUpdateTableName(replyPacket.getTablename());
                        continue block15;
                    }
                    case 2: {
                        columnNames = replyPacket.parseColumnNames(columnNames);
                        continue block15;
                    }
                    case 36: {
                        columnNames = replyPacket.parseSchemaTableColumnNames(columnNames);
                        continue block15;
                    }
                    case 16: {
                        this.m_tableLocations = replyPacket.parseTableLocations();
                        continue block15;
                    }
                }
            }
            if (!parseAgain) {
                this.inputArgs = new Object[result.paramInfos.length];
                if (cache != null) {
                    cache.addParseinfo(result);
                }
            }
        }
        if (!parseAgain) {
            this.clearParameters();
        }
        return result;
    }

    public boolean execute() throws SQLException {
        this.assertOpen();
        JdbcCommunication session = this.getSession(false, true);
        return this.execute(10, session);
    }

    private void reparse(JdbcCommunication session) throws SQLException {
        this.doParse(this.parseinfo.sqlCmd, true, session);
    }

    protected String getUpdTablename(String sqlCmd) {
        return this.parseinfo.updTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(int afterParseAgain, JdbcCommunication session) throws SQLException {
        if (this.connection == null) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.connectionnull");
        }
        boolean isCommunicationLocked = false;
        Parseinfo.ParseID parseID = this.parseinfo.getParseId(session);
        if (parseID == null) {
            this.reparse(session);
            parseID = this.parseinfo.getParseId(session);
        }
        try {
            boolean isQuery;
            ReplyPacket replyPacket;
            boolean packetToSmall;
            boolean truncated = false;
            this.canceled = false;
            this.closeResultSet(true);
            this.replyMem = null;
            this.outputOMSStreams = null;
            RequestPacket requestPacket = this.connection.getRequestPacket(session);
            do {
                packetToSmall = false;
                requestPacket.initExecute(parseID, this.connection.m_transaction.m_autocommit, this.resultSetType, this.resultSetHoldability, this.connection.getStatementContext());
                if (this.parseinfo.inputCount <= 0 && !this.parseinfo.hasStreams) continue;
                DataPart dataPart = requestPacket.newParameterDataPart();
                if (this.parseinfo.hasDirectRecordPassing) {
                    this.recordGenerator.init(requestPacket, this.parseinfo.hasColumnStoreAccess);
                }
                if (this.parseinfo.inputCount > 0) {
                    dataPart.addRow(this.parseinfo.inputCount);
                    for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                        if (this.parseinfo.paramInfos[i].isInput() && "initParam" == this.inputArgs[i]) {
                            if (this.parseinfo.paramInfos[i].isStreamKind() && this.outPutTypes != null && this.outPutTypes[i + 1] != 0) {
                                if (this.outputOMSStreams == null) {
                                    this.outputOMSStreams = new Vector();
                                }
                                ABAPStreamTranslator t = (ABAPStreamTranslator)this.parseinfo.paramInfos[i];
                                AbstractABAPStreamGetval getval = t.createGetval();
                                this.outputOMSStreams.add(getval);
                                if (t.put(dataPart, getval)) continue;
                                throw new SQLException(MessageTranslator.translate("error.internal.packetTooSmall"));
                            }
                            throw new SQLException(MessageTranslator.translate("error.missinginout", Integer.toString(i + 1)), "02000");
                        }
                        if (this.parseinfo.hasDirectRecordPassing) {
                            this.recordGenerator.insert(this.parseinfo.paramInfos[i], this.inputArgs[i]);
                            continue;
                        }
                        if (this.parseinfo.paramInfos[i].put(dataPart, this.inputArgs[i])) continue;
                        requestPacket.resize();
                        packetToSmall = true;
                        break;
                    }
                    if (!packetToSmall) {
                        this.inputProcedureLongs = null;
                        if (this.parseinfo.hasLongs) {
                            truncated = this.handleStreamsForExecute(dataPart, this.inputArgs);
                        }
                        if (this.parseinfo.hasStreams) {
                            this.handleOMSStreamsForExecute(dataPart);
                        }
                    }
                } else {
                    this.handleOMSStreamsForExecute(dataPart);
                }
                if (this.parseinfo.hasDirectRecordPassing) {
                    if (!this.recordGenerator.close()) {
                        throw new SQLException(MessageTranslator.translate("error.internal.packetTooSmall"));
                    }
                    dataPart.increaseExtent(this.recordGenerator.getDataPartSize());
                }
                dataPart.close();
            } while (packetToSmall);
            if (truncated && this.connection.m_transaction.m_autocommit) {
                requestPacket.setAutoCommit(false);
            }
            if (this.parseinfo.hasDirectRecordPassing) {
                if (!this.parseinfo.hasStreams && this.inputProcedureLongs == null) {
                    replyPacket = this.connection.execute(requestPacket, this.recordGenerator, this, 1, session, false);
                } else {
                    this.connection.m_communicationSemaphore.acquire();
                    isCommunicationLocked = true;
                    replyPacket = this.connection.execute(requestPacket, this.recordGenerator, false, false, this, 3, session, false);
                }
            } else if (!this.parseinfo.hasStreams && this.inputProcedureLongs == null) {
                replyPacket = this.connection.execute(requestPacket, this, 1, session, false);
            } else {
                this.connection.m_communicationSemaphore.acquire();
                isCommunicationLocked = true;
                replyPacket = this.connection.execute(requestPacket, false, false, this, 3, session, false);
            }
            if (this.parseinfo.isSelect) {
                isQuery = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos());
            } else {
                if (this.inputProcedureLongs != null) {
                    replyPacket = this.processProcedureStreams(replyPacket, session);
                } else if (this.parseinfo.hasStreams) {
                    replyPacket = this.processOMSStreams(replyPacket, session);
                }
                if (isCommunicationLocked) {
                    this.connection.m_communicationSemaphore.release();
                    isCommunicationLocked = false;
                }
                int returnCode = replyPacket.returnCode();
                boolean resetrowcount = true;
                if (this.parseinfo.hasLongs && returnCode == 0) {
                    this.rowsAffected = -1;
                    this.hasRowCount = false;
                    replyPacket = this.handleStreamsForPutval(replyPacket, session);
                    if (this.hasRowCount) {
                        resetrowcount = false;
                    }
                }
                isQuery = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), false);
                replyPacket.firstSegment();
                this.replyMem = replyPacket.getOutputDataPart(this.parseinfo);
            }
            if (truncated && this.connection.m_transaction.m_autocommit) {
                this.connection.commitInternal();
            }
            boolean bl = isQuery;
            Object var15_17 = null;
            this.canceled = false;
            if (isCommunicationLocked) {
                this.connection.m_communicationSemaphore.release();
            }
            return bl;
        }
        catch (InternalReconnectException reconnect) {
            try {
                if (isCommunicationLocked) {
                    this.connection.m_communicationSemaphore.release();
                    isCommunicationLocked = false;
                }
                this.m_tableLocations = null;
                this.closeResultSet(true);
                this.resetPutvals(this.inputLongs);
                boolean bl = this.execute(10, session);
                Object var15_18 = null;
                this.canceled = false;
                if (isCommunicationLocked) {
                    this.connection.m_communicationSemaphore.release();
                }
                return bl;
            }
            catch (Throwable throwable) {
                block39: {
                    Object var15_19 = null;
                    this.canceled = false;
                    if (!isCommunicationLocked) break block39;
                    this.connection.m_communicationSemaphore.release();
                }
                throw throwable;
            }
        }
    }

    public boolean execute(String sql) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.execute.preparedstatement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.assertOpen();
        this.serverProcessingTime = 0L;
        JdbcCommunication session = this.getSession(false, true);
        Parseinfo.ParseID parseID = this.parseinfo.getParseId(session);
        if (this.parseinfo == null || parseID == null) {
            this.reparse(session);
            parseID = this.parseinfo.getParseId(session);
        }
        if (this.parseinfo.isSelect) {
            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset"), new int[0]);
        }
        if (this.parseinfo.functionCode == 8 || this.parseinfo.functionCode == 9) {
            for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                if (!this.parseinfo.paramInfos[i].isOutput()) continue;
                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout"), new int[0]);
            }
        }
        if (this.batchItems == null) {
            return new int[0];
        }
        Vector streamVec = null;
        Vector localBatchItems = this.batchItems;
        this.batchItems = null;
        try {
            this.canceled = false;
            int count = localBatchItems.size();
            ReplyPacket replyPacket = null;
            int inputCursor = 0;
            boolean noError = true;
            int executeCount = -1;
            int[] result = new int[count];
            this.rowsAffected = -1;
            boolean truncated = false;
            boolean packetToSmall = false;
            int rowcnt = 0;
            while (inputCursor < count && noError) {
                int[] updateCounts;
                streamVec = null;
                int firstRecordNo = inputCursor;
                RequestPacket requestPacket = this.connection.getRequestPacket(session);
                if (packetToSmall) {
                    requestPacket.resize();
                    packetToSmall = false;
                }
                requestPacket.initExecute(parseID, this.connection.m_transaction.m_autocommit, this.resultSetType, this.resultSetHoldability, this.connection.getStatementContext());
                boolean looptruncated = true;
                if (this.parseinfo.paramInfos.length > 0) {
                    DataPart dataPart = requestPacket.newParameterDataPart();
                    if (executeCount == -1) {
                        dataPart.setFirstPart();
                    }
                    if (this.parseinfo.hasDirectRecordPassing) {
                        this.recordGenerator.init(requestPacket, this.parseinfo.hasColumnStoreAccess);
                    }
                    rowcnt = 0;
                    do {
                        boolean isPacketFull = false;
                        Object[] row = (Object[])localBatchItems.elementAt(inputCursor);
                        dataPart.addRow(this.parseinfo.inputCount);
                        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
                            if (this.parseinfo.paramInfos[i].isInput() && "initParam" == row[i]) {
                                this.makeBatchCountArray(result, new int[0], firstRecordNo, count - firstRecordNo, -3);
                                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", Integer.toString(inputCursor + 1), Integer.toString(i + 1)), "0200", result);
                            }
                            if (this.parseinfo.hasDirectRecordPassing) {
                                if (this.recordGenerator.insert(this.parseinfo.paramInfos[i], row[i])) continue;
                                this.recordGenerator.resetCurrentRecord();
                                break;
                            }
                            if (this.parseinfo.paramInfos[i].put(dataPart, row[i])) continue;
                            if (rowcnt == 0) {
                                packetToSmall = true;
                            }
                            isPacketFull = true;
                            dataPart.resetCurrentRecord();
                            break;
                        }
                        if (packetToSmall || isPacketFull || rowcnt + 1 >= Short.MAX_VALUE) break;
                        ++rowcnt;
                        if (this.parseinfo.hasLongs) {
                            looptruncated = this.handleStreamsForExecute(dataPart, row);
                            if (looptruncated) {
                                truncated = true;
                            }
                            if (truncated && this.connection.m_transaction.m_autocommit) {
                                requestPacket.setAutoCommit(false);
                            }
                            if (streamVec == null) {
                                streamVec = new Vector(this.inputLongs.size());
                            }
                            streamVec.addAll(this.inputLongs);
                        }
                        if (this.parseinfo.hasDirectRecordPassing) {
                            if (this.recordGenerator.moveRecordBase()) continue;
                            this.recordGenerator.resetCurrentRecord();
                            break;
                        }
                        dataPart.moveRecordBase();
                    } while (++inputCursor < count);
                    if (this.parseinfo.hasDirectRecordPassing) {
                        dataPart.increaseExtent(this.recordGenerator.getDataPartSize());
                    }
                    if (inputCursor == count) {
                        dataPart.setLastPart();
                    }
                    dataPart.closeArrayPart(inputCursor - firstRecordNo);
                } else {
                    ++inputCursor;
                }
                if (rowcnt <= 0) continue;
                try {
                    replyPacket = this.parseinfo.hasDirectRecordPassing ? (truncated && this.connection.m_transaction.m_autocommit ? this.connection.execute(requestPacket, this.recordGenerator, this, 3, session, false) : this.connection.execute(requestPacket, this.recordGenerator, this, 2, session, false)) : (truncated && this.connection.m_transaction.m_autocommit ? this.connection.execute(requestPacket, this, 3, session, false) : this.connection.execute(requestPacket, this, 2, session, false));
                }
                catch (SQLException dbExc) {
                    SQLExceptionSapDBInterface specific = (SQLExceptionSapDBInterface)((Object)dbExc);
                    if (!this.connection.getAutoCommit()) {
                        this.rowsAffected = this.rowsAffected > 0 ? (this.rowsAffected += specific.getErrorPos() - 1) : specific.getErrorPos() - 1;
                    }
                    updateCounts = ((SQLExceptionSapDBInterface)((Object)dbExc)).getUpdateCountsFromLastPacket();
                    this.makeBatchCountArray(result, updateCounts, firstRecordNo, count - firstRecordNo, -3);
                    throw new BatchUpdateExceptionSapDB(dbExc, new Integer(inputCursor + 1), result);
                }
                executeCount = replyPacket.rowsAffected(false);
                updateCounts = replyPacket.getBatchUpdateCounts(false);
                long processingTime = replyPacket.getServerExecutionTime(false);
                if (this.serverProcessingTime != -1L) {
                    this.serverProcessingTime = processingTime < 0L ? processingTime : (this.serverProcessingTime += processingTime);
                }
                if (this.parseinfo.hasLongs) {
                    this.handleStreamsForPutval(replyPacket, session);
                }
                this.makeBatchCountArray(result, updateCounts, firstRecordNo, inputCursor - firstRecordNo, -2);
                this.rowsAffected = executeCount;
            }
            if (truncated && this.connection.m_transaction.m_autocommit) {
                this.connection.commitInternal();
            }
            int[] nArray = result;
            Object var23_29 = null;
            this.canceled = false;
            return nArray;
        }
        catch (InternalReconnectException reconnect) {
            try {
                this.m_tableLocations = null;
                this.batchItems = localBatchItems;
                this.resetPutvals(streamVec);
                int[] nArray = this.executeBatch();
                Object var23_30 = null;
                this.canceled = false;
                return nArray;
            }
            catch (Throwable throwable) {
                Object var23_31 = null;
                this.canceled = false;
                throw throwable;
            }
        }
    }

    private void makeBatchCountArray(int[] resultArr, int[] updateCounts, int chunkOffset, int chunkLen, int defaultValue) {
        if (updateCounts == null) {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = defaultValue;
            }
        } else {
            for (int i = 0; i < chunkLen; ++i) {
                resultArr[chunkOffset + i] = updateCounts.length > i ? updateCounts[i] : defaultValue;
            }
        }
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        this.execute();
        return this.currentResultSet;
    }

    public ResultSet executeQuery(String statement) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.executequery.preparedstatement");
    }

    public ResultSetSapDB executeQuerySap() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        return this.currentResultSet;
    }

    public int executeUpdate() throws SQLException {
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.resultset");
        }
        this.execute();
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    public int executeUpdate(String statement) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.executeupdate.preparedstatement");
    }

    private DBTechTranslator findColInfo(int colIndex) throws SQLException {
        DBTechTranslator info;
        try {
            info = this.parseinfo.paramInfos[colIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.colindex.notfound", Integer.toString(colIndex));
        }
        return info;
    }

    private DBTechTranslator findParamInfo(String paramName) throws SQLException {
        DBTechTranslator info;
        if (!this.parseinfo.isDBProc) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.noprocedure");
        }
        if (this.columnMap == null) {
            this.columnMap = this.parseinfo.getColumnMap();
        }
        if ((info = (DBTechTranslator)this.columnMap.get(paramName)) == null && (info = (DBTechTranslator)this.columnMap.get(paramName.toUpperCase())) != null) {
            this.columnMap.put(paramName, info);
        }
        if (info == null) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", paramName);
        }
        return info;
    }

    public Array getArray(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBigDecimal(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBigDecimal(scale, this, this.getReplyData());
    }

    public Blob getBlob(int i) throws SQLException {
        this.assertOpen();
        return this.findColInfo(i).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBoolean(this, this.getReplyData());
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getByte(this, this.getReplyData());
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getBytes(this, this.getReplyData());
    }

    public Clob getClob(int i) throws SQLException {
        this.assertOpen();
        return this.findColInfo(i).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDate(this, this.getReplyData(), null);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDate(this, this.getReplyData(), cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getDouble(this, this.getReplyData());
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getFloat(this, this.getReplyData());
    }

    Object getInputParameter(int parameterIndex) {
        return this.inputArgs[parameterIndex - 1];
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getInt(this, this.getReplyData());
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.assertOpen();
        return this.findColInfo(parameterIndex).getLong(this, this.getReplyData());
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.fetchInfo == null) {
            if (this.parseinfo == null) {
                return null;
            }
            if (!this.parseinfo.isSelect && this.parseinfo.functionCode != 5 && this.parseinfo.functionCode != 6 && this.parseinfo.functionCode != 9) {
                return null;
            }
            DBTechTranslator[] colinfos = this.parseinfo.getColumnInfos();
            if (colinfos != null) {
                return new ResultSetMetaDataSapDB(colinfos, "");
            }
        }
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo(), "");
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.assertOpen();
        Object result = null;
        DBTechTranslator translator = this.findColInfo(parameterIndex);
        DataPart replymem = this.getReplyData();
        int typeCode = this.outPutTypes == null ? 0 : this.outPutTypes[parameterIndex];
        switch (typeCode) {
            case -7: {
                if (translator.isNull(this, replymem)) break;
                result = new Boolean(translator.getBoolean(this, replymem));
                break;
            }
            case -6: {
                if (translator.isNull(this, replymem)) break;
                result = new Byte(translator.getByte(this, replymem));
                break;
            }
            case 5: {
                if (translator.isNull(this, replymem)) break;
                result = new Short(translator.getShort(this, replymem));
                break;
            }
            case 4: {
                if (translator.isNull(this, replymem)) break;
                result = new Integer(translator.getInt(this, replymem));
                break;
            }
            case -5: {
                if (translator.isNull(this, replymem)) break;
                result = new Long(translator.getLong(this, replymem));
                break;
            }
            case 7: {
                if (translator.isNull(this, replymem)) break;
                result = new Float(translator.getFloat(this, replymem));
                break;
            }
            case 6: 
            case 8: {
                if (translator.isNull(this, replymem)) break;
                result = new Double(translator.getDouble(this, replymem));
                break;
            }
            case 2: 
            case 3: {
                byte scale = this.outPutScale[parameterIndex];
                if (scale == -1) {
                    result = translator.getBigDecimal(this, replymem);
                    break;
                }
                result = translator.getBigDecimal(scale, this, replymem);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                result = translator.getString(this, replymem);
                break;
            }
            case 91: {
                result = translator.getDate(this, replymem, null);
                break;
            }
            case 92: {
                result = translator.getTime(this, replymem, null);
                break;
            }
            case 93: {
                result = translator.getTimestamp(this, replymem, null);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = translator.getBytes(this, replymem);
                break;
            }
            case 2004: {
                result = translator.getBlob(this, replymem, replymem);
                break;
            }
            case 2005: {
                result = translator.getClob(this, replymem, replymem);
                break;
            }
            default: {
                result = translator.getObject(this, replymem);
            }
        }
        return result;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getObject", "CallableStatement");
    }

    public Ref getRef(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public DataPart getReplyData() throws SQLException {
        if (this.replyMem == null && (this.outputOMSStreams == null || this.outputOMSStreams != null && this.outputOMSStreams.size() == 0)) {
            throw SQLExceptionSapDB.generateSQLException("error.nooutparamdata");
        }
        return this.replyMem;
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getShort(this, this.getReplyData());
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getString(this, this.getReplyData());
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getTime(this, this.getReplyData(), null);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.findColInfo(parameterIndex).getTime(this, this.getReplyData(), cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getTimestamp(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.findColInfo(parameterIndex).getTimestamp(this, this.getReplyData(), cal);
    }

    private boolean handleStreamsForExecute(DataPart dataPart, Object[] arguments) throws SQLException {
        Putval putval;
        int i;
        this.inputLongs = new Vector();
        for (i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object inarg = arguments[i];
            if (inarg == null || !this.parseinfo.paramInfos[i].isLongKind()) continue;
            try {
                putval = (Putval)inarg;
                this.inputLongs.addElement(putval);
                continue;
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        if (this.inputLongs.size() > 1) {
            Collections.sort(this.inputLongs, putvalComparator);
        }
        boolean truncated = false;
        Enumeration putvals = this.inputLongs.elements();
        i = 0;
        while (putvals.hasMoreElements()) {
            putval = (Putval)putvals.nextElement();
            if (putval.atEnd() && (putval = (Putval)putval.cloneForBatch()).atEnd()) {
                throw SQLExceptionSapDB.generateSQLException("error.stream.isatend");
            }
            putval.transferStream(dataPart, i);
            if (!putval.atEnd()) {
                truncated = true;
            }
            putval.setNeedsDescriptorUpdate();
            putval.setState(2);
            ++i;
        }
        return truncated;
    }

    private void handleProcedureStreamsForExecute(DataPart dataPart, Object[] objects) throws SQLExceptionSapDB {
        this.inputProcedureLongs = new Vector();
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object arg = this.inputArgs[i];
            if (arg == null) continue;
            try {
                AbstractProcedurePutval pv = (AbstractProcedurePutval)arg;
                this.inputProcedureLongs.addElement(pv);
                pv.updateIndex(this.inputProcedureLongs.size() - 1);
                continue;
            }
            catch (ClassCastException ignored) {
                // empty catch block
            }
        }
    }

    private void handleOMSStreamsForExecute(DataPart dataPart) {
        ABAPStreamDescriptor t;
        int k;
        this.inputOMSStreams = new Vector();
        for (int i = 0; i < this.parseinfo.paramInfos.length; ++i) {
            Object inarg = this.inputArgs[i];
            if (inarg == null) continue;
            try {
                this.inputOMSStreams.addElement((AbstractABAPStreamPutval)this.inputArgs[i]);
                continue;
            }
            catch (ClassCastException exc) {
                // empty catch block
            }
        }
        int inputoms_size = this.inputOMSStreams.size();
        for (k = 0; k < inputoms_size; ++k) {
            t = (ABAPStreamDescriptor)this.inputOMSStreams.elementAt(k);
            t.updateIndex(k);
        }
        if (this.outputOMSStreams != null) {
            for (k = 0; k < this.outputOMSStreams.size(); ++k) {
                t = (ABAPStreamDescriptor)this.outputOMSStreams.elementAt(k);
                t.updateIndex(k);
            }
        }
    }

    private ReplyPacket processProcedureStreams(ReplyPacket packet, JdbcCommunication session) throws SQLException {
        ReplyPacket erg = null;
        try {
            while (packet.existsPart(25)) {
                StreamInfo[] streaminfos = packet.parseStreamInfos();
                StreamInfo info = streaminfos[0];
                int tabid = info.getTabId();
                if (tabid < 0 || tabid > this.inputProcedureLongs.size()) {
                    throw SQLExceptionSapDB.generateSQLException("error.unknown.procedurelong", Integer.toString(tabid));
                }
                AbstractProcedurePutval pv = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(tabid);
                RequestPacket requestPacket = this.connection.getRequestPacket(session);
                DataPart dataPart = requestPacket.initStreamCommand(this.connection.m_transaction.m_autocommit);
                pv.transferStream(dataPart, info.getRowCount());
                dataPart.close();
                packet = this.connection.execute(requestPacket, false, false, this, 3, session, false);
            }
            erg = packet;
        }
        catch (SQLException sqlEx) {
            ReplyPacket tmppacket = this.connection.sendStreamErrorPacket(sqlEx, session);
            if (tmppacket == null) {
                throw sqlEx;
            }
            erg = tmppacket;
        }
        for (int k = 0; k < this.inputProcedureLongs.size(); ++k) {
            AbstractProcedurePutval pv = (AbstractProcedurePutval)this.inputProcedureLongs.elementAt(k);
            pv.closeStream();
        }
        return erg;
    }

    private ReplyPacket processOMSStreams(ReplyPacket replyPacket, JdbcCommunication session) throws SQLException {
        AbstractABAPStreamGetval gv;
        while (true) {
            int tabid;
            if (replyPacket.existsPart(25)) {
                tabid = replyPacket.parseABAPTabIDForInput();
                AbstractABAPStreamPutval pv = (AbstractABAPStreamPutval)this.inputOMSStreams.elementAt(tabid);
                if (pv.atEnd()) {
                    throw SQLExceptionSapDB.generateSQLException("error.stream.eof", Integer.toString(tabid));
                }
                RequestPacket requestPacket = this.connection.getRequestPacket(session);
                DataPart dataPart = requestPacket.initStreamCommand(this.connection.m_transaction.m_autocommit);
                pv.transferStream(dataPart);
                dataPart.close();
                replyPacket = this.connection.execute(requestPacket, false, false, this, 3, session, false);
                continue;
            }
            if (!replyPacket.existsPart(26)) break;
            tabid = replyPacket.parseABAPTabIDForOutput();
            gv = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(tabid);
            boolean eos = gv.addReplyData(replyPacket);
            RequestPacket requestPacket = this.connection.getRequestPacket(session);
            DataPart datapart = requestPacket.initStreamCommand(this.connection.m_transaction.m_autocommit);
            if (eos) {
                datapart.fillWithOMSReturnCode(100);
            } else {
                datapart.fillWithOMSReturnCode(0);
            }
            datapart.close();
            replyPacket = this.connection.execute(requestPacket, false, false, this, 3, session, false);
        }
        if (this.outputOMSStreams != null) {
            for (int i = 0; i < this.outputOMSStreams.size(); ++i) {
                gv = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(i);
                if (gv == null) continue;
                gv.coalesceReply();
            }
        }
        return replyPacket;
    }

    private void getChangedPutvalDescriptors(ReplyPacket replyPacket) throws SQLException {
        byte[][] descriptorArray = replyPacket.parseLongDescriptors();
        int descIndex = 0;
        for (int i = 0; i < this.inputLongs.size(); ++i) {
            Putval putval = (Putval)this.inputLongs.elementAt(i);
            if (putval.atEnd()) continue;
            if (descriptorArray.length > descIndex) {
                putval.setLOBLocatorID(descriptorArray[descIndex++]);
                continue;
            }
            throw SQLExceptionSapDB.generateSQLException("error.internal.LOBDescriptorMissing");
        }
        if (descriptorArray.length > descIndex) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.ToManyLOBDescriptors");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ReplyPacket handleStreamsForPutval(ReplyPacket replyPacket, JdbcCommunication session) throws SQLException {
        if (this.inputLongs == null || this.inputLongs.size() == 0) {
            return replyPacket;
        }
        PartEnumeration pe = replyPacket.partEnumeration();
        while (pe.hasMoreElements()) {
            pe.nextElement();
            int partKind = pe.partKind();
            if (partKind != 12) continue;
            if (this.parseinfo.isSelect) break;
            this.rowsAffected = replyPacket.rowsAffected(true);
            this.hasRowCount = true;
            break;
        }
        Putval lastStream = (Putval)this.inputLongs.lastElement();
        Putval lastGoodPutval = null;
        int firstOpenStream = 0;
        int count = this.inputLongs.size();
        boolean requiresTrailingPacket = false;
        int putvalshandled = 0;
        if (!lastStream.atEnd()) {
            this.getChangedPutvalDescriptors(replyPacket);
        }
        while (!lastStream.atEnd()) {
            putvalshandled = 0;
            RequestPacket requestPacket = this.connection.getRequestPacket(session);
            DataPart dataPart = requestPacket.initPutval(false, this.connection.getStatementContext());
            for (int i = firstOpenStream; i < count && dataPart.hasRoomFor(21); ++i) {
                Putval putval = (Putval)this.inputLongs.elementAt(i);
                if (putval.atEnd() || !putval.isDescriptorUpdated()) {
                    ++firstOpenStream;
                    continue;
                }
                int descriptorPos = dataPart.getExtent();
                putval.putDescriptor(dataPart, descriptorPos);
                ++putvalshandled;
                lastGoodPutval = putval;
                dataPart.addArg(descriptorPos, 21);
                if (this.canceled) {
                    putval.markErrorStream();
                    ++firstOpenStream;
                    continue;
                }
                putval.transferStream(dataPart, i);
                if (!putval.atEnd()) continue;
                ++firstOpenStream;
            }
            if (putvalshandled == 0) {
                if (lastGoodPutval == null) return replyPacket;
                try {
                    lastGoodPutval.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    requiresTrailingPacket = true;
                    lastStream = lastGoodPutval;
                }
            } else if (lastStream.atEnd() && !this.canceled) {
                try {
                    lastStream.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    requiresTrailingPacket = true;
                }
            }
            dataPart.closeArrayPart(putvalshandled);
            dataPart.close();
            replyPacket = this.connection.execute(requestPacket, this, 2, session, false);
            if (!requiresTrailingPacket || this.canceled) continue;
            requestPacket = this.connection.getRequestPacket(session);
            dataPart = requestPacket.initPutval(false, this.connection.getStatementContext());
            lastStream.markAsLast(dataPart);
            dataPart.close();
            this.connection.execute(requestPacket, this, 2, session, false);
        }
        if (!this.canceled) return replyPacket;
        throw SQLExceptionSapDB.generateSQLException("error.statement.cancelled");
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.outPutTypes == null) {
            this.outPutTypes = new short[this.parseinfo.paramInfos.length + 1];
            this.outPutScale = new byte[this.parseinfo.paramInfos.length + 1];
        }
        if (parameterIndex >= this.outPutTypes.length) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.unexpectedoutput", new Integer(parameterIndex));
        }
        this.outPutTypes[parameterIndex] = (short)sqlType;
        this.outPutScale[parameterIndex] = (byte)scale;
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, -1);
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain, JdbcCommunication session) throws SQLException {
        requestPacket.initParseCommand(sqlCmd, true, parseAgain, this.resultSetType, this.resultSetHoldability, this.connection.getStatementContext());
        ReplyPacket replyPacket = this.connection.execute(requestPacket, false, true, this, gcFlags, session, false);
        return replyPacket;
    }

    public void setArray(int i, Array x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBigDecimalForInput(x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        Object arg;
        this.inputArgs[i - 1] = arg = this.findColInfo(i).transBlobForInput(x, this.connection);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBooleanForInput(x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transByteForInput(x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBytesForInput(x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        Object arg;
        this.inputArgs[i - 1] = arg = this.findColInfo(i).transClobForInput(x, this.connection);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transDateForInput(x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transDoubleForInput(x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transFloatForInput(x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transIntForInput(x);
    }

    public void setLastWasNull(boolean wasNull) {
        this.lastWasNull = wasNull;
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transLongForInput(x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.inputArgs[parameterIndex - 1] = null;
    }

    public void setDefault(int parameterIndex) throws SQLException {
        this.inputArgs[parameterIndex - 1] = "DefaultValue";
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transObjectForInput(x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case 4: {
                if (x instanceof Number) {
                    Number n = (Number)x;
                    this.setInt(parameterIndex, n.intValue());
                    return;
                }
            }
            case -5: {
                if (!(x instanceof Number)) break;
                Number n = (Number)x;
                this.setLong(parameterIndex, n.longValue());
                return;
            }
        }
        this.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterIndex, x, scale);
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transShortForInput(x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        Object arg;
        this.assertOpen();
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transStringForInput(x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transTimeForInput(x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Object arg;
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transTimestampForInput(x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transUnicodeStreamForInput(x);
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    protected FetchInfo getFetchInfo(Cursor cursorName, DBTechTranslator[] infos) throws SQLException {
        if (this.fetchInfo == null) {
            this.fetchInfo = new FetchInfo(this.connection, cursorName, infos, this.packetEncodingUnicode);
        } else if (!this.fetchInfo.getCursorName().equals(cursorName)) {
            this.fetchInfo = new FetchInfo(this.connection, cursorName, infos, this.packetEncodingUnicode);
        }
        return this.fetchInfo;
    }

    public void close() throws SQLException {
        this.replyMem = null;
        if (this.connection != null) {
            this.closeResultSet(false);
            if (this.parseinfo != null && !this.parseinfo.cached) {
                this.parseinfo.dropParseIDs();
            }
        }
    }

    protected void closeForFinalize() throws SQLException {
        if (this.connection != null && this.parseinfo != null && !this.parseinfo.cached) {
            if (this.currentResultSet != null) {
                this.currentResultSet.setCursorType(0);
            }
            this.parseinfo.dropParseIDs();
        }
    }

    protected void resetPutvals(Vector inpLongs) {
        if (inpLongs != null) {
            Enumeration putvals = inpLongs.elements();
            while (putvals.hasMoreElements()) {
                Putval putval = (Putval)putvals.nextElement();
                putval.reset();
            }
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, -1);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParamInfo(parameterName).getColIndex() + 1, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, -1);
    }

    public URL getURL(int parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getURL", "CallableStatementSapDB");
    }

    public void setURL(String parm1, URL parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setURL", "CallableStatementSapDB");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParamInfo(parameterName).getColIndex() + 1, sqlType);
    }

    public void setDefault(String parameterName) throws SQLException {
        this.setDefault(this.findParamInfo(parameterName).getColIndex() + 1);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParamInfo(parameterName).getColIndex() + 1, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParamInfo(parameterName).getColIndex() + 1, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getString(this, this.getReplyData());
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBoolean(this, this.getReplyData());
    }

    public byte getByte(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getByte(this, this.getReplyData());
    }

    public short getShort(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getShort(this, this.getReplyData());
    }

    public int getInt(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getInt(this, this.getReplyData());
    }

    public long getLong(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getLong(this, this.getReplyData());
    }

    public float getFloat(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getFloat(this, this.getReplyData());
    }

    public double getDouble(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDouble(this, this.getReplyData());
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBytes(this, this.getReplyData());
    }

    public Date getDate(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDate(this, this.getReplyData(), null);
    }

    public Time getTime(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTime(this, this.getReplyData(), null);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTimestamp(this, this.getReplyData(), null);
    }

    public Object getObject(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getObject(this, this.getReplyData());
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBigDecimal(this, this.getReplyData());
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "CallableStatement", "getObject");
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.ref.unsupported");
    }

    public Blob getBlob(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getBlob(this, this.getReplyData(), this.getReplyData());
    }

    public Clob getClob(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getClob(this, this.getReplyData(), this.getReplyData());
    }

    public Array getArray(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.array.unsupported");
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getDate(this, this.getReplyData(), cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTime(this, this.getReplyData(), cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getTimestamp(this, this.getReplyData(), cal);
    }

    public URL getURL(String parm1) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.url.unsupported");
    }

    public void setURL(int parm1, URL parm2) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.url.unsupported");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ParameterMetaDataSapDB.createParameterMetaDataSapDB(this.parseinfo.getParamInfo());
    }

    public AbstractABAPStreamGetval getOMSGetval(int index) throws SQLException {
        if (this.outputOMSStreams == null) {
            return null;
        }
        for (int i = 0; i < this.outputOMSStreams.size(); ++i) {
            AbstractABAPStreamGetval t = (AbstractABAPStreamGetval)this.outputOMSStreams.elementAt(i);
            if (t == null || index != t.getColIndex()) continue;
            return t;
        }
        throw SQLExceptionSapDB.generateSQLException("error.colindex.notfound", Integer.toString(index));
    }

    boolean isParameterSet(int parameterIndex) {
        return "initParam" != this.inputArgs[parameterIndex - 1];
    }

    void unsetParameter(int parameterIndex) {
        this.inputArgs[parameterIndex - 1] = "initParam";
    }

    Object[] getInputArgs() {
        return this.inputArgs;
    }

    public String toString() {
        return super.toString() + "[" + this.parseinfo + "]";
    }

    public Parseinfo getParseinfo() {
        return this.parseinfo;
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getCharacterStream(this, this.getReplyData(), this.getReplyData());
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        this.assertOpen();
        return this.findParamInfo(parameterName).getCharacterStream(this, this.getReplyData(), this.getReplyData());
    }

    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStream(parameterIndex);
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(parameterName);
    }

    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.findColInfo(parameterIndex).getNClob(this, this.getReplyData(), this.getReplyData());
    }

    public NClob getNClob(String parameterName) throws SQLException {
        return this.findParamInfo(parameterName).getNClob(this, this.getReplyData(), this.getReplyData());
    }

    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    public String getNString(String parameterName) throws SQLException {
        return this.getString(parameterName);
    }

    public RowId getRowId(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "CallableStatementSapDB");
    }

    public RowId getRowId(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "CallableStatementSapDB");
    }

    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "CallableStatementSapDB");
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "CallableStatementSapDB");
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, -1);
    }

    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParamInfo(parameterName).getColIndex() + 1, x, length);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, inputStream);
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParamInfo(parameterName).getColIndex() + 1, inputStream, length);
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader);
    }

    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, x);
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, reader);
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParamInfo(parameterName).getColIndex() + 1, reader, length);
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setCharacterStream(parameterName, value);
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(parameterName, value);
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setClob(parameterName, (Clob)value);
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(parameterName, reader);
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(parameterName, reader, length);
    }

    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(parameterName, value);
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setRowId", "CallableStatementSapDB");
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setSQLXML", "CallableStatementSapDB");
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, -1L);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transAsciiStreamForInput(x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, -1L);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(x, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(inputStream, -1L);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transBinaryStreamForInput(inputStream, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, -1L);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, -1L);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, -1L);
    }

    public void setNCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Object arg;
        this.inputArgs[parameterIndex - 1] = arg = this.findColInfo(parameterIndex).transCharacterStreamForInput(reader, length);
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, (Clob)value);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setRowId", "CallableStatementSapDB");
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setSQLXML", "CallableStatementSapDB");
    }

    public JdbcCommunication getSession(boolean avoidOpenSession, boolean handleTransaction) throws SQLException {
        if (this.connection.m_distributionMode >= 2 && this.m_tableLocations != null && this.m_tableLocations.length > 0) {
            int volumeID = this.m_tableLocations[(int)(this.m_tableLocationCounter.getNextID() % (long)this.m_tableLocations.length)];
            if (volumeID > 0) {
                JdbcCommunication session = this.connection.m_sessionPool.getSession(volumeID);
                if (avoidOpenSession) {
                    return session != null ? session : this.m_Session;
                }
                if (session == null) {
                    session = this.connection.openSession(volumeID);
                    if (session != null) {
                        session.setSendSessionContextInfo(true);
                    } else {
                        session = this.connection.m_sessionPool.getPrimarySession();
                    }
                }
                this.m_Session = session;
            }
        } else {
            this.m_Session = this.connection.m_sessionPool.getPrimarySession();
        }
        if (handleTransaction) {
            this.connection.m_transaction.handleTransaction(this.connection, this.m_Session, Transaction.isWriteOperation(this.parseinfo.functionCode));
        }
        return this.m_Session;
    }

    public boolean hasDirectRecordPassing() {
        if (this.parseinfo != null) {
            return this.parseinfo.hasDirectRecordPassing;
        }
        return false;
    }

    private static class PutvalComparator
    implements Comparator {
        private PutvalComparator() {
        }

        public int compare(Object o1, Object o2) {
            Putval p1 = (Putval)o1;
            Putval p2 = (Putval)o2;
            int p1_bufpos = p1.getBufpos();
            int p2_bufpos = p2.getBufpos();
            return p1_bufpos - p2_bufpos;
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }
}

