/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.DataPartNGDB;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.rte.comm.JdbcCommunication;
import java.sql.SQLException;
import java.util.Hashtable;

public class FetchInfo
implements DataFormatDescription {
    private ConnectionSapDB connection;
    private Cursor cursor;
    private DBTechTranslator[] columnInfo;
    private int recordSize;
    private Hashtable columnMapping = null;
    private Hashtable columnLabelMapping = null;
    private String _fetchparamstring;
    private boolean packetEncodingUnicode = false;
    private long serverProcessingTime = 0L;
    boolean marker = false;

    public long getServerProcessingTime() {
        return this.serverProcessingTime;
    }

    public FetchInfo(ConnectionSapDB connection, Cursor cursorName, DBTechTranslator[] infos, boolean apacketEncodingUnicode) throws SQLException {
        this.connection = connection;
        this.cursor = cursorName;
        this.packetEncodingUnicode = apacketEncodingUnicode;
        this.setColumnInfo(infos);
    }

    private void setColMapping() throws SQLException {
        int colCnt = this.columnInfo.length;
        this.columnMapping = new Hashtable(2 * colCnt);
        this.columnLabelMapping = new Hashtable(2 * colCnt);
        for (int i = 0; i < colCnt; ++i) {
            DBTechTranslator currentInfo = this.columnInfo[i];
            if (currentInfo == null) {
                throw SQLExceptionSapDB.generateSQLException("error.internal.invalidColumnDescription", new Integer(i + 1));
            }
            if (!this.columnMapping.containsKey(currentInfo.getColumnName())) {
                this.columnMapping.put(currentInfo.getColumnName(), currentInfo);
            }
            if (this.columnLabelMapping.containsKey(currentInfo.getColumnLabel())) continue;
            this.columnLabelMapping.put(currentInfo.getColumnLabel(), currentInfo);
        }
    }

    public Cursor getCursorName() {
        return this.cursor;
    }

    public DataPart executeFetchNext(int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(71, fetchSize, session);
        return this.executeFetch(r, session);
    }

    private DataPart executeFetch(RequestPacket r, JdbcCommunication session) throws SQLException {
        DataPartNGDB data;
        ReplyPacket rep = this.connection.execute(r, this, 2, session, false);
        long processingTime = rep.getServerExecutionTime(false);
        if (this.serverProcessingTime != -1L) {
            this.serverProcessingTime = processingTime < 0L ? processingTime : (this.serverProcessingTime += processingTime);
        }
        if ((data = rep.findResultSetPart()) == null) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.fetchnodatapart");
        }
        if (data.size() <= 0 && !data.isLastPart()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.fetchnodatapart");
        }
        data.setDataFormatDescription(this);
        return data;
    }

    public DataPart executeFetchAbsolute(long position, int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(72, fetchSize, session);
        OptionsPart op = r.addOptionsPart(44);
        op.addLongOption(1, position);
        op.close();
        return this.executeFetch(r, session);
    }

    public DataPart executeFetchLastWithRowNo(int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(76, fetchSize, session);
        return this.executeFetch(r, session);
    }

    public DataPart executeFetchRelative(long position, int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(73, fetchSize, session);
        OptionsPart op = r.addOptionsPart(44);
        op.addLongOption(1, position);
        op.close();
        return this.executeFetch(r, session);
    }

    public DataPart executeFetchFirst(int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(74, fetchSize, session);
        return this.executeFetch(r, session);
    }

    public DataPart executeFetchLast(int fetchSize, JdbcCommunication session) throws SQLException {
        RequestPacket r = this.initFetchCommand(75, fetchSize, session);
        return this.executeFetch(r, session);
    }

    private RequestPacket initFetchCommand(int messType, int fetchSize, JdbcCommunication session) throws SQLException {
        if (fetchSize < 1) {
            fetchSize = 1;
        }
        RequestPacket request = this.connection.getRequestPacket(session);
        request.initFetch(messType, this.connection.getAutoCommit(), this.cursor, fetchSize, this.connection.getStatementContext());
        return request;
    }

    public final DBTechTranslator getColumnInfo(String name) throws SQLException {
        String uc;
        Object o;
        if (this.columnMapping == null) {
            this.setColMapping();
        }
        if ((o = this.columnMapping.get(name)) == null && (o = this.columnMapping.get(uc = name.toUpperCase())) != null) {
            this.columnMapping.put(uc, o);
        }
        if (o == null && (o = this.columnLabelMapping.get(name)) == null && (o = this.columnLabelMapping.get(uc = name.toUpperCase())) != null) {
            this.columnLabelMapping.put(uc, o);
        }
        return (DBTechTranslator)o;
    }

    public DBTechTranslator[] getColInfo() throws SQLException {
        return this.columnInfo;
    }

    int numberOfColumns() {
        return this.columnInfo.length;
    }

    int getRecordSize() {
        return this.recordSize;
    }

    public int getNumberOfFields() {
        return this.columnInfo.length;
    }

    public int getDataTypeCode(int index) throws SQLException {
        return this.columnInfo[index - 1].getDataTypeCode();
    }

    private void setColumnInfo(DBTechTranslator[] infos) {
        this.columnInfo = infos;
        for (int i = 0; i < this.columnInfo.length; ++i) {
            DBTechTranslator currentInfo = infos[i];
            this.recordSize += currentInfo.getPhysicalLength();
        }
    }

    public boolean isCompleteDatatypeSupported() {
        return this.connection.getEngineFeatures().isCompleteDataTypeSupported();
    }
}

