/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.DBProcParameterInfo;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.Tracer;
import com.sap.db.util.VolumeIDList;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;

public class Parseinfo
implements DataFormatDescription {
    ConnectionSapDB connection;
    String sqlCmd;
    private VolumeIDList m_parseids = new VolumeIDList();
    DBTechTranslator[] paramInfos;
    int[] outputDataTypeCode;
    DBProcParameterInfo[] procParamInfos;
    int inputCount;
    int outputCount;
    boolean isSelect;
    boolean isDBProc;
    boolean hasLongs;
    boolean hasStreams;
    boolean cached;
    boolean hasDirectRecordPassing;
    boolean hasColumnStoreAccess;
    int functionCode;
    AbstractMap columnMap;
    DBTechTranslator[] columnInfos;
    boolean isClosed = false;
    boolean varDataInput = false;
    private static final int applicationCodeByte = 10;
    String updTableName;

    public Parseinfo(ConnectionSapDB connection, String sqlCmd, int functionCode) throws SQLException {
        this.connection = connection;
        this.sqlCmd = sqlCmd;
        this.paramInfos = new DBTechTranslator[0];
        this.outputDataTypeCode = new int[0];
        this.inputCount = 0;
        this.outputCount = 0;
        this.isSelect = false;
        this.isDBProc = false;
        this.hasLongs = false;
        this.hasStreams = false;
        this.hasDirectRecordPassing = false;
        this.hasColumnStoreAccess = false;
        this.functionCode = functionCode;
        this.updTableName = null;
        this.cached = false;
        this.varDataInput = false;
        if (functionCode == 5 || functionCode == 9 || functionCode == 6) {
            this.isSelect = true;
        }
        if (functionCode == 9 || functionCode == 8) {
            this.isDBProc = true;
        }
        this.columnMap = null;
    }

    public void setUpdateTableName(String atablename) {
        this.updTableName = atablename;
    }

    public DBTechTranslator[] getColumnInfos() {
        return this.columnInfos;
    }

    public void setParseIdAndSession(byte[] parseId, JdbcCommunication session) {
        ParseID pid = new ParseID(parseId, session);
        this.m_parseids.add(session.getVolumeID(), pid);
    }

    public synchronized void dropParseIDs() throws SQLException {
        if (this.connection != null) {
            Iterator iter = this.m_parseids.completeiterator();
            while (iter.hasNext()) {
                ParseID parseid = (ParseID)iter.next();
                if (parseid == null) continue;
                this.connection.handleTransaction(parseid.m_session, false);
                this.connection.dropParseid(parseid.parseID, parseid.m_session);
            }
            this.m_parseids.clear();
        }
    }

    public ParseID getParseId(JdbcCommunication session) {
        int volumeID = session.getVolumeID();
        ParseID pid = (ParseID)this.m_parseids.get(volumeID);
        if (pid != null && pid.m_sessionContextCount == session.getSessionContextCount()) {
            return pid;
        }
        return null;
    }

    protected void finalize() {
        this.cached = false;
    }

    public DBTechTranslator[] getParamInfo() {
        return this.paramInfos;
    }

    public void setSelect(boolean select) {
        this.isSelect = select;
    }

    public void setResultSetMetaData(DBTechTranslator[] resultSetMetaData) throws SQLException {
        this.columnMap = null;
        if (resultSetMetaData == null) {
            this.columnInfos = new DBTechTranslator[0];
        } else {
            this.columnInfos = resultSetMetaData;
            for (int i = 0; i < this.columnInfos.length; ++i) {
                this.hasLongs |= this.columnInfos[i].isLongKind();
                this.hasStreams |= this.columnInfos[i].isStreamKind();
            }
        }
    }

    public void setParameterMetaData(DBTechTranslator[] parameterMetaData, int numberOfOutputParams, boolean directRecordPassing, boolean columnStoreAccess) throws SQLException {
        this.inputCount = 0;
        this.outputCount = 0;
        this.outputDataTypeCode = new int[numberOfOutputParams];
        this.hasDirectRecordPassing = directRecordPassing;
        this.hasColumnStoreAccess = columnStoreAccess;
        this.paramInfos = parameterMetaData;
        for (int i = 0; i < this.paramInfos.length; ++i) {
            switch (this.paramInfos[i].getParameterMode()) {
                case 1: {
                    ++this.inputCount;
                    break;
                }
                case 4: {
                    this.outputDataTypeCode[this.outputCount] = this.paramInfos[i].getDataTypeCode();
                    ++this.outputCount;
                    break;
                }
                case 2: {
                    this.outputDataTypeCode[this.outputCount] = this.paramInfos[i].getDataTypeCode();
                    ++this.inputCount;
                    ++this.outputCount;
                }
            }
            this.hasLongs |= this.paramInfos[i].isLongKind();
            this.hasStreams |= this.paramInfos[i].isStreamKind();
        }
    }

    public AbstractMap getColumnMap() throws SQLException {
        if (this.columnMap != null) {
            return this.columnMap;
        }
        this.columnMap = new HashMap(this.paramInfos.length);
        for (int i = 0; i < this.paramInfos.length; ++i) {
            DBTechTranslator current = this.paramInfos[i];
            String colname = current.getColumnName();
            if (colname == null) continue;
            this.columnMap.put(colname, current);
        }
        return this.columnMap;
    }

    public String getSqlCommand() {
        return this.sqlCmd;
    }

    public int getNumberOfFields() {
        return this.outputCount;
    }

    public int getDataTypeCode(int index) throws SQLException {
        return this.outputDataTypeCode[index - 1];
    }

    public boolean isCompleteDatatypeSupported() {
        return this.connection.getEngineFeatures().isCompleteDataTypeSupported();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ParseID:");
        if (this.connection != null) {
            Iterator iter = this.m_parseids.iterator();
            while (iter.hasNext()) {
                ParseID parseid = (ParseID)iter.next();
                sb.append(Tracer.Hex2String(parseid.parseID));
            }
        }
        return sb.toString();
    }

    public class ParseID {
        public byte[] parseID;
        public long m_sessionContextCount;
        public JdbcCommunication m_session;

        public ParseID(byte[] parseID, JdbcCommunication session) {
            this.parseID = parseID;
            this.m_sessionContextCount = session.getSessionContextCount();
            this.m_session = session;
        }
    }
}

