/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ColumnInfo;
import com.sap.db.jdbc.ConnectionItem;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.ResultSetSapDBFinalize;
import com.sap.db.jdbc.UpdatableResultSetSapDB;
import com.sap.db.jdbc.UpdatableResultSetSapDBFinalize;
import com.sap.db.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartNGDB;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.PartEnumeration;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.StringUtil;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class StatementSapDB
extends ConnectionItem
implements Statement {
    protected ResultSetSapDB currentResultSet;
    protected int currentResultSetIndex;
    protected ArrayList resultsets;
    protected int rowsAffected = -1;
    protected String cursorNameString;
    protected final int resultSetType;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = 1;
    protected int fetchDirection = 1000;
    protected int fetchSize;
    protected Vector batchItems;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int queryTimeout = 0;
    protected boolean hasRowCount = false;
    protected boolean canceled = false;
    protected boolean packetEncodingUnicode = false;
    protected int cursorUsage;
    protected boolean isPoolable = false;
    protected String m_CommandInfo_Source;
    protected int m_CommandInfo_Line;
    protected JdbcCommunication m_Session;
    protected long serverProcessingTime = -1L;
    private boolean isMetaDataStatement = false;
    static final int Cursor_not_used = 0;
    static final int Cursor_scrollable = 1;
    static final int Cursor_forward_only = 2;
    protected int statementType;
    static final int Statement_User = 0;
    static final int Statement_Internal = 1;
    static final int Statement_UpdatableResultSet = 2;
    public static final long Statement_ServerProcessingTimeNotAvailable = -1L;
    protected static final int defaultConcurrency_C = 1007;
    protected static final int defaultHoldability_C = 1;
    public static final int BATCH_SUCCESS_NO_INFO_C = -2;
    public static final int BATCH_EXECUTE_FAILED_C = -3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSapDB(ConnectionSapDB connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection);
        this.cursorNameString = connection.nextCursorName();
        switch (resultSetType) {
            case 1003: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetType", "TYPE_FORWARD_ONLY");
            }
        }
        switch (resultSetConcurrency) {
            case 1007: {
                break;
            }
            case 1008: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY");
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetConcurrency", "CONCUR_READ_ONLY, CONCUR_UPDATABLE");
            }
        }
        switch (resultSetHoldability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "resultSetHoldability", "CLOSE_CURSORS_AT_COMMIT, HOLD_CURSORS_OVER_COMMIT");
            }
        }
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.statementType = 0;
        this.getSession(false, false, false);
        if (this.resultSetHoldability == 2) {
            ArrayList arrayList = connection.statementContainer;
            synchronized (arrayList) {
                connection.statementContainer.add(new WeakReference<StatementSapDB>(this));
            }
        }
    }

    public void addBatch(String sql) throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(sql);
    }

    public void cancel() throws SQLException {
        this.assertOpen();
        this.canceled = true;
        if (this.currentResultSet != null) {
            this.currentResultSet.cancel();
            try {
                ResultSetSapDB rs = this.currentResultSet;
                this.connection.cancel(this, rs.getExecutingObject());
            }
            catch (ClassCastException e) {
                this.connection.cancel(this);
            }
        } else {
            this.connection.cancel(this);
        }
    }

    public void clearBatch() throws SQLException {
        this.batchItems = null;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.closeResultSet(false);
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet(boolean restore) throws SQLException {
        if (this.resultsets != null && !this.resultsets.isEmpty()) {
            ConnectionSapDB connectionSapDB = this.connection;
            synchronized (connectionSapDB) {
                for (int i = 0; i < this.resultsets.size(); ++i) {
                    ResultSetSapDB rs = (ResultSetSapDB)this.resultsets.get(i);
                    rs.close();
                }
            }
            this.resultsets.clear();
        }
        this.cursorUsage = 0;
        this.currentResultSet = null;
        this.currentResultSetIndex = 0;
    }

    public boolean execute(String sql) throws SQLException {
        boolean isQuery = false;
        JdbcCommunication session = this.getSession(false, true, !this.cmdIsQuery(sql));
        return this.execute(sql, isQuery, this.resultSetType, this.resultSetConcurrency, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(String sql, boolean forQuery, int resultSetType, int resultSetConcurrency, JdbcCommunication session) throws SQLException {
        try {
            boolean isQuery;
            this.canceled = false;
            this.clearWarnings();
            this.assertOpen();
            if (sql == null) {
                throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.null");
            }
            try {
                this.closeResultSet(true);
                ReplyPacket replyPacket = this.sendSQL(sql, resultSetType, resultSetConcurrency, false, session);
                isQuery = this.parseResult(replyPacket, sql, null);
            }
            catch (InternalReconnectException reconnect) {
                isQuery = this.execute(sql, forQuery, resultSetType, resultSetConcurrency, session);
            }
            boolean bl = isQuery;
            Object var10_10 = null;
            this.canceled = false;
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.canceled = false;
            throw throwable;
        }
    }

    protected String getUpdTablename(String sqlCmd) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getUpdTablename", "StatementSapDB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        this.assertOpen();
        this.serverProcessingTime = 0L;
        if (this.batchItems == null) {
            return new int[0];
        }
        int count = this.batchItems.size();
        int[] result = new int[count];
        Vector items = this.batchItems;
        this.batchItems = null;
        JdbcCommunication session = this.getSession(false, true, true);
        try {
            this.canceled = false;
            int inputCursor = 0;
            int receiveCursor = 0;
            this.packetEncodingUnicode = false;
            while (inputCursor < count) {
                RequestPacket requestPacket = this.connection.getRequestPacket(session);
                requestPacket.initDbsCommand(this.connection.m_transaction.m_autocommit, (String)items.elementAt(inputCursor), 1003, this.resultSetHoldability, this.connection.getStatementContext());
                requestPacket.setMaxSegment((short)Short.MAX_VALUE);
                ++inputCursor;
                while (inputCursor < count && requestPacket.initDbsCommand((String)items.elementAt(inputCursor), false, this.connection.m_transaction.m_autocommit, 1003, this.resultSetHoldability, this.connection.getStatementContext())) {
                    ++inputCursor;
                }
                ReplyPacket replyPacket = this.connection.execute(requestPacket, true, false, this, 2, session, false);
                while (receiveCursor < inputCursor) {
                    if (replyPacket.returnCode() != 0) {
                        int[] resArr = new int[receiveCursor];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        throw new BatchUpdateExceptionSapDB(resArr, replyPacket.createException());
                    }
                    int functionCode = replyPacket.functionCode();
                    if (functionCode == 5 || functionCode == 6) {
                        int[] resArr = new int[receiveCursor + 1];
                        System.arraycopy(result, 0, resArr, 0, receiveCursor);
                        resArr[receiveCursor] = -3;
                        throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset.withnumber", Integer.toString(receiveCursor + 1)), "2A000", resArr);
                    }
                    result[receiveCursor] = replyPacket.rowsAffected(false);
                    if (result[receiveCursor] == -1) {
                        result[receiveCursor] = -2;
                    }
                    long processingTime = replyPacket.getServerExecutionTime(false);
                    if (this.serverProcessingTime != -1L) {
                        this.serverProcessingTime = processingTime < 0L ? processingTime : (this.serverProcessingTime += processingTime);
                    }
                    replyPacket.nextSegment();
                    ++receiveCursor;
                }
            }
            int[] nArray = result;
            Object var13_15 = null;
            this.canceled = false;
            return nArray;
        }
        catch (InternalReconnectException reconn) {
            try {
                this.batchItems = items;
                int[] nArray = this.executeBatch();
                Object var13_16 = null;
                this.canceled = false;
                return nArray;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                this.canceled = false;
                throw throwable;
            }
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.assertOpen();
        if (!this.cmdIsQuery(sql)) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.rowcount");
        }
        JdbcCommunication session = this.getSession(false, true, false);
        this.execute(sql, true, this.resultSetType, this.resultSetConcurrency, session);
        return this.currentResultSet;
    }

    public ResultSetSapDB executeQuerySap(String sql) throws SQLException {
        return (ResultSetSapDB)this.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.assertOpen();
        JdbcCommunication session = this.getSession(false, true, true);
        boolean isQuery = this.execute(sql, false, 1003, 1007, session);
        if (isQuery) {
            throw SQLExceptionSapDB.generateSQLException("error.sqlstatement.resultset");
        }
        if (this.hasRowCount) {
            return this.rowsAffected;
        }
        return 0;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int parm1) throws SQLException {
        this.assertOpen();
        this.rowsAffected = -1;
        switch (parm1) {
            case 1: {
                if (this.currentResultSet != null) {
                    ConnectionSapDB connectionSapDB = this.connection;
                    synchronized (connectionSapDB) {
                        this.currentResultSet.close();
                    }
                }
                this.cursorUsage = 0;
                this.currentResultSet = null;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.resultsets != null && !this.resultsets.isEmpty()) {
                    ConnectionSapDB connectionSapDB = this.connection;
                    synchronized (connectionSapDB) {
                        for (int i = 0; i <= this.currentResultSetIndex; ++i) {
                            ResultSetSapDB rs = (ResultSetSapDB)this.resultsets.get(i);
                            rs.close();
                        }
                    }
                }
                this.cursorUsage = 0;
                this.currentResultSet = null;
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "getMoreResults", "Statement.CLOSE_CURRENT_RESULT, Statement.KEEP_CURRENT_RESULT, or Statement.CLOSE_ALL_RESULTS");
            }
        }
        if (this.resultsets != null && this.resultsets.size() > this.currentResultSetIndex + 1) {
            ++this.currentResultSetIndex;
            this.currentResultSet = (ResultSetSapDB)this.resultsets.get(this.currentResultSetIndex);
            this.cursorUsage = this.resultSetType == 1003 ? 2 : 1;
            return true;
        }
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        this.assertOpen();
        return this.currentResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        this.assertOpen();
        return this.rowsAffected;
    }

    protected boolean isQuerySQL(String sql) {
        if (sql.startsWith("SELECT") || sql.startsWith("MDX SELECT")) {
            return true;
        }
        String begin = sql.substring(0, Math.min(30, sql.length())).trim().toLowerCase();
        return begin.startsWith("select") || begin.startsWith("mdx select");
    }

    protected boolean parseResult(ReplyPacket replyPacket, String sqlCmd, DBTechTranslator[] infos) throws SQLException {
        return this.parseResult(replyPacket, sqlCmd, infos, true);
    }

    protected boolean parseResult(ReplyPacket replyPacket, String sqlCmd, DBTechTranslator[] infos, boolean resetrowcount) throws SQLException {
        String tableName = null;
        boolean isQuery = false;
        boolean rowNotFound = false;
        Cursor cursor = null;
        DataPartNGDB resultPart = null;
        this.serverProcessingTime = -1L;
        if (resetrowcount) {
            this.rowsAffected = -1;
            this.hasRowCount = false;
        }
        int functionCode = replyPacket.functionCode();
        switch (functionCode) {
            case 5: 
            case 6: 
            case 9: {
                isQuery = true;
                break;
            }
            case 11: {
                if (this.connection.closeCursorAtCommit()) {
                    this.connection.isClosed();
                }
                this.connection.m_transaction.clear(this.connection);
                break;
            }
            case 1: {
                this.handleDDLReply();
                break;
            }
            case 12: {
                this.connection.m_transaction.clear(this.connection);
                ++this.connection.m_rollbackCount;
                break;
            }
            case 14: {
                this.handleDDLReply();
                this.connection.refreshMetaData();
            }
        }
        PartEnumeration enume = replyPacket.partEnumeration();
        while (enume.hasMoreElements()) {
            enume.nextElement();
            int partKind = enume.partKind();
            switch (partKind) {
                case 48: {
                    ResultSetSapDB result;
                    if (isQuery && infos != null && cursor != null) {
                        if (this.resultsets == null) {
                            this.resultsets = new ArrayList();
                        }
                        if (resultPart == null) {
                            resultPart = new DataPartNGDB(new FullswapMem(new byte[0]), 0, false, false);
                        }
                        result = this.createResultSet(sqlCmd, tableName, cursor, infos, rowNotFound, resultPart);
                        this.resultsets.add(result);
                        tableName = null;
                        cursor = null;
                        infos = null;
                        resultPart = null;
                        rowNotFound = false;
                    }
                    if (infos != null) break;
                    infos = replyPacket.parseResultSetMetaData(this.connection);
                    break;
                }
                case 14: {
                    if (infos != null) break;
                    infos = replyPacket.parseResultSetMetaDataOld(this.connection);
                    break;
                }
                case 12: {
                    if (isQuery) break;
                    this.rowsAffected = replyPacket.rowsAffected(true);
                    this.hasRowCount = true;
                    break;
                }
                case 13: {
                    Cursor cname;
                    ResultSetSapDB result;
                    if (isQuery && infos != null && cursor != null) {
                        if (this.resultsets == null) {
                            this.resultsets = new ArrayList();
                        }
                        if (resultPart == null) {
                            resultPart = new DataPartNGDB(new FullswapMem(new byte[0]), 0, false, false);
                        }
                        result = this.createResultSet(sqlCmd, tableName, cursor, infos, rowNotFound, resultPart);
                        this.resultsets.add(result);
                        tableName = null;
                        cursor = null;
                        infos = null;
                        resultPart = null;
                        rowNotFound = false;
                    }
                    if ((cname = replyPacket.getCursor()) == null) break;
                    cursor = cname;
                    break;
                }
                case 5: {
                    resultPart = replyPacket.getResultSetPart();
                    if ((replyPacket.getPartAttributes() & 8) != 0) {
                        this.rowsAffected = -1;
                        rowNotFound = true;
                        if (!isQuery) {
                            this.rowsAffected = 0;
                        }
                    }
                    if (!isQuery || infos == null || cursor == null) break;
                    if (this.resultsets == null) {
                        this.resultsets = new ArrayList();
                    }
                    if (resultPart == null) {
                        resultPart = new DataPartNGDB(new FullswapMem(new byte[0]), 0, false, false);
                    }
                    ResultSetSapDB result = this.createResultSet(sqlCmd, tableName, cursor, infos, rowNotFound, resultPart);
                    this.resultsets.add(result);
                    tableName = null;
                    cursor = null;
                    infos = null;
                    resultPart = null;
                    rowNotFound = false;
                    break;
                }
                case 6: {
                    break;
                }
                case 39: {
                    OptionsPart sc = replyPacket.getStatementContext();
                    do {
                        switch (sc.getOptionName()) {
                            case 2: {
                                this.serverProcessingTime = sc.getOptionLongValue();
                            }
                        }
                    } while (sc.nextOption());
                    break;
                }
                case 19: {
                    tableName = replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength());
                    break;
                }
            }
        }
        if (isQuery) {
            if (infos != null && cursor != null) {
                if (this.resultsets == null) {
                    this.resultsets = new ArrayList();
                }
                if (resultPart == null) {
                    resultPart = new DataPartNGDB(new FullswapMem(new byte[0]), 0, false, false);
                }
                ResultSetSapDB result = this.createResultSet(sqlCmd, tableName, cursor, infos, rowNotFound, resultPart);
                this.resultsets.add(result);
            }
            if (this.resultsets != null) {
                this.currentResultSet = (ResultSetSapDB)this.resultsets.get(0);
            }
        }
        return isQuery;
    }

    private void handleDDLReply() throws SQLException {
        if (this.connection.isDDLCommitted) {
            this.connection.closeCursorAtCommit();
            this.connection.m_transaction.clear(this.connection);
        }
    }

    protected ResultSetSapDB createResultSet(String sqlCmd, String tableName, Cursor cursorName, DBTechTranslator[] infos, boolean rowNotFound, DataPartNGDB data) throws SQLException {
        ResultSetSapDB result;
        FetchInfo fetchInfo = this.getFetchInfo(cursorName, infos);
        data.setDataFormatDescription(fetchInfo);
        int n = this.cursorUsage = this.resultSetType == 1003 ? 2 : 1;
        if (this.resultSetConcurrency == 1008) {
            if (tableName == null) {
                tableName = this.getUpdTablename(sqlCmd);
            }
            result = Driver.getBooleanProperty(this.connection.getConnectProperties(), "closehandlesonfinalize", true) ? new UpdatableResultSetSapDBFinalize(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, tableName, this.cursorUsage, data) : new UpdatableResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, tableName, this.cursorUsage, data);
        } else {
            result = Driver.getBooleanProperty(this.connection.getConnectProperties(), "closehandlesonfinalize", true) ? new ResultSetSapDBFinalize(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, this.cursorUsage, data) : new ResultSetSapDB(this.connection, fetchInfo, this, this.fetchSize, this.maxRows, this.cursorUsage, data);
        }
        if (this.fetchDirection == 1001) {
            result.setFetchDirection(this.fetchDirection);
        }
        if (rowNotFound) {
            result.setEmpty(true);
        }
        result.setFromMetaData(this.isMetaDataStatement);
        return result;
    }

    protected FetchInfo getFetchInfo(Cursor cursorName, DBTechTranslator[] infos) throws SQLException {
        FetchInfo result = new FetchInfo(this.connection, cursorName, infos, this.packetEncodingUnicode);
        return result;
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String sqlCmd, int gcFlags, boolean parseAgain, JdbcCommunication session) throws SQLException {
        requestPacket.initDbsCommand(this.connection.m_transaction.m_autocommit, sqlCmd, this.resultSetType, this.resultSetHoldability, this.connection.getStatementContext());
        if (this.m_CommandInfo_Source != null) {
            requestPacket.addCommandInfoPart(this.m_CommandInfo_Source, this.m_CommandInfo_Line);
        }
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, gcFlags, session, false);
        return replyPacket;
    }

    protected ReplyPacket sendSQL(String sql, int resultSetType, int resultSetConcurrency, boolean parseAgain, JdbcCommunication session) throws SQLException {
        ReplyPacket replyPacket;
        String actualSQL = sql;
        boolean touchedCommand = false;
        if (resultSetConcurrency == 1008) {
            actualSQL = actualSQL + " FOR UPDATE ";
            touchedCommand = true;
        }
        if (resultSetType == 1004) {
            actualSQL = actualSQL + " FOR REUSE";
            touchedCommand = true;
        }
        int statementlen = this.connection.maxStatementLength();
        if (touchedCommand) {
            int cesulen = 0;
            RequestPacket requestPacket = actualSQL.length() * 3 < statementlen ? this.connection.getRequestPacket(session) : ((cesulen = StringUtil.getCesu8Length(actualSQL)) < statementlen ? this.connection.getRequestPacket(session) : this.connection.getRequestPacket(cesulen + 1024, session));
            this.packetEncodingUnicode = false;
            replyPacket = this.sendCommand(requestPacket, actualSQL, 1, parseAgain, session);
        } else {
            int cesulen = 0;
            RequestPacket requestPacket = sql.length() * 3 < statementlen ? this.connection.getRequestPacket(session) : ((cesulen = StringUtil.getCesu8Length(sql)) < statementlen ? this.connection.getRequestPacket(session) : this.connection.getRequestPacket(cesulen + 1024, session));
            this.packetEncodingUnicode = false;
            replyPacket = this.sendCommand(requestPacket, sql, 1, parseAgain, session);
        }
        return replyPacket;
    }

    public void setCursorName(String name) throws SQLException {
        this.assertOpen();
        if (name != null && name.length() > 0) {
            this.cursorNameString = name;
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.assertOpen();
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue.wexample", "direction", "FETCH_FORWARD, FETCH_REVERSE, FETCH_UNKNOWN");
            }
        }
        this.fetchDirection = direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.fetchsize", Integer.toString(rows));
        }
        this.fetchSize = rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.maxfieldsize", Integer.toString(max));
        }
        this.assertOpen();
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.maxrows", Integer.toString(max));
        }
        this.assertOpen();
        this.maxRows = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.querytimeout", Integer.toString(seconds));
        }
        this.assertOpen();
        this.queryTimeout = seconds;
    }

    private boolean cmdIsQuery(String sql) {
        String[] keywords = new String[]{"SELECT", "CALL", "DECLARE", "MDX SELECT", "EXPLAIN"};
        int pos = 0;
        if (sql == null) {
            return false;
        }
        char current = sql.charAt(pos);
        while (current == '(' || Character.isWhitespace(current)) {
            current = sql.charAt(++pos);
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!sql.regionMatches(true, pos, keywords[i], 0, keywords[i].length())) continue;
            return true;
        }
        return false;
    }

    protected void updateFetchInfo(DBTechTranslator[] infos, ColumnInfo[] columnNames) throws SQLException {
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.executeUpdate(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 1) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames.length != 0) {
            throw SQLExceptionSapDB.generateSQLException("error.autogenkeys.retrieval.unsupported");
        }
        return this.execute(sql);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    public boolean isPacketEncodingUnicode() {
        return this.packetEncodingUnicode;
    }

    public String toString() {
        if (this.connection != null && !this.connection.isClosed) {
            return super.toString() + "[T" + this.m_Session.getKernelTaskID() + "]";
        }
        return super.toString() + "[closed]";
    }

    public boolean isClosed() throws SQLException {
        return this.connection == null || this.connection.isClosed;
    }

    public boolean isPoolable() throws SQLException {
        this.assertOpen();
        return this.isPoolable;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.assertOpen();
        this.isPoolable = poolable;
    }

    public void setCommandInfo(String source, int line) throws SQLException {
        this.assertOpen();
        this.m_CommandInfo_Source = source;
        this.m_CommandInfo_Line = line;
    }

    public JdbcCommunication getSession(boolean avoidOpenSession, boolean handleTransaction, boolean isWriteOperation) throws SQLException {
        this.m_Session = this.connection.m_sessionPool.getPrimarySession();
        if (handleTransaction) {
            this.connection.m_transaction.handleTransaction(this.connection, this.m_Session, isWriteOperation);
        }
        return this.m_Session;
    }

    public long getServerProcessingTime() throws SQLException {
        return this.serverProcessingTime;
    }

    void setMetaDataStatement(boolean isMetaDataStatement) {
        this.isMetaDataStatement = isMetaDataStatement;
    }
}

