/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.ConnectionException;
import com.sap.db.jdbc.exceptions.DatabaseException;
import com.sap.db.jdbc.exceptions.JDBCDriverException;
import com.sap.db.jdbc.exceptions.NotSupportedException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.exceptions.TimeoutException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLDataException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLFeatureNotSupportedException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLIntegrityConstraintViolationException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLInvalidAuthorizationSpecException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLNonTransientConnectionException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLSyntaxErrorException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLTimeoutException;
import com.sap.db.jdbc.exceptions.jdbc40.SQLTransactionRollbackException;
import com.sap.db.util.MessageTranslator;
import java.sql.SQLException;

public class SQLExceptionSapDB
extends SQLException
implements SQLExceptionSapDBInterface {
    public static final int[] NO_UPDATE_COUNTS = new int[0];
    protected String prefix = "";
    private int errorPos = 0;
    private int m_rteError = 0;
    private int[] m_updateCountsFromLastPacket = null;

    public int[] getUpdateCountsFromLastPacket() {
        return this.m_updateCountsFromLastPacket;
    }

    public int getRTEReturncode() {
        return this.m_rteError;
    }

    protected SQLExceptionSapDB(String reason, String sqlState, int vendorCode, int errpos, int[] updateCountsFromLastPacket) {
        super(reason, sqlState, vendorCode);
        this.errorPos = errpos;
        this.m_updateCountsFromLastPacket = updateCountsFromLastPacket;
    }

    public int getErrorPos() {
        return this.errorPos;
    }

    public String getMessage() {
        return this.prefix + super.getMessage();
    }

    public boolean isConnectionReleasing() {
        int err = this.getErrorCode();
        switch (err) {
            case -904: 
            case -813: 
            case -709: 
            case -708: 
            case -75: 
            case -71: 
            case -70: 
            case 700: 
            case 710: 
            case 750: {
                return true;
            }
        }
        return false;
    }

    public static SQLException generateSQLException(String messageKey) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0, NO_UPDATE_COUNTS);
    }

    public static SQLException generateSQLException(String messageKey, Throwable cause) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0, NO_UPDATE_COUNTS, cause);
    }

    public static SQLException generateSQLException(String messageKey, Object val1) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0, NO_UPDATE_COUNTS);
    }

    public static SQLException generateSQLException(String messageKey, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, 0, NO_UPDATE_COUNTS);
    }

    public static SQLException generateSQLException(String message, String sqlState, int vendorCode, int errpos, int[] updateCountsFromLastPacket, Throwable cause) {
        return SQLExceptionSapDB.createException(message, sqlState, vendorCode, errpos, 0, updateCountsFromLastPacket, cause);
    }

    public static SQLException generateDatabaseException(String messageKey, String sqlState, int vendorCode, int errpos, int rteError, int[] updateCountsFromLastPacket, Object val1, Object val2, Object val3) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2, val3), sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
    }

    public static SQLException generateDatabaseException(String messageKey, String sqlState, int vendorCode, int errpos, int rteError, int[] updateCountsFromLastPacket, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2), sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
    }

    public static SQLException generateDatabaseException(String messageKey, String sqlState, int vendorCode, int errpos, int rteError, int[] updateCountsFromLastPacket, Throwable cause, Object val1, Object val2) {
        return SQLExceptionSapDB.createException(MessageTranslator.translate(messageKey, val1, val2), sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket, cause);
    }

    private static SQLException createException(String errText, String sqlState, int vendorCode, int errpos, int rteError, int[] updateCountsFromLastPacket, Throwable cause) {
        SQLException r = SQLExceptionSapDB.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
        if (cause != null) {
            r.initCause(cause);
        }
        return r;
    }

    private static SQLException createException(String errText, String sqlState, int vendorCode, int errpos, int rteError, int[] updateCountsFromLastPacket) {
        if (sqlState == null || sqlState.length() != 5) {
            return new JDBCDriverException(errText, "HY000", vendorCode, errpos, updateCountsFromLastPacket);
        }
        char state1 = sqlState.charAt(0);
        char state2 = sqlState.charAt(1);
        switch (state1) {
            case '0': {
                if (state2 == '8') {
                    if (Driver.isJDBC40) {
                        return SQLNonTransientConnectionException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                    }
                    return new ConnectionException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
                }
                if (state2 != 'A') break;
                if (Driver.isJDBC40) {
                    return SQLFeatureNotSupportedException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                }
                return new NotSupportedException(errText, sqlState, vendorCode, updateCountsFromLastPacket);
            }
            case '2': {
                if (state2 == '2') {
                    if (Driver.isJDBC40) {
                        return SQLDataException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                    }
                    return new JDBCDriverException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
                }
                if (state2 == '3') {
                    if (Driver.isJDBC40) {
                        return SQLIntegrityConstraintViolationException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                    }
                    return new DatabaseException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
                }
                if (state2 != '8') break;
                if (Driver.isJDBC40) {
                    return SQLInvalidAuthorizationSpecException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                }
                return new JDBCDriverException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
            }
            case '4': {
                if (state2 == '0') {
                    if (Driver.isJDBC40) {
                        return SQLTransactionRollbackException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                    }
                    return new DatabaseException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
                }
                if (state2 != '2') break;
                if (Driver.isJDBC40) {
                    return SQLSyntaxErrorException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                }
                return new DatabaseException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
            }
            case 'H': {
                if (state2 != 'Y') break;
                if (sqlState.equals("HYT01")) {
                    if (Driver.isJDBC40) {
                        return SQLTimeoutException.createException(errText, sqlState, vendorCode, errpos, rteError, updateCountsFromLastPacket);
                    }
                    return new TimeoutException(errText, sqlState, vendorCode, updateCountsFromLastPacket);
                }
                return new JDBCDriverException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
            }
        }
        return new JDBCDriverException(errText, sqlState, vendorCode, errpos, updateCountsFromLastPacket);
    }
}

