/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.NumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BigIntegerTranslator
extends NumericTranslator {
    BigIntegerTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBigDecimal(controller, mem);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        long val = mem.getInt8(this.bufpos_output);
        result = BigDecimal.valueOf(val);
        return result;
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        long val = this.getLong(controller, mem);
        return val != 0L;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return (byte)this.getLong(controller, mem);
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NaN;
            }
        }
        return this.getLong(controller, mem);
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Float.NaN;
            }
        }
        return this.getLong(controller, mem);
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return (int)this.getLong(controller, mem);
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        long result = 0L;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        result = mem.getInt8(this.bufpos_output);
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        return new Long(this.getLong(controller, mem));
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public int getScale() {
        return 0;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return (short)this.getLong(controller, mem);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Byte) {
            result = this.transByteForInput((Byte)obj);
        } else if (obj instanceof Double) {
            result = this.transDoubleForInput((Double)obj);
        } else if (obj instanceof Float) {
            result = this.transFloatForInput(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            result = this.transIntForInput((Integer)obj);
        } else if (obj instanceof Long) {
            result = this.transLongForInput((Long)obj);
        } else if (obj instanceof Short) {
            result = this.transShortForInput((Short)obj);
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return null;
            }
            case 2: {
                return "NaN";
            }
        }
        return String.valueOf(this.getLong(controller, mem));
    }

    public Object transByteForInput(byte val) throws SQLException {
        byte[] value = new byte[]{1, val};
        return value;
    }
}

