/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.NumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class DecimalTranslator
extends NumericTranslator {
    protected static final int D_SIZE = 2;
    protected static final int D_BITS = 64;
    protected static final int E_BITS = 14;
    protected static final int EXP_BIAS = 6176;
    protected static final int MAX_PRECISION = 34;
    protected static final int MAX_EXPONENT = 12352;
    protected static final int EXP_NULL = 14336;
    protected static final int EXP_INFINITY = 12288;
    protected static final int MIN_PRECISION = 1;
    protected static final int MIN_EXPONENT = 0;
    protected static final int MIN_SCALE = -6176;
    protected static final int MAX_SCALE = 6176;
    protected static final int MAX_STRING_LENGTH = 6220;
    protected static final int D_HEADER = 1;
    protected static final long D_FILLBIT = -2L;
    protected static final long D_SIGNBIT = Long.MIN_VALUE;
    protected static final long D_NULLBIT = 0x7000000000000000L;
    protected static final long D_BITMASK = 0x1FFFFFFFFFFFFL;

    DecimalTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBigDecimal(controller, mem);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        byte[] val = mem.getBytes(this.bufpos_output, 16);
        long[] dec_ = new long[]{NumericTranslator.parseLong(val, 0), NumericTranslator.parseLong(val, 8)};
        if ((dec_[1] & 0x7000000000000000L) != 0x7000000000000000L) {
            int signum = (dec_[1] & Long.MIN_VALUE) == 0L ? 1 : -1;
            long exponent = (dec_[1] & 0x7FFE000000000000L) >> 49;
            exponent = -(exponent - 6176L);
            byte[] ba = new byte[16];
            for (int i = 1; i < 16; ++i) {
                ba[i] = val[15 - i];
            }
            ba[1] = (byte)(ba[1] & 1);
            if (exponent >= 0L) {
                BigInteger bi = new BigInteger(signum, ba);
                BigDecimal bd = new BigDecimal(bi, (int)exponent);
                if (this.fraction < Short.MAX_VALUE && exponent != (long)this.fraction) {
                    bd = bd.setScale(this.getScale());
                }
                return bd;
            }
            BigInteger bi = new BigInteger(signum, ba);
            StringBuffer sb = new StringBuffer(bi.toString());
            exponent *= -1L;
            for (long l = 0L; l < exponent; ++l) {
                sb.append("0");
            }
            BigDecimal bd = new BigDecimal(new BigInteger(sb.toString()), 0);
            if (this.fraction < Short.MAX_VALUE) {
                bd = bd.setScale(this.getScale());
            }
            return bd;
        }
        return null;
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        long val = this.getLong(controller, mem);
        return val != 0L;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return (byte)this.getLong(controller, mem);
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NaN;
            }
        }
        return this.getBigDecimal(controller, mem).doubleValue();
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Float.NaN;
            }
        }
        return this.getBigDecimal(controller, mem).floatValue();
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return (int)this.getLong(controller, mem);
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        long result = 0L;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        BigDecimal bd = this.getBigDecimal(controller, mem);
        result = bd.longValue();
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        return this.getBigDecimal(controller, mem);
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return (short)this.getLong(controller, mem);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Byte) {
            result = this.transByteForInput((Byte)obj);
        } else if (obj instanceof Double) {
            result = this.transDoubleForInput((Double)obj);
        } else if (obj instanceof Float) {
            result = this.transFloatForInput(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            result = this.transIntForInput((Integer)obj);
        } else if (obj instanceof Long) {
            result = this.transLongForInput((Long)obj);
        } else if (obj instanceof Short) {
            result = this.transShortForInput((Short)obj);
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return null;
            }
            case 2: {
                return "NaN";
            }
        }
        return String.valueOf(this.getBigDecimal(controller, mem));
    }
}

