/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.translators.AbstractGetval;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.RawByteReader;
import com.sap.db.util.StringUtil;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

class GetvalLob
extends AbstractGetval
implements Blob,
Clob,
NClob {
    public GetvalLob(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, JdbcCommunication session) {
        super(connection, descriptor, dataPart, 1, session);
    }

    public long length() throws SQLException {
        return this.lengthInBytes();
    }

    protected boolean isReReadEnabled() {
        return true;
    }

    public java.io.InputStream getAsciiStream() throws SQLException {
        this.isValid();
        return new InputStream();
    }

    public java.io.InputStream getBinaryStream() throws SQLException {
        this.isValid();
        return new InputStream();
    }

    public Reader getCharacterStream() throws SQLException {
        this.isValid();
        if (this.sourceType == 1) {
            return new RawByteReader(this.getAsciiStream(), 1);
        }
        return new RawByteReader(this.getAsciiStream(), 2);
    }

    public byte[] transSearchPattern(String searchPattern) {
        byte[] pattern = StringUtil.bytes_iso8859_1(searchPattern);
        return pattern;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] result;
        --pos;
        try {
            int bytesRead;
            if (pos < this.currentChunkStartPos || pos > this.currentChunkEndPos || pos < this.longPosition) {
                this.changePositionInLob(pos);
            }
            java.io.InputStream stream = this.getBinaryStream();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            if ((bytesRead = stream.read(result = new byte[length], 0, length)) < length) {
                byte[] tmp = new byte[bytesRead];
                System.arraycopy(result, 0, tmp, 0, bytesRead);
                result = tmp;
            }
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioExc.getMessage());
        }
        return result;
    }

    protected void changePositionInLob(long newPosition) throws StreamIOException {
        this.longPosition = newPosition;
        this.atEnd = false;
        this.lastChunk = false;
        if (!this.firstChunk && this.totalLOBByteLength > 1024L || this.itemsInBuffer != 0) {
            this.nextChunk();
        }
    }

    public String getSubString(long pos, int length) throws SQLException {
        byte[] bytes = this.getBytes(pos, length);
        try {
            return new String(bytes, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public long position(byte[] pattern, long start) throws SQLException {
        return this.getPositionGetval(pattern, start);
    }

    public long position(Blob pattern, long start) throws SQLException {
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    public java.io.InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getBinaryStream", "GetvalLob");
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getCharacterStream", "GetvalLob");
    }

    protected boolean isBinary() {
        return this.sourceType == 1 || this.sourceType == 0;
    }

    private class InputStream
    extends java.io.InputStream {
        boolean streamAtEnd = false;

        private InputStream() {
        }

        public int read() throws StreamIOException {
            if (GetvalLob.this.itemsInBuffer <= 0) {
                GetvalLob.this.nextChunk();
            }
            if (GetvalLob.this.atEnd) {
                return -1;
            }
            int result = GetvalLob.this.streamBuffer.getUInt1(0);
            GetvalLob.this.streamBuffer.moveBase(1);
            --GetvalLob.this.itemsInBuffer;
            ++GetvalLob.this.longPosition;
            return result;
        }

        public int read(byte[] b, int off, int len) throws StreamIOException {
            if (this.streamAtEnd) {
                return -1;
            }
            int bytesCopied = 0;
            int nCopied = 0;
            while (len > 0 && !GetvalLob.this.atEnd) {
                if (GetvalLob.this.itemsInBuffer <= 0) {
                    GetvalLob.this.nextChunk();
                }
                if (GetvalLob.this.atEnd) continue;
                int chunkSize = Math.min(len, GetvalLob.this.itemsInBuffer);
                byte[] chunk = GetvalLob.this.streamBuffer.getBytes(0, chunkSize);
                System.arraycopy(chunk, 0, b, off, chunkSize);
                GetvalLob.this.streamBuffer.moveBase(chunkSize);
                len -= chunkSize;
                off += chunkSize;
                GetvalLob.this.itemsInBuffer -= chunkSize;
                nCopied = bytesCopied += chunkSize;
                GetvalLob.this.longPosition += (long)chunkSize;
            }
            if (bytesCopied == 0 && GetvalLob.this.atEnd) {
                GetvalLob.this.changePositionInLob(0L);
                this.streamAtEnd = true;
                return -1;
            }
            return nCopied;
        }
    }
}

