/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.AbstractGetval;
import com.sap.db.jdbc.translators.GetvalCLOB;
import com.sap.db.jdbc.translators.GetvalLob;
import com.sap.db.jdbc.translators.LOBTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.StructuredMem;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;

public class NCLOBTranslator
extends LOBTranslator {
    protected NCLOBTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufposIn, int bufposOut, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufposIn, bufposOut, readOnly, autoIncre);
    }

    public AbstractGetval getStream(SQLParamController controller, DataPart mem, StructuredMem dummy) throws SQLException {
        GetvalCLOB getval = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            StructuredMem longData = mem.getLOBDataPointer(this.bufpos_output);
            getval = new GetvalCLOB(controller.getConnectionSapDB(), descriptor, longData, controller.getSession(true, false));
        }
        return getval;
    }

    public GetvalLob getLob(SQLParamController controller, DataPart mem, StructuredMem dummy) throws SQLException {
        GetvalCLOB result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            StructuredMem longData = mem.getLOBDataPointer(this.bufpos_output);
            result = new GetvalCLOB(controller.getConnectionSapDB(), descriptor, longData, controller.getSession(true, false));
        }
        return result;
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        if (clob == null) {
            return null;
        }
        return this.transCharacterStreamForInput(clob.getCharacterStream(), -1L);
    }

    public Object transNClobForInput(NClob clob, ConnectionSapDB conn) throws SQLException {
        if (clob == null) {
            return null;
        }
        return this.transCharacterStreamForInput(clob.getCharacterStream(), -1L);
    }
}

