/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.NumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;

public class RealTranslator
extends NumericTranslator {
    RealTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBigDecimal(controller, mem);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        switch (this.dataType) {
            case 6: {
                float val = this.getFloat(controller, mem);
                return BigDecimal.valueOf(val);
            }
        }
        double vald = this.getDouble(controller, mem);
        return BigDecimal.valueOf(vald);
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        double val = this.getDouble(controller, mem);
        return val != 0.0;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return (byte)this.getFloat(controller, mem);
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Float.NaN;
            }
        }
        byte[] buffer = mem.getBytes(this.bufpos_output, 8);
        float value = Float.intBitsToFloat(buffer[0] & 0xFF | buffer[1] << 8 & 0xFF00 | buffer[2] << 16 & 0xFF0000 | buffer[3] << 24 & 0xFF000000);
        return value;
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NaN;
            }
        }
        return this.getFloat(controller, mem);
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return (int)this.getFloat(controller, mem);
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        long result = 0L;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        return (long)this.getFloat(controller, mem);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        return new Float(this.getFloat(controller, mem));
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return (short)this.getFloat(controller, mem);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Byte) {
            result = this.transByteForInput((Byte)obj);
        } else if (obj instanceof Double) {
            result = this.transDoubleForInput((Double)obj);
        } else if (obj instanceof Float) {
            result = this.transFloatForInput(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            result = this.transIntForInput((Integer)obj);
        } else if (obj instanceof Long) {
            result = this.transLongForInput((Long)obj);
        } else if (obj instanceof Short) {
            result = this.transShortForInput((Short)obj);
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return null;
            }
            case 2: {
                return "NaN";
            }
        }
        switch (this.dataType) {
            case 6: {
                return String.valueOf(this.getFloat(controller, mem));
            }
        }
        return String.valueOf(this.getDouble(controller, mem));
    }

    private static boolean isNull(byte[] buffer) {
        return buffer[0] == -1 && buffer[1] == -1 && buffer[2] == -1 && buffer[3] == -1 && buffer[4] == -1 && buffer[5] == -1 && buffer[6] == -1 && buffer[7] == -1;
    }
}

