/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.AbstractGetval;
import com.sap.db.jdbc.translators.BinaryDataTranslator;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.GetvalLob;
import com.sap.db.jdbc.translators.Putval;
import com.sap.db.jdbc.translators.PutvalBlobCopy;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.RawByteReader;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class StreamTranslator
extends BinaryDataTranslator {
    protected StreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.asciireadfromlong");
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getStream(controller, mem, longData);
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getLob(controller, mem, longData);
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        InputStream byteStream = this.getAsciiStream(controller, mem, longData);
        if (byteStream == null) {
            return null;
        }
        return new RawByteReader(byteStream);
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getLob(controller, mem, longData);
    }

    public int getColumnDisplaySize() {
        switch (this.dataType) {
            default: 
        }
        return 0x7FFFDFFF;
    }

    public GetvalLob getLob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        GetvalLob result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            result = new GetvalLob(controller.getConnectionSapDB(), descriptor, longData, controller.getSession(true, false));
        }
        return result;
    }

    public int getPrecision() {
        return Integer.MAX_VALUE;
    }

    public InputStream getStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        InputStream result = null;
        GetvalLob getval = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            getval = new GetvalLob(controller.getConnectionSapDB(), descriptor, longData, controller.getSession(true, false));
            result = ((AbstractGetval)getval).getAsciiStream();
        }
        return result;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Timestamp ts = Timestamp.valueOf(strValue);
            if (cal == null) {
                return ts;
            }
            cal.setTime(ts);
            Timestamp result = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, ts.getNanos());
            return result;
        }
        catch (IllegalArgumentException tsExc) {
            try {
                Date dateValue = Date.valueOf(strValue);
                if (cal == null) {
                    return new Timestamp(dateValue.getTime());
                }
                cal.setTime(dateValue);
                return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, 0);
            }
            catch (IllegalArgumentException dateExc) {
                throw this.newParseException(strValue, "Timestamp");
            }
        }
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        int bufSizeC = 4096;
        StringBuffer result = new StringBuffer();
        Reader reader = this.getCharacterStream(controller, mem, controller.getReplyData());
        if (reader == null) {
            return null;
        }
        try {
            int charsRead;
            char[] buf = new char[4096];
            while ((charsRead = reader.read(buf)) > 0) {
                result.append(new String(buf, 0, charsRead));
                if (charsRead >= 4096) continue;
                break;
            }
        }
        catch (StreamIOException streamExc) {
            throw streamExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioExc.getMessage());
        }
        return result.toString();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected int putSpecific(DataPart dataPart, Object data) {
        Putval putval = (Putval)data;
        return putval.putDescriptor(dataPart, this.bufpos_output - 1);
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.asciiputtolong");
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.binaryputtolong");
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.binaryputtolong");
    }

    public Object transBlobForInput(Blob blob, ConnectionSapDB conn) throws SQLException {
        AbstractGetval getVal;
        ConnectionSapDB blobConn;
        if (blob == null) {
            return null;
        }
        if (blob instanceof AbstractGetval && (blobConn = (getVal = (AbstractGetval)((Object)blob)).getConnection()).equals(conn)) {
            return new PutvalBlobCopy(getVal.getDescriptor(), -1, this.bufpos_input);
        }
        return new Putval(blob.getBinaryStream(), -1L, this.bufpos_input, 1);
    }

    public Object transClobForInput(Clob clob, ConnectionSapDB conn) throws SQLException {
        AbstractGetval getVal;
        ConnectionSapDB blobConn;
        if (clob == null) {
            return null;
        }
        if (clob instanceof AbstractGetval && (blobConn = (getVal = (AbstractGetval)((Object)clob)).getConnection()).equals(conn) && this.isUnicodeColumn() == getVal.isUnicodeColumn()) {
            return new PutvalBlobCopy(getVal.getDescriptor(), -1, this.bufpos_input);
        }
        return new Putval(clob.getAsciiStream(), -1L, this.bufpos_input, 3);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof InputStream) {
            result = this.transAsciiStreamForInput((InputStream)obj, -1L);
        }
        return result;
    }

    public Object transStreamForInput(InputStream stream, long length, int dataType) throws SQLException {
        if (stream == null) {
            return null;
        }
        return new Putval(stream, length, this.bufpos_input, dataType);
    }

    public Object transStringForInput(String val) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.asciiputtolong");
    }

    public Object cloneObjectForBatch(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Putval pv = (Putval)object;
            return pv.cloneForBatch();
        }
        catch (ClassCastException ccex) {
            return object;
        }
    }

    abstract boolean isPackectEncodingUnicode();
}

