/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class Structure
implements Struct {
    private Object[] elements;
    private String typeName;
    private static char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Structure(Object[] elements, String typeName) {
        this.elements = elements;
        this.typeName = typeName;
    }

    public Object[] getAttributes() throws SQLException {
        return this.elements;
    }

    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    public Object[] getAttributes(Map arg0) throws SQLException {
        throw new SQLException("Feature not supported.");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Object[] cmpArray = null;
        if (o instanceof Struct) {
            try {
                cmpArray = ((Struct)o).getAttributes();
            }
            catch (SQLException sqlEx) {
                return false;
            }
        } else if (o instanceof Object[]) {
            cmpArray = (Object[])o;
        } else {
            return false;
        }
        if (this.elements.length != cmpArray.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].equals(cmpArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("STRUCTURE (");
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] instanceof byte[]) {
                pw.println("  FIELD[" + i + "]=" + this.toHex((byte[])this.elements[i]));
                continue;
            }
            pw.println("  FIELD[" + i + "]=" + this.elements[i]);
        }
        pw.println(")");
        return sw.toString();
    }

    private String toHex(byte[] ba) {
        StringBuffer r = new StringBuffer("x'");
        for (int i = 0; i < ba.length; ++i) {
            int ba_i = ba[i];
            r.append(hexchar[(ba_i &= 0xFF) >> 4]);
            r.append(hexchar[ba_i % 4]);
        }
        r.append("'");
        String s = new String(ba);
        return r.toString() + " (" + s + ")";
    }
}

