/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.TimestampTranslator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimeTranslator
extends TimestampTranslator {
    TimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected TimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getTime(controller, mem, null);
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        value[0] = 15;
        int time_null = 128;
        byte hour = (byte)(cal.get(11) | time_null);
        byte minute = (byte)cal.get(12);
        short milli = (short)(cal.get(13) * 1000);
        dataFormat.putInt1(value, hour, 1);
        dataFormat.putInt1(value, minute, 2);
        dataFormat.putInt2(value, milli, 3);
        return value;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Time dateVal = Time.valueOf(val);
            return this.transTimeForInput(dateVal, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
        }
    }

    public int getPrecision() {
        return 8;
    }

    public Object transDateForInput(Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        throw this.newSetException("java.sql.Date");
    }
}

