/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class VariableDataLengthTranslator
extends DBTechTranslator {
    protected VariableDataLengthTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
        this.characterDatatypePostfix = " ASCII";
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected int putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = (byte[])data;
        this.checkFieldLimits(bytes.length);
        return dataPart.putBytes(bytes, this.bufpos_input);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Date dateValue = Date.valueOf(strValue);
            if (cal == null) {
                return dateValue;
            }
            cal.setTime(dateValue);
            return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
        }
        catch (IllegalArgumentException dateExc) {
            try {
                Timestamp tsValue = Timestamp.valueOf(strValue);
                if (cal == null) {
                    return new Date(tsValue.getTime());
                }
                cal.setTime(tsValue);
                return DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
            catch (IllegalArgumentException tsExc) {
                throw this.newParseException(strValue, "Date");
            }
        }
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Time dateValue = Time.valueOf(strValue.trim());
            if (cal == null) {
                return dateValue;
            }
            cal.setTime(dateValue);
            return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
        }
        catch (IllegalArgumentException dateExc) {
            try {
                Timestamp dateValue = Timestamp.valueOf(strValue.trim());
                if (cal == null) {
                    return new Time(dateValue.getTime());
                }
                cal.setTime(dateValue);
                return DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
            catch (IllegalArgumentException dateExc2) {
                throw this.newParseException(strValue, "Time");
            }
        }
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        String strValue = this.getString(controller, mem);
        if (strValue == null) {
            return null;
        }
        try {
            Timestamp ts = Timestamp.valueOf(strValue);
            if (cal == null) {
                return ts;
            }
            cal.setTime(ts);
            return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, ts.getNanos());
        }
        catch (IllegalArgumentException tsExc) {
            try {
                Date dateValue = Date.valueOf(strValue);
                if (cal == null) {
                    return new Timestamp(dateValue.getTime());
                }
                cal.setTime(dateValue);
                return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, 0);
            }
            catch (IllegalArgumentException dateExc) {
                throw this.newParseException(strValue, "Timestamp");
            }
        }
    }
}

