/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbcext.ConnectionPoolDataSourceSAP;
import com.sap.db.jdbcext.DataSourceSAP;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DataSourceSAPFactory
implements ObjectFactory {
    static HashSet forbiddenproperties = new HashSet();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            if ("com.sap.db.jdbcext.ConnectionPoolDataSourceSAP".equals(ref.getClassName())) {
                Properties p = this.propertiesFromRef(ref);
                ConnectionPoolDataSourceSAP result = new ConnectionPoolDataSourceSAP();
                result.setProperties(p);
                return result;
            }
            if ("com.sap.db.jdbcext.DataSourceSAP".equals(ref.getClassName())) {
                Properties p = this.propertiesFromRef(ref);
                DataSourceSAP result = new DataSourceSAP();
                result.setProperties(p);
                return result;
            }
            return null;
        }
        return null;
    }

    private Properties propertiesFromRef(Reference ref) {
        Enumeration<RefAddr> refaddrs = ref.getAll();
        Properties result = new Properties();
        while (refaddrs.hasMoreElements()) {
            RefAddr o = refaddrs.nextElement();
            try {
                StringRefAddr stringref = (StringRefAddr)o;
                if (forbiddenproperties.contains(stringref.getType())) continue;
                if (!stringref.getType().equals("isolation")) {
                    String stringreftype = stringref.getType();
                    String content = (String)stringref.getContent();
                    if (content == null) continue;
                    result.setProperty(stringreftype, content);
                    continue;
                }
                String j2eeisolation = (String)stringref.getContent();
                if (j2eeisolation.equals("none")) continue;
                if (j2eeisolation.equals("ruc")) {
                    j2eeisolation = "TRANSACTION_READ_UNCOMMITTED";
                } else if (j2eeisolation.equals("rc")) {
                    j2eeisolation = "TRANSACTION_READ_COMMITTED";
                } else if (j2eeisolation.equals("rr")) {
                    j2eeisolation = "TRANSACTION_REPEATABLE_READ";
                } else if (j2eeisolation.equals("s")) {
                    j2eeisolation = "TRANSACTION_SERIALIZABLE";
                }
                result.setProperty("isolation", j2eeisolation);
            }
            catch (ClassCastException ccx) {}
        }
        return result;
    }

    static {
        forbiddenproperties.add("autocommit");
    }
}

