/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.rte.comm;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.rte.comm.BasicSocketComm;
import com.sap.db.rte.comm.JdbcCommFactory;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.rte.comm.RteC;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.Tracer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureCommunication
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(Location location, Properties properties, Tracer tracer) throws RTEException {
            SecureCommunication sc = new SecureCommunication(location, properties, tracer);
            sc.connectDB();
            return sc;
        }
    };
    private boolean validateCertificate;
    private String hostNameInCertificate;
    private String keyStore = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String trustStore = null;
    private String trustStoreType = null;
    private String trustStorePassword = null;
    private static final int ALTNAME_DNS = 2;

    private SecureCommunication(Location location, Properties properties, Tracer tracer) throws RTEException {
        super(location, properties, tracer);
        this.validateCertificate = Driver.getBooleanProperty(properties, "validateCertificate", true);
        this.hostNameInCertificate = properties.getProperty("hostNameInCertificate");
        this.keyStore = properties.getProperty("keyStore");
        this.keyStoreType = properties.getProperty("keyStoreType");
        this.keyStorePassword = properties.getProperty("keyStorePassword");
        this.trustStore = properties.getProperty("trustStore");
        this.trustStoreType = properties.getProperty("trustStoreType");
        this.trustStorePassword = properties.getProperty("trustStorePassword");
        this.openSocket();
    }

    private boolean isSystemDefaultUsed() {
        return this.keyStore == null && this.keyStoreType == null && this.keyStorePassword == null && this.trustStore == null && this.trustStorePassword == null && this.trustStoreType == null;
    }

    private String getKeyStoreType() {
        if (this.keyStoreType == null) {
            return "jks";
        }
        return this.keyStoreType;
    }

    private String getTrustStoreType() {
        if (this.trustStoreType == null) {
            return "jks";
        }
        return this.trustStoreType;
    }

    private String getKeyStoreFileName() {
        if (this.keyStore == null) {
            return System.getProperty("javax.net.ssl.keyStore");
        }
        return this.keyStore;
    }

    private String getTrustStoreFileName() {
        if (this.trustStore == null) {
            return System.getProperty("javax.net.ssl.trustStore");
        }
        return this.trustStore;
    }

    private String getKeyStorePassword() {
        if (this.keyStorePassword != null) {
            return this.keyStorePassword;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String getTrustStorePassword() {
        if (this.trustStorePassword != null) {
            return this.trustStorePassword;
        }
        String syspasswd = System.getProperty("javax.net.ssl.trustStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return null;
    }

    KeyManagerFactory getKeyManagerFactory(String host) throws RTEException {
        FileInputStream fis;
        KeyStore ks;
        String keystorefilename = this.getKeyStoreFileName();
        if (keystorefilename == null) {
            return null;
        }
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsaex) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keymanagerfactorynodefault", nsaex.getMessage());
                sqlEx.initCause(nsaex);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            ks = KeyStore.getInstance(this.getKeyStoreType());
        }
        catch (KeyStoreException kse) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keystore.create", kse.getMessage());
                sqlEx.initCause(kse);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, kse.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            fis = new FileInputStream(keystorefilename);
        }
        catch (FileNotFoundException fnf) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keystorefilenotfound", fnf.getMessage());
                sqlEx.initCause(fnf);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, fnf.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            ks.load(fis, this.getKeyStorePassword().toCharArray());
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.nosuchalgorithm", nsae.getMessage());
                sqlEx.initCause(nsae);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, nsae.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        catch (CertificateException certe) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.certificate", certe.getMessage());
                sqlEx.initCause(certe);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, certe.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        catch (IOException ioe) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.ioexception", ioe.getMessage());
                sqlEx.initCause(ioe);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, ioe.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            kmf.init(ks, this.getKeyStorePassword().toCharArray());
        }
        catch (UnrecoverableKeyException urke) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("errror.ssl.keymanagerfactory.unrecoverablekey", urke.getMessage());
                sqlEx.initCause(urke);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, urke.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        catch (KeyStoreException e) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", host, "Key manager initialization failed: " + e.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keymanagerfactory.nosuchalgorithm", nsae.getMessage());
                sqlEx.initCause(nsae);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, nsae.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        return kmf;
    }

    TrustManagerFactory getTrustManagerFactory(String host) throws RTEException {
        FileInputStream fis;
        KeyStore ks;
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsaex) {
            try {
                SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.trustmanagerfactorynodefault", nsaex.getMessage());
                sqlEx.initCause(nsaex);
                throw sqlEx;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            ks = KeyStore.getInstance(this.getTrustStoreType());
        }
        catch (KeyStoreException kse) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keystore.create", kse.getMessage());
                sqlex.initCause(kse);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, kse.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        String keystorefilename = this.getTrustStoreFileName();
        if (keystorefilename == null) {
            return null;
        }
        try {
            fis = new FileInputStream(keystorefilename);
        }
        catch (FileNotFoundException fnf) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keystorefilenotfound", fnf.getMessage());
                sqlex.initCause(fnf);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, fnf.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            String tspass = this.getTrustStorePassword();
            ks.load(fis, tspass == null ? null : tspass.toCharArray());
        }
        catch (NoSuchAlgorithmException nsaex) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.nosuchalgorithm", nsaex.getMessage());
                sqlex.initCause(nsaex);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, nsaex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        catch (CertificateException cex) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.certificate", cex.getMessage());
                sqlex.initCause(cex);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, cex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        catch (IOException ioex) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keystoreloadfailed.ioexception", ioex.getMessage());
                sqlex.initCause(ioex);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, ioex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        try {
            tmf.init(ks);
        }
        catch (KeyStoreException kse) {
            try {
                SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.keymanagerfactory.keystore", kse);
                sqlex.initCause(kse);
                throw sqlex;
            }
            catch (SQLException e) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host, kse.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
            }
        }
        return tmf;
    }

    protected void openSocket() throws RTEException {
        Iterator hosts = this.m_location.getHostNames();
        RTEException exc = null;
        while (hosts.hasNext()) {
            String host = (String)hosts.next();
            try {
                this.openSocketIntern(host);
                return;
            }
            catch (RTEException e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openSocketIntern(String host) throws RTEException {
        Socket sslsocket = null;
        boolean socketInUse = false;
        try {
            try {
                SSLContext sc = null;
                SSLSocketFactory factory = null;
                if (!this.validateCertificate) {
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    sc = SSLContext.getInstance("TLSv1");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    factory = sc.getSocketFactory();
                } else if (this.isSystemDefaultUsed()) {
                    factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                } else {
                    sc = SSLContext.getInstance("TLSv1");
                    KeyManagerFactory kmf = this.getKeyManagerFactory(host);
                    TrustManagerFactory tmf = this.getTrustManagerFactory(host);
                    KeyManager[] km = null;
                    TrustManager[] tm = null;
                    if (kmf != null) {
                        km = kmf.getKeyManagers();
                    }
                    if (tmf != null) {
                        tm = tmf.getTrustManagers();
                    }
                    sc.init(km, tm, new SecureRandom());
                    factory = sc.getSocketFactory();
                }
                this.socket = factory.createSocket(host, this.lookupPort());
                sslsocket = (SSLSocket)this.socket;
                ((SSLSocket)sslsocket).setUseClientMode(true);
                String[] protocols = new String[]{"SSLv3", "TLSv1"};
                ((SSLSocket)sslsocket).setEnabledProtocols(protocols);
                ((SSLSocket)sslsocket).startHandshake();
                if (!"*".equals(this.hostNameInCertificate) && this.validateCertificate) {
                    SQLException e;
                    Certificate[] certs = ((SSLSocket)sslsocket).getSession().getPeerCertificates();
                    if (certs.length == 0) {
                        try {
                            throw SQLExceptionSapDB.generateSQLException("error.ssl.nocertificatefound");
                        }
                        catch (SQLException sqlEx) {
                            throw new RTEException(MessageTranslator.translate("error.host.connect", host, sqlEx.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlEx);
                        }
                    }
                    try {
                        X509Certificate x509cert = (X509Certificate)certs[0];
                        X500Principal principal = x509cert.getSubjectX500Principal();
                        String rfc2253name = principal.getName("RFC2253");
                        Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                        if (!this.validate(rfc2253name, alternativenames, this.hostNameInCertificate == null ? host : this.hostNameInCertificate)) {
                            try {
                                throw SQLExceptionSapDB.generateSQLException("error.ssl.hostnameverificationfailed", rfc2253name, host);
                            }
                            catch (SQLException sqlEx) {
                                throw new RTEException(MessageTranslator.translate("error.host.connect", host, sqlEx.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlEx);
                            }
                        }
                    }
                    catch (ClassCastException classCastEx) {
                        try {
                            e = SQLExceptionSapDB.generateSQLException("error.ssl.nox509certificate");
                            e.initCause(classCastEx);
                            throw e;
                        }
                        catch (SQLException sqlEx) {
                            throw new RTEException(MessageTranslator.translate("error.host.connect", host, sqlEx, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlEx);
                        }
                    }
                    catch (CertificateParsingException certParsingEx) {
                        try {
                            e = SQLExceptionSapDB.generateSQLException("error.ssl.nox509certificate");
                            e.initCause(certParsingEx);
                            throw e;
                        }
                        catch (SQLException sqlEx) {
                            throw new RTEException(MessageTranslator.translate("error.host.connect", host, sqlEx, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, sqlEx);
                        }
                    }
                }
                try {
                    sslsocket.setSoTimeout(this.socketTimeOut);
                    sslsocket.setTcpNoDelay(true);
                    sslsocket.setReceiveBufferSize(36864);
                    sslsocket.setSendBufferSize(36864);
                }
                catch (SocketException socketEx) {
                    // empty catch block
                }
                this.instream = this.socket.getInputStream();
                this.outstream = this.socket.getOutputStream();
                socketInUse = true;
            }
            catch (NoSuchAlgorithmException noSuchAlg) {
                try {
                    SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.nosuchalgorithm", noSuchAlg.getMessage());
                    sqlEx.initCause(noSuchAlg);
                    throw sqlEx;
                }
                catch (SQLException e) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", host, noSuchAlg.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
                }
            }
            catch (KeyManagementException keyManagementEx) {
                try {
                    SQLException sqlEx = SQLExceptionSapDB.generateSQLException("error.ssl.keymanagementexception", keyManagementEx.getMessage());
                    sqlEx.initCause(keyManagementEx);
                    throw sqlEx;
                }
                catch (SQLException e) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", host, keyManagementEx.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5, e);
                }
            }
            catch (UnknownHostException uhexc) {
                throw new RTEException(MessageTranslator.translate("error.unknown.host", host, uhexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13);
            }
            catch (SSLHandshakeException sslhsex) {
                if (sslhsex.getMessage().contains("PKIX path building failed")) {
                    try {
                        SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.certificatepath", sslhsex.getMessage());
                        sqlex.initCause(sslhsex);
                        throw sqlex;
                    }
                    catch (SQLException e) {
                        throw new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslhsex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13, e);
                    }
                }
                try {
                    SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.handshake", sslhsex.getMessage());
                    sqlex.initCause(sslhsex);
                    throw sqlex;
                }
                catch (SQLException e) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslhsex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13, e);
                }
            }
            catch (SSLException sslex) {
                if (sslex.getMessage().contains("Received fatal alert: internal_error")) {
                    try {
                        SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.nosslsupport", sslex.getMessage());
                        sqlex.initCause(sslex);
                        throw sqlex;
                    }
                    catch (SQLException e) {
                        throw new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13, e);
                    }
                }
                try {
                    SQLException sqlex = SQLExceptionSapDB.generateSQLException("error.ssl.handshake", sslex.getMessage());
                    sqlex.initCause(sslex);
                    throw sqlex;
                }
                catch (SQLException e) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), sslex.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13, e);
                }
            }
            catch (IOException ioexc) {
                throw new RTEException(MessageTranslator.translate("error.host.connect", host + ":" + this.lookupPort(), ioexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13);
            }
            Object var14_37 = null;
            if (sslsocket == null) return;
            if (socketInUse) return;
        }
        catch (Throwable throwable) {
            Object var14_38 = null;
            if (sslsocket == null) throw throwable;
            if (socketInUse) throw throwable;
            try {
                sslsocket.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        sslsocket.close();
        return;
    }

    private static boolean looksLikeCommonName(String name) {
        return name != null && name.startsWith("CN=");
    }

    private static boolean matches(String nameFromCertificate, String host) {
        int hasWildCard = nameFromCertificate.indexOf("*");
        if (hasWildCard == -1) {
            if (nameFromCertificate.equalsIgnoreCase(host)) {
                return true;
            }
        } else {
            String before = nameFromCertificate.substring(0, hasWildCard).toLowerCase();
            if (before.indexOf(46) != -1) {
                return false;
            }
            String after = nameFromCertificate.substring(hasWildCard + 1).toLowerCase();
            if (after.length() < 2) {
                return false;
            }
            if (after.charAt(0) != '.') {
                return false;
            }
            String host_lc = host.toLowerCase();
            if (host_lc.startsWith(before) && host_lc.endsWith(after)) {
                if (host_lc.length() < before.length() + after.length()) {
                    return false;
                }
                String match = host_lc.substring(before.length());
                return (match = match.substring(0, match.length() - after.length())).indexOf(46) == -1;
            }
        }
        return false;
    }

    private boolean validate(String rfc2253name, Collection alternativeNames, String host) {
        boolean dnsfound = false;
        if (alternativeNames != null) {
            Iterator listi = alternativeNames.iterator();
            while (listi.hasNext()) {
                List l = (List)listi.next();
                if ((Integer)l.get(0) != 2) continue;
                dnsfound = true;
                String dns = (String)l.get(1);
                if (!SecureCommunication.matches(dns, host)) continue;
                return true;
            }
        }
        if (!dnsfound) {
            if (SecureCommunication.looksLikeCommonName(host)) {
                return host.equals(rfc2253name);
            }
            int comma = rfc2253name.indexOf(",");
            String commonNamePart = rfc2253name.substring(0, comma).toUpperCase();
            String compare = ("CN=" + host).toUpperCase();
            return compare.equals(commonNamePart);
        }
        return false;
    }

    protected boolean supportsInfoRequest() {
        return true;
    }
}

