drop table appdemo2.demoapp_properties
/
drop table appdemo2.STATS
/
drop table appdemo2.orderdetails
/
drop table appdemo2.orders
/
drop table appdemo2.titles
/
drop table appdemo2.authors
/
drop table appdemo2.publishers
/
drop table appdemo2.stores
/

drop sequence appdemo2.titles_seq
/
drop sequence appdemo2.authors_seq
/
drop sequence appdemo2.publishers_seq
/
drop sequence appdemo2.orders_seq
/
drop sequence appdemo2.stores_seq
/
drop synonym demoapp_usage_statistics
/

-- SEQUENCES --

create sequence appdemo2.titles_seq
 start with 100000
 increment by 1
 minvalue 0
 nomaxvalue
 nocycle
/ 
create sequence appdemo2.authors_seq
 start with 100000
 increment by 1
 minvalue 0
 nomaxvalue
 nocycle
/ 
create sequence appdemo2.publishers_seq
 start with 100000
 increment by 1
 minvalue 0
 nomaxvalue
 nocycle
/ 
create sequence appdemo2.orders_seq
 start with 100000
 increment by 1
 minvalue 0
 nomaxvalue
 nocycle
/ 
create sequence appdemo2.stores_seq
 start with 100000
 increment by 1
 minvalue 0
 nomaxvalue
 nocycle
/ 

-- GENERAL TABLES

create table appdemo2.demoapp_properties
(
	propname    varchar2(30),
	int_value   int,
	str_value   varchar (30),
	description varchar2(255),
	
	primary key(propname)
)
/
-- insert default values for configurations
insert into appdemo2.demoapp_properties values('use_package_variables', 1, null, 'democlient logic: if SQL Statements holding ''call ${PKG:myPkgName}proc'' should be substituted to ''call myPkgName.proc'' or ''call proc'' before the SQL Statement is sent to the server.')
/

CREATE TABLE appdemo2.STATS
(
	statname    varchar2(30)  not null,
	int_value   int null,
	str_value   varchar (100) null,
	description varchar2(255) null
	
	,primary key(statname)
)
/

CREATE SYNONYM demoapp_usage_statistics for appdemo2.STATS
/

-- APPDEMO TABLES --

create table appdemo2.publishers  (
   pub_id             int		not null,
   pub_name           VARCHAR2(40) not null,
   city               VARCHAR2(20),
   state              CHAR(2),
   constraint PK_PUBLISHERS primary key (pub_id)
)
/
create unique index pub_name_index2 on appdemo2.publishers (pub_name)
/

create table appdemo2.stores  (
   store_id           int		not null,
   store_name         VARCHAR2(40)                    not null,
   address            VARCHAR2(60),
   city               VARCHAR2(20)                    not null,
   state              CHAR(2)                         not null,
   country            VARCHAR2(12),
   postalcode         CHAR(10),
   constraint PK_STORES  primary key (store_id),
   constraint PK2_STORES unique      (store_name, city, state)
)
/

create unique index store_name_index2 on appdemo2.stores (store_name)
/

create index store_add2 on appdemo2.stores (
   store_name ASC,
   address ASC
)
/

create table appdemo2.titles  (
   title_id           int 		not null,
   title              VARCHAR2(80)      not null,
   type               CHAR(12)          default 'UNDECIDED' not null,
   pub_id             int,
   price              NUMBER(8,2),
   advance            NUMBER(8,2),
   total_sales        INTEGER,
   notes              VARCHAR2(200),
   pubdate            DATE              default sysdate not null,
   contract           SMALLINT          not null,
   au_id	      INT,
   ISBN		      char (17),
   picture			BLOB null,
   constraint PK_TITLES primary key (title_id),
   constraint ISBN_UNIQUE unique (ISBN)
)
/

create index titleind2 on appdemo2.titles (
   title ASC
)
/

create table appdemo2.authors  (
   au_id              int		not null,
   au_lname           VARCHAR2(40)      not null,
   au_fname           VARCHAR2(20)      not null,
   phone              CHAR(12)          default 'UNKNOWN' not null,
   address            VARCHAR2(60),
   city               VARCHAR2(20),
   state              CHAR(2),
   country            VARCHAR2(12),
   postalcode         CHAR(10),
   picture			BLOB null,
   constraint PK_AUTHORS primary key (au_id)
)
/

create unique index aunameind2 on appdemo2.authors (
   au_lname ASC,
   au_fname ASC
)
/

alter table appdemo2.titles
   add constraint FK_TITLES_REFERENCE_PUBLISHERS foreign key (pub_id)
      references appdemo2.publishers (pub_id)
/

alter table appdemo2.titles
   add constraint FK_TITLES_REFERENCE_AUTHORS foreign key (au_id)
      references appdemo2.authors (au_id)
/

create table appdemo2.orders  (
   order_id           INTEGER  		not null,
   store_name         VARCHAR2(40),
   order_date         DATE,
   constraint PK_ORDERS primary key (order_id)
)
/

create table appdemo2.orderdetails  (
   order_id           INTEGER		not null,
   title_id           INTEGER		not null,
   quantity           INTEGER,
   discount           numeric (4,2),
   constraint PK_ORDERDETAILS primary key (order_id, title_id)
)
/

alter table appdemo2.orderdetails
   add constraint FK_ORDERDET_REFERENCE_ORDERS foreign key (order_id)
      references appdemo2.orders (order_id)
/

alter table appdemo2.orderdetails
   add constraint FK_ORDERDET_REFERENCE_TITLES foreign key (title_id)
      references appdemo2.titles (title_id)
/


-- IMPORTANT NOTE
-- All data is prepared to be loaded with all sequences starting from 1, if something needs to be created 
-- recreate everthing with this script (drop and recreate sequences)


-- DEMO DATA --

insert into appdemo2.publishers
values (appdemo2.publishers_seq.nextval, 'New Age Books', 'Boston', 'MA')
/
insert into appdemo2.publishers
values (appdemo2.publishers_seq.nextval, 'Binnet Hardley', 'Washington', 'DC')
/
insert into appdemo2.publishers
values (appdemo2.publishers_seq.nextval, 'Algodata Infosystems', 'Berkeley', 'CA')
/
insert into appdemo2.publishers
values (appdemo2.publishers_seq.nextval, '21th Century Books', 'Washington', 'DC')
/



insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Barnum''s', '567 Pasadena Ave.', 'Tustin', 'CA', 'USA', '92789')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'News - Brews', '577 First St.', 'Los Gatos', 'CA', 'USA', '96745')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Doc-U-Mat: Quality Laundry and Books', '24-A Avrogado Way', 'Remulade', 'WA', 'USA', '98014')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Bookbeat', '679 Carson St.', 'Portland', 'OR', 'USA', '89076')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Eric the Read Books', '788 Catamaugus Ave.', 'Seattle', 'WA', 'USA', '98056')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Fricative Bookshop', '89 Madison St.', 'Fremont', 'CA', 'USA', '90019')
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Thoreau Reading Discount Chain', '20435 Walden Expressway', 'Concord', 'MA', 'USA', '01776') 
/
insert into appdemo2.stores values (appdemo2.stores_seq.nextval, 'Fnac', '127 Madison St.', 'Fremont', 'CA', 'USA', '90019') 
/


insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Barnum''s', '12-OCT-2010') 				-- order 1
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '31-OCT-2010') 	-- order 2
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '06-NOV-2010') 	-- order 3
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '13-JUL-2014') 				-- order 4
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Fricative Bookshop', '14-AUG-2011')			-- order 5
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Doc-U-Mat: Quality Laundry and Books', '16-NOV-2011')	-- order 6
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '12-DEC-2011')		-- order 7
/	
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'News - Brews', '02-FEB-2012')				-- order 8
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '01-DEC-2010')		-- order 9
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '18-JUL-2012')		-- order 10
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Doc-U-Mat: Quality Laundry and Books', '09-SEP-2012')	-- order 11
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Barnum''s', '27-OCT-2012')				-- order 12
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '20-MAR-2011')				-- order 13
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '20-MAR-2011')				-- order 14
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '20-MAR-2011')				-- order 15
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '13-JAN-2013')				-- order 16
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Fricative Bookshop', '14-FEB-2011')			-- order 17
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '15-MAR-2012')		-- order 18
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Doc-U-Mat: Quality Laundry and Books', '20-DEC-2010')	-- order 19
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '27-JUL-2013')		-- order 20
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Barnum''s', '05-AUG-2013')				-- order 21
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '21-MAR-2011')		-- order 22
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Bookbeat', '23-MAY-2014')				-- order 23
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'News - Brews', '13-JUN-2010')				-- order 24
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '21-MAR-2011')		-- order 25
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '21-MAR-2011')		-- order 26
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Thoreau Reading Discount Chain', '21-MAR-2011')		-- order 27
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Eric the Read Books', '13-DEC-2010')			-- order 28
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Eric the Read Books', '17-FEB-2011')			-- order 29
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Eric the Read Books', '20-SEP-2012')			-- order 30
/
insert into appdemo2.orders values (appdemo2.orders_seq.nextval, 'Eric the Read Books', '15-MAY-2014')			-- order 30
/

\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Bennet', 'Abraham',
'415 658-9932', '6223 Bateman St.', 'Berkeley', 'CA', 'USA', '94705', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\1_abraham_bennet.jpg')
/
\prep insert into appdemo2.authors values 
(appdemo2.authors_seq.nextval, 'Green', 'Marjorie',
'415 986-7020', '309 63rd St. #411', 'Oakland', 'CA', 'USA', '94618', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\2_marjorie_green.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Carson', 'Cheryl',
'415 548-7723', '589 Darwin Ln.', 'Berkeley', 'CA', 'USA', '94705', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\3_cheryl_carlson.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Ringer', 'Albert',
'801 826-0752', '67 Seventh Av.', 'Salt Lake City', 'UT', 'USA', '84152', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\4_albert_ringer.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Ringer', 'Anne',
'801 826-0752', '67 Seventh Av.', 'Salt Lake City', 'UT', 'USA', '84152', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\5_anne_ringer.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'DeFrance', 'Michel',
'219 547-9982', '3 Balding Pl.', 'Gary', 'IN', 'USA', '46403', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\6_michel_defrance.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Panteley', 'Sylvia',
'301 946-8853', '1956 Arlington Pl.', 'Rockville', 'MD', 'USA', '20853', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\7_sylvia_panteley.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'McBadden', 'Heather',
'707 448-4982', '301 Putnam', 'Vacaville', 'CA', 'USA', '95688', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\8_heather_mcbadden.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Stringer', 'Dirk',
'415 843-2991', '5420 Telegraph Av.', 'Oakland', 'CA', 'USA', '94609', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\9_dirk_stringer.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Straight', 'Dick',
'415 834-2919', '5420 College Av.', 'Oakland', 'CA', 'USA', '94609', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\10_dick_straight.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Karsen', 'Livia',
'415 534-9219', '5720 McAuley St.', 'Oakland', 'CA', 'USA', '94609', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\11_livia_karsen.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'MacFeather', 'Stearns',
'415 354-7128', '44 Upland Hts.', 'Oakland', 'CA', 'USA', '94612', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\12_stearns_macfeather.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Dull', 'Ann',
'415 836-7128', '3410 Blonde St.', 'Palo Alto', 'CA', 'USA', '94301', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\13_ann_dull.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Yokomoto', 'Akiko',
'415 935-4228', '3 Silver Ct.', 'Walnut Creek', 'CA', 'USA', '94595', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\14_akiko_yokomoto.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'O''Leary', 'Michael',
'408 286-2428', '22 Cleveland Av. #14', 'San Jose', 'CA', 'USA', '95128', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\15_michael_0leary.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Gringlesby', 'Burt',
'707 938-6445', 'PO Box 792', 'Covelo', 'CA', 'USA', '95428', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\16_burt_gringlesby.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Greene', 'Morningstar',
'615 297-2723', '22 Graybar House Rd.', 'Nashville', 'TN', 'USA', '37215', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\17_morningstar_greene.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'White', 'Johnson',
'408 496-7223', '10932 Bigge Rd.', 'Menlo Park', 'CA', 'USA', '94025', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\18_johnson_white.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'del Castillo', 'Innes',
'615 996-8275', '2286 Cram Pl. #86', 'Ann Arbor', 'MI', 'USA', '48105', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\19_innes_del_castillo.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Hunter', 'Sheryl',
'415 836-7128', '3410 Blonde St.', 'Palo Alto', 'CA', 'USA', '94301', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\20_sheryl_hunter.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Locksley', 'Chastity',
'415 585-4620', '18 Broadway Av.', 'San Francisco', 'CA', 'USA', '94130', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\21_chastity_locksley.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Blotchet-Halls', 'Reginald',
'503 745-6402', '55 Hillsdale Bl.', 'Corvallis', 'OR', 'USA', '97330', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\22_reginald_blotchet-halls.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Smith', 'Meander',
'913 843-0462', '10 Mississippi Dr.', 'Lawrence', 'KS', 'USA', '66044', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\23_meander_smith.jpg')
/
\prep insert into appdemo2.authors values
(appdemo2.authors_seq.nextval, 'Martin', 'Juan',
'044-55-88675', 'Av. Chicopan No. 256 Del. Iztapalapa', 'Mxico D.F', 'DF', 'Mexico', '236587', ?)
:(blob='${DBMTK_APPDEMO}\pictures\authors\24_juan_martin.jpg')
/
insert into appdemo2.authors values ( appdemo2.authors_seq.nextval, 'Jonathan', 'Grey', '199-177-2859', '1857 Angel', 'Las Vegas', 'NV', 'U.S.A', '89153', null ) 
/ 

\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Secrets of Silicon Valley',
	'popular_comp', 
	100003, 
	20.00, 
	8000.00, 
	4095,
	'Muckraking reporting by two courageous women on the world''s largest computer hardware and software manufacturers.',
	'12-JUN-2012',
	1,
	100013,
	'978-84-8181-227-5', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\1_Secrets_of_Silicon_Valley.gif')
/

\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'The Busy Executive''s Database Guide',
	'business', 
	100003, 
	19.99, 
	5000.00, 
	4095,
	'An overview of available database systems with emphasis on common business applications. Illustrated.',
	'12-JUN-2011', 
	1,
	100001,
	'978-84-9877-284-5', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\2_The_Busy_Executive_s_Database_Guide.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Emotional Security: A New Algorithm',
	'psychology', 
	100001, 
	7.99, 
	4000.00, 
	3336,
	'Protecting yourself and your loved ones from undue emotional stress in the modern world.  Use of computer and nutritional aids emphasized.',
	'12-JUN-2011', 
	1,
	100021,
	'978-84-9877-366-8', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\3_Emotional_Security_A_New_Algorithm.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Prolonged Data Deprivation: Four Case Studies',
	'psychology', 
	100001, 
	19.99, 
	2000.00, 
	4072,
	?,
	'12-JUN-2013', 
	1,
	100018,
	'978-84-9877-378-1', 
	?
)
:(string='What happens when the data runs dry ?  Searching evaluations of information-shortage effects on heavy users.',
  blob='${DBMTK_APPDEMO}\pictures\titles\4_Prolonged_Data_Deprivation_Four_Case_Studies.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Cooking with Computers: Surreptitious Balance Sheets',
	'business', 
	100003, 
	11.95, 
	5000.00, 
	3876,
	'Helpful hints on how to use your electronic resources to the best advantage.', 
	'9-JUN-2014', 
	1,
	100012,
	'978-84-6703-968-9', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\5_Cooking_with_Computers_Surreptitious_Balance_Sheets.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Silicon Valley Gastronomic Treats',
	'mod_cook', 
	100002, 
	19.99, 
	0.00, 
	2032,
	'Favorite recipes for quick, easy, and elegant meals, tried and tested by people who never have time to eat, let alone cook.',
	'9-JUN-2014', 
	1,
	100019,
	'978-84-9877-285-2', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\6_Silicon_Valley_Gastronomic_Treats.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	?,
	'trad_cook', 
	100002, 
	14.99, 
	8000.00, 
	4095,
	'Detailed instructions on improving your position in life by learning how to make authentic Japanese sushi in your spare time.  5-10% increase in number of friends per recipe reported from beta test.',
	'12-JUN-2012', 
	1,
	100014,
	'978-84-9877-288-3', 
	?	
)
:(string='Sushi, Anyone ?', blob='${DBMTK_APPDEMO}\pictures\titles\7_Sushi_Anyone.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Fifty Years in Buckingham Palace Kitchens',
	'trad_cook', 
	100002, 
	11.95, 
	4000.00, 
	15096,
	'More anecdotes from the Queen''s favorite cook describing life among English royalty.  Recipes, techniques, tender vignettes.',
	'12-JUN-2010', 
	1,
	100022,
	'978-84-9877-370-5', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\8_Fifty_Years_in_Buckingham_Palace_Kitchens.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval,
	?,
	'popular_comp', 
	100003, 
	22.95, 
	7000.00, 
	8780,
	'A survey of software for the naive user, focusing on the ''friendliness'' of each.',
	'30-JUN-2011', 
	1,
	100003,
	'978-84-9877-382-8', 
	?
)
:(string='But Is It User Friendly ?', blob='${DBMTK_APPDEMO}\pictures\titles\9_But_Is_It_User_Friendly.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'You Can Combat Computer Stress!',
	'business', 
	100001, 
	2.99, 
	10125.00, 
	18722,
	'The latest medical and psychological techniques for living with the electronic office.  Easy-to-understand explanations.',
	'30-JUN-2010', 
	1,
	100002,
	'978-84-9877-395-8', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\10_You_Can_Combat_Computer_Stress.gif')
/
\prep insert into appdemo2.titles values
(	appdemo2.titles_seq.nextval, 
	?,
	'psychology', 
	100001, 
	10.95, 
	2275.00, 
	2045,
	'Carefully researched study of the effects of strong emotions on the body.  Metabolic charts included.',
	'15-JUN-2011', 
	1,
	100004,
	'978-84-1562-362-5', 
	?
)
:(string='Is Anger the Enemy ?', blob='${DBMTK_APPDEMO}\pictures\titles\11_Is_Anger_the_Enemy.gif')
/
\prep insert into appdemo2.titles values
(	appdemo2.titles_seq.nextval, 
	'Life Without Fear',
	'psychology', 
	100001, 
	7.00, 
	6000.00, 
	111,
	'New exercise, meditation, and nutritional techniques that can reduce the shock of daily interactions. Popular audience.  Sample menus included, exercise video available separately.',
	'05-OCT-2010', 
	1,
	100004,
	'978-84-9877-384-2', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\12_Life_Without_Fear.gif')
/
\prep insert into appdemo2.titles values
(	appdemo2.titles_seq.nextval, 
	'The Gourmet Microwave',
	'mod_cook', 
	100002, 
	2.99, 
	15000.00, 
	22246,
	'Traditional French gourmet recipes adapted for modern microwave cooking.',
	'18-JUN-2010', 
	1,
	100006,
	'978-84-9877-386-6', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\13_The_Gourmet_Microwave.gif')
/
\prep insert into appdemo2.titles values
(	appdemo2.titles_seq.nextval,
	'Onions, Leeks, and Garlic: Cooking Secrets of the Mediterranean',
	'trad_cook', 
	100002, 
	20.95, 
	7000.00, 
	375,
	'Profusely illustrated in color, this makes a wonderful gift book for a cuisine-oriented friend.',
	'21-OCT-2010', 
	1,
	100007,
	'978-84-9877-399-6', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\14_Onions_Leeks_and_Garlic.gif')
/
\prep insert into appdemo2.titles (	title_id, 
				title, 
				pub_id, 
				contract,
				au_id,
				ISBN,
				picture
				) 
values
(	appdemo2.titles_seq.nextval, 
	'The Psychology of Computer Cooking', 
	100002, 
	0,
	100003,
	'978-84-724-5371-5',
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\15_The_Psychology_of_Computer_Cooking.gif')
/
\prep insert into appdemo2.titles values 
(	appdemo2.titles_seq.nextval, 
	'Straight Talk About Computers',
	'business', 
	100003, 
	19.99, 
	5000.00, 
	4095,
	'Annotated analysis of what computers can do for you: a no-hype guide for the critical user.',
	'22-JUN-2012', 
	1,
	100010,
	'978-84-9877-293-7', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\16_Straight_Talk_About_Computers.gif')
/
\prep insert into appdemo2.titles values
(	appdemo2.titles_seq.nextval,
	'Computer Phobic and Non-Phobic Individuals: Behavior Variations',
	'psychology', 
	100002, 
	21.59, 
	7000.00, 375,
	'A must for the specialist, this book examines the difference between those who hate and fear computers and those who think they are swell.',
	'21-OCT-2010', 
	1,
	100011,
	'978-84-9877-294-4', 
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\17_Computer_Phobic_and_Non-Phobic_Individuals.gif')
/
\prep insert into appdemo2.titles (	title_id, 
				title, 
				type, 
				pub_id, 
				notes, 
				contract,
				au_id,
				ISBN,
				picture
				)
values
(	appdemo2.titles_seq.nextval, 
	'Net Etiquette', 
	'popular_comp', 
	100003,
	'A must-read for computer conferencing debutantes!', 
	0,
	100021,
	'978-84-9877-377-4',
	?
)
:(blob='${DBMTK_APPDEMO}\pictures\titles\18_Net_Etiquette.gif')
/
insert into appdemo2.titles values ( appdemo2.titles_seq.nextval, 'Keep your mind free', 'psychology  ', 100001, 35.95, 0.00, 48678, 'Interesing book that will help you to control your mind.', '14-Sep-2010', 0, 100009, '978-84-1593-298-7', null )
/ 

insert into appdemo2.orderdetails values (100017, 100014, 75, 40)
/
insert into appdemo2.orderdetails values (100017, 100007, 75, 40)
/
insert into appdemo2.orderdetails values (100019, 100014, 50, 40)
/
insert into appdemo2.orderdetails values (100019, 100007, 80, 40)
/
insert into appdemo2.orderdetails values (100026, 100014, 85, 40)
/
insert into appdemo2.orderdetails values (100013, 100004, 90, 45)
/
insert into appdemo2.orderdetails values (100013, 100014, 40, 45)
/
insert into appdemo2.orderdetails values (100013, 100012, 30, 45)
/
insert into appdemo2.orderdetails values (100014, 100012, 50, 45)
/
insert into appdemo2.orderdetails values (100015, 100012, 31, 45)
/
insert into appdemo2.orderdetails values (100013, 100013, 69, 45)
/
insert into appdemo2.orderdetails values (100007, 100009, 1000, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100010, 500, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100002, 200, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100016, 150, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100003, 125, 46.7)
/
insert into appdemo2.orderdetails values (100010, 100007, 1000, 46.7)
/
insert into appdemo2.orderdetails values (100010, 100002, 1000, 46.7)
/
insert into appdemo2.orderdetails values (100010, 100009, 750, 46.7)
/
insert into appdemo2.orderdetails values (100011, 100002, 200, 46.7)
/
insert into appdemo2.orderdetails values (100012, 100016, 100, 46.7)
/
insert into appdemo2.orderdetails values (100021, 100003, 200, 46.7)
/
insert into appdemo2.orderdetails values (100021, 100009, 300, 46.7)
/
insert into appdemo2.orderdetails values (100021, 100007, 350, 46.7)
/
insert into appdemo2.orderdetails values (100022, 100011, 1000, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100011, 200, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100003, 250, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100004, 345, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100016, 360, 46.7)
/
insert into appdemo2.orderdetails values (100026, 100011, 845, 46.7)
/
insert into appdemo2.orderdetails values (100026, 100003, 581, 46.7)
/
insert into appdemo2.orderdetails values (100027, 100017, 375, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100005, 175, 46.7)
/
insert into appdemo2.orderdetails values (100026, 100016, 885, 46.7)
/
insert into appdemo2.orderdetails values (100022, 100016, 900, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100008, 550, 46.7)
/
insert into appdemo2.orderdetails values (100011, 100008, 350, 46.7)
/
insert into appdemo2.orderdetails values (100017, 100008, 275, 46.7)
/
insert into appdemo2.orderdetails values (100021, 100008, 500, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100008, 512, 46.7)
/
insert into appdemo2.orderdetails values (100011, 100013, 400, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100001, 105, 46.7)
/
insert into appdemo2.orderdetails values (100010, 100001, 300, 46.7)
/
insert into appdemo2.orderdetails values (100021, 100001, 350, 46.7)
/
insert into appdemo2.orderdetails values (100024, 100001, 335, 46.7)
/
insert into appdemo2.orderdetails values (100019, 100005, 500, 46.7)
/
insert into appdemo2.orderdetails values (100017, 100005, 340, 46.7)
/
insert into appdemo2.orderdetails values (100009, 100005, 370, 46.7)
/
insert into appdemo2.orderdetails values (100022, 100004, 750, 46.7)
/
insert into appdemo2.orderdetails values (100016, 100016, 300, 51.7)
/
insert into appdemo2.orderdetails values (100023, 100010, 150, 51.7)
/
insert into appdemo2.orderdetails values (100023, 100002, 300, 51.7)
/
insert into appdemo2.orderdetails values (100023, 100009, 400, 51.7)
/
insert into appdemo2.orderdetails values (100013, 100003, 180, 51.7)
/
insert into appdemo2.orderdetails values (100016, 100008, 250, 51.7)
/
insert into appdemo2.orderdetails values (100023, 100008, 226, 51.7)
/
insert into appdemo2.orderdetails values (100023, 100013, 400, 51.7)
/
insert into appdemo2.orderdetails values (100014, 100005, 390, 51.7)
/
insert into appdemo2.orderdetails values (100003, 100013, 5000, 50)
/
insert into appdemo2.orderdetails values (100010, 100010, 2000, 50)
/
insert into appdemo2.orderdetails values (100018, 100009, 2000, 50)
/
insert into appdemo2.orderdetails values (100020, 100009, 2000, 50)
/
insert into appdemo2.orderdetails values (100020, 100003, 1500, 50)
/
insert into appdemo2.orderdetails values (100022, 100010, 3000, 50)
/
insert into appdemo2.orderdetails values (100022, 100007, 1500, 50)
/
insert into appdemo2.orderdetails values (100025, 100010, 3000, 50)
/
insert into appdemo2.orderdetails values (100026, 100004, 2687, 50)
/
insert into appdemo2.orderdetails values (100026, 100007, 1090, 50)
/
insert into appdemo2.orderdetails values (100026, 100009, 2138, 50)
/
insert into appdemo2.orderdetails values (100027, 100006, 2032, 50)
/
insert into appdemo2.orderdetails values (100027, 100005, 1001, 50)
/
insert into appdemo2.orderdetails values (100020, 100005, 1100, 50)
/
insert into appdemo2.orderdetails values (100010, 100016, 1400, 50)
/
insert into appdemo2.orderdetails values (100007, 100008, 2700, 50)
/
insert into appdemo2.orderdetails values (100018, 100008, 2500, 50)
/
insert into appdemo2.orderdetails values (100010, 100008, 3500, 50)
/
insert into appdemo2.orderdetails values (100007, 100013, 4500, 50)
/
insert into appdemo2.orderdetails values (100009, 100013, 1600, 50)
/
insert into appdemo2.orderdetails values (100010, 100013, 2550, 50)
/
insert into appdemo2.orderdetails values (100020, 100013, 3000, 50)
/
insert into appdemo2.orderdetails values (100025, 100013, 3200, 50)
/
insert into appdemo2.orderdetails values (100007, 100010, 2200, 50)
/
insert into appdemo2.orderdetails values (100018, 100002, 1500, 50)
/
insert into appdemo2.orderdetails values (100027, 100001, 1005, 50)
/
insert into appdemo2.orderdetails values (100005, 100010, 42, 50.5)
/
insert into appdemo2.orderdetails values (100005, 100009, 25, 50.5)
/
insert into appdemo2.orderdetails values (100006, 100010, 35, 50.5)
/
insert into appdemo2.orderdetails values (100008, 100009, 34, 50.5)
/
insert into appdemo2.orderdetails values (100008, 100008, 53, 50.5)
/
insert into appdemo2.orderdetails values (100004, 100010, 30, 55.5)
/
insert into appdemo2.orderdetails values (100004, 100002, 94, 55.5)
/
insert into appdemo2.orderdetails values (100001, 100010, 200, 57.2)
/
insert into appdemo2.orderdetails values (100005, 100008, 350, 57.2)
/
insert into appdemo2.orderdetails values (100001, 100008, 230, 57.2)
/
insert into appdemo2.orderdetails values (100001, 100013, 200, 57.2)
/
insert into appdemo2.orderdetails values (100006, 100013, 137, 57.2)
/
insert into appdemo2.orderdetails values (100008, 100013, 270, 57.2)
/
insert into appdemo2.orderdetails values (100008, 100010, 230, 57.2)
/
insert into appdemo2.orderdetails values (100006, 100002, 345, 57.2)
/
insert into appdemo2.orderdetails values (100008, 100002, 136, 57.2)
/
insert into appdemo2.orderdetails values (100004, 100008, 300, 62.2)
/
insert into appdemo2.orderdetails values (100004, 100013, 270, 62.2)
/
insert into appdemo2.orderdetails values (100004, 100009, 133, 62.2)
/
insert into appdemo2.orderdetails values (100002, 100008, 2500, 60.5)
/
insert into appdemo2.orderdetails values (100002, 100010, 4000, 60.5)
/
insert into appdemo2.orderdetails values (100028, 100010, 200, 57.2)
/
insert into appdemo2.orderdetails values (100028, 100013, 250, 57.2)
/
insert into appdemo2.orderdetails values (100029, 100004, 200, 46.7)
/
insert into appdemo2.orderdetails values (100029, 100003, 500, 46.7)
/
insert into appdemo2.orderdetails values (100029, 100014, 125, 46.7)
/
insert into appdemo2.orderdetails values (100017, 100010, 135, 46.7)
/
insert into appdemo2.orderdetails values (100017, 100002, 320, 46.7)
/
insert into appdemo2.orderdetails values (100017, 100013, 400, 46.7)
/
 
commit
/