package com.sap.dbmtk.demo;

import java.awt.Window;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;
import java.util.LinkedHashMap;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sap.dbmtk.demo.SqlStatement.Type;
import com.sap.dbmtk.demo.ui.GTable;

import net.miginfocom.swing.MigLayout;

public class AddOrChangePublisher
extends AddOrChangeAbstract
{
	private static final long serialVersionUID = 1L;

	private static final String NAME = "Publisher";

	private int        _pub_id         = -1;
	private JLabel     _pub_id_lbl     = new JLabel("pub_id");
	private JTextField _pub_id_txt     = new JTextField(10);
	
	private JLabel     _pub_name_lbl   = new JLabel("Publisher Name");
	private JTextField _pub_name_txt   = new JTextField(50);
	
	private JLabel     _city_lbl       = new JLabel("City");
	private JTextField _city_txt       = new JTextField();
	
	private JLabel     _state_lbl      = new JLabel("State");
	private JTextField _state_txt      = new JTextField();
	
	public AddOrChangePublisher(Window owner, ConnectionProvider connProvider, OpType opType)
	{
		super(NAME, owner, connProvider, opType);
		super.init();
	}

	@Override
	public JPanel createPanel()
	{
		JPanel panel = new JPanel();
		panel.setLayout(new MigLayout());

		if ( isUpdate() || isDelete() )
		{
			_pub_id_txt.setEnabled(false);
			panel.add(_pub_id_lbl, "");
			panel.add(_pub_id_txt, "growx, pushx, wrap 20");
		}

		panel.add(_pub_name_lbl,   "");
		panel.add(_pub_name_txt,   "growx, pushx, wrap");

		panel.add(_city_lbl,       "");
		panel.add(_city_txt,       "growx, pushx, wrap");
		
		panel.add(_state_lbl,      "");
		panel.add(_state_txt,      "growx, pushx, wrap 20");
		
		if ( isDelete())
		{
			_pub_name_txt   .setEnabled(false);
			_city_txt       .setEnabled(false);
			_state_txt      .setEnabled(false);
		}

		return panel;
	}

	@Override
	public void setFields(GTable table, int vrow)
	{
		_pub_id          = table.getValueAsInteger(vrow, "pub_id", false);
		_pub_id_txt      .setText(_pub_id+"");

		_pub_name_txt   .setText(table.getValueAsString(vrow, "publisher_name", false));
		_city_txt       .setText(table.getValueAsString(vrow, "city",           false));
		_state_txt      .setText(table.getValueAsString(vrow, "state",          false));
	}

	public String getPubName()    { return getStringValue(_pub_name_txt); }
	public String getCity()       { return getStringValue(_city_txt    ); }
	public String getState()      { return getStringValue(_state_txt   ); }

	@Override
	public boolean doInsert()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call insert_publisher(?, ?, ?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("pub_name", Types.VARCHAR, getPubName()) );
		stmnt.addParam( SqlStatementParam.createInParam("city",     Types.VARCHAR, getCity()   ) );
		stmnt.addParam( SqlStatementParam.createInParam("state",    Types.VARCHAR, getState()  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Adding "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doUpdate()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call update_publisher(?, ?, ?, ?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("pub_id",   Types.INTEGER, _pub_id) );

		stmnt.addParam( SqlStatementParam.createInParam("pub_name", Types.VARCHAR, getPubName()) );
		stmnt.addParam( SqlStatementParam.createInParam("city",     Types.VARCHAR, getCity()   ) );
		stmnt.addParam( SqlStatementParam.createInParam("state",    Types.VARCHAR, getState()  ) );

		return stmnt.execute(getConnectionProvider(), _owner, "Updating "+NAME+" information <b>failed.</b>");
	}

	@Override
	public boolean doDelete()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call delete_publisher(?)}");
	    
		stmnt.addParam( SqlStatementParam.createInParam("pub_id",   Types.INTEGER, _pub_id) );

		return stmnt.execute(getConnectionProvider(), _owner, "Deleting "+NAME+" information <b>failed.</b>");
	}


//	public static HashMap<String, Integer> getPublishersLookup(Window owner, ConnectionProvider connProvider)
//	{
//		LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
//		
////		String sql = "select pub_name, pub_id from publishers \n";
//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_publishers_lookup(?)}");
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
//
//		try
//		{
//			ResultSet rs = stmnt.executeQuery(connProvider);
//			int rowc = 0;
//			while(rs.next())
//			{
//				rowc++;
//				map.put(rs.getString(1), rs.getInt(2));
//			}
//			SqlTraceWindow.getInstance().addRowcount( rowc );
//
//			SqlStatement.putWarningMessages(connProvider, null, rs);
//			rs.close();
//		}
//		catch (SQLException e)
//		{
//			SqlStatement.showErrorMessage(e, stmnt, owner, "Getting Publishers (name,id) <b>failed.</b>");
//		}
//		
//		return map;
//	}

}
