package com.sap.dbmtk.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import com.sap.dbmtk.demo.AddOrChangeAbstract.OpType;
import com.sap.dbmtk.demo.SqlStatement.Type;
import com.sap.dbmtk.demo.utils.Configuration;
import com.sap.dbmtk.demo.utils.SelectAllFocusListener;
import com.sap.dbmtk.demo.utils.SwingUtils;

import net.miginfocom.swing.MigLayout;


public class DataPanelPublishers 
extends DataPanelAbstract
{
	private static final long serialVersionUID = 1L;
	public static final String NAME = "Publishers";

	public DataPanelPublishers(DemoApp owner)
	{
		super(owner, NAME, true);
	}


	//----------------------------------------------------------------
	// BEGIN: DB filter stuff
	//----------------------------------------------------------------
	private JLabel     _pubName_lbl;
	private JTextField _pubName_txt;

	@Override
	public JPanel createDbSearchPanel()
	{
		_pubName_lbl = new JLabel("Publisher Name");
		_pubName_txt = new JTextField();

		JPanel p = SwingUtils.createPanel("DB/Server Filter", true, new MigLayout());		
		
		p.add(_pubName_lbl, "");
		p.add(_pubName_txt, "growx, pushx");

		p.add(_dbRowCount_lbl, "");

		// On return in some fields, press "refresh" button
		ActionListener al = new ActionListener()
		{
			@Override
			public void actionPerformed(ActionEvent e)
			{
				_refresh_but.doClick();
			}
		};
		_pubName_txt.addActionListener(al);

		_pubName_txt.addFocusListener(new SelectAllFocusListener());

		return p;
	}

	@Override
	public int getDbRowCount()
	{
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_publishers_count(?)}");
		stmnt.addParam( SqlStatementParam.createOutParam("rcount", Types.INTEGER) );
		
		stmnt.execute(getConnectionProvider(), getOwner(), "Get rowcount");

		Integer rcount = (Integer) stmnt.getParameterValue("rcount");
		return rcount == null ? -1 : rcount;
	}

	@Override
	public void saveProps()
	{
		Configuration conf = Configuration.getInstance(Configuration.USER_TEMP);
		if (conf != null)
		{
			conf.setProperty(NAME+".field.pubName", _pubName_txt.getText());
		}
	}
	@Override
	public void loadProps()
	{
		Configuration conf = Configuration.getCombinedConfiguration();
		_pubName_txt.setText(conf.getProperty(NAME+".field.pubName", "books"));
	}
	//----------------------------------------------------------------
	// END: DB filter stuff
	//----------------------------------------------------------------

	/**
	 * Is called when the "New" button is pressed
	 */
	@Override
	public void actionAdd()
	{
		AddOrChangeAbstract dialog = new AddOrChangePublisher(_owner.getWindow(), getConnectionProvider(), OpType.INSERT);
		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}

	/**
	 * Is called when the "Change" button is pressed
	 */
	@Override
	public void actionChange()
	{
		AddOrChangeAbstract dialog = new AddOrChangePublisher(_owner.getWindow(), getConnectionProvider(), OpType.UPDATE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
			refreshTableData();
		dialog.dispose();
	}
	
	/**
	 * Is called when the "Remove" button is pressed
	 */
	@Override
	public void actionRemove()
	{
		AddOrChangeAbstract dialog = new AddOrChangePublisher(_owner.getWindow(), getConnectionProvider(), OpType.DELETE);
		
		int vrow = getTable().getSelectedRow();
		dialog.setFields(getTable(), vrow);

		if (dialog.open() == AddOrChangeAbstract.OK)
		{
			refreshDbRowCount();
			refreshTableData();
		}
		dialog.dispose();
	}
	
	@Override
	public SqlStatement getTableDataSqlStatement()
	{
//		return new SqlStatement(Type.LANGUAGE, "select pub_name, city, state, pub_id from publishers");

		String pubName = null;
		if (isDbSearchPanelVisible())
		{
			pubName = _pubName_txt.getText();
		}
		
		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_publishers(?, ?)}");
		stmnt.addParam( SqlStatementParam.createInParam("pub_name", Types.VARCHAR, pubName) );
		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
		
//		SqlStatement stmnt = new SqlStatement(Type.CALLABLE, "{call get_publishers(?)}");
//		stmnt.addParam( SqlStatementParam.createOracleResultSetParam("a_cursor") );
		
		return stmnt;
	}

	
	@Override
	public List<String> getHiddenColumns()
	{
		List<String> hiddenCols = new ArrayList<String>();
		hiddenCols.add("pub_id");
		return hiddenCols;
	}
}
