/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.CallableStatementSapDB;
import com.sap.db.jdbc.CallableStatementSapDBFinalize;
import com.sap.db.jdbc.ClientInfo;
import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.DatabaseMetaDataNGDB_StoredQueries;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.EngineFeatures;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.NameHandling;
import com.sap.db.jdbc.Parseinfo;
import com.sap.db.jdbc.ParseinfoCache;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.SavepointSapDB;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.StatementSapDBFinalize;
import com.sap.db.jdbc.Transaction;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.ConnectionException;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.MultiLineOptionsPart;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.PartEnumeration;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.jdbc.topology.System;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.util.CountingSemaphore;
import com.sap.db.util.GarbageCursor;
import com.sap.db.util.GarbageParseid;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.RecordGenerator;
import com.sap.db.util.StringUtil;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import com.sap.db.util.UniqueID;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AuthenticationManager;
import com.sap.db.util.security.NativeAuthenticationManagerImpl;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.security.auth.Subject;

public class ConnectionSapDB
extends WrapperDummy
implements Connection {
    public static final int GC_ALLOWED = 1;
    public static final int GC_DELAYED = 2;
    public static final int GC_NONE = 3;
    public static final int DISTRIBUTION_UNKNOWN = -1;
    public static final int DISTRIBUTION_OFF = 0;
    public static final int DISTRIBUTION_CONNECTION = 1;
    public static final int DISTRIBUTION_STATEMENT_ONLY = 2;
    public static final int DISTRIBUTION_STATEMENT_CONNECTION = 3;
    private static final int[] isolationLevelInternal2JDBC = new int[]{1, 2, 4, 8};
    protected CountingSemaphore m_communicationSemaphore = new CountingSemaphore();
    SessionPool m_sessionPool;
    int m_distributionMode = 3;
    protected boolean inReconnect = false;
    private GarbageParseid garbageParseids = null;
    private GarbageCursor garbageCursors = null;
    ArrayList statementContainer = null;
    Transaction m_transaction;
    private byte[] m_statementcontext = null;
    Stack packetPool = new Stack();
    private SQLWarning warningList;
    private Properties connectProperties;
    private byte[] m_cookie = null;
    private Subject authenticatedSubject;
    UniqueID UniqueID = new UniqueID();
    private Map typeMap;
    private Object executingObject = null;
    private boolean keepGarbage = false;
    private int isolationLevel = 2;
    private int resultSetHoldability = 1;
    private int defaultResultSetType = 1003;
    private boolean readOnly = false;
    ParseinfoCache parseCache = null;
    private AbstractAuthenticationManager m_authMan = null;
    private DatabaseMetaDataNGDB_StoredQueries DatabaseMetaData;
    private String cursorPrefix = "JDBC_CURSOR_";
    private static final String syncObj = "";
    private int nonRecyclingExecutions = 0;
    private int defaultStatementLength = -1;
    private int kernelversion;
    private Object mClientInfo = null;
    private boolean releaseSavePointSupported = true;
    boolean picky = false;
    private boolean isTracingDisabled;
    protected boolean isDDLCommitted = true;
    public Tracer tracer;
    public TraceControl m_trcCtl;
    protected int m_rollbackCount = 0;
    protected EngineFeatures m_engineFeatures;
    boolean isClosed = false;

    public ConnectionSapDB(JdbcCommunication session, Properties info, TraceControl mytrc) throws SQLException {
        this.m_trcCtl = mytrc;
        this.tracer = this.m_trcCtl.tracer;
        this.m_sessionPool = new SessionPool(this.tracer);
        this.m_transaction = new Transaction(this.m_sessionPool, this.tracer);
        this.connectProperties = (Properties)info.clone();
        this.isTracingDisabled = Driver.getBooleanProperty(this.connectProperties, "disableTracing", false);
        this.defaultResultSetType = Driver.resultSetTypeString2Jdbc(this.connectProperties.getProperty("defaultresultsettype", String.valueOf(1003)));
        String dist = this.connectProperties.getProperty("distribution", "STATEMENT");
        this.m_distributionMode = Driver.parseDistributionMode(dist);
        try {
            this.doConnect(this.connectProperties, session);
        }
        catch (SQLException e) {
            mytrc.tracer.traceException(e);
            throw e;
        }
        this.statementContainer = new ArrayList();
    }

    final void addWarning(SQLWarning warning) {
        if (this.warningList == null) {
            this.warningList = warning;
        } else {
            this.warningList.setNextWarning(warning);
        }
    }

    protected void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    public final void cancel(Object requestingObject) throws SQLException {
        if (this.executingObject == requestingObject) {
            this.cancelInternal();
        }
    }

    public final void cancel(Object r1, Object r2) throws SQLException {
        if (this.executingObject == r1 && r1 != null || this.executingObject == r2 && r2 != null) {
            this.cancelInternal();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelInternal() throws SQLException {
        Connection conn = null;
        try {
            conn = Driver.singleton().connect(this.connectProperties.getProperty("dburl"), this.connectProperties);
            long connID = this.getConnectionID();
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("ALTER SYSTEM CANCEL SESSION '" + connID + "'");
            stmt.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public final void clearWarnings() throws SQLException {
        this.warningList = null;
    }

    public synchronized void close() throws SQLException {
        if (!this.isClosed) {
            if (this.garbageCursors != null) {
                this.garbageCursors.emptyCan();
            }
            if (this.garbageParseids != null) {
                this.garbageParseids.emptyCan();
            }
            this.m_sessionPool.releaseAll(this);
            this.m_transaction.clear(this);
            this.releaseSession();
            this.isClosed = true;
        }
    }

    void releaseSession() {
        if (!this.isClosed) {
            this.m_sessionPool.releaseAll(this);
        }
        this.DatabaseMetaData = null;
    }

    boolean closeCursorAtCommit() throws SQLException {
        boolean forceGC = false;
        if (this.statementContainer != null) {
            int sz = this.statementContainer.size();
            for (int i = 0; i < sz; ++i) {
                StatementSapDB st = (StatementSapDB)((WeakReference)this.statementContainer.get(i)).get();
                if (st == null) continue;
                ResultSetSapDB rs = st.currentResultSet;
                if (st.getResultSetHoldability() != 2 || rs == null) continue;
                forceGC = true;
                rs.close();
            }
            this.statementContainer.clear();
            if (forceGC && this.garbageCursors != null) {
                this.garbageCursors.forceGarbageCollection();
            }
        }
        return forceGC;
    }

    public synchronized void commit() throws SQLException {
        this.assertOpen();
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        this.commitInternal();
    }

    void commitInternal() throws SQLException {
        block2: {
            JdbcCommunication session = this.m_sessionPool.getSessionForTransactionHandling();
            RequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initCommit(true, this.m_statementcontext);
            this.closeCursorAtCommit();
            try {
                this.execute(requestPacket, this, 1, session, true);
            }
            catch (SQLException ignore) {
                if (ignore.getErrorCode() == 700) break block2;
                throw ignore;
            }
        }
        this.m_transaction.clear(this);
    }

    public Statement createStatement() throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, this.defaultResultSetType, 1007, 1);
        }
        return new StatementSapDB(this, this.defaultResultSetType, 1007, 1);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, resultSetType, resultSetConcurrency, 1);
        }
        return new StatementSapDB(this, resultSetType, resultSetConcurrency, 1);
    }

    public String getTermID() {
        StringBuffer termidsb = new StringBuffer(18);
        if (Driver.processid == 0) {
            termidsb.append("java@");
            termidsb.append(Integer.toHexString(this.hashCode()));
        } else {
            termidsb.append(Driver.processid);
            termidsb.append('@');
            termidsb.append(Driver.fullcomputername);
        }
        return termidsb.toString();
    }

    protected void doConnect(Properties info, JdbcCommunication session) throws SQLException {
        String currentSchema;
        this.openSession(info, session);
        this.m_sessionPool.addSession(session);
        if (!this.m_engineFeatures.isCompleteArrayExecutionSupported) {
            SQLException exc = SQLExceptionSapDB.generateSQLException("error.connection.updateengine", "NEW_TABLE_UPDATE");
            this.addWarning(new SQLWarning(exc.getMessage(), exc.getSQLState(), exc.getErrorCode()));
        }
        this.m_distributionMode = this.m_engineFeatures.distributionMode;
        if (this.m_authMan != null && !this.m_authMan.supportsReconnect()) {
            switch (this.m_distributionMode) {
                case 2: {
                    this.m_distributionMode = 0;
                    this.tracer.print("Disable distribution (mode statement_only) because it isn't supported with authentication mode " + this.m_authMan.getMethodName() + ".");
                    break;
                }
                case 3: {
                    this.m_distributionMode = 1;
                    this.tracer.print("Disable distribution (mode statement) because it isn't supported with authentication mode " + this.m_authMan.getMethodName() + ".");
                }
            }
        }
        session.setConnectionID(this.m_engineFeatures.connectionID);
        this.refreshMetaData();
        this.m_transaction.setAutocommit(Driver.getBooleanProperty(info, "autocommit", this.m_transaction.m_autocommit));
        if (info.containsKey("cache")) {
            this.parseCache = new ParseinfoCache(info);
        }
        if ((currentSchema = info.getProperty("currentschema")) != null && currentSchema.length() != 0) {
            String cmd = "SET SCHEMA " + currentSchema;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            try {
                setIso.executeUpdate(cmd);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.tracer.dumpConnectionState(this.m_sessionPool, this, "new session added to");
    }

    protected JdbcCommunication openSession(int volumeID) throws SQLException {
        JdbcCommunication session = this.m_sessionPool.getSession(volumeID);
        ReplyPacket reply = null;
        if (session == null) {
            System sys = this.m_sessionPool.getSystem();
            this.tracer.print("new session '" + volumeID + "'");
            try {
                session = sys.getSession(volumeID, this.connectProperties, this.m_trcCtl);
                if (session == null) {
                    this.tracer.println("=> FAILED because of missing location information for volumeID " + volumeID + ".");
                    return null;
                }
                reply = this.openSession(this.connectProperties, session);
            }
            catch (RTEException rteExc) {
                this.tracer.print("using " + session);
                this.tracer.print("=> FAILED");
                throw SQLExceptionSapDB.generateDatabaseException("error.connect.rteexception", syncObj, rteExc.getDetailErrorCode(), 0, rteExc.getRTEReturncode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, "VolumeID=" + volumeID, rteExc.getMessage());
            }
            catch (SQLException exc) {
                this.tracer.print("using " + session);
                this.tracer.print("=> FAILED " + exc.toString());
                throw exc;
            }
            this.tracer.println("=> " + session + " " + session.getLocation());
        }
        EngineFeatures engineFeatures = reply.findEngineFeatures();
        this.m_sessionPool.addSession(session);
        session.setConnectionID(engineFeatures.connectionID);
        String currentSchema = this.connectProperties.getProperty("currentschema");
        if (currentSchema != null && currentSchema.length() != 0) {
            String cmd = "SET SCHEMA " + currentSchema;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            setIso.executeUpdate(cmd);
        }
        if (this.isolationLevel != 2) {
            String sapdbEncoding = Driver.isolevelJdbc2native(this.isolationLevel);
            String cmd = "SET TRANSACTION ISOLATION LEVEL   " + sapdbEncoding;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            setIso.execute(cmd, session, true, true);
        }
        this.tracer.dumpConnectionState(this.m_sessionPool, this, "new session added to");
        return session;
    }

    private ReplyPacket openSession(Properties info, JdbcCommunication session) throws SQLException {
        boolean isUserPasswdAscii;
        String userName = this.connectProperties.getProperty("user");
        if (userName == null || userName.length() == 0) {
            userName = syncObj;
        }
        String userEscaped = NameHandling.stripUsernameEscaped(userName);
        String passwd = this.connectProperties.getProperty("password");
        if (passwd == null) {
            passwd = syncObj;
        }
        if (isUserPasswdAscii = StringUtil.isIso8859_1(passwd)) {
            isUserPasswdAscii = StringUtil.isIso8859_1(userEscaped);
        }
        String strippedPassword = NameHandling.stripPassword(passwd);
        if (Driver.getBooleanProperty(info, "nativeAuthentication", false)) {
            try {
                this.m_authMan = new NativeAuthenticationManagerImpl();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -11204) {
                    this.tracer.print("Cannot load native authentication library [" + e.toString() + "].");
                    this.m_authMan = new AuthenticationManager();
                }
                throw e;
            }
        } else {
            this.m_authMan = new AuthenticationManager();
        }
        this.m_authMan.authenticate(this, userName, strippedPassword, isUserPasswdAscii, session);
        int maxpwdLen = this.m_authMan.getMaxPasswordLength();
        if (maxpwdLen != -1 && strippedPassword.length() > maxpwdLen) {
            strippedPassword = strippedPassword.substring(0, maxpwdLen);
        }
        if (Driver.getBooleanProperty(info, "authentication", false)) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.challengeresponsenotsupported");
        }
        return this.m_authMan.connect(this, info, userName, strippedPassword, isUserPasswdAscii, session);
    }

    public ReplyPacket execute(RequestPacket requestPacket, RecordGenerator recordGenerator, Object executingObject, int gcFlags, JdbcCommunication session, boolean avoidReconnect) throws SQLException {
        return this.execute(requestPacket, recordGenerator, false, false, executingObject, gcFlags, session, avoidReconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplyPacket execute(RequestPacket requestPacket, RecordGenerator recordGenerator, boolean ignoreErrors, boolean isParse, Object executingObject, int gcFlags, JdbcCommunication session, boolean avoidReconnect) throws SQLException {
        int[] updateCnt = null;
        StructuredMem errorPart = null;
        this.m_communicationSemaphore.acquire();
        try {
            ReplyPacket replyPacket;
            block73: {
                int localWeakReturnCode;
                block74: {
                    replyPacket = null;
                    localWeakReturnCode = 0;
                    boolean functionCode = false;
                    this.assertOpen();
                    if (!this.isTracingDisabled) {
                        this.m_trcCtl.checkTraceSettings();
                    }
                    if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                        Properties prop = ClientInfo.getClientInfo(this.mClientInfo);
                        HashSet unset = ClientInfo.getUnsetProperties(this.mClientInfo);
                        requestPacket.addClientInfoPart(prop, unset, this.m_engineFeatures.canHandleNullClientInfoValues);
                    }
                    if ((gcFlags = 2) == 1) {
                        boolean spaceleft = true;
                        if (this.garbageCursors != null && this.garbageCursors.isPending()) {
                            if (this.inReconnect) {
                                this.garbageCursors.emptyCan();
                            } else {
                                spaceleft = this.garbageCursors.emptyCan(requestPacket);
                            }
                        }
                        if (spaceleft && this.garbageParseids != null && this.garbageParseids.isPending()) {
                            if (this.inReconnect) {
                                this.garbageParseids.emptyCan();
                            } else {
                                this.garbageParseids.emptyCan(requestPacket);
                            }
                        }
                    } else if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                        ++this.nonRecyclingExecutions;
                    }
                    requestPacket.closePacket();
                    try {
                        block72: {
                            try {
                                this.executingObject = executingObject;
                                replyPacket = new ReplyPacket(session.execute(recordGenerator.getPacketVec(), recordGenerator.getLengthVec()));
                                replyPacket.firstSegment();
                                localWeakReturnCode = replyPacket.returnCode();
                                OptionsPart transFlags = null;
                                OptionsPart scpart = null;
                                MultiLineOptionsPart topoPart = null;
                                boolean transWriteNoWriteFlagFound = false;
                                PartEnumeration enume = replyPacket.partEnumeration();
                                block27: while (enume.hasMoreElements()) {
                                    enume.nextElement();
                                    switch (enume.partKind()) {
                                        case 6: {
                                            errorPart = replyPacket.getPartPointer();
                                            continue block27;
                                        }
                                        case 12: {
                                            updateCnt = replyPacket.getBatchUpdateCounts(true);
                                            continue block27;
                                        }
                                        case 64: {
                                            transFlags = replyPacket.getTransactionFlags();
                                            continue block27;
                                        }
                                        case 39: {
                                            scpart = replyPacket.getStatementContext();
                                            continue block27;
                                        }
                                        case 15: {
                                            topoPart = replyPacket.getTopology();
                                            continue block27;
                                        }
                                        case 42: {
                                            this.m_engineFeatures = replyPacket.getEngineFeatures();
                                            continue block27;
                                        }
                                    }
                                }
                                System sys = null;
                                if (this.m_engineFeatures != null && this.m_engineFeatures.systemID != null) {
                                    sys = session.setSystemID(this.m_engineFeatures.systemID);
                                }
                                if (sys != null) {
                                    Location loc;
                                    sys.setEngineDistributionMode(this.m_engineFeatures.distributionMode);
                                    if (topoPart != null && (loc = sys.updateLocations(topoPart)) != null) {
                                        session.getLocation().update(loc);
                                    }
                                }
                                if (scpart != null) {
                                    do {
                                        switch (scpart.getOptionName()) {
                                            case 1: {
                                                this.m_statementcontext = scpart.getOptionBinaryValue();
                                                break;
                                            }
                                            case 2: {
                                                long loc = scpart.getOptionLongValue();
                                                break;
                                            }
                                        }
                                    } while (scpart.nextOption());
                                }
                                if (transFlags != null) {
                                    block29: do {
                                        switch (transFlags.getOptionName()) {
                                            case 1: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.clear(this);
                                                this.closeCursorAtCommit();
                                                break;
                                            }
                                            case 0: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                ++this.m_rollbackCount;
                                                this.m_transaction.clear(this);
                                                break;
                                            }
                                            case 2: {
                                                int isoLevel = transFlags.getOptionIntValue();
                                                this.isolationLevel = isolationLevelInternal2JDBC[isoLevel];
                                                break;
                                            }
                                            case 3: {
                                                this.isDDLCommitted = transFlags.getOptionBoolValue();
                                                break;
                                            }
                                            case 4: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.setTransactionState(2, session);
                                                transWriteNoWriteFlagFound = true;
                                                break;
                                            }
                                            case 5: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.setTransactionState(1, session);
                                                transWriteNoWriteFlagFound = true;
                                                break;
                                            }
                                            case 6: {
                                                this.close();
                                                break;
                                            }
                                        }
                                    } while (transFlags.nextOption());
                                } else if (!(this.m_transaction.m_autocommit || isParse || transWriteNoWriteFlagFound || this.m_transaction.isWriteTransaction() || this.m_engineFeatures.useTransactionFlagsOnly || !this.m_transaction.setTransactionState(replyPacket.functionCode(), session, this.isDDLCommitted, this))) {
                                    this.closeCursorAtCommit();
                                }
                                if (this.m_transaction.m_autocommit) {
                                    this.m_transaction.clear(this);
                                    this.closeCursorAtCommit();
                                }
                                if (gcFlags == 3) break block72;
                                if (this.garbageCursors != null && this.garbageCursors.isPending() && localWeakReturnCode == 0) {
                                    if (this.inReconnect) {
                                        this.garbageCursors.emptyCan();
                                    } else {
                                        this.garbageCursors.emptyCan(this, session);
                                    }
                                }
                                if (this.garbageParseids == null || !this.garbageParseids.isPending() || localWeakReturnCode != 0) break block72;
                                this.nonRecyclingExecutions = 0;
                                if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                                    if (this.inReconnect) {
                                        this.garbageParseids.emptyCan();
                                    } else {
                                        this.garbageParseids.emptyCan(this, session);
                                    }
                                }
                                this.nonRecyclingExecutions = 0;
                            }
                            catch (RTEException rteExc) {
                                if (!this.isClosed && !session.isConnected()) {
                                    this.releaseSession();
                                }
                                if (avoidReconnect) throw ConnectionException.createException(rteExc);
                                if (!Driver.getBooleanProperty(this.connectProperties, "reconnect", true)) throw ConnectionException.createException(rteExc);
                                if (this.inReconnect) throw ConnectionException.createException(rteExc);
                                if (this.m_transaction.isWriteTransaction()) throw ConnectionException.createException(rteExc);
                                if (this.getTransactionIsolation() == 4) throw ConnectionException.createException(rteExc);
                                if (this.getTransactionIsolation() == 8) {
                                    throw ConnectionException.createException(rteExc);
                                }
                                this.tryReconnect(rteExc, session);
                                Object var24_27 = null;
                                this.executingObject = null;
                                if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                                    ClientInfo.setHasChanged(this.mClientInfo, false);
                                }
                                if (errorPart == null) break block73;
                                SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                                if (exc instanceof SQLWarning) {
                                    this.addWarning((SQLWarning)exc);
                                    break block73;
                                } else {
                                    if (this.m_transaction.m_autocommit) {
                                        ++this.m_rollbackCount;
                                    }
                                    if (!ignoreErrors && localWeakReturnCode != 0) {
                                        throw exc;
                                    }
                                }
                                break block73;
                            }
                        }
                        Object var24_26 = null;
                        this.executingObject = null;
                        if (this.mClientInfo == null) break block74;
                    }
                    catch (Throwable throwable) {
                        Object var24_28 = null;
                        this.executingObject = null;
                        if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                            ClientInfo.setHasChanged(this.mClientInfo, false);
                        }
                        if (errorPart == null) throw throwable;
                        SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                        if (exc instanceof SQLWarning) {
                            this.addWarning((SQLWarning)exc);
                            throw throwable;
                        }
                        if (this.m_transaction.m_autocommit) {
                            ++this.m_rollbackCount;
                        }
                        if (ignoreErrors) throw throwable;
                        if (localWeakReturnCode == 0) throw throwable;
                        throw exc;
                    }
                    if (ClientInfo.hasChanged(this.mClientInfo)) {
                        ClientInfo.setHasChanged(this.mClientInfo, false);
                    }
                }
                if (errorPart != null) {
                    SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                    if (exc instanceof SQLWarning) {
                        this.addWarning((SQLWarning)exc);
                    } else {
                        if (this.m_transaction.m_autocommit) {
                            ++this.m_rollbackCount;
                        }
                        if (!ignoreErrors && localWeakReturnCode != 0) {
                            throw exc;
                        }
                    }
                }
            }
            ReplyPacket replyPacket2 = replyPacket;
            Object var27_33 = null;
            this.freeRequestPacket(requestPacket);
            this.m_communicationSemaphore.release();
            return replyPacket2;
        }
        catch (Throwable throwable) {
            Object var27_34 = null;
            this.freeRequestPacket(requestPacket);
            this.m_communicationSemaphore.release();
            throw throwable;
        }
    }

    public ReplyPacket execute(RequestPacket requestPacket, Object executingObject, int gcFlags, JdbcCommunication session, boolean avoidReconnect) throws SQLException {
        return this.execute(requestPacket, false, false, executingObject, gcFlags, session, avoidReconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReplyPacket execute(RequestPacket requestPacket, boolean ignoreErrors, boolean isParse, Object executingObject, int gcFlags, JdbcCommunication session, boolean avoidReconnect) throws SQLException {
        int[] updateCnt = null;
        StructuredMem errorPart = null;
        this.m_communicationSemaphore.acquire();
        try {
            ReplyPacket replyPacket;
            block73: {
                int localWeakReturnCode;
                block74: {
                    replyPacket = null;
                    localWeakReturnCode = 0;
                    boolean functionCode = false;
                    this.assertOpen();
                    if (!this.isTracingDisabled) {
                        this.m_trcCtl.checkTraceSettings();
                    }
                    if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                        Properties prop = ClientInfo.getClientInfo(this.mClientInfo);
                        HashSet unset = ClientInfo.getUnsetProperties(this.mClientInfo);
                        requestPacket.addClientInfoPart(prop, unset, this.m_engineFeatures.canHandleNullClientInfoValues);
                    }
                    if ((gcFlags = 2) == 1) {
                        boolean spaceleft = true;
                        if (this.garbageCursors != null && this.garbageCursors.isPending()) {
                            if (this.inReconnect) {
                                this.garbageCursors.emptyCan();
                            } else {
                                spaceleft = this.garbageCursors.emptyCan(requestPacket);
                            }
                        }
                        if (spaceleft && this.garbageParseids != null && this.garbageParseids.isPending()) {
                            if (this.inReconnect) {
                                this.garbageParseids.emptyCan();
                            } else {
                                this.garbageParseids.emptyCan(requestPacket);
                            }
                        }
                    } else if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                        ++this.nonRecyclingExecutions;
                    }
                    requestPacket.closePacket();
                    int requestLen = requestPacket.length();
                    try {
                        block72: {
                            try {
                                this.executingObject = executingObject;
                                replyPacket = new ReplyPacket(session.execute(requestPacket.getBase(), requestLen));
                                replyPacket.firstSegment();
                                localWeakReturnCode = replyPacket.returnCode();
                                OptionsPart transFlags = null;
                                OptionsPart scpart = null;
                                MultiLineOptionsPart topoPart = null;
                                boolean transWriteNoWriteFlagFound = false;
                                PartEnumeration enume = replyPacket.partEnumeration();
                                block27: while (enume.hasMoreElements()) {
                                    enume.nextElement();
                                    switch (enume.partKind()) {
                                        case 6: {
                                            errorPart = replyPacket.getPartPointer();
                                            continue block27;
                                        }
                                        case 12: {
                                            updateCnt = replyPacket.getBatchUpdateCounts(true);
                                            continue block27;
                                        }
                                        case 64: {
                                            transFlags = replyPacket.getTransactionFlags();
                                            continue block27;
                                        }
                                        case 39: {
                                            scpart = replyPacket.getStatementContext();
                                            continue block27;
                                        }
                                        case 15: {
                                            topoPart = replyPacket.getTopology();
                                            continue block27;
                                        }
                                        case 42: {
                                            this.m_engineFeatures = replyPacket.getEngineFeatures();
                                            continue block27;
                                        }
                                    }
                                }
                                System sys = null;
                                if (this.m_engineFeatures != null && this.m_engineFeatures.systemID != null) {
                                    sys = session.setSystemID(this.m_engineFeatures.systemID);
                                }
                                if (sys != null) {
                                    Location loc;
                                    sys.setEngineDistributionMode(this.m_engineFeatures.distributionMode);
                                    if (topoPart != null && (loc = sys.updateLocations(topoPart)) != null) {
                                        session.getLocation().update(loc);
                                    }
                                }
                                if (scpart != null) {
                                    do {
                                        switch (scpart.getOptionName()) {
                                            case 1: {
                                                this.m_statementcontext = scpart.getOptionBinaryValue();
                                                break;
                                            }
                                            case 2: {
                                                long loc = scpart.getOptionLongValue();
                                                break;
                                            }
                                        }
                                    } while (scpart.nextOption());
                                }
                                if (transFlags != null) {
                                    block29: do {
                                        switch (transFlags.getOptionName()) {
                                            case 1: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.clear(this);
                                                this.closeCursorAtCommit();
                                                break;
                                            }
                                            case 0: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                ++this.m_rollbackCount;
                                                this.m_transaction.clear(this);
                                                break;
                                            }
                                            case 2: {
                                                int isoLevel = transFlags.getOptionIntValue();
                                                this.isolationLevel = isolationLevelInternal2JDBC[isoLevel];
                                                break;
                                            }
                                            case 3: {
                                                this.isDDLCommitted = transFlags.getOptionBoolValue();
                                                break;
                                            }
                                            case 4: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.setTransactionState(2, session);
                                                transWriteNoWriteFlagFound = true;
                                                break;
                                            }
                                            case 5: {
                                                if (!transFlags.getOptionBoolValue()) continue block29;
                                                this.m_transaction.setTransactionState(1, session);
                                                transWriteNoWriteFlagFound = true;
                                                break;
                                            }
                                            case 6: {
                                                this.close();
                                                break;
                                            }
                                        }
                                    } while (transFlags.nextOption());
                                } else if (!(this.m_transaction.m_autocommit || isParse || transWriteNoWriteFlagFound || this.m_transaction.isWriteTransaction() || this.m_engineFeatures.useTransactionFlagsOnly || !this.m_transaction.setTransactionState(replyPacket.functionCode(), session, this.isDDLCommitted, this))) {
                                    this.closeCursorAtCommit();
                                }
                                if (this.m_transaction.m_autocommit) {
                                    this.m_transaction.clear(this);
                                    this.closeCursorAtCommit();
                                }
                                if (gcFlags == 3) break block72;
                                if (this.garbageCursors != null && this.garbageCursors.isPending() && localWeakReturnCode == 0) {
                                    if (this.inReconnect) {
                                        this.garbageCursors.emptyCan();
                                    } else {
                                        this.garbageCursors.emptyCan(this, session);
                                    }
                                }
                                if (this.garbageParseids == null || !this.garbageParseids.isPending() || localWeakReturnCode != 0) break block72;
                                this.nonRecyclingExecutions = 0;
                                if (this.garbageParseids != null && this.garbageParseids.isPending()) {
                                    if (this.inReconnect) {
                                        this.garbageParseids.emptyCan();
                                    } else {
                                        this.garbageParseids.emptyCan(this, session);
                                    }
                                }
                                this.nonRecyclingExecutions = 0;
                            }
                            catch (RTEException rteExc) {
                                if (!this.isClosed && !session.isConnected()) {
                                    this.releaseSession();
                                }
                                if (avoidReconnect) throw ConnectionException.createException(rteExc);
                                if (!Driver.getBooleanProperty(this.connectProperties, "reconnect", true)) throw ConnectionException.createException(rteExc);
                                if (this.inReconnect) throw ConnectionException.createException(rteExc);
                                if (this.m_transaction.isWriteTransaction()) throw ConnectionException.createException(rteExc);
                                if (this.getTransactionIsolation() == 4) throw ConnectionException.createException(rteExc);
                                if (this.getTransactionIsolation() == 8) {
                                    throw ConnectionException.createException(rteExc);
                                }
                                this.tryReconnect(rteExc, session);
                                Object var23_27 = null;
                                this.executingObject = null;
                                if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                                    ClientInfo.setHasChanged(this.mClientInfo, false);
                                }
                                if (errorPart == null) break block73;
                                SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                                if (exc instanceof SQLWarning) {
                                    this.addWarning((SQLWarning)exc);
                                    break block73;
                                } else {
                                    if (this.m_transaction.m_autocommit) {
                                        ++this.m_rollbackCount;
                                    }
                                    if (!ignoreErrors && localWeakReturnCode != 0) {
                                        throw exc;
                                    }
                                }
                                break block73;
                            }
                        }
                        Object var23_26 = null;
                        this.executingObject = null;
                        if (this.mClientInfo == null) break block74;
                    }
                    catch (Throwable throwable) {
                        Object var23_28 = null;
                        this.executingObject = null;
                        if (this.mClientInfo != null && ClientInfo.hasChanged(this.mClientInfo)) {
                            ClientInfo.setHasChanged(this.mClientInfo, false);
                        }
                        if (errorPart == null) throw throwable;
                        SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                        if (exc instanceof SQLWarning) {
                            this.addWarning((SQLWarning)exc);
                            throw throwable;
                        }
                        if (this.m_transaction.m_autocommit) {
                            ++this.m_rollbackCount;
                        }
                        if (ignoreErrors) throw throwable;
                        if (localWeakReturnCode == 0) throw throwable;
                        throw exc;
                    }
                    if (ClientInfo.hasChanged(this.mClientInfo)) {
                        ClientInfo.setHasChanged(this.mClientInfo, false);
                    }
                }
                if (errorPart != null) {
                    SQLException exc = replyPacket.buildExceptionChain(errorPart, updateCnt);
                    if (exc instanceof SQLWarning) {
                        this.addWarning((SQLWarning)exc);
                    } else {
                        if (this.m_transaction.m_autocommit) {
                            ++this.m_rollbackCount;
                        }
                        if (!ignoreErrors && localWeakReturnCode != 0) {
                            throw exc;
                        }
                    }
                }
            }
            ReplyPacket replyPacket2 = replyPacket;
            Object var26_33 = null;
            this.freeRequestPacket(requestPacket);
            this.m_communicationSemaphore.release();
            return replyPacket2;
        }
        catch (Throwable throwable) {
            Object var26_34 = null;
            this.freeRequestPacket(requestPacket);
            this.m_communicationSemaphore.release();
            throw throwable;
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        this.assertOpen();
        return this.m_transaction.m_autocommit;
    }

    public final String getCatalog() throws SQLException {
        this.assertOpen();
        return null;
    }

    final String getConnectProperty(String key) {
        return this.connectProperties.getProperty(key, syncObj);
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpen();
        return this.DatabaseMetaData;
    }

    final void refreshMetaData() throws SQLException {
        if (this.DatabaseMetaData == null) {
            this.DatabaseMetaData = new DatabaseMetaDataNGDB_StoredQueries(this);
        } else {
            this.DatabaseMetaData.getDBInfo();
        }
    }

    public final RequestPacket getRequestPacket(JdbcCommunication session) throws SQLException {
        return this.getRequestPacket(-1, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RequestPacket getRequestPacket(int size, JdbcCommunication session) throws SQLException {
        Stack stack = this.packetPool;
        synchronized (stack) {
            RequestPacket erg = null;
            if (size > 0) {
                size = RequestPacket.aligned(size);
            }
            try {
                if (this.packetPool.isEmpty()) {
                    erg = new RequestPacket(session.getRequestPacket(size));
                } else {
                    erg = (RequestPacket)this.packetPool.pop();
                    if (erg.size() < size) {
                        erg = new RequestPacket(session.getRequestPacket(size));
                    }
                }
            }
            catch (RTEException rteEx) {
                throw ConnectionException.createException(rteEx);
            }
            erg.inUse = true;
            if (session.sendSessionContextInfo()) {
                JdbcCommunication masterSession = this.m_sessionPool.getMasterSession();
                JdbcCommunication primarySession = this.m_sessionPool.getPrimarySession();
                byte[] sc = erg.createSessionContextPart(primarySession, masterSession);
                erg.addAdditionalPart(34, sc, 6);
                session.setSendSessionContextInfo(false);
            }
            return erg;
        }
    }

    public final void freeRequestPacket(RequestPacket requestPacket) {
        requestPacket.inUse = false;
        this.packetPool.push(requestPacket);
    }

    public final int getTransactionIsolation() throws SQLException {
        this.assertOpen();
        return this.isolationLevel;
    }

    public final Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warningList;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public final boolean isReadOnly() throws SQLException {
        this.assertOpen();
        return this.readOnly;
    }

    final synchronized int maxStatementLength() throws SQLException {
        if (this.defaultStatementLength == -1) {
            RequestPacket requestPacket = this.getRequestPacket(this.m_sessionPool.getPrimarySession());
            int packetSize = requestPacket.size();
            int result = packetSize - 32 - 24 - 16;
            this.freeRequestPacket(requestPacket);
            this.defaultStatementLength = result;
        }
        return this.defaultStatementLength;
    }

    public final String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    final String nextCursorName() {
        return this.UniqueID.getNextID(this.cursorPrefix);
    }

    protected final void setCursorPrefix(String prefix) {
        this.cursorPrefix = prefix;
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, this.defaultResultSetType, 1007, 1);
        }
        return new CallableStatementSapDB(this, sql, this.defaultResultSetType, 1007, 1);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, 1);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, 1);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, this.defaultResultSetType, 1007, 1);
        }
        return new CallableStatementSapDB(this, sql, this.defaultResultSetType, 1007, 1);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, 1);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, 1);
    }

    public void rollback() throws SQLException {
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        this.rollbackInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInternal() throws SQLException {
        this.assertOpen();
        JdbcCommunication session = this.m_sessionPool.getSessionForTransactionHandling();
        RequestPacket requestPacket = this.getRequestPacket(session);
        requestPacket.initRollback(this.m_statementcontext);
        try {
            try {
                this.execute(requestPacket, this, 1, session, true);
            }
            catch (SQLException ignore) {
                if (ignore.getErrorCode() != 700) {
                    throw ignore;
                }
                Object var5_4 = null;
                ++this.m_rollbackCount;
                this.m_transaction.clear(this);
            }
            Object var5_3 = null;
            ++this.m_rollbackCount;
            this.m_transaction.clear(this);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ++this.m_rollbackCount;
            this.m_transaction.clear(this);
            throw throwable;
        }
    }

    public synchronized void setAutoCommit(boolean SetAutoCommit) throws SQLException {
        this.assertOpen();
        this.connectProperties.setProperty("autocommit", SetAutoCommit ? "TRUE" : "FALSE");
        if (SetAutoCommit && !this.m_transaction.m_autocommit) {
            this.commit();
        }
        this.m_transaction.setAutocommit(SetAutoCommit);
    }

    public final void setCatalog(String catalog) throws SQLException {
    }

    public final void setReadOnly(boolean readonly) throws SQLException {
        this.assertOpen();
        if (this.readOnly != readonly) {
            this.connectProperties.setProperty("readonly", readonly ? "TRUE" : "FALSE");
            String cmd = "SET TRANSACTION " + (readonly ? "READ ONLY" : "READ WRITE");
            InternalStatementSapDB roSt = new InternalStatementSapDB(this);
            roSt.executeUpdate(cmd);
            this.readOnly = readonly;
        }
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        this.assertOpen();
        if (this.isolationLevel != level) {
            this.connectProperties.setProperty("isolation", String.valueOf(level));
            String sapdbEncoding = Driver.isolevelJdbc2native(level);
            String cmd = "SET TRANSACTION ISOLATION LEVEL   " + sapdbEncoding;
            InternalStatementSapDB setIso = new InternalStatementSapDB(this);
            setIso.executeUpdateOnAllSessions(cmd, true, true);
            this.isolationLevel = level;
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.assertOpen();
        this.typeMap = map;
    }

    public void tryReconnect(RTEException outerRteExc, JdbcCommunication session) throws SQLException {
        String string = syncObj;
        synchronized (syncObj) {
            if (this.parseCache != null) {
                this.parseCache.clear();
            }
            if (this.garbageCursors != null) {
                this.garbageCursors.emptyCan();
            }
            if (this.garbageParseids != null) {
                this.garbageParseids.emptyCan();
            }
            this.packetPool.setSize(0);
            this.inReconnect = true;
            try {
                try {
                    if (this.m_authMan == null || !this.m_authMan.supportsReconnect()) {
                        SQLException ex = SQLExceptionSapDB.generateSQLException("error.reconnect.notpossible", this.m_authMan == null ? "NULL" : this.m_authMan.getMethodName());
                        ex.setNextException(ConnectionException.createException(outerRteExc));
                        throw ex;
                    }
                    session.getSystem().reconnect(session, this.tracer, this.m_distributionMode == 1 || this.m_distributionMode == 3);
                    this.tracer.print("try to reconnect ", this.connectProperties);
                    this.doConnect(this.connectProperties, session);
                    this.m_transaction.clear(this);
                    this.reinitialize();
                }
                catch (RTEException rteExc) {
                    throw ConnectionException.createException(outerRteExc);
                }
                Object var6_6 = null;
                this.inReconnect = false;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.inReconnect = false;
                throw throwable;
            }
            throw new InternalReconnectException();
        }
    }

    public final void dropParseid(byte[] pid, JdbcCommunication session) {
        if (!this.keepGarbage) {
            if (pid == null) {
                return;
            }
            try {
                RequestPacket requestPacket = this.getRequestPacket(session);
                requestPacket.dropPid(pid, true);
                this.execute(requestPacket, this, 1, session, true);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCursor(Cursor cursor, boolean forceGarbageCollection, JdbcCommunication session) {
        if (cursor == null || !session.isConnected()) {
            return;
        }
        if (!forceGarbageCollection) {
            ConnectionSapDB connectionSapDB = this;
            synchronized (connectionSapDB) {
                if (this.garbageCursors == null) {
                    this.garbageCursors = new GarbageCursor();
                }
                this.garbageCursors.throwIntoGarbageCan(cursor);
            }
        }
        try {
            RequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initdropCursorPart(cursor, true);
            this.execute(requestPacket, this, 1, session, true);
        }
        catch (SQLException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean restoreCursor(Cursor cursorname) {
        ConnectionSapDB connectionSapDB = this;
        synchronized (connectionSapDB) {
            if (this.garbageCursors != null) {
                return this.garbageCursors.restoreFromGarbageCan(cursorname);
            }
            return false;
        }
    }

    public void printCacheStats(PrintStream stream) {
        if (this.parseCache == null) {
            stream.println("no cache available");
        } else {
            this.parseCache.dumpStats(stream);
        }
    }

    public void printCacheStats(PrintWriter stream) {
        if (this.parseCache == null) {
            stream.println("no cache available");
        } else {
            this.parseCache.dumpStats(stream);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.assertOpen();
        this.resultSetHoldability = holdability;
    }

    public int getHoldability() throws SQLException {
        this.assertOpen();
        return this.resultSetHoldability;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setSavepoint", "ConnectionSapDB");
    }

    public Savepoint setSavepoint(String SavepointName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "setSavepoint", "ConnectionSapDB");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.getAutoCommit()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.autocommit");
        }
        SavepointSapDB.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "releaseSavepoint", "ConnectionSapDB");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new StatementSapDBFinalize(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new StatementSapDB(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpen();
        if (Driver.getBooleanProperty(this.connectProperties, "closehandlesonfinalize", true)) {
            return new CallableStatementSapDBFinalize(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new CallableStatementSapDB(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.preparestatement.notimplemented"));
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.autogenkeys.retrieval.unsupported"));
    }

    public void reinitialize() throws SQLException {
        boolean autoCommitMode;
        String isolation;
        int preset_isolationlevel;
        if (this.parseCache != null) {
            Object[] parseInfos = this.parseCache.clearAll();
            for (int i = 0; i < parseInfos.length; ++i) {
                ((Parseinfo)parseInfos[i]).dropParseIDs();
            }
        }
        int n = preset_isolationlevel = (isolation = this.connectProperties.getProperty("isolation")) == null ? 2 : Driver.isolevelString2Jdbc(isolation);
        if (preset_isolationlevel != this.getTransactionIsolation()) {
            this.setTransactionIsolation(preset_isolationlevel);
        }
        this.readOnly = false;
        boolean readonly = Driver.getBooleanProperty(this.connectProperties, "readonly", false);
        if (readonly) {
            this.setReadOnly(readonly);
        }
        if (!(autoCommitMode = Driver.getBooleanProperty(this.connectProperties, "autocommit", true)) || autoCommitMode && !this.m_transaction.m_autocommit) {
            this.setAutoCommit(autoCommitMode);
        }
        this.resultSetHoldability = 1;
        this.typeMap = null;
    }

    int getKernelVersion() {
        return this.kernelversion;
    }

    public Properties getConnectProperties() {
        return this.connectProperties;
    }

    public byte[] getCookie() {
        return this.m_cookie;
    }

    public boolean isReleaseSavePointSupported() {
        return this.releaseSavePointSupported;
    }

    public void setReleaseSavePointSupported(boolean value) {
        this.releaseSavePointSupported = false;
    }

    public String toString() {
        JdbcCommunication session = this.m_sessionPool.getPrimarySession();
        if (session != null) {
            return super.toString() + "[ID " + session.getConnectionID() + "]";
        }
        return super.toString();
    }

    public void setPicky(boolean picky) {
        this.picky = picky;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && ((ConnectionSapDB)obj).getSessionID() == this.getSessionID();
    }

    public Properties getClientInfo() throws SQLException {
        return ClientInfo.getClientInfo(this.mClientInfo);
    }

    public String getClientInfo(String name) throws SQLException {
        return ClientInfo.getClientInfo(this.mClientInfo, name);
    }

    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", new Integer(timeout));
        }
        if (this.isClosed) {
            return false;
        }
        try {
            JdbcCommunication session = this.m_sessionPool.getSessionForTransactionHandling();
            RequestPacket requestPacket = this.getRequestPacket(0, session);
            requestPacket.initDbsCommand(this.m_transaction.m_autocommit, "SELECT 'PING' FROM SYS.DUMMY", 1003, 2, this.m_statementcontext);
            this.execute(requestPacket, this, 1, session, false);
        }
        catch (InternalReconnectException e) {
            return this.isValid(timeout);
        }
        catch (SQLException exc) {
            try {
                this.releaseSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isClosed = true;
            this.DatabaseMetaData = null;
            return false;
        }
        return true;
    }

    public EngineFeatures getEngineFeatures() {
        return this.m_engineFeatures;
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.mClientInfo = ClientInfo.setClientInfo(this.mClientInfo, properties);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.mClientInfo = ClientInfo.setClientInfo(this.mClientInfo, name, value);
    }

    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createArrayOf", "ConnectionSapDB");
    }

    public Blob createBlob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createBlob", "ConnectionSapDB");
    }

    public Clob createClob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createClob", "ConnectionSapDB");
    }

    public NClob createNClob() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createNClob", "ConnectionSapDB");
    }

    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createSQLXML", "ConnectionSapDB");
    }

    public ReplyPacket sendStreamErrorPacket(SQLException sqlEx, JdbcCommunication session) {
        try {
            RequestPacket requestPacket = this.getRequestPacket(session);
            requestPacket.initDbs(this.m_transaction.m_autocommit, 1003, 2, this.m_statementcontext);
            String errorMsg = MessageTranslator.translate("error.message.notavailable");
            int errorCode = -9999;
            String sqlState = "S9999";
            if (sqlEx.getMessage() != null && sqlEx.getMessage().length() != 0) {
                errorMsg = sqlEx.getMessage();
            }
            if (sqlEx.getErrorCode() != 0) {
                errorCode = sqlEx.getErrorCode();
                sqlState = sqlEx.getSQLState();
            }
            requestPacket.addErrorPart(errorCode, 0, 1, sqlState, errorMsg);
            return this.execute(requestPacket, false, false, this, 3, session, true);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "createStruct", "ConnectionSapDB");
    }

    public long getSessionID() {
        JdbcCommunication session = this.m_sessionPool.getPrimarySession();
        return session.getSessionID();
    }

    public long getConnectionID() {
        JdbcCommunication session = this.m_sessionPool.getPrimarySession();
        return session.getConnectionID();
    }

    public SessionPool getSessionPool() {
        return this.m_sessionPool;
    }

    public int getTransactionState() {
        return this.m_transaction.getTransactionState();
    }

    public byte[] getStatementContext() {
        return this.m_statementcontext;
    }

    public int getDistributionMode() {
        return this.m_distributionMode;
    }

    public int getNumberOfServers() {
        return this.m_sessionPool.getSystem().getNumberOfLocations();
    }

    public void setCookie(byte[] cookie) {
        this.m_cookie = cookie;
    }

    public void setUserNameFromServer(String user) {
        this.connectProperties.setProperty("user", user);
    }

    public Subject getAuthenticatedSubject() {
        return this.authenticatedSubject;
    }

    public void setAuthenticatedSubject(Subject subject) {
        this.authenticatedSubject = subject;
    }

    public void handleTransaction(JdbcCommunication session, boolean isWriteOperation) throws SQLException {
        this.m_transaction.handleTransaction(this, session, isWriteOperation);
    }
}

