/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.CallableStatementSapDB;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.MemoryResultSetSapDB;
import com.sap.db.jdbc.NameHandling;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.util.VersionInfo;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DatabaseMetaDataNGDB_StoredQueries
extends WrapperDummy
implements DatabaseMetaData {
    public static final String defaultCatalogName = "";
    private String[] m_tableTypes = null;
    protected ConnectionSapDB conn_;
    private VersionInfo dbVersionInfo = null;
    private String username = null;
    private int MAX_TABLE_NAME_LENGTH = 127;
    private int MAX_COLUMN_NAME_LENGTH = 127;
    private int MAX_PROCEDURE_NAME_LENGTH = 127;
    private int MAX_USER_NAME_LENGTH = 256;
    private int MAX_SCHEMA_NAME_LENGTH = 128;

    public DatabaseMetaDataNGDB_StoredQueries(ConnectionSapDB conn) throws SQLException {
        this.conn_ = conn;
        this.getDBInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getDBInfo() throws SQLException {
        Statement s = null;
        s = this.conn_.createStatement();
        s.execute("SELECT VERSION, CURRENT_USER FROM SYS.M_DATABASE");
        ResultSet rs = s.getResultSet();
        if (rs != null) {
            if (rs.next()) {
                this.username = rs.getString(2);
                this.dbVersionInfo = new VersionInfo(rs.getString(1));
            }
            rs.close();
        }
        s.close();
        Object var4_4 = null;
        if (this.dbVersionInfo == null) {
            this.dbVersionInfo = new VersionInfo();
        }
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (SQLException ignore) {}
        return;
        {
            catch (SQLException e) {
                this.username = null;
                Object var4_5 = null;
                if (this.dbVersionInfo == null) {
                    this.dbVersionInfo = new VersionInfo();
                }
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (SQLException ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (this.dbVersionInfo == null) {
                this.dbVersionInfo = new VersionInfo();
            }
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void initTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        ResultSet rs = this.getTableTypes();
        while (rs.next()) {
            types.add(rs.getString(1));
        }
        rs.close();
        this.m_tableTypes = new String[types.size()];
        this.m_tableTypes = types.toArray(this.m_tableTypes);
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_TABLES", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schemaPattern));
            cstmt_.setString(3, this.replaceForSystemQuery(tableNamePattern));
            int paramCnt = cstmt_.getParameterMetaData().getParameterCount();
            if (types == null) {
                int i = 4;
                if (this.m_tableTypes == null) {
                    this.initTableTypes();
                }
                if (paramCnt >= this.m_tableTypes.length) {
                    for (int j = 0; j < this.m_tableTypes.length; ++j) {
                        cstmt_.setString(j + i, this.m_tableTypes[j]);
                    }
                    i += this.m_tableTypes.length;
                } else {
                    cstmt_.setString(4, "VIEW");
                    cstmt_.setString(5, "SYNONYM");
                    cstmt_.setString(6, "TABLE");
                    cstmt_.setString(7, "SYSTEM TABLE");
                    cstmt_.setString(8, "GLOBAL TEMPORARY");
                    cstmt_.setString(9, "SHARED TEMPORARY");
                    i = 10;
                    if (paramCnt >= 11) {
                        cstmt_.setString(10, "USER DEFINED");
                        cstmt_.setString(11, "COLUMN VIEW");
                        i = 12;
                    }
                    if (paramCnt >= 15) {
                        cstmt_.setString(12, "OLAP VIEW");
                        cstmt_.setString(13, "JOIN VIEW");
                        cstmt_.setString(14, "HIERARCHY VIEW");
                        cstmt_.setString(15, "CALC VIEW");
                        i = 16;
                    }
                }
                while (i <= paramCnt) {
                    cstmt_.setNull(i, 12);
                    ++i;
                }
            } else {
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] != null) {
                        types[i] = types[i].toUpperCase();
                    }
                    cstmt_.setString(i + 4, types[i]);
                }
                for (int j = i + 4; j <= paramCnt; ++j) {
                    cstmt_.setNull(j, 12);
                }
            }
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getTables(catalog, schemaPattern, tableNamePattern, types);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_PROCEDURES", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schemaPattern));
            cstmt_.setString(3, this.replaceForSystemQuery(procedureNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getProcedures(catalog, schemaPattern, procedureNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_FUNCTIONS", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schemaPattern));
            cstmt_.setString(3, this.replaceForSystemQuery(functionNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getFunctions(catalog, schemaPattern, functionNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_FUNCTION_COLUMNS", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schemaPattern);
            cstmt_.setString(3, this.replaceForSystemQuery(functionNamePattern));
            cstmt_.setString(4, this.replaceForSystemQuery(columnNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_PROCEDURE_COLUMNS", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schemaPattern);
            cstmt_.setString(3, this.replaceForSystemQuery(procedureNamePattern));
            cstmt_.setString(4, this.replaceForSystemQuery(columnNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_TABLE_TYPES", 1003, 1007, 1);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getTableTypes();
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_COLUMN_PRIVILEGES", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schema);
            cstmt_.setString(3, table);
            cstmt_.setString(4, this.replaceForSystemQuery(columnNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getColumnPrivileges(catalog, schema, table, columnNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_TABLE_PRIVILEGES", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schemaPattern));
            cstmt_.setString(3, this.replaceForSystemQuery(tableNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getTablePrivileges(catalog, schemaPattern, tableNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_BEST_ROW_IDENTIFIER", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schema);
            cstmt_.setString(3, table);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getBestRowIdentifier(catalog, schema, table, scope, nullable);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_PRIMARY_KEYS", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schema);
            cstmt_.setString(3, table);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getPrimaryKeys(catalog, schema, table);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_INDEX_INFO", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schema);
            cstmt_.setString(3, table);
            cstmt_.setBoolean(4, unique);
            cstmt_.setBoolean(5, approximate);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getIndexInfo(catalog, schema, table, unique, approximate);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_TYPE_INFO", 1003, 1007, 1);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getTypeInfo();
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_VERSION_COLUMNS", 1003, 1007, 1);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getVersionColumns(catalog, schema, table);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_UDTS", 1003, 1007, 1);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getUDTs(catalog, schemaPattern, typeNamePattern, types);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_COLUMNS", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schemaPattern));
            cstmt_.setString(3, this.replaceForSystemQuery(tableNamePattern));
            cstmt_.setString(4, this.replaceForSystemQuery(columnNamePattern));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        this.conn_.assertOpen();
        String[] colHeadings = new String[]{"TABLE_CAT"};
        Object[][] rows = new Object[][]{};
        MemoryResultSetSapDB result = new MemoryResultSetSapDB(colHeadings, rows);
        return result;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_IMPORTED_KEYS_NEW", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, schema);
            cstmt_.setString(3, table);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_IMPORTED_KEYS", 1003, 1007, 1);
                cstmt_.setString(1, catalog);
                cstmt_.setString(2, schema);
                cstmt_.setString(3, table);
                int paramCnt = cstmt_.getParameterMetaData().getParameterCount();
                for (int i = 3; i <= paramCnt; ++i) {
                    cstmt_.setNull(i, 1);
                }
                cstmt_.execute();
                return cstmt_.getResultSet();
            }
            catch (Exception e2) {
                try {
                    StringBuffer query = new StringBuffer("SELECT         NULL as PKTABLE_CAT,         NULL as PKTABLE_SCHEM,         NULL as PKTABLE_NAME,         NULL as PKCOLUMN_NAME,        NULL as FKTABLE_CAT,         NULL as FKTABLE_SCHEM,         NULL as FKTABLE_NAME,         NULL as FKCOLUMN_NAME,        NULL as KEY_SEQ,         NULL as UPDATE_RULE,         NULL as DELETE_RULE,         NULL as FK_NAME,         NULL as PK_NAME,         NULL as DEFERRABILITY  \tFROM SYS.USERS WHERE 1 <> 1");
                    PreparedStatement pstmt_ = this.newPreparedStatementInstance(this.conn_, query.toString(), 1003, 1007, 1);
                    pstmt_.execute();
                    return pstmt_.getResultSet();
                }
                catch (Exception e3) {
                    throw e;
                }
            }
        }
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_EXPORTED_KEYS_NEW", 1003, 1007, 1);
            cstmt_.setString(1, catalog);
            cstmt_.setString(2, this.replaceForSystemQuery(schema));
            cstmt_.setString(3, this.replaceForSystemQuery(table));
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_EXPORTED_KEYS", 1003, 1007, 1);
                cstmt_.setString(1, catalog);
                cstmt_.setString(2, this.replaceForSystemQuery(schema));
                cstmt_.setString(3, this.replaceForSystemQuery(table));
                int paramCnt = cstmt_.getParameterMetaData().getParameterCount();
                for (int i = 3; i <= paramCnt; ++i) {
                    cstmt_.setNull(i, 1);
                }
                cstmt_.execute();
                return cstmt_.getResultSet();
            }
            catch (Exception e2) {
                try {
                    StringBuffer query = new StringBuffer("SELECT         NULL as PKTABLE_CAT   ,        NULL as PKTABLE_SCHEM ,        NULL as PKTABLE_NAME  ,        NULL as PKCOLUMN_NAME ,        NULL as FKTABLE_CAT   ,        NULL as FKTABLE_SCHEM ,        NULL as FKTABLE_NAME  ,        NULL as FKCOLUMN_NAME ,        NULL as KEY_SEQ       ,        NULL as UPDATE_RULE   ,        NULL as DELETE_RULE   ,        NULL as FK_NAME ,        NULL as PK_NAME ,        NULL as DEFERRABILITY  \tFROM SYS.USERS WHERE 1 <> 1");
                    PreparedStatement pstmt_ = this.newPreparedStatementInstance(this.conn_, query.toString(), 1003, 1007, 1);
                    pstmt_.execute();
                    return pstmt_.getResultSet();
                }
                catch (Exception e3) {
                    throw e;
                }
            }
        }
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_CROSS_REFERENCE_NEW", 1003, 1007, 1);
            cstmt_.setString(1, primaryCatalog);
            cstmt_.setString(2, primarySchema);
            cstmt_.setString(3, primaryTable);
            cstmt_.setString(4, foreignCatalog);
            cstmt_.setString(5, foreignSchema);
            cstmt_.setString(6, foreignTable);
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_CROSS_REFERENCE", 1003, 1007, 1);
                cstmt_.setString(1, primaryCatalog);
                cstmt_.setString(2, primarySchema);
                cstmt_.setString(3, primaryTable);
                cstmt_.setString(4, foreignCatalog);
                cstmt_.setString(5, foreignSchema);
                cstmt_.setString(6, foreignTable);
                int paramCnt = cstmt_.getParameterMetaData().getParameterCount();
                for (int i = 6; i <= paramCnt; ++i) {
                    cstmt_.setNull(i, 1);
                }
                cstmt_.execute();
                return cstmt_.getResultSet();
            }
            catch (Exception e2) {
                try {
                    StringBuffer query = new StringBuffer("SELECT         NULL as PKTABLE_CAT    ,        NULL as PKTABLE_SCHEM  ,        NULL as PKTABLE_NAME   ,        NULL as PKCOLUMN_NAME  ,        NULL as FKTABLE_CAT    ,        NULL as FKTABLE_SCHEM  ,        NULL as FKTABLE_NAME   ,        NULL as FKCOLUMN_NAME  ,        NULL as KEY_SEQ        ,        NULL as UPDATE_RULE    ,        NULL as DELETE_RULE    ,        NULL as FK_NAME        ,        NULL as PK_NAME        ,        NULL as DEFERRABILITY   \tFROM SYS.USERS WHERE 1 <> 1");
                    PreparedStatement pstmt_ = this.newPreparedStatementInstance(this.conn_, query.toString(), 1003, 1007, 1);
                    pstmt_.execute();
                    return pstmt_.getResultSet();
                }
                catch (Exception e3) {
                    throw e;
                }
            }
        }
    }

    public ResultSet getSchemas() throws SQLException {
        this.conn_.assertOpen();
        try {
            CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_SCHEMAS", 1003, 1007, 1);
            cstmt_.setNull(1, 12);
            cstmt_.setString(2, "%");
            cstmt_.execute();
            return cstmt_.getResultSet();
        }
        catch (SQLException e) {
            try {
                return this.getSchemas();
            }
            catch (Exception e2) {
                throw e;
            }
        }
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.conn_.assertOpen();
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        CallableStatement cstmt_ = this.newCallableStatementInstance(this.conn_, " JDBC_GET_SCHEMAS", 1003, 1007, 1);
        cstmt_.setString(1, catalog);
        cstmt_.setString(2, schemaPattern);
        cstmt_.execute();
        return cstmt_.getResultSet();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.conn_.assertOpen();
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"}, new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.String", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.Integer", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Short"}, new Object[0][]);
    }

    public String getCatalogSeparator() throws SQLException {
        return new String(".");
    }

    public String getCatalogTerm() throws SQLException {
        return new String("CATALOG");
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        String[] colHeadings = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        return new MemoryResultSetSapDB(colHeadings, new Object[0][]);
    }

    public Connection getConnection() throws SQLException {
        return this.conn_;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.dbVersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.dbVersionInfo.getMinorVersion();
    }

    public String getDatabaseProductName() throws SQLException {
        return "HDB";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.dbVersionInfo.toShortString();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return Driver.singleton().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return Driver.singleton().getMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return Driver.singleton().getName();
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getStaticShortVersionNumber();
    }

    public String getExtraNameCharacters() throws SQLException {
        return new String(defaultCatalogName);
    }

    public String getIdentifierQuoteString() throws SQLException {
        return new String("\"");
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.MAX_COLUMN_NAME_LENGTH;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.MAX_PROCEDURE_NAME_LENGTH;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.MAX_SCHEMA_NAME_LENGTH;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.MAX_TABLE_NAME_LENGTH;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.MAX_USER_NAME_LENGTH;
    }

    public String getNumericFunctions() throws SQLException {
        return new String("ABS,ACOS,ASIN,ATAN,ATAN2,BINTOHEX,BITAND,CEIL,COS,COSH,COT,EXP,FLOOR,GREATEST,HEXTOBIN,LEAST,LN,LOG,MOD,POWER,ROUND,SIGN,SIN,SINH,SQRT,TAN,TANH,UMINUS");
    }

    public String getProcedureTerm() throws SQLException {
        return new String("PROCEDURE");
    }

    public int getResultSetHoldability() throws SQLException {
        return this.conn_.getHoldability();
    }

    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    public String getSQLKeywords() throws SQLException {
        return new String(defaultCatalogName);
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public String getSchemaTerm() throws SQLException {
        return new String("SCHEMA");
    }

    public String getSearchStringEscape() throws SQLException {
        return new String("\\");
    }

    public String getStringFunctions() throws SQLException {
        return new String("ASCII,CHAR,CONCAT,LCASE,LEFT,LENGTH,LOCATE,LOWER,LPAD,LTRIM,NCHAR,REPLACE,RIGHT,RPAD,RTRIM,SUBSTR_AFTER,SUBSTR_BEFORE,SUBSTRING,TRIM,UCASE,UNICODE,UPPER");
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.conn_.assertOpen();
        StringBuffer query = new StringBuffer("SELECT         NULL as TABLE_CAT          ,        NULL as TABLE_SCHEM        ,        NULL as TABLE_NAME         ,        NULL as SUPERTABLE_NAME     \tFROM SYS.USERS WHERE 1 <> 1");
        PreparedStatement pstmt_ = this.newPreparedStatementInstance(this.conn_, query.toString(), 1003, 1007, 1);
        pstmt_.execute();
        return pstmt_.getResultSet();
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.conn_.assertOpen();
        StringBuffer query = new StringBuffer("SELECT         NULL as TYPE_CAT          ,        NULL as TYPE_SCHEM        ,        NULL as TYPE_NAME         ,        NULL as SUPERTYPE_CAT     ,        NULL as SUPERTYPE_SCHEM   ,        NULL as SUPERTYPE_NAME     \tFROM SYS.USERS WHERE 1 <> 1");
        PreparedStatement pstmt_ = this.newPreparedStatementInstance(this.conn_, query.toString(), 1003, 1007, 1);
        pstmt_.execute();
        return pstmt_.getResultSet();
    }

    public String getSystemFunctions() throws SQLException {
        return new String("COALESCE,CURRENT_CONNECTION,CURRENT_SCHEMA,CURRENT_USER,GROUPING_ID,IFNULL,MAP,NULLIF,SESSION_CONTEXT,SESSION_USER,SYSUUID");
    }

    public String getTimeDateFunctions() throws SQLException {
        return new String("ADD_DAYS,ADD_MONTHS,ADD_SECONDS,ADD_YEARS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_UTCDATE,CURRENT_UTCTIME,CURRENT_UTCTIMESTAMP,DAYNAME,DAYOFMONTH,DAYOFYEAR,DAYS_BETWEEN,EXTRACT,HOUR,ISOWEEK,LAST_DAY,LOCALTOUTC,MINUTE,MONTH,MONTHNAME,NEXT_DAY,NOW,QUARTER,SECOND,SECONDS_BETWEEN,UTCTOLOCAL,WEEK,WEEKDAY,YEAR");
    }

    public String getURL() throws SQLException {
        return this.conn_.getConnectProperty("dburl");
    }

    public String getUserName() throws SQLException {
        if (this.username == null) {
            this.getDBInfo();
        }
        if (this.username != null) {
            return this.username;
        }
        return NameHandling.stripUsername(this.conn_.getConnectProperty("user"));
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return concurrency == 1007 && type == 1003;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return true;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    protected String replaceForSystemQuery(String src) {
        if (src == null) {
            return "%";
        }
        return src;
    }

    protected CallableStatement newCallableStatementInstance(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatementSapDB stmt = (CallableStatementSapDB)conn.prepareCall("{CALLQ " + sql + "}", resultSetType, resultSetConcurrency, resultSetHoldability);
        stmt.setMetaDataStatement(true);
        return stmt;
    }

    protected PreparedStatement newPreparedStatementInstance(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatementSapDB stmt = (CallableStatementSapDB)conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        stmt.setMetaDataStatement(true);
        return stmt;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }
}

