/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.util.StructuredMem;

public class MultiLineOptionsPart
extends OptionsPart {
    protected int m_currentLine;
    protected int m_optionsInLine;
    protected int m_currentOptionCount;

    public MultiLineOptionsPart(StructuredMem rawMem, int argCnt) {
        super(rawMem, argCnt);
        this.m_currentLine = 1;
        this.m_optionsInLine = this.originalMem.getInt2(this.m_currentOffset);
        this.m_currentOffset += 2;
        this.m_currentOptionCount = 1;
    }

    MultiLineOptionsPart(StructuredMem rawMem, RequestPacket requestPacket) {
        super(rawMem, requestPacket);
    }

    public boolean nextLine() {
        if (this.m_currentLine >= this.argCount) {
            return false;
        }
        while (this.nextOption()) {
        }
        ++this.m_currentLine;
        this.m_optionsInLine = this.originalMem.getInt2(this.m_currentOffset);
        this.m_currentOffset += 2;
        this.m_currentOptionCount = 1;
        return true;
    }

    public boolean nextOption() {
        if (this.m_currentOptionCount > this.m_optionsInLine) {
            return false;
        }
        switch (this.getOptionType()) {
            case 28: {
                this.m_currentOffset += 3;
                break;
            }
            case 3: {
                this.m_currentOffset += 6;
                break;
            }
            case 29: {
                int len = this.originalMem.getInt2(this.m_currentOffset + 2);
                this.m_currentOffset += 4;
                this.m_currentOffset += len;
                break;
            }
            case 7: {
                this.m_currentOffset += 10;
                break;
            }
            default: {
                return false;
            }
        }
        ++this.m_currentOptionCount;
        return this.m_currentOptionCount <= this.m_optionsInLine;
    }

    public boolean findOption(int option) {
        boolean rc;
        do {
            if (this.getOptionName() != option) continue;
            return true;
        } while (rc = this.nextOption());
        return rc;
    }
}

