/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.ColumnInfo;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.EngineFeatures;
import com.sap.db.jdbc.Parseinfo;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.jdbc.packet.DataPartNGDB;
import com.sap.db.jdbc.packet.MultiLineOptionsPart;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.PartEnumeration;
import com.sap.db.jdbc.packet.SQLPacket;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.StreamInfo;
import com.sap.db.jdbc.translators.TranslatorFactory;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class ReplyPacket
extends SQLPacket {
    private int cachedResultCount = Integer.MIN_VALUE;
    private int cachedPartCount = Integer.MIN_VALUE;
    private int[] partIndices;
    private int partIdx = -1;
    private int currentSegment;

    public ReplyPacket(StructuredMem rawPacket) {
        super(rawPacket);
        this.segmOffs = 32;
        this.currentSegment = 1;
        this.clearPartCache();
    }

    public SQLException createException() {
        int[] updCnt = this.getBatchUpdateCounts(false);
        if (-1 != this.findPart(6)) {
            return this.buildExceptionChain(this.getPartPointer(), updCnt);
        }
        return SQLExceptionSapDB.generateSQLException("error.internal.unknownError");
    }

    public SQLException buildExceptionChain(StructuredMem mem, int[] updCnt) {
        int errorLen;
        SQLException erg = null;
        int partOffset = 0;
        int numberOfErrors = mem.getInt2(2);
        int partLen = mem.getInt4(8);
        partOffset = 16;
        for (int i = 0; i < numberOfErrors && partOffset < partLen; partOffset += errorLen, ++i) {
            SQLException ex;
            int rc = mem.getInt4(partOffset + 0);
            String state = mem.getString(partOffset + 13, 5);
            int errorPos = mem.getInt4(partOffset + 4);
            int errmsgLen = mem.getInt4(partOffset + 8);
            String errmsg = mem.getString(partOffset + 18, errmsgLen);
            byte errorLevel = mem.getInt1(partOffset + 12);
            errorLen = 19 + errmsgLen;
            if (errorLevel == 0) {
                SQLWarning warn = new SQLWarning(errmsg, state, rc);
                return warn;
            }
            SQLException sQLException = ex = errorPos > 1 ? SQLExceptionSapDB.generateDatabaseException("error.databaseexception", state, rc, errorPos, 0, updCnt, Integer.toString(rc), (Object)Integer.toString(errorPos), (Object)errmsg) : SQLExceptionSapDB.generateDatabaseException("error.databaseexception.woerrpos", state, rc, errorPos, 0, updCnt, Integer.toString(rc), errmsg);
            if (erg == null) {
                erg = ex;
            } else {
                erg.setNextException(ex);
            }
            int modResult = errorLen % 8;
            if (modResult == 0) continue;
            errorLen += 8 - modResult;
        }
        return erg;
    }

    public int partCount() {
        if (this.cachedPartCount == Integer.MIN_VALUE) {
            this.cachedPartCount = super.partCount();
            return this.cachedPartCount;
        }
        return this.cachedPartCount;
    }

    int dumpSegment(PrintStream stream, int maxBuf, int segmPos) {
        stream.println("   <SEGMENT ");
        stream.println("    type=\"REPLY\"");
        stream.println("    index=\"" + this.getInt2(segmPos + 10) + "\"");
        stream.println("    offset=\"" + this.getInt4(segmPos + 4) + "\"");
        stream.println("    length=\"" + this.getInt4(segmPos + 0) + "\"");
        stream.println("    number_of_parts=\"" + this.getInt2(segmPos + 8) + "\"");
        int partCount = this.getInt2(segmPos + 8);
        int pos = segmPos + 24;
        for (int i = 0; i < partCount; ++i) {
            pos += this.dumpPart(stream, maxBuf, pos);
        }
        stream.println("   </SEGMENT> ");
        return this.getInt4(segmPos + 0);
    }

    public boolean existsPart(int requestedKind) {
        return this.findPart(requestedKind) != -1;
    }

    public int findPart(int requestedKind) {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int partsLeft = this.partCount(); partsLeft > 0; --partsLeft) {
            this.nextPart();
            if (this.partKind() != requestedKind) continue;
            return this.partPos();
        }
        return -1;
    }

    public int firstSegment() {
        int result = this.segmCount() > 0 ? 32 : -1;
        this.segmOffs = result;
        this.currentSegment = 1;
        this.clearPartCache();
        return result;
    }

    public int functionCode() {
        return this.mem.getInt2(this.segmOffs + 14);
    }

    public byte[] getDataBytes(int pos, int len) {
        byte[] result = this.mem.getBytes(pos + 1, len - 1);
        return result;
    }

    public int getPartDataPos() {
        return this.partOffs + 16;
    }

    int nextPart() {
        ++this.partIdx;
        this.partOffs = this.partIndices[this.partIdx];
        return this.partOffs;
    }

    public int nextSegment() {
        if (this.segmCount() <= this.currentSegment++) {
            return -1;
        }
        this.segmOffs += this.segmLength();
        this.clearPartCache();
        return this.segmOffs;
    }

    public ColumnInfo[] parseSchemaTableColumnNames(ColumnInfo[] result) {
        int j;
        String name;
        int nameLen;
        int i;
        int count = this.partArguments();
        if (result == null || result.length == 0) {
            result = new ColumnInfo[count];
            for (i = 0; i < result.length; ++i) {
                result[i] = new ColumnInfo();
            }
        }
        int pos = this.getPartDataPos();
        count = this.getInt2(pos);
        pos += 2;
        int[] tableMap = new int[count];
        int[] schemaMap = new int[count];
        for (i = 0; i < count; ++i) {
            nameLen = this.getInt2(pos);
            pos += 2;
            if (nameLen == 0) continue;
            tableMap[i] = nameLen;
            nameLen = this.getInt2(pos);
            result[i].columnName = this.getString(pos += 2, nameLen, 2);
            pos += nameLen;
        }
        count = this.getInt2(pos);
        pos += 2;
        for (i = 0; i < count; ++i) {
            int index = this.getInt2(pos);
            nameLen = this.getInt2(pos += 2);
            name = this.getString(pos += 2, nameLen);
            pos += nameLen;
            for (j = 0; j < tableMap.length; ++j) {
                if (tableMap[j] - 1 != i) continue;
                result[j].tableName = name;
                schemaMap[j] = index;
            }
        }
        count = this.getInt2(pos);
        pos += 2;
        for (i = 0; i < count; ++i) {
            nameLen = this.getInt2(pos);
            name = this.getString(pos += 2, nameLen);
            pos += nameLen;
            for (j = 0; j < schemaMap.length; ++j) {
                if (schemaMap[j] - 1 != i) continue;
                result[j].schemaName = name;
            }
        }
        return result;
    }

    public ColumnInfo[] parseColumnNames(ColumnInfo[] result) {
        int i;
        int columnCount = this.partArguments();
        if (result == null || result.length == 0) {
            result = new ColumnInfo[columnCount];
            for (i = 0; i < result.length; ++i) {
                result[i] = new ColumnInfo();
            }
        }
        int pos = this.getPartDataPos();
        for (i = 0; i < columnCount; ++i) {
            byte nameLen = this.getInt1(pos);
            result[i].columnDisplayName = this.getIdentifier(pos + 1, nameLen);
            if (result[i].columnName == null) {
                result[i].columnName = result[i].columnDisplayName;
            }
            pos += nameLen + 1;
        }
        return result;
    }

    public byte[][] parseLongDescriptors() {
        if (!this.existsPart(30)) {
            return new byte[0][];
        }
        int argCount = this.partArguments();
        byte[][] result = new byte[argCount][];
        for (int i = 0; i < argCount; ++i) {
            int pos = i * 8;
            result[i] = this.getBytes(this.getPartDataPos() + pos, 8);
        }
        return result;
    }

    public int[] parseTableLocations() {
        int argCount = this.partArguments();
        int[] result = new int[argCount];
        for (int i = 0; i < argCount; ++i) {
            int pos = i * 4;
            result[i] = this.getInt4(this.getPartDataPos() + pos);
        }
        return result;
    }

    public DBTechTranslator[] parseResultSetMetaData(ConnectionSapDB conn) throws SQLException {
        boolean autoIncre = false;
        boolean readOnly = false;
        int columnCount = this.partArguments();
        DBTechTranslator[] result = new DBTechTranslator[columnCount];
        int pos = this.getPartDataPos();
        int identPos = pos + columnCount * 24;
        for (int i = 0; i < columnCount; ++i) {
            int bufpos_out;
            byte mode = this.getInt1(pos + 0);
            int ioType = 4;
            byte dataType = this.getInt1(pos + 1);
            int frac = this.getInt2(pos + 2);
            int len = this.getInt2(pos + 4);
            int bufpos_in = bufpos_out = i + 1;
            readOnly = (mode & 0x10) != 0;
            autoIncre = (mode & 0x20) != 0;
            switch (conn.getEngineFeatures().dataFormatVersion2) {
                case 4: {
                    result[i] = TranslatorFactory.createDataFormat4(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, false);
                    break;
                }
                default: {
                    result[i] = conn.getEngineFeatures().isCompleteDataTypeSupported() ? TranslatorFactory.createCompleteDataTypes(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, false) : TranslatorFactory.create(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, false);
                }
            }
            int tableNameOffset = this.getInt4(pos + 8);
            String tableName = tableNameOffset == -1 ? "" : this.getString(identPos + tableNameOffset + 1, this.getUInt1(identPos + tableNameOffset));
            int schemaNameOffset = this.getInt4(pos + 12);
            String schemaName = schemaNameOffset == -1 ? "" : this.getString(identPos + schemaNameOffset + 1, this.getUInt1(identPos + schemaNameOffset));
            int columnNameOffset = this.getInt4(pos + 16);
            String columnName = columnNameOffset == -1 ? "" : this.getString(identPos + columnNameOffset + 1, this.getUInt1(identPos + columnNameOffset));
            int columnDisplayNameOffset = this.getInt4(pos + 20);
            String columnDisplayName = columnDisplayNameOffset == -1 ? "" : this.getString(identPos + columnDisplayNameOffset + 1, this.getUInt1(identPos + columnDisplayNameOffset));
            result[i].setColName(tableName, schemaName, columnName, columnDisplayName);
            pos += 24;
        }
        return result;
    }

    public DBTechTranslator[] parseResultSetMetaDataOld(ConnectionSapDB conn) throws SQLException {
        boolean autoIncre = false;
        boolean readOnly = false;
        int columnCount = this.partArguments();
        DBTechTranslator[] result = new DBTechTranslator[columnCount];
        int pos = this.getPartDataPos();
        int identPos = pos + columnCount * 24;
        for (int i = 0; i < columnCount; ++i) {
            int bufpos_out;
            byte mode = this.getInt1(pos + 0);
            int ioType = 4;
            byte dataType = this.getInt1(pos + 1);
            byte frac = this.getInt1(pos + 2);
            int len = this.getInt2(pos + 4);
            int bufpos_in = bufpos_out = i + 1;
            readOnly = (mode & 0x10) != 0;
            autoIncre = (mode & 0x20) != 0;
            result[i] = TranslatorFactory.create(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, false);
            int tableNameOffset = this.getInt4(pos + 8);
            String tableName = tableNameOffset == -1 ? "" : this.getString(identPos + tableNameOffset + 1, this.getUInt1(identPos + tableNameOffset));
            int schemaNameOffset = this.getInt4(pos + 12);
            String schemaName = schemaNameOffset == -1 ? "" : this.getString(identPos + schemaNameOffset + 1, this.getUInt1(identPos + schemaNameOffset));
            int columnNameOffset = this.getInt4(pos + 16);
            String columnName = columnNameOffset == -1 ? "" : this.getString(identPos + columnNameOffset + 1, this.getUInt1(identPos + columnNameOffset));
            int columnDisplayNameOffset = this.getInt4(pos + 20);
            String columnDisplayName = columnDisplayNameOffset == -1 ? "" : this.getString(identPos + columnDisplayNameOffset + 1, this.getUInt1(identPos + columnDisplayNameOffset));
            result[i].setColName(tableName, schemaName, columnName, columnDisplayName);
            pos += 24;
        }
        return result;
    }

    public void parseParameterMetaData(ConnectionSapDB conn, Parseinfo parseInfo, boolean directRecordPassing, boolean columnStoreAccess) throws SQLException {
        int bufpos_in = 0;
        int bufpos_out = 0;
        int inputParmCnt = 0;
        int outputParmCnt = 0;
        boolean autoIncre = false;
        boolean readOnly = false;
        int parameterCount = this.partArguments();
        DBTechTranslator[] result = new DBTechTranslator[parameterCount];
        int pos = this.getPartDataPos();
        int identPos = pos + parameterCount * 16;
        for (int i = 0; i < parameterCount; ++i) {
            byte mode = this.getInt1(pos + 0);
            byte dataType = this.getInt1(pos + 1);
            byte ioType = this.getInt1(pos + 2);
            int frac = this.getInt2(pos + 10);
            int fieldOffset = this.getInt2(pos + 12);
            int idxInGroup = this.getInt2(pos + 14);
            int len = this.getInt2(pos + 8);
            switch (ioType) {
                case 1: {
                    bufpos_in = bufpos_out = ++inputParmCnt;
                    break;
                }
                case 4: {
                    bufpos_in = bufpos_out = ++outputParmCnt;
                    break;
                }
                case 2: {
                    bufpos_in = ++inputParmCnt;
                    bufpos_out = ++outputParmCnt;
                }
            }
            readOnly = (mode & 0x10) != 0;
            autoIncre = (mode & 0x20) != 0;
            switch (conn.getEngineFeatures().dataFormatVersion2) {
                case 4: {
                    result[i] = TranslatorFactory.createDataFormat4(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, directRecordPassing);
                    break;
                }
                default: {
                    result[i] = conn.getEngineFeatures().isCompleteDataTypeSupported() ? TranslatorFactory.createCompleteDataTypes(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, directRecordPassing) : TranslatorFactory.create(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, directRecordPassing);
                }
            }
            int parameterNameOffset = this.getInt4(pos + 4);
            String parameterName = parameterNameOffset == -1 ? "" : this.getString(identPos + parameterNameOffset + 1, this.getUInt1(identPos + parameterNameOffset));
            result[i].setColName("", "", parameterName, parameterName);
            result[i].setFieldOffset(fieldOffset);
            result[i].setIdxInGroup(idxInGroup);
            pos += 16;
        }
        parseInfo.setParameterMetaData(result, outputParmCnt, directRecordPassing, columnStoreAccess);
    }

    public void parseParameterMetaDataOld(ConnectionSapDB conn, Parseinfo parseInfo) throws SQLException {
        int bufpos_in = 0;
        int bufpos_out = 0;
        int inputParmCnt = 0;
        int outputParmCnt = 0;
        boolean autoIncre = false;
        boolean readOnly = false;
        int parameterCount = this.partArguments();
        DBTechTranslator[] result = new DBTechTranslator[parameterCount];
        int pos = this.getPartDataPos();
        int identPos = pos + parameterCount * 16;
        for (int i = 0; i < parameterCount; ++i) {
            byte mode = this.getInt1(pos + 0);
            byte dataType = this.getInt1(pos + 1);
            byte ioType = this.getInt1(pos + 2);
            byte frac = this.getInt1(pos + 3);
            int len = this.getInt2(pos + 8);
            switch (ioType) {
                case 1: {
                    bufpos_out = inputParmCnt++;
                    bufpos_in = bufpos_out;
                    break;
                }
                case 4: {
                    bufpos_in = bufpos_out = ++outputParmCnt;
                    break;
                }
                case 2: {
                    bufpos_in = inputParmCnt++;
                    bufpos_out = ++outputParmCnt;
                }
            }
            readOnly = (mode & 0x10) != 0;
            autoIncre = (mode & 0x20) != 0;
            result[i] = TranslatorFactory.create(mode, ioType, dataType, frac, len, bufpos_in, bufpos_out, false, null, readOnly, autoIncre, false);
            int parameterNameOffset = this.getInt4(pos + 4);
            String parameterName = parameterNameOffset == -1 ? "" : this.getString(identPos + parameterNameOffset + 1, this.getUInt1(identPos + parameterNameOffset));
            result[i].setColName("", "", parameterName, parameterName);
            pos += 16;
        }
        parseInfo.setParameterMetaData(result, outputParmCnt, false, false);
    }

    public int partArguments() {
        return this.mem.getInt2(this.partOffs + 2);
    }

    public PartEnumeration partEnumeration() {
        this.partIdx = -1;
        this.partOffs = -1;
        return new PartEnumeration(this);
    }

    int partKind() {
        return this.mem.getInt1(this.partOffs + 0);
    }

    public int partLength() {
        return this.mem.getInt4(this.partOffs + 8);
    }

    int partPos() {
        return this.partOffs;
    }

    public int rowsAffected(boolean positionedAtPart) throws SQLException {
        if (this.cachedResultCount == Integer.MIN_VALUE) {
            if (!positionedAtPart && this.findPart(12) == -1) {
                this.cachedResultCount = -1;
                return -1;
            }
            this.cachedResultCount = this.getInt4(this.partOffs + 16);
            return this.cachedResultCount;
        }
        return this.cachedResultCount;
    }

    public int[] getBatchUpdateCounts(boolean positionedAtPart) {
        if (!positionedAtPart && this.findPart(12) == -1) {
            return new int[0];
        }
        int argCnt = this.getInt2(this.partOffs + 2);
        int[] erg = new int[argCnt];
        for (int i = 0; i < erg.length; ++i) {
            erg[i] = this.getInt4(this.partOffs + 16 + i * 4);
        }
        return erg;
    }

    public long getServerExecutionTime(boolean positionedAtPart) {
        if (!positionedAtPart && this.findPart(39) == -1) {
            return -1L;
        }
        OptionsPart sc = this.getStatementContext();
        do {
            switch (sc.getOptionName()) {
                case 2: {
                    return sc.getOptionLongValue();
                }
            }
        } while (sc.nextOption());
        return -1L;
    }

    public int getSessionID() {
        int result = this.findPart(20) != -1 ? this.mem.getInt4(this.getPartDataPos() - 1 + 2) : -1;
        return result;
    }

    public DataPartAuthentication getAuthenticationPart() throws SQLException {
        if (this.findPart(33) != -1) {
            int argCount = 1;
            if (this.partLength() > 0) {
                return new DataPartAuthentication((StructuredMem)new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), argCount);
            }
        }
        return null;
    }

    public int findDataPart() throws SQLException {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int partsLeft = this.partCount(); partsLeft > 0; --partsLeft) {
            this.nextPart();
            int partKind = this.partKind();
            if (partKind != 5) continue;
            return partKind;
        }
        return -1;
    }

    public DataPartNGDB findResultSetPart() throws SQLException {
        int partKind = this.findDataPart();
        if (partKind == -1) {
            return null;
        }
        return this.getResultSetPart();
    }

    public DataPartNGDB getResultSetPart() throws SQLException {
        if (this.partKind() == 5) {
            boolean isLast = this.wasLastPart();
            boolean isClosed = this.isCursorClosed();
            return new DataPartNGDB(new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments(), isLast, isClosed);
        }
        return null;
    }

    public DataPart getOutputDataPart(DataFormatDescription dfd) throws SQLException {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int partsLeft = this.partCount(); partsLeft > 0; --partsLeft) {
            this.nextPart();
            int partKind = this.partKind();
            if (partKind != 41) continue;
            return new DataPartNGDB(new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments(), dfd, true, true);
        }
        return null;
    }

    public int getKernelMajorVersion() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2200, 1)) : -1;
        return result;
    }

    public EngineFeatures findEngineFeatures() {
        EngineFeatures result = null;
        if (this.findPart(42) != -1) {
            OptionsPart opt = new OptionsPart((StructuredMem)new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
            result = new EngineFeatures(opt);
        }
        return result;
    }

    public EngineFeatures getEngineFeatures() {
        EngineFeatures result = null;
        OptionsPart opt = new OptionsPart((StructuredMem)new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
        result = new EngineFeatures(opt);
        return result;
    }

    public OptionsPart getTransactionFlags() {
        OptionsPart opt = new OptionsPart((StructuredMem)new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
        return opt;
    }

    public OptionsPart getStatementContext() {
        OptionsPart opt = new OptionsPart((StructuredMem)new FullswapMem(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
        return opt;
    }

    public StructuredMem getPartPointer() {
        StructuredMem result = this.mem.getPointer(this.partOffs);
        return result;
    }

    public MultiLineOptionsPart getTopology() {
        byte[] rawData;
        MultiLineOptionsPart result = null;
        if (this.findPart(15) != -1 && (rawData = this.mem.getBytes(this.getPartDataPos(), this.partLength())) != null && rawData.length > 0) {
            result = new MultiLineOptionsPart((StructuredMem)new FullswapMem(rawData), this.partArguments());
        }
        return result;
    }

    public byte[] getStatementID() {
        byte[] erg = null;
        if (this.partKind() == 10) {
            int parseidPos = this.getPartDataPos();
            erg = this.getBytes(parseidPos, 8);
        }
        return erg;
    }

    public byte[] getTransactionID() {
        byte[] erg = null;
        if (this.findPart(11) != -1) {
            int parseidPos = this.getPartDataPos();
            int len = this.partLength();
            erg = this.getBytes(parseidPos, len);
        }
        return erg;
    }

    public int getKernelMinorVersion() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2201, 2)) : -1;
        return result;
    }

    public boolean supportsKernelUnicode() {
        boolean result = this.findPart(20) != -1 ? this.mem.getInt1(this.getPartDataPos() - 1 + 1) == 1 : false;
        return result;
    }

    public short getDateTimeFormat() {
        short result = this.findPart(20) != -1 ? (short)this.mem.getInt1(this.getPartDataPos() - 1 + 170) : (short)-1;
        return result;
    }

    public int getKernelCorrectionLevel() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2203, 2)) : -1;
        return result;
    }

    public final int returnCode() {
        int result = 0;
        if (-1 != this.findPart(6)) {
            result = this.mem.getInt4(this.getPartDataPos() + 0);
        }
        return result;
    }

    private int segmLength() {
        return this.mem.getInt4(this.segmOffs + 0);
    }

    public boolean wasLastPart() {
        byte partAttributes = this.getInt1(this.partOffs + 1);
        boolean result = (partAttributes & 1) != 0;
        return result;
    }

    public boolean isCursorClosed() {
        byte partAttributes = this.getInt1(this.partOffs + 1);
        boolean result = (partAttributes & 0x10) != 0;
        return result;
    }

    private final void clearPartCache() {
        this.cachedResultCount = Integer.MIN_VALUE;
        this.cachedPartCount = Integer.MIN_VALUE;
        int pc = this.mem.getInt2(this.segmOffs + 8);
        this.partIndices = new int[pc];
        int partofs = 0;
        for (int i = 0; i < pc; ++i) {
            if (i == 0) {
                partofs = this.partIndices[i] = this.segmOffs + 24;
                continue;
            }
            int partlen = this.mem.getInt4(partofs + 8);
            partofs = this.partIndices[i] = partofs + ReplyPacket.aligned(partlen + 16);
        }
    }

    public StreamInfo[] parseStreamInfos() throws SQLException {
        Vector<StreamInfo> v = new Vector<StreamInfo>();
        PartEnumeration e = this.partEnumeration();
        while (e.hasMoreElements()) {
            e.nextElement();
            if (e.partKind() != 25) continue;
            int tabid = this.getInt4(this.getPartDataPos());
            short rowcount = (short)this.partArguments();
            v.addElement(new StreamInfo(true, tabid, rowcount));
        }
        return v.toArray(new StreamInfo[v.size()]);
    }

    public int parseABAPTabIDForInput() throws SQLException {
        if (this.findPart(25) == -1) {
            throw new SQLException("Internal error: expected ABAP input stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }

    public int parseABAPTabIDForOutput() throws SQLException {
        if (this.findPart(26) == -1) {
            throw new SQLException("Internal error: expected ABAP output stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }

    protected String getIdentifier(int pos, int nameLen) {
        return this.getString(pos, nameLen);
    }

    public String getTablename() {
        return this.getIdentifier(this.getPartDataPos(), this.partLength());
    }

    public byte getPartAttributes() {
        return this.getInt1(this.partOffs + 1);
    }

    public Cursor getCursor() {
        Cursor erg = new Cursor(this.getBytes(this.getPartDataPos(), this.partLength()));
        return erg;
    }

    public String toString() {
        StringBuffer erg = new StringBuffer(super.toString());
        byte[] packet = this.mem.getBytes(0, this.size());
        erg.append("Receive Packet: [\n");
        erg.append(Tracer.Hex2String(packet));
        erg.append("\n]\n");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.traceOn(ps);
        try {
            erg.append(os.toString("ISO-8859-1"));
        }
        catch (Exception e) {
            erg.append(e.toString());
        }
        return erg.toString();
    }

    public byte[] getRawPart() {
        return this.mem.getBytes(this.getPartDataPos(), this.partLength());
    }
}

