/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.jdbc.Cursor;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Parseinfo;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.jdbc.packet.DataPartFixed;
import com.sap.db.jdbc.packet.DataPartNGDB;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.jdbc.packet.SQLPacket;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.StringUtil;
import com.sap.db.util.StructuredMem;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class RequestPacket
extends SQLPacket {
    private int packetLength;
    private int packetSegments;
    private int segmLength;
    private int maxNumberOfSegm = 6;
    private int segmParts;
    protected int partLength;
    private int partArguments;
    private int replyReserve;
    public boolean inUse = false;
    public static final boolean reset_C = true;
    public static final boolean append_C = false;
    public static final int resultCountSize_C = 6;
    public static final int defaultmaxNumberOfSegm_C = 6;
    public static final int reserveFor2ndSegment_C = 8192;
    public static final int reserveForReply_C = 208;
    private byte[] additionalPartData = null;
    private int additionalPartKind = 0;
    private int additionalPartArgCnt = 0;

    public RequestPacket(StructuredMem rawPacket) {
        super(rawPacket);
        if (rawPacket != null) {
            this.initPacket();
        }
    }

    public void addAdditionalPart(int partKind, byte[] part, int argCnt) throws SQLException {
        if (this.additionalPartData != null) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.InternalError", "More than one additional Part isn't allowed.");
        }
        this.additionalPartData = part;
        this.additionalPartArgCnt = argCnt;
        this.additionalPartKind = partKind;
    }

    public void addBytes(byte[] bytes) {
        this.mem.putBytes(bytes, this.dataPos());
        this.partLength += bytes.length;
    }

    public void addCursorPart(Cursor cursorName) {
        if (cursorName != null) {
            this.newPart(13);
            this.addBytes(cursorName.getCursorID());
            ++this.partArguments;
            this.closePart();
        }
    }

    public void addErrorPart(int errorCode, int errorPosition, int errorLevel, String sqlState, String errortext) throws SQLException {
        if (errortext != null && errortext.length() != 0) {
            this.mem.putInt1(6, this.segmOffs + 12);
            this.newPart(6);
            int dataPos = this.dataPos();
            this.mem.putInt4(errorCode, dataPos);
            this.mem.putInt4(errorPosition, dataPos + 4);
            this.mem.putInt4(errortext.length(), dataPos + 8);
            this.mem.putInt1(errorLevel, dataPos + 12);
            this.mem.putString(sqlState, dataPos + 13);
            this.mem.putString(errortext, dataPos + 18);
            this.partLength += 18 + errortext.length();
            ++this.partArguments;
            this.closePart();
        }
    }

    public void addStatementIDPart(byte[] parseID) throws SQLException {
        if (parseID == null) {
            throw SQLExceptionSapDB.generateSQLException("error.internal.invalidParseid");
        }
        this.newPart(10);
        this.addBytes(parseID);
        this.partArguments = 1;
        this.closePart();
    }

    public void addDataBytes(byte[] bytes) {
        this.mem.putInt1(0, this.dataPos());
        this.mem.putBytes(bytes, this.dataPos() + 1);
        this.partLength += bytes.length + 1;
    }

    public void addDataString(String data) throws SQLException {
        this.mem.putInt1(32, this.dataPos());
        this.partLength += this.mem.putString(data, this.dataPos() + 1) + 1;
    }

    public void addVariableDataString(String dataStr) throws SQLException {
        int pos = this.dataPos();
        if (dataStr == null) {
            this.mem.putInt1(255, pos);
            ++this.partLength;
            return;
        }
        byte[] data = StringUtil.bytes_cesu8(dataStr);
        int byteLen = data.length;
        if (byteLen <= 245) {
            this.mem.putInt1(byteLen, pos);
            this.mem.putBytes(data, pos + 1);
            this.partLength += byteLen + 1;
        } else if (byteLen <= Short.MAX_VALUE) {
            this.mem.putInt1(246, pos);
            this.mem.putInt2(byteLen, pos + 1);
            this.mem.putBytes(data, pos + 3);
            this.partLength += byteLen + 3;
        } else {
            this.mem.putInt1(247, pos);
            this.mem.putInt4(byteLen, pos + 1);
            this.mem.putBytes(data, pos + 5);
            this.partLength += byteLen + 5;
        }
    }

    public void addRowsAffectedPart(int count) {
        this.newPart(12);
        this.mem.putInt4(count, this.dataPos());
        this.partLength += 4;
        ++this.partArguments;
    }

    public void addFetchSizePart(int count) {
        this.newPart(45);
        this.mem.putInt4(count, this.dataPos());
        this.partLength += 4;
        ++this.partArguments;
    }

    public void addUndefRowsAffected() {
        this.newPart(12);
        this.mem.putInt4(-1, this.dataPos());
        this.partLength += 4;
        ++this.partArguments;
    }

    public byte[] createSessionContextPart(JdbcCommunication primarySession, JdbcCommunication masterSession) throws SQLException {
        int masterPortNumber;
        String masterHostName;
        int masterConnectionID;
        int primaryPortNumber;
        String primaryHostName;
        int primaryConnectionID;
        Location loc;
        if (primarySession != null) {
            loc = primarySession.getLocation();
            primaryConnectionID = primarySession.getConnectionID();
            primaryHostName = loc.getPrimaryHostName();
            primaryPortNumber = loc.getPortNumber();
        } else {
            primaryHostName = "unknown";
            primaryConnectionID = 0;
            primaryPortNumber = 0;
        }
        if (masterSession != null) {
            loc = masterSession.getLocation();
            masterConnectionID = masterSession.getConnectionID();
            masterHostName = loc.getPrimaryHostName();
            masterPortNumber = loc.getPortNumber();
        } else {
            masterHostName = "unknown";
            masterConnectionID = 0;
            masterPortNumber = 0;
        }
        OptionsPart opt = new OptionsPart((StructuredMem)new FullswapMem(new byte[16 + primaryHostName.length() + 6 + 4 + 6 + masterHostName.length()]), 0);
        opt.addIntOption(1, primaryConnectionID);
        opt.addStringOption(2, primaryHostName);
        opt.addIntOption(3, primaryPortNumber);
        opt.addIntOption(4, masterConnectionID);
        opt.addStringOption(5, masterHostName);
        opt.addIntOption(6, masterPortNumber);
        return opt.getBytes(0, opt.extent);
    }

    public void addString(String data) throws SQLException {
        this.partLength += this.mem.putString(data, this.dataPos());
    }

    public void closePacket() {
        this.closeSegment();
        this.mem.putInt4(this.packetLength - 32, 12);
        this.mem.putInt2(this.packetSegments, 20);
    }

    private void closePart() {
        this.closePart(this.partLength, this.partArguments);
    }

    void closePart(int extent, int arguments) {
        if (this.partOffs == -1) {
            return;
        }
        this.mem.putInt4(extent, this.partOffs + 8);
        this.mem.putInt2(arguments, this.partOffs + 2);
        this.segmLength += RequestPacket.aligned(extent + 16);
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
    }

    private void closeSegment() {
        if (this.segmOffs == -1) {
            return;
        }
        this.closePart();
        this.mem.putInt4(this.segmLength, this.segmOffs + 0);
        this.mem.putInt2(this.segmParts, this.segmOffs + 8);
        this.packetLength += this.segmLength;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
    }

    protected int dataPos() {
        return this.partOffs + 16 + this.partLength;
    }

    public int getDataPartOffset() {
        return this.partOffs + 16;
    }

    public boolean dropPid(byte[] pid, boolean reset) {
        if (reset) {
            this.resetPacket();
        } else {
            int remainingSpace;
            if (this.segmOffs != -1) {
                this.closeSegment();
            }
            if ((remainingSpace = this.size() - this.packetLength - 24 - 16 - this.replyReserve - 208 - 12 - 24 - 16 - 12) <= 0 || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.newSegment(70, false, false, 1004, 2, null);
        this.newPart(10);
        this.partArguments = 1;
        this.addBytes(pid);
        return true;
    }

    public boolean dropPidAddtoParsidPart(byte[] pid) {
        int remainingSpace = this.size() - this.packetLength - 24 - 16 - this.replyReserve - 208 - this.partLength - 12;
        if (remainingSpace <= 0) {
            return false;
        }
        this.addBytes(pid);
        ++this.partArguments;
        return true;
    }

    public boolean initdropCursorPart(Cursor cursor, boolean reset) {
        if (reset) {
            this.resetPacket();
        } else {
            int remainingSpace;
            if (this.segmOffs != -1) {
                this.closeSegment();
            }
            if ((remainingSpace = this.size() - this.packetLength - 24 - 16 - this.replyReserve - 208 - 12 - 24 - 16 - 12) <= 0 || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.newSegment(69, false, false, 1004, 2, null);
        this.newPart(13);
        this.partArguments = 1;
        this.addBytes(cursor.getCursorID());
        return true;
    }

    public boolean addCursorToDropCursorPart(Cursor cursor) {
        int remainingSpace = this.size() - this.packetLength - 24 - 16 - this.replyReserve - 208 - this.partLength - 12;
        if (remainingSpace <= 0) {
            return false;
        }
        this.addBytes(cursor.getCursorID());
        ++this.partArguments;
        return true;
    }

    int dumpSegment(PrintStream stream, int maxBuf, int segmPos) {
        stream.println("   <SEGMENT ");
        stream.println("    type=\"REQUEST\"");
        stream.println("    index=\"" + this.getInt2(segmPos + 10) + "\"");
        stream.println("    offset=\"" + this.getInt4(segmPos + 4) + "\"");
        stream.println("    length=\"" + this.getInt4(segmPos + 0) + "\"");
        stream.println("    number_of_parts=\"" + this.getInt2(segmPos + 8) + "\"");
        StringUtil.fprintfs(stream, "    <! Detailed info skipped >\n", new Object[0]);
        int partCount = this.getInt2(segmPos + 8);
        int pos = segmPos + 24;
        for (int i = 0; i < partCount; ++i) {
            pos += this.dumpPart(stream, maxBuf, pos);
        }
        stream.println("   </SEGMENT> ");
        return this.getInt4(segmPos + 0);
    }

    public void incrPartArguments() {
        ++this.partArguments;
    }

    public void incrPartArguments(int count) {
        this.partArguments += count;
    }

    public void initHello(byte[] statementcontext) {
        this.resetPacket();
        this.newSegment(25, false, false, 1004, 2, statementcontext);
    }

    public void initDisconnect() {
        this.resetPacket();
        this.newSegment(77, false, false, 1004, 2, null);
    }

    public void initCommit(boolean holdCursorOverCommit, byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(67, false, false, 1004, 2, statementcontext);
        if (holdCursorOverCommit) {
            OptionsPart opt = this.addOptionsPart(43);
            opt.addBoolOption(1, holdCursorOverCommit);
            opt.close();
        }
    }

    public void initRollback(byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(68, false, false, 1004, 2, statementcontext);
    }

    public void initStartDistributedTransaction(byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(5, false, false, 1004, 2, statementcontext);
    }

    public void initJoinDistributedTransaction(byte[] transID, byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(6, false, false, 1004, 2, statementcontext);
        this.newPart(11);
        this.partArguments = 1;
        this.addBytes(transID);
    }

    public void initDbs(boolean autocommit, int scrollableCursor, int holdCursorOverCommit, byte[] statementcontext) {
        this.initDbs(true, autocommit, scrollableCursor, holdCursorOverCommit, statementcontext);
    }

    public void initDbs(boolean reset, boolean autocommit, int scrollableCursor, int resultSetHoldability, byte[] statementcontext) {
        if (reset) {
            this.resetPacket();
        }
        this.newSegment(2, autocommit, false, scrollableCursor, resultSetHoldability, statementcontext);
        this.newPart(3);
        this.partArguments = 1;
    }

    public void initDbsCommand(boolean autocommit, String cmd, int scrollableCursor, int holdCursorOverCommit, byte[] statementcontext) throws SQLException {
        this.initDbsCommand(cmd, true, autocommit, scrollableCursor, holdCursorOverCommit, statementcontext);
    }

    public void initDbsCommandThrowSQLExc(boolean autocommit, String cmd, int scrollableCursor, int holdCursorOverCommit, byte[] statementcontext) throws SQLException {
        this.initDbsCommand(cmd, true, autocommit, scrollableCursor, holdCursorOverCommit, statementcontext);
    }

    public boolean initDbsCommand(String cmd, boolean reset, boolean autocommit, int scrollableCursor, int resultSetHoldability, byte[] statementcontext) throws SQLException {
        if (!reset) {
            this.closeSegment();
            int remainingSpace = this.size() - this.packetLength - 24 - 16 - this.replyReserve - 208;
            if (remainingSpace < cmd.length() || this.packetSegments >= this.maxNumberOfSegm) {
                return false;
            }
        }
        this.initDbs(reset, autocommit, scrollableCursor, resultSetHoldability, statementcontext);
        this.addString(cmd);
        this.partArguments = 1;
        return true;
    }

    public void initExecute(Parseinfo.ParseID parseID, boolean autocommit, int scrollableCursor, int resultsetHoldability, byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(13, autocommit, false, scrollableCursor, resultsetHoldability, statementcontext);
        this.addStatementIDPart(parseID.parseID);
    }

    public DataPart initReadLOB(boolean autocommit, byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(16, autocommit, false, 1004, 2, statementcontext);
        this.newPart(17);
        int partDataOffs = this.partOffs + 16;
        DataPartFixed result = new DataPartFixed(this.getPointer(partDataOffs), this);
        return result;
    }

    private void initPacket() {
        StructuredMem packet = this.mem;
        packet.putInt4(packet.size() - 32, 16);
        this.packetLength = 32;
    }

    public void initParse(boolean reset, boolean parseagain, int resultSetType, int resultSetHoldability, byte[] statementcontext) {
        if (reset) {
            this.resetPacket();
        }
        this.newSegment(3, false, parseagain, resultSetType, resultSetHoldability, statementcontext);
        this.newPart(3);
    }

    public DataPartAuthentication initAuthenticationMethodRequest() throws SQLException {
        this.resetPacket();
        this.newSegment(65, false, false, 1004, 2, null);
        this.addClientContextPart();
        DataPartAuthentication data = this.newAuthenticationPartInternal();
        return data;
    }

    public void initConnectRequest() throws SQLException {
        this.resetPacket();
        this.newSegment(66, false, false, 1004, 2, null);
    }

    public void addClientProofPart(String method, byte[] clientProof) throws SQLException {
        DataPartAuthentication data = this.newAuthenticationPartInternal();
        data.addRow(2);
        data.putBytes(method.getBytes(), data.extent);
        data.addArg(data.extent, 0);
        data.putBytes(clientProof, data.extent);
        data.addArg(data.extent, 0);
        data.close();
    }

    public void addClientIDPart(String clientID) throws SQLException {
        this.newPart(35);
        this.addDataString(clientID);
        this.partArguments = 1;
    }

    public void addStatementContext(byte[] statementContext) {
        try {
            if (statementContext != null) {
                OptionsPart opt = this.addOptionsPart(39);
                opt.addBinaryOption(1, statementContext);
                opt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void addSessionContextPart(int connID, String hostname, int port) throws SQLException {
        OptionsPart opt = this.addOptionsPart(34);
        opt.addIntOption(1, connID);
        opt.addStringOption(2, hostname);
        opt.addIntOption(3, port);
        opt.close();
    }

    public void addClientContextPart() throws SQLException {
        OptionsPart opt = this.addOptionsPart(29);
        opt.addStringOption(1, Driver.getStaticShortVersionNumber());
        opt.addStringOption(2, "JDBC");
        opt.addStringOption(3, "UNKNOWN");
        opt.close();
    }

    public void addConnectOptionsPart(Properties props, int distributionMode) throws SQLException {
        OptionsPart opt = this.addOptionsPart(42);
        opt.addBoolOption(2, true);
        this.addDataFormatToOptions(props, opt);
        String strVal = props.getProperty("locale");
        if (strVal != null) {
            opt.addStringOption(3, strVal);
        }
        if (distributionMode > 0) {
            opt.addBoolOption(5, true);
        }
        opt.addIntOption(15, distributionMode);
        opt.addBoolOption(14, true);
        opt.addIntOption(17, 1);
        opt.addBoolOption(20, true);
        opt.close();
    }

    private void addDataFormatToOptions(Properties props, OptionsPart opt) {
        boolean compatibilityFormatVersion = true;
        String requestedDataFormat = props.getProperty("dataformatsupport", String.valueOf(4));
        if (String.valueOf(4).equals(requestedDataFormat)) {
            this.addCompatibilityFormatVersionForNewerServer(opt, 4);
        } else {
            this.addCompatibilityFormatVersionForNewerServer(opt, 1);
        }
        this.addCompatibilityFormatVersionForOlderServer(opt, 1);
    }

    private void addCompatibilityFormatVersionForOlderServer(OptionsPart opt, int formatVersion) {
        opt.addIntOption(12, formatVersion);
    }

    private void addCompatibilityFormatVersionForNewerServer(OptionsPart opt, int formatVersion) {
        opt.addIntOption(23, formatVersion);
    }

    public void addCommandInfoPart(String sourceModul, int lineNo) throws SQLException {
        OptionsPart opt = this.addOptionsPart(27);
        opt.addIntOption(1, lineNo);
        opt.addStringOption(2, sourceModul);
        opt.close();
    }

    public void addClientInfoPart(Hashtable clientInfo, HashSet unset, boolean serverCanHandleNullValues) throws SQLException {
        String key;
        boolean clientInfoContainsValues = clientInfo != null && clientInfo.size() != 0;
        boolean clientInfoValuesToBoUnset = unset != null && unset.size() != 0;
        boolean clientInfoPartAdded = false;
        if (clientInfoContainsValues || clientInfoValuesToBoUnset) {
            this.newPart(57);
            clientInfoPartAdded = true;
        }
        if (clientInfo != null) {
            Enumeration e = clientInfo.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                String val = (String)clientInfo.get(key);
                this.addVariableDataString(key);
                this.addVariableDataString(val);
                ++this.partArguments;
            }
        }
        if (unset != null) {
            Iterator i = unset.iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                this.addVariableDataString(key);
                if (serverCanHandleNullValues) {
                    this.addVariableDataString(null);
                } else {
                    this.addVariableDataString("");
                }
                ++this.partArguments;
            }
            unset.clear();
        }
        if (clientInfoPartAdded) {
            this.closePart();
        }
    }

    public int initParseCommand(String cmd, boolean reset, boolean parseagain, int resultSetType, int resultsetHoldability, byte[] statementcontext) throws SQLException {
        this.initParse(reset, parseagain, resultSetType, resultsetHoldability, statementcontext);
        this.addString(cmd);
        this.partArguments = 1;
        return this.partLength;
    }

    private void initPart(int partKind) {
        StructuredMem packet = this.mem;
        ++this.segmParts;
        this.partOffs = this.segmOffs + this.segmLength;
        this.partLength = 0;
        this.partArguments = 0;
        int pos = this.partOffs;
        packet.putInt1(partKind, pos + 0);
        packet.putInt1(0, pos + 1);
        packet.putInt2(1, pos + 2);
        packet.putInt4(this.segmOffs - 32, pos + 4);
        packet.putInt4(16, pos + 8);
        packet.putInt4(packet.size() - pos, pos + 12);
    }

    public DataPart initPutval(boolean autocommit, byte[] statementcontext) throws SQLException {
        this.resetPacket();
        this.newSegment(17, autocommit, false, 1004, 2, statementcontext);
        return this.newDataPart(28);
    }

    protected int createSegment(int segmKind) {
        int pos;
        StructuredMem packet = this.mem;
        this.segmOffs = pos = this.packetLength;
        this.segmLength = 24;
        this.segmParts = 0;
        ++this.packetSegments;
        packet.putInt4(0, pos + 0);
        packet.putInt4(pos - 32, pos + 4);
        packet.putInt2(0, pos + 8);
        packet.putInt2(this.packetSegments, pos + 10);
        packet.putInt1(segmKind, pos + 12);
        return pos;
    }

    public void dropSegment() {
        --this.packetSegments;
    }

    private void initSegment(int messKind, boolean autocommit, boolean parseagain, int resultSetType, int holdCursorOverCommit, byte[] statementcontext) {
        StructuredMem packet = this.mem;
        int pos = this.createSegment(1);
        packet.putInt1(messKind, pos + 13);
        packet.putInt1(autocommit ? 1 : 0, pos + 14);
        int commopt = 0;
        packet.putInt1(commopt += holdCursorOverCommit == 1 ? 8 : 0, pos + 15);
        this.addStatementContext(statementcontext);
        if (this.additionalPartData != null) {
            this.newPart(this.additionalPartKind);
            this.partArguments = this.additionalPartArgCnt;
            this.addBytes(this.additionalPartData);
            this.additionalPartKind = 0;
            this.additionalPartArgCnt = 0;
            this.additionalPartData = null;
        }
    }

    public int length() {
        return this.packetLength;
    }

    private DataPartAuthentication newAuthenticationPartInternal() throws SQLException {
        this.newPart(33);
        int partDataOffs = this.partOffs + 16;
        DataPartAuthentication result = new DataPartAuthentication(this.getPointer(partDataOffs), this);
        return result;
    }

    public DataPart newAuthenticationPart() throws SQLException {
        return this.newAuthenticationPartInternal();
    }

    public DataPart newParameterDataPart() throws SQLException {
        return this.newDataPart(32);
    }

    public DataPart newDataPart(int partKind) throws SQLException {
        this.newPart(partKind);
        int partDataOffs = this.partOffs + 16;
        DataPartNGDB result = new DataPartNGDB(this.getPointer(partDataOffs), this);
        return result;
    }

    public void newPart(int partKind) {
        this.closePart();
        this.initPart(partKind);
    }

    private void newSegment(int messKind, boolean autocommit, boolean parseagain, int resultSetType, int holdCursorOverCommit, byte[] statementcontext) {
        this.closeSegment();
        this.initSegment(messKind, autocommit, parseagain, resultSetType, holdCursorOverCommit, statementcontext);
        this.replyReserve = this.packetSegments == 2 ? (this.replyReserve += 8192) : (this.replyReserve += 208);
    }

    public void initializePacket(short maxSegment) {
        this.resetPacket();
        this.maxNumberOfSegm = maxSegment;
    }

    private void resetPacket() {
        this.packetLength = 32;
        this.packetSegments = 0;
        this.segmOffs = -1;
        this.segmLength = -1;
        this.segmParts = -1;
        this.maxNumberOfSegm = 6;
        this.partOffs = -1;
        this.partLength = -1;
        this.partArguments = -1;
        this.replyReserve = 0;
    }

    public static int resultCountPartSize() {
        return 30;
    }

    public void setMaxSegment(short maxSegment) {
        this.maxNumberOfSegm = maxSegment;
    }

    void addPartAttribute(int attribute) {
        int attrOffset = this.partOffs + 1;
        int currentAttribute = this.getInt1(attrOffset);
        this.putInt1(currentAttribute |= attribute, attrOffset);
    }

    public DataPart initStreamCommand(boolean autocommit) throws SQLException {
        this.resetPacket();
        this.newSegment(2, autocommit, false, 1004, 2, null);
        return this.newParameterDataPart();
    }

    public boolean isUnicodePacket() {
        return false;
    }

    public OptionsPart addOptionsPart(int partkind) throws SQLException {
        this.newPart(partkind);
        int partDataOffs = this.partOffs + 16;
        OptionsPart result = new OptionsPart(this.getPointer(partDataOffs), this);
        return result;
    }

    public void initFetch(int messType, boolean autocommit, Cursor cursor, int fetchSize, byte[] statementcontext) {
        this.resetPacket();
        this.newSegment(messType, autocommit, false, 1000, 2, statementcontext);
        this.addCursorPart(cursor);
        this.addFetchSizePart(fetchSize);
    }

    public void setAutoCommit(boolean autocommit) {
        StructuredMem packet = this.mem;
        packet.putInt1(autocommit ? 1 : 0, this.segmOffs + 14);
    }

    public void resize() {
        this.mem.resize();
        this.initPacket();
    }
}

