/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.TimestampTranslator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateTranslator
extends TimestampTranslator {
    public static final String zeroPadC = "0000";

    public DateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected DateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        Date timestamp = this.getDate(controller, mem, null);
        if (timestamp == null) {
            return null;
        }
        return timestamp.toString();
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getDate(controller, mem, null);
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transTimestampForInput(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        value[0] = 14;
        int date_null = 32768;
        short year = (short)(cal.get(1) | date_null);
        byte month = (byte)cal.get(2);
        byte day = (byte)cal.get(5);
        dataFormat.putInt2(value, year, 1);
        dataFormat.putInt1(value, month, 3);
        dataFormat.putInt1(value, day, 4);
        return value;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Date dateVal = Date.valueOf(val);
            return this.transDateForInput(dateVal, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
        }
    }

    public int getPrecision() {
        return 10;
    }
}

