/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.translators.GetvalLob;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.StructuredMem;
import java.io.IOException;
import java.sql.SQLException;

public class GetvalCLOB
extends GetvalLob {
    public GetvalCLOB(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, JdbcCommunication session) {
        super(connection, descriptor, dataPart, session);
    }

    protected boolean isBinary() {
        return false;
    }

    public java.io.Reader getCharacterStream() throws SQLException {
        this.isValid();
        return new Reader();
    }

    public long length() throws SQLException {
        this.isValid();
        return this.lengthInCharacters();
    }

    protected boolean isReReadEnabled() {
        return true;
    }

    public String getSubString(long pos, int length) throws SQLException {
        char[] result;
        this.isValid();
        --pos;
        try {
            int charactersRead;
            if (pos < this.currentChunkStartPos || pos > this.currentChunkEndPos || pos < this.longPosition) {
                this.changePositionInLob(pos);
            }
            java.io.Reader stream = this.getCharacterStream();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            if ((charactersRead = stream.read(result = new char[length], 0, length)) < length) {
                char[] tmp = new char[charactersRead];
                System.arraycopy(result, 0, tmp, 0, charactersRead);
                result = tmp;
            }
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioExc.getMessage());
        }
        return String.valueOf(result);
    }

    public class Reader
    extends java.io.Reader {
        int[] m_length = new int[2];
        boolean streamAtEnd = false;

        public int read() throws StreamIOException {
            char result;
            if (this.streamAtEnd) {
                return -1;
            }
            this.m_length[0] = GetvalCLOB.this.itemsInBuffer;
            this.m_length[1] = 1;
            if (GetvalCLOB.this.itemsInBuffer <= 0) {
                GetvalCLOB.this.nextChunk();
                this.m_length[0] = GetvalCLOB.this.itemsInBuffer;
            }
            if (GetvalCLOB.this.atEnd) {
                this.streamAtEnd = true;
                return -1;
            }
            try {
                result = GetvalCLOB.this.streamBuffer.getChar(0, this.m_length);
            }
            catch (SQLException sqlExc) {
                throw new StreamIOException(sqlExc);
            }
            GetvalCLOB.this.itemsInBuffer = this.m_length[0];
            ++GetvalCLOB.this.longPosition;
            return result;
        }

        public int read(char[] b, int off, int len) throws StreamIOException {
            if (this.streamAtEnd) {
                return -1;
            }
            int charsCopied = 0;
            int chunkChars = 0;
            this.m_length[0] = GetvalCLOB.this.itemsInBuffer;
            this.m_length[1] = len;
            while (len > 0 && !GetvalCLOB.this.atEnd) {
                if (GetvalCLOB.this.itemsInBuffer <= 0) {
                    GetvalCLOB.this.nextChunk();
                    this.m_length[0] = GetvalCLOB.this.itemsInBuffer;
                }
                if (GetvalCLOB.this.atEnd) continue;
                try {
                    chunkChars = GetvalCLOB.this.streamBuffer.getCharArray(b, off, 0, this.m_length);
                }
                catch (SQLException e) {
                    throw new StreamIOException(e);
                }
                GetvalCLOB.this.itemsInBuffer = this.m_length[0];
                len = this.m_length[1];
                off += chunkChars;
                charsCopied += chunkChars;
                GetvalCLOB.this.longPosition += (long)chunkChars;
            }
            if (charsCopied == 0 && GetvalCLOB.this.atEnd) {
                GetvalCLOB.this.changePositionInLob(0L);
                charsCopied = -1;
                this.streamAtEnd = true;
            }
            return charsCopied;
        }

        protected void dumpReadResult(char[] b, int offs, int charsCopied) {
            String repr;
            if (charsCopied <= 32) {
                repr = new String(b, offs, charsCopied);
            } else {
                String start = new String(b, offs, 16);
                String end = new String(b, offs + charsCopied - 16, 16);
                repr = start + "..." + end;
            }
            System.out.println("        => [" + charsCopied + "] '" + repr + "'");
        }

        public void close() {
        }
    }
}

