/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.comunication.protocol.DataType;
import com.sap.db.jdbc.DBProcParameterInfo;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.translators.AlphanumTranslator;
import com.sap.db.jdbc.translators.BigIntegerTranslator;
import com.sap.db.jdbc.translators.BytesTranslator;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.Date2Translator;
import com.sap.db.jdbc.translators.DateTranslator;
import com.sap.db.jdbc.translators.DayDateTranslator;
import com.sap.db.jdbc.translators.DecimalTranslator;
import com.sap.db.jdbc.translators.DirectRecordInsertTranslator;
import com.sap.db.jdbc.translators.DoubleTranslator;
import com.sap.db.jdbc.translators.IntegerTranslater;
import com.sap.db.jdbc.translators.LOBTranslator;
import com.sap.db.jdbc.translators.LongDateTranslator;
import com.sap.db.jdbc.translators.NCLOBTranslator;
import com.sap.db.jdbc.translators.RealTranslator;
import com.sap.db.jdbc.translators.SecondDateTranslator;
import com.sap.db.jdbc.translators.SecondTimeTranslator;
import com.sap.db.jdbc.translators.ShortTranslator;
import com.sap.db.jdbc.translators.StringTranslator;
import com.sap.db.jdbc.translators.Time2Translator;
import com.sap.db.jdbc.translators.TimeTranslator;
import com.sap.db.jdbc.translators.TimestampTranslator;
import com.sap.db.jdbc.translators.TinyIntegerTranslator;
import java.sql.SQLException;

public abstract class TranslatorFactory {
    public static DBTechTranslator create(int mode, int ioType, int dataType, int frac, int len, int bufpos_in, int bufpos_out, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean directRecordPassing) throws SQLException {
        DBTechTranslator result = null;
        int ioLen = 0;
        if (directRecordPassing) {
            result = new DirectRecordInsertTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
            return result;
        }
        switch (dataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                result = new BigIntegerTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: {
                result = new StringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 14: {
                result = new DateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 15: {
                result = new TimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 16: {
                result = new TimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 27: 
            case 31: {
                result = new LOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 25: 
            case 26: 
            case 32: {
                result = new NCLOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 7: {
                result = new DoubleTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 6: {
                result = new RealTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 5: {
                result = new DecimalTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.notranslator", Integer.toString(dataType) + " " + (DataType.stringValuesC.length > dataType ? DataType.stringValuesC[dataType] : "unknown type code " + dataType));
            }
        }
        return result;
    }

    public static DBTechTranslator createCompleteDataTypes(int mode, int ioType, int dataType, int frac, int len, int bufpos_in, int bufpos_out, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean directRecordPassing) throws SQLException {
        DBTechTranslator result = null;
        int ioLen = 0;
        if (directRecordPassing) {
            result = new DirectRecordInsertTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
            return result;
        }
        switch (dataType) {
            case 1: {
                result = new TinyIntegerTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 2: {
                result = new ShortTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 3: {
                result = new IntegerTranslater(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 4: {
                result = new BigIntegerTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: 
            case 52: {
                result = new StringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 55: {
                result = new AlphanumTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 14: {
                result = new Date2Translator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 63: {
                result = new DayDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 15: {
                result = new Time2Translator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 64: {
                result = new SecondTimeTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 16: {
                result = new TimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 61: {
                result = new LongDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 62: {
                result = new SecondDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 27: 
            case 31: {
                result = new LOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 25: 
            case 26: 
            case 32: 
            case 51: 
            case 53: 
            case 70: {
                result = new NCLOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 7: {
                result = new DoubleTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 6: {
                result = new RealTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 5: {
                result = new DecimalTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.notranslator", Integer.toString(dataType) + " " + DataType.stringValuesC[dataType]);
            }
        }
        return result;
    }

    public static DBTechTranslator createDataFormat4(int mode, int ioType, int dataType, int frac, int len, int bufpos_in, int bufpos_out, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean directRecordPassing) throws SQLException {
        DBTechTranslator result = null;
        int ioLen = 0;
        if (directRecordPassing) {
            result = new DirectRecordInsertTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
            return result;
        }
        switch (dataType) {
            case 1: {
                result = new TinyIntegerTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 2: {
                result = new ShortTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 3: {
                result = new IntegerTranslater(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 4: {
                result = new BigIntegerTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 29: 
            case 30: 
            case 35: 
            case 52: {
                result = new StringTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 55: {
                result = new AlphanumTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 12: 
            case 13: 
            case 33: {
                result = new BytesTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 14: 
            case 63: {
                result = new DayDateTranslator(mode, ioType, 63, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 15: 
            case 64: {
                result = new SecondTimeTranslator(mode, ioType, 64, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 16: {
                result = new TimestampTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 61: {
                result = new LongDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 62: {
                result = new SecondDateTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 27: 
            case 31: {
                result = new LOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 25: 
            case 26: 
            case 32: 
            case 51: 
            case 70: {
                result = new NCLOBTranslator(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 7: {
                result = new DoubleTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 6: {
                result = new RealTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            case 5: {
                result = new DecimalTranslator(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
                break;
            }
            default: {
                throw SQLExceptionSapDB.generateSQLException("error.notranslator", Integer.toString(dataType) + " " + DataType.stringValuesC[dataType]);
            }
        }
        return result;
    }
}

