/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.NameHandling;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.Tracer;
import java.sql.SQLException;
import java.util.Properties;

public abstract class AbstractAuthenticationManager {
    public abstract int getMaxPasswordLength();

    public abstract void addClientProofPart(RequestPacket var1, String var2, String var3, boolean var4) throws SQLException;

    public abstract void authenticate(ConnectionSapDB var1, String var2, String var3, boolean var4, JdbcCommunication var5) throws SQLException;

    public ReplyPacket connect(ConnectionSapDB conn, Properties info, String userName, String password, boolean isUserPasswdAscii, JdbcCommunication session) throws SQLException {
        RequestPacket requestPacket = conn.getRequestPacket(session);
        requestPacket.initConnectRequest();
        String userNameFromServer = this.getUserNameFromServer();
        this.addClientProofPart(requestPacket, NameHandling.stripUsername(userNameFromServer != null ? userNameFromServer : userName), password, !isUserPasswdAscii);
        requestPacket.addClientIDPart(conn.getTermID());
        requestPacket.addConnectOptionsPart(info, conn.getDistributionMode());
        ReplyPacket replyPacket = conn.execute(requestPacket, this, 2, session, true);
        DataPartAuthentication authData = replyPacket.getAuthenticationPart();
        if (authData == null || !authData.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived");
        }
        if (!this.getMethodName().equals("NATIVE") && !authData.getString(1, 0).equals(this.getMethodName())) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived");
        }
        authData.nextField();
        byte[] cookie = this.evaluateConnectReply(authData, conn.tracer);
        if (cookie != null) {
            if (userNameFromServer == null) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.wrongserverchallengereceived");
            }
            conn.setUserNameFromServer(userNameFromServer);
            conn.setCookie(cookie);
        }
        this.onAuthenticationCompleted();
        return replyPacket;
    }

    public void onAuthenticationCompleted() {
    }

    public abstract byte[] evaluateConnectReply(DataPartAuthentication var1, Tracer var2) throws SQLException;

    public abstract boolean supportsReconnect();

    public abstract String getMethodName();

    public String getUserNameFromServer() {
        return null;
    }
}

