/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.jdbc.packet.ReplyPacket;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.Tracer;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.GSSAuthentication;
import com.sap.db.util.security.SAMLAuthentication;
import com.sap.db.util.security.ScrammMD5AuthenticationV1;
import com.sap.db.util.security.ScrammSHA256Authentication;
import com.sap.db.util.security.SessionCookieAuthentication;
import java.sql.SQLException;
import java.util.ArrayList;

public class AuthenticationManager
extends AbstractAuthenticationManager {
    ArrayList m_authMethods = new ArrayList(2);
    AbstractAuthenticationMethod m_method;

    public void authenticate(ConnectionSapDB conn, String user, String password, boolean isUserPasswdAscii, JdbcCommunication session) throws SQLException {
        if (conn.getCookie() != null && user != null && user != "") {
            this.m_authMethods.add(new SessionCookieAuthentication(conn));
            conn.tracer.println("Using Session Cookie Authentication");
        } else if (password == null || password.length() == 0) {
            try {
                this.m_authMethods.add(new GSSAuthentication(conn.tracer, conn));
            }
            catch (Exception e) {
                conn.tracer.println("Reject GSS Authentication: exception caught");
                conn.tracer.traceException(e);
            }
        } else {
            conn.tracer.println("Reject GSS Authentication - password is not empty");
            if (user == null || user.length() == 0) {
                this.m_authMethods.add(new SAMLAuthentication());
            } else {
                conn.tracer.println("Reject SAML Authentication - user name is not empty");
            }
        }
        this.m_authMethods.add(new ScrammSHA256Authentication());
        this.m_authMethods.add(new ScrammMD5AuthenticationV1());
        RequestPacket reqPckg = conn.getRequestPacket(session);
        boolean errorOccured = false;
        do {
            int index = 0;
            DataPartAuthentication dataPart = reqPckg.initAuthenticationMethodRequest();
            dataPart.addArg(0, 0);
            dataPart.addRow(2 * this.m_authMethods.size() + 1);
            dataPart.putBytes(user.getBytes(), dataPart.getCurrentOffset());
            errorOccured = false;
            for (index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                Object obj = this.m_authMethods.get(index);
                AbstractAuthenticationMethod method = (AbstractAuthenticationMethod)obj;
                try {
                    dataPart.putBytes(method.getMethodName().getBytes(), dataPart.getCurrentOffset());
                    dataPart.putBytes(method.getInitialData(password.getBytes()), dataPart.getCurrentOffset());
                    continue;
                }
                catch (SQLException e) {
                    conn.tracer.println("Reject authentication method " + method.getMethodName());
                    conn.tracer.traceException(e);
                    this.m_authMethods.remove(index);
                    errorOccured = true;
                    if (this.m_authMethods.size() != 0) continue;
                    conn.freeRequestPacket(reqPckg);
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable"), "08001", -11111);
                }
            }
            if (errorOccured) continue;
            dataPart.close();
        } while (errorOccured);
        byte[] data = null;
        do {
            ReplyPacket replPckg;
            DataPartAuthentication authData;
            if ((authData = (replPckg = conn.execute(reqPckg, this, 2, session, true)).getAuthenticationPart()) == null || !authData.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.noauthenticationmethodavailable");
            }
            String methodName = authData.getString(1, 0);
            authData.nextField();
            for (int index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                this.m_method = (AbstractAuthenticationMethod)this.m_authMethods.get(index);
                if (this.m_method.getMethodName().equals(methodName)) break;
            }
            if ((data = this.m_method.evaluateAuthReply(authData, conn.tracer)) == null) continue;
            reqPckg = conn.getRequestPacket(session);
            DataPartAuthentication dpOutput = reqPckg.initAuthenticationMethodRequest();
            dpOutput.addArg(0, 0);
            dpOutput.addRow(2);
            dpOutput.putBytes(methodName.getBytes(), dpOutput.getCurrentOffset());
            dpOutput.putBytes(data, dpOutput.getCurrentOffset());
            dpOutput.close();
        } while (data != null);
    }

    public byte[] evaluateConnectReply(DataPartAuthentication input, Tracer tracer) throws SQLException {
        return this.m_method.evaluateConnectReply(input, tracer);
    }

    public void addClientProofPart(RequestPacket requestPacket, String user, String pwd, boolean isUnicode) throws SQLException {
        DataPartAuthentication data = (DataPartAuthentication)requestPacket.newAuthenticationPart();
        data.addRow(3);
        if (isUnicode) {
            char[] userArray = user.toCharArray();
            data.putBigUnicode(userArray, data.getExtent(), userArray.length * 2);
        } else {
            data.putString(user, data.getExtent());
        }
        data.addArg(data.getExtent(), 0);
        data.putString(this.m_method.getMethodName(), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.putBytes(this.m_method.getFinalData(pwd, isUnicode), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.close();
    }

    public String getFinalDBMConnectCmd(String pwd, boolean isUnicode) throws SQLException {
        String cmd = "USER_RESPONSE " + this.m_method.getMethodName() + " " + Tracer.Hex2String(this.m_method.getFinalData(pwd, isUnicode)).toUpperCase();
        return cmd;
    }

    public int getMaxPasswordLength() {
        return this.m_method.getMaxPasswordLength();
    }

    public boolean supportsReconnect() {
        if (this.m_method == null) {
            return false;
        }
        return this.m_method.supportsReconnect();
    }

    public String getMethodName() {
        if (this.m_method == null) {
            return "NULL";
        }
        return this.m_method.getMethodName();
    }

    public String getUserNameFromServer() {
        return this.m_method.getUserNameFromServer();
    }

    public void onAuthenticationCompleted() {
        this.m_method.onAuthenticationCompleted();
    }
}

