/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPartAuthentication;
import com.sap.db.util.StructuredBytes;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSAuthentication
extends AbstractAuthenticationMethod {
    static final int REJECT = 0;
    static final int SERVICE_PRINCIPAL_NAME_REQUEST = 1;
    static final int SERVICE_PRINCIPAL_NAME_REPLY = 2;
    static final int UNESTABLISHED_REQUEST = 3;
    static final int UNESTABLISHED_REPLY = 4;
    static final int ESTABLISHED_REQUEST = 5;
    static final int ESTABLISHED_REPLY = 6;
    static final int CONNECT_REPLY = 7;
    static final int c_init = 0;
    static final int c_unestablished = 1;
    static final int c_established = 2;
    Oid m_krb5Oid;
    GSSManager m_manager;
    GSSContext m_context = null;
    byte[] m_finalData = null;
    int m_state;
    private ConnectionSapDB connection;
    private Subject authenticatedSubject;
    private Subject currentContextSubject;
    private String userName = null;

    public GSSAuthentication(Tracer tracer, ConnectionSapDB connection) throws GSSException {
        if (tracer != null) {
            tracer.println("Property: java.security.auth.login.config=" + System.getProperty("java.security.auth.login.config", "not set"));
            tracer.println("Property: javax.security.auth.useSubjectCredsOnly=" + System.getProperty("javax.security.auth.useSubjectCredsOnly", "not set"));
        }
        this.m_manager = GSSManager.getInstance();
        this.m_krb5Oid = new Oid("1.2.840.113554.1.2.2");
        this.m_state = 0;
        this.connection = connection;
        this.authenticatedSubject = this.connection.getAuthenticatedSubject();
        if (tracer != null) {
            if (this.authenticatedSubject != null) {
                tracer.println("Reusing connection subject");
            } else {
                this.currentContextSubject = Subject.getSubject(AccessController.getContext());
                tracer.println("Using current access context subject");
            }
        }
    }

    private byte[] reject() {
        return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {0}});
    }

    byte[] evaluateAuthReply(DataPartAuthentication input, Tracer tracer) throws SQLException {
        if (this.authenticatedSubject == null) {
            return this.evaluateAuthReplyInternal(input, tracer);
        }
        EvaluateAuthReplyAction action = new EvaluateAuthReplyAction(input, tracer);
        Subject.doAs(this.authenticatedSubject, action);
        if (action.exception != null) {
            throw action.exception;
        }
        return action.result;
    }

    private byte[] evaluateAuthReplyInternal(DataPartAuthentication input, Tracer tracer) throws SQLException {
        DataPartAuthentication vd = new DataPartAuthentication((StructuredMem)new StructuredBytes(input.getBytes(input.getCurrentOffset(), input.getCurrentFieldLen())), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        String kerneloid = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (!kerneloid.equals(this.m_krb5Oid.toString())) {
            if (tracer != null) {
                tracer.println("Reject GSS Authentication - wrong OID found " + kerneloid + ", expected " + this.m_krb5Oid.toString());
            }
            return this.reject();
        }
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        byte requestType = vd.getBase().getInt1(vd.getCurrentOffset());
        byte[] token = null;
        if (!vd.nextField()) {
            if (requestType != 6) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
            }
        } else {
            token = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        }
        if (requestType == 2) {
            if (!vd.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
            }
            String plainServerName = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
            if (tracer != null) {
                tracer.println("GSS Authentication - received SPN " + plainServerName);
            }
            try {
                if (vd.nextField()) {
                    this.userName = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
                    if (tracer != null) {
                        tracer.println("GSS Authentication - received user name " + this.userName);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            GSSCredential defaultCred = null;
            try {
                GSSName serverName = this.m_manager.createName(plainServerName, null);
                this.m_context = this.m_manager.createContext(serverName, this.m_krb5Oid, defaultCred, 0);
                this.m_context.requestMutualAuth(true);
                this.m_context.requestConf(true);
                this.m_context.requestInteg(true);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            token = new byte[]{};
        }
        if (requestType == 4 || requestType == 2) {
            try {
                token = this.m_context.initSecContext(token, 0, token.length);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            if (token == null) {
                if (tracer != null) {
                    tracer.print("Reject GSS Authentication due to protocol error");
                }
                return this.reject();
            }
            if (this.m_context.isEstablished()) {
                return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}, token});
            }
            return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {3}, token});
        }
        if (requestType == 6) {
            if (token == null) {
                this.m_finalData = this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}});
                return null;
            }
            try {
                token = this.m_context.initSecContext(token, 0, token.length);
            }
            catch (Exception e) {
                if (tracer != null) {
                    tracer.println("Reject GSS Authentication");
                    tracer.traceException(e);
                }
                return this.reject();
            }
            if (this.m_context.isEstablished()) {
                this.m_finalData = token == null ? this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}}) : this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {5}, token});
                return null;
            }
            if (tracer != null) {
                tracer.println("Reject GSS Authentication - communication type 6 but not established");
            }
            return this.reject();
        }
        if (tracer != null) {
            tracer.println("Reject GSS Authentication - no suitable communication type (found: " + requestType + ")");
        }
        return this.reject();
    }

    byte[] getFinalData(String pass, boolean isUnicode) throws SQLException {
        if (this.m_finalData != null) {
            return this.m_finalData;
        }
        throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", "GSS Protokoll error, context is still unestablished.");
    }

    String getMethodName() {
        return "GSS";
    }

    private byte[] pack(byte[][] chunks) {
        int length_pos = 2;
        for (int i = 0; i < chunks.length; ++i) {
            int chunkLen = chunks[i].length;
            length_pos += chunkLen;
            length_pos += chunkLen <= 250 ? 1 : 3;
        }
        StructuredBytes part = new StructuredBytes(length_pos);
        part.putInt2(chunks.length, 0);
        length_pos = 2;
        for (int i = 0; i < chunks.length; ++i) {
            int chunkLen = chunks[i].length;
            if (chunkLen <= 250) {
                part.putInt1(chunkLen, length_pos++);
            } else {
                part.putInt1(255, length_pos++);
                part.putInt2(chunkLen, length_pos);
                length_pos += 2;
            }
            part.putBytes(chunks[i], length_pos);
            length_pos += chunkLen;
        }
        return part.bytes();
    }

    byte[] evaluateConnectReply(DataPartAuthentication input, Tracer tracer) throws SQLException {
        DataPartAuthentication vd = new DataPartAuthentication((StructuredMem)new StructuredBytes(input.getBytes(input.getCurrentOffset(), input.getCurrentFieldLen())), 1);
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        String kerneloid = vd.getBase().getString(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (!kerneloid.equals(this.m_krb5Oid.toString())) {
            if (tracer != null) {
                tracer.println("Reject GSS Authentication - wrong OID found " + kerneloid + ", expected " + this.m_krb5Oid.toString());
            }
            return this.reject();
        }
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        byte requestType = vd.getBase().getInt1(vd.getCurrentOffset());
        if (requestType != 7) {
            return null;
        }
        byte[] sessionCookie = null;
        if (!vd.nextField()) {
            throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat");
        }
        sessionCookie = vd.getBase().getBytes(vd.getCurrentOffset(), vd.getCurrentFieldLen());
        if (tracer != null) {
            tracer.println("GSS Authentication - received session cookie");
        }
        return sessionCookie;
    }

    byte[] getInitialData(byte[] pass) throws SQLException {
        if (this.authenticatedSubject == null) {
            return this.getInitialDataInternal(pass);
        }
        GetInitialDataAction action = new GetInitialDataAction(pass);
        Subject.doAs(this.authenticatedSubject, action);
        if (action.exception != null) {
            throw action.exception;
        }
        return action.result;
    }

    private byte[] getInitialDataInternal(byte[] pass) throws SQLException {
        try {
            GSSCredential clientCredential = this.m_manager.createCredential(1);
            GSSName client = clientCredential.getName().canonicalize(this.m_krb5Oid);
            Oid typeOID = client.getStringNameType();
            return this.pack(new byte[][]{this.m_krb5Oid.toString().getBytes(), {1}, typeOID.toString().getBytes(), ((Object)client).toString().getBytes()});
        }
        catch (GSSException e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", e.toString());
        }
        catch (Exception e) {
            throw SQLExceptionSapDB.generateSQLException("error.connection.gssauthenticationerror", e.toString());
        }
    }

    public String getUserNameFromServer() {
        return this.userName;
    }

    public boolean supportsReconnect() {
        return true;
    }

    public void onAuthenticationCompleted() {
        this.connection.setAuthenticatedSubject(this.currentContextSubject);
    }

    private class GetInitialDataAction
    implements PrivilegedAction {
        private byte[] pass;
        private byte[] result;
        private SQLException exception;

        public GetInitialDataAction(byte[] pass) {
            this.pass = pass;
        }

        public Object run() {
            try {
                this.result = GSSAuthentication.this.getInitialDataInternal(this.pass);
            }
            catch (SQLException e) {
                this.exception = e;
            }
            return null;
        }
    }

    private class EvaluateAuthReplyAction
    implements PrivilegedAction {
        private DataPartAuthentication input;
        private Tracer tracer;
        byte[] result;
        SQLException exception;

        public EvaluateAuthReplyAction(DataPartAuthentication input, Tracer tracer) {
            this.input = input;
            this.tracer = tracer;
        }

        public Object run() {
            try {
                this.result = GSSAuthentication.this.evaluateAuthReplyInternal(this.input, this.tracer);
            }
            catch (SQLException e) {
                this.exception = e;
            }
            return null;
        }
    }
}

