/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.tds.TdsDataInputStream;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.CacheStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RawInputStream
extends FilterInputStream {
    private static final int HIBIT = Integer.MIN_VALUE;
    private static final int LOBITS = Integer.MAX_VALUE;
    private static final int NOLIMIT = -1;
    private int _visibleLength;
    private boolean _noLimit;
    private int _actualLength;
    private int _resetVisibleLength;
    private int _resetActualLength;
    private boolean _resetLastChunk;
    private int _bytesRead;
    private int _jmark;
    private boolean _markSupported;
    CacheManager _cm;
    TdsDataInputStream _tdis;
    private boolean _dead = false;
    protected boolean _isCached = false;
    private boolean _needReset = false;
    private boolean _lastChunk = true;

    public RawInputStream(InputStream inputStream, int n, int n2, CacheManager cacheManager) throws IOException {
        super(inputStream);
        this._resetVisibleLength = n2;
        this._visibleLength = n2;
        this._noLimit = n2 == -1;
        this._resetActualLength = n;
        this._actualLength = n;
        this._bytesRead = 0;
        this._jmark = -1;
        this._markSupported = false;
        this._cm = cacheManager;
        this._tdis = inputStream instanceof TdsDataInputStream ? (TdsDataInputStream)inputStream : null;
        if (n < 0) {
            this._lastChunk = false;
        }
    }

    public void setCached(boolean bl) {
        this._isCached = bl;
    }

    public boolean cache(CacheStream cacheStream) throws IOException {
        if (this._jmark != -1) {
            return true;
        }
        this._jmark = this._bytesRead;
        this._needReset = true;
        this._resetActualLength = this._actualLength;
        this._resetVisibleLength = this._visibleLength;
        this._resetLastChunk = this._lastChunk;
        if (this._actualLength == 0 && this._lastChunk || this._dead) {
            this._isCached = true;
            return true;
        }
        if (this._isCached) {
            return true;
        }
        this.in = cacheStream;
        try {
            byte[] byArray = new byte[512];
            while (this._actualLength > 0 || !this._lastChunk) {
                while (this._actualLength > 0) {
                    int n = this._actualLength < 512 ? this._actualLength : 512;
                    if ((n = this.in.read(byArray, 0, n)) > 0) {
                        this._actualLength -= n;
                        this._bytesRead += n;
                        continue;
                    }
                    ErrorMessage.raiseIOException("JZ0EM");
                }
                this.nextChunk();
            }
            this._isCached = true;
            this.doneReading();
        }
        catch (IOException iOException) {
            this._dead = true;
            throw iOException;
        }
        return this._isCached;
    }

    @Override
    public int read() throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return -1;
        }
        if (!this._noLimit) {
            --this._visibleLength;
        }
        int n = 0;
        if (this._actualLength > 0) {
            --this._actualLength;
            ++this._bytesRead;
            n = this.in.read();
        }
        this.checkDone();
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.checkMe();
        if (n2 == 0) {
            return 0;
        }
        int n4 = n2;
        if (!this._noLimit && this._visibleLength < n2) {
            n4 = this._visibleLength;
        }
        if (n4 == 0) {
            return -1;
        }
        n2 = n4;
        while (!(n2 <= 0 || this._actualLength <= 0 && this._lastChunk)) {
            int n5 = n3 = n2 < this._actualLength ? n2 : this._actualLength;
            if (n3 > 0) {
                int n6 = this.in.read(byArray, n, n3);
                n += n6;
                n2 -= n6;
                if (this._actualLength > 0) {
                    this._actualLength -= n6;
                }
                this._bytesRead += n6;
            }
            if (this._actualLength != 0) continue;
            this.nextChunk();
        }
        if (this._noLimit) {
            if (n2 == n4) {
                return -1;
            }
            if (n2 > 0) {
                n4 -= n2;
            }
        } else {
            this._visibleLength -= n4;
            if (n2 > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    byArray[n + n3] = 0;
                }
            }
        }
        this.checkDone();
        return n4;
    }

    @Override
    public int available() throws IOException {
        this.checkMe();
        if (this.in == null) {
            return 0;
        }
        int n = 0;
        if (this._actualLength > 0) {
            n = this.in.available();
        }
        if (n < this._actualLength && n < this._visibleLength && !this._noLimit) {
            return n;
        }
        return this._noLimit ? this._actualLength : this._visibleLength;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkMe();
        if (this._visibleLength == 0) {
            return 0L;
        }
        long l2 = l;
        if (!this._noLimit) {
            if ((long)this._visibleLength < l) {
                l2 = this._visibleLength;
            }
            this._visibleLength = (int)((long)this._visibleLength - l2);
        }
        long l3 = 0L;
        while (!(l2 <= 0L || this._actualLength <= 0 && this._lastChunk)) {
            long l4;
            long l5 = l4 = l2 < (long)this._actualLength ? l2 : (long)this._actualLength;
            if (l4 > 0L) {
                this.in.skip(l4);
                this._actualLength = (int)((long)this._actualLength - l4);
                this._bytesRead = (int)((long)this._bytesRead + l4);
                l2 -= l4;
                l3 += l4;
            }
            if (l2 <= 0L) continue;
            this.nextChunk();
        }
        this.checkDone();
        return l3;
    }

    @Override
    public void close() throws IOException {
        if (this._dead) {
            return;
        }
        if (this._dead) {
            return;
        }
        this._needReset = false;
        this.checkMe();
        try {
            if (!this._isCached) {
                if (this._noLimit) {
                    while (this._actualLength > 0 || !this._lastChunk) {
                        this.skip(this._actualLength);
                    }
                } else {
                    this.read(new byte[this._actualLength], 0, this._actualLength);
                    this._visibleLength = this._actualLength;
                    this.skip(this._visibleLength);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.checkDone();
            this._dead = true;
            this.in = null;
        }
    }

    @Override
    public boolean markSupported() {
        return this._markSupported;
    }

    private void checkMe() throws IOException {
        if (this._dead) {
            ErrorMessage.raiseIOException("JZ0I9");
        }
        if (this._needReset && this._tdis != null) {
            this._tdis.reset();
            this._needReset = false;
            this.in.reset();
            this._visibleLength = this._resetVisibleLength;
            this._actualLength = this._resetActualLength;
            this._lastChunk = this._resetLastChunk;
            this._bytesRead = 0;
            this.in.skip(this._jmark);
            this._bytesRead = this._jmark;
            this._jmark = -1;
        }
        if (this._actualLength <= 0 && !this._lastChunk) {
            this.nextChunk();
        }
    }

    private void checkDone() throws IOException {
        if (this.in != null && (this._visibleLength == 0 || this._noLimit && this._actualLength == 0 && this._lastChunk)) {
            this.doneReading();
            this._isCached = true;
        }
    }

    private void doneReading() throws IOException {
        if (!this._isCached) {
            if (!this._noLimit) {
                if (this._resetActualLength > this._resetVisibleLength) {
                    this.in.read(new byte[this._actualLength]);
                } else {
                    this.in.skip(this._actualLength);
                }
            } else {
                while (!(this.in == null || this._actualLength <= 0 && this._lastChunk)) {
                    this.skip(this._actualLength);
                }
            }
        }
        if (this._cm != null) {
            this._cm.doneReading();
            this._cm = null;
        }
    }

    private void nextChunk() throws IOException {
        if (this._lastChunk) {
            return;
        }
        int n = this._tdis.readInt(this.in);
        this._bytesRead += 4;
        if ((n & Integer.MIN_VALUE) == 0) {
            this._lastChunk = true;
        }
        this._actualLength = n & Integer.MAX_VALUE;
    }
}

