/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Utils;
import java.util.prefs.Preferences;

public class Settings {
    public static final boolean DEFAULT_ENABLE_SERVER_DISCOVERY = false;
    public static final boolean DEFAULT_ENABLE_LOGIN_TIMEOUT = true;
    public static final boolean DEFAULT_ENABLE_SAVE_SERVERS = true;
    public static final int DEFAULT_LOGIN_TIMEOUT = 30;
    public static final int DEFAULT_NUM_SAVED_SERVERS = 5;
    public static final int DEFAULT_SERVER_DISCOVERY_TIMEOUT = 30;
    public static final boolean DEFAULT_USE_DEFAULT_INTERFACES = true;
    private static Preferences SETTINGS = Preferences.userRoot().node("/com/sybase/util/ds/Settings");
    private static final String KEY_ENABLE_LOGIN_TIMEOUT = "EnableLoginTimeOut";
    private static final String KEY_LOGIN_TIMEOUT = "LoginTimeout";
    private static final String KEY_ENABLE_SERVER_DISCOVERY = "EnableServerDiscovery";
    private static final String KEY_ENABLE_SAVE_SERVERS = "EnableSaveServers";
    private static final String KEY_NUM_SAVED_SERVERS = "NumberOfSavedServers";
    private static final String KEY_SERVER_DISCOVERY_TIMEOUT = "ServerDiscoveryTimeout";
    private static final String KEY_USE_DEFAULT_INTERFACES = "UseDefaultInterfaces";
    private static final String KEY_INTERFACES_PATH = "InterfacesPath";
    private static final String KEY_LAST_INTERFACES_FOLDER = "LastInterfacesFolder";

    public static boolean getEnableServerDiscovery() {
        return SETTINGS.getBoolean(KEY_ENABLE_SERVER_DISCOVERY, false);
    }

    public static void setEnableServerDiscovery(boolean bl) {
        SETTINGS.putBoolean(KEY_ENABLE_SERVER_DISCOVERY, bl);
    }

    public static boolean getEnableLoginTimeout() {
        return SETTINGS.getBoolean(KEY_ENABLE_LOGIN_TIMEOUT, true);
    }

    public static void setEnableLoginTimeout(boolean bl) {
        SETTINGS.putBoolean(KEY_ENABLE_LOGIN_TIMEOUT, bl);
    }

    public static int getLoginTimeout() {
        return SETTINGS.getInt(KEY_LOGIN_TIMEOUT, 30);
    }

    public static void setLoginTimeout(int n) {
        SETTINGS.putInt(KEY_LOGIN_TIMEOUT, n);
    }

    public static boolean getEnableSaveServers() {
        return SETTINGS.getBoolean(KEY_ENABLE_SAVE_SERVERS, true);
    }

    public static void setEnableSaveServers(boolean bl) {
        SETTINGS.putBoolean(KEY_ENABLE_SAVE_SERVERS, bl);
    }

    public static int getNumberOfSavedServers() {
        return SETTINGS.getInt(KEY_NUM_SAVED_SERVERS, 5);
    }

    public static void setNumberOfSavedServers(int n) {
        SETTINGS.putInt(KEY_NUM_SAVED_SERVERS, n);
    }

    public static int getServerDiscoveryTimeout() {
        return SETTINGS.getInt(KEY_SERVER_DISCOVERY_TIMEOUT, 30);
    }

    public static void setServerDiscoveryTimeout(int n) {
        SETTINGS.putInt(KEY_SERVER_DISCOVERY_TIMEOUT, n);
    }

    public static boolean getUseDefaultInterfaces() {
        return SETTINGS.getBoolean(KEY_USE_DEFAULT_INTERFACES, true);
    }

    public static void setUseDefaultInterfaces(boolean bl) {
        SETTINGS.putBoolean(KEY_USE_DEFAULT_INTERFACES, bl);
    }

    public static String getCustomInterfacesPath() {
        return SETTINGS.get(KEY_INTERFACES_PATH, "");
    }

    public static void setCustomInterfacesPath(String string) {
        SETTINGS.put(KEY_INTERFACES_PATH, string);
    }

    public static String getLastInterfacesFolder() {
        String string = SETTINGS.get(KEY_LAST_INTERFACES_FOLDER, null);
        if (string == null || !Utils.isExistingDirectory(string)) {
            string = Utils.getSybasePath();
            if (string == null) {
                string = Utils.getEnVariable("SYBROOT");
            }
            if (string != null) {
                if (Utils.isExistingDirectory(string)) {
                    if (Utils.OS_WINDOWS) {
                        String string2 = string + System.getProperty("file.separator") + "ini";
                        string = Utils.isExistingDirectory(string2) ? string2 : null;
                    }
                } else {
                    string = null;
                }
            }
            if (string == null) {
                string = System.getProperty("user.dir");
            }
        }
        return string;
    }

    public static void setLastInterfacesFolder(String string) {
        SETTINGS.put(KEY_LAST_INTERFACES_FOLDER, string);
    }
}

