/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.EditDiscoverySettingPage;
import com.sybase.util.ds.ui.ServerDiscoveryPage;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditDiscoverySettingDialog
extends BaseDialog
implements DocumentListener,
ASASpinBoxChangeListener {
    private EditDiscoverySettingPage _page;
    private ServerDiscoveryPage _parentPage;
    private DiscoverySetting _setting;
    private boolean _isEdit = false;

    EditDiscoverySettingDialog(ServerDiscoveryPage serverDiscoveryPage, DiscoverySetting discoverySetting, boolean bl) {
        super(serverDiscoveryPage.getParentDialog());
        this._parentPage = serverDiscoveryPage;
        this._setting = discoverySetting;
        this._isEdit = bl;
    }

    DiscoverySetting create() {
        this.setVisible(this.createUI());
        this.destroyUI();
        return this._setting;
    }

    private boolean createUI() {
        this._page = new EditDiscoverySettingPage(this._isEdit);
        this._page.setPreferredSize(new Dimension(450, 200));
        this._page.init(this._setting);
        this._page.discoveryMethodComboBox.addActionListener((ActionListener)this);
        this._page.defaultHostRadioButton.addActionListener((ActionListener)this);
        this._page.specifyHostRadioButton.addActionListener((ActionListener)this);
        this._page.defaultPortRadioButton.addActionListener((ActionListener)this);
        this._page.specifyPortRadioButton.addActionListener((ActionListener)this);
        this._page.discoveryHostTextField.getDocument().addDocumentListener(this);
        this._page.discoveryPortSpinBox.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
        String string = this._isEdit ? _res.get("EDIT_DISCOVERY_SETTING") : _res.get("ADD_DISCOVERY_SETTING");
        super.createUI((JPanel)((Object)this._page), string);
        return true;
    }

    @Override
    void destroyUI() {
        this._page = null;
        this._parentPage = null;
        super.destroyUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._page.specifyPortRadioButton || object == this._page.defaultPortRadioButton || object == this._page.specifyHostRadioButton || object == this._page.defaultHostRadioButton || object == this._page.discoveryMethodComboBox) {
            this._page.handleActionPerformed(actionEvent);
            this.enableComponents();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        this.enableComponents();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableComponents();
    }

    private void enableComponents() {
        this._okButton.setEnabled(this._page.getEnableSave());
    }

    @Override
    void handleOK() {
        DiscoverySetting discoverySetting = new DiscoverySetting(this._page.getDiscoveryService(), this._page.getDiscoveryHost(), this._page.getDiscoveryPort());
        if (this._parentPage.containsDiscoverySetting(discoverySetting)) {
            JOptionPane.showMessageDialog(this._parentPage.getParentDialog(), _res.getFormatted("ERR_DISCOVERY_SETTING_EXISTS", discoverySetting.getURL()), _res.get("Error"), 0);
            this._setting = null;
            return;
        }
        this.setVisible(false);
        this._setting = discoverySetting;
    }

    @Override
    void handleCancel() {
        this._setting = null;
        this.setVisible(false);
    }
}

