/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.comunication.protocol;

import com.sap.db.comunication.protocol.DataType;
import com.sap.db.comunication.protocol.Packet;
import com.sap.db.jdbc.packet.MultiLineOptionsPart;
import com.sap.db.jdbc.packet.OptionsPart;
import com.sap.db.util.FullswapMem;
import com.sap.db.util.StructuredMem;
import com.sap.db.util.Tracer;
import com.sap.db.vsp001.CmdMessType;
import com.sap.db.vsp001.FunctionCode;
import com.sap.db.vsp001.PartKind;
import java.util.ArrayList;

public class PacketAnalyzer {
    private int SegmOffset = 0;
    private int PartOffset = 0;
    private StructuredMem mem;
    int numberOfSegments = 0;
    int numberOfParts = 0;
    int currentSegment = 0;
    int currentPart = 0;
    private ArrayList parameterMetaData = new ArrayList();
    private ArrayList resultSetMetaData = new ArrayList();

    public static void main(String[] args) {
        String packet = "[d8 e2 e8 33 00 00 00 00 08 00 00 00 78 00 00 00 e0 03 00 00 01 00 ad ba 0d f0 ad ba 0d f0 ad ba 78 00 00 00 00 00 00 00 02 00 01 00 02 00 08 00 00 00 00 00 00 00 00 00 0a 00 01 00 00 00 00 00 08 00 00 00 b8 03 00 00 c8 3b ed 33 00 00 00 00 2e 00 03 00 00 00 00 00 37 00 00 00 a0 03 00 00 0d 05 04 00 00 00 00 00 ff ff 00 00 00 00 00 00 0d 05 04 00 01 00 00 00 ff ff 00 00 00 00 00 00 0d 05 04 00 03 00 00 00 ff ff 00 00 00 00 00 00 09 09 4d 0a 4e 55 4c 4c]";
        PacketAnalyzer pa = new PacketAnalyzer();
        pa.parse(packet);
        pa.printPacket();
    }

    public void parse(String packet) {
        this.parse(this.normalizePacketString(packet));
    }

    public void parse(byte[] packet) {
        this.mem = new FullswapMem(packet);
        try {
            this.numberOfSegments = this.mem.getInt2(20);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.numberOfParts = 0;
        this.currentSegment = 0;
        this.currentPart = 0;
    }

    byte[] normalizePacketString(String packet) {
        char[] bytearr = packet.toCharArray();
        StringBuffer sb = new StringBuffer(bytearr.length);
        block3: for (int i = 0; i < bytearr.length; ++i) {
            switch (bytearr[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.append(bytearr[i]);
                    continue block3;
                }
            }
        }
        byte[] val = Tracer.String2Hex(sb.toString());
        return val;
    }

    public String getPacketHeader() {
        StringBuffer result = new StringBuffer();
        try {
            result.append("SessionID=" + this.mem.getInt8(0) + " PacketCount=" + this.mem.getInt4(8) + " VarpartLength=" + this.mem.getInt4(12) + " VarpartSize=" + this.mem.getInt4(16) + " NumberOfSegments=" + this.mem.getInt2(20) + " PacketOptions=" + this.mem.getInt1(22));
        }
        catch (Exception e) {
            result.append(" Illegal packet header.");
        }
        return result.toString();
    }

    public String getSegmentHeader() {
        byte segmKind = this.mem.getInt1(this.SegmOffset + 12);
        String result = new String((segmKind == 1 ? "Request" : "Reply") + " Length=" + this.mem.getInt4(this.SegmOffset + 0) + " Offset=" + this.mem.getInt4(this.SegmOffset + 4) + " NoOfParts=" + this.mem.getInt2(this.SegmOffset + 8) + " Index=" + this.mem.getInt2(this.SegmOffset + 10) + " SegmentKind=" + this.mem.getInt1(this.SegmOffset + 12));
        if (segmKind == 1) {
            byte messType = this.mem.getInt1(this.SegmOffset + 13);
            result = result + " MessType=" + CmdMessType.CmdMessTypeString[messType] + "(" + messType + ")" + " CommitImmediateley=" + this.mem.getInt1(this.SegmOffset + 14) + " CommandOptions=" + this.mem.getInt1(this.SegmOffset + 15);
        } else {
            int fcode = this.mem.getInt2(this.SegmOffset + 14);
            try {
                result = result + " FunctionCode=" + FunctionCode.FunctionCode2String[fcode] + "(" + fcode + ")";
            }
            catch (Exception e) {
                result = result + " FunctionCode=" + fcode;
            }
        }
        return result;
    }

    public String getPartHeader() {
        byte partKind = this.mem.getInt1(this.PartOffset + 0);
        String pKind = "unknown (" + partKind + ")";
        try {
            pKind = PartKind.names[partKind];
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String result = "PartKind=" + pKind + " Attributes=" + this.mem.getInt1(this.PartOffset + 1) + this.getPartAttributes(this.mem.getInt1(this.PartOffset + 1)) + " ArgCount=" + this.mem.getInt2(this.PartOffset + 2) + " SegmOffs=" + this.mem.getInt4(this.PartOffset + 4) + " BufLen=" + this.mem.getInt4(this.PartOffset + 8) + " BufSize=" + this.mem.getInt4(this.PartOffset + 12);
            return result;
        }
        catch (Exception e) {
            return "corrupt packet header";
        }
    }

    String getPartAttributes(byte attr) {
        StringBuffer sb = new StringBuffer(" [");
        if ((attr & 1) != 0) {
            sb.append("last ");
        }
        if ((attr & 2) != 0) {
            sb.append("next ");
        }
        if ((attr & 4) != 0) {
            sb.append("first ");
        }
        if ((attr & 8) != 0) {
            sb.append("RowNotFound ");
        }
        if ((attr & 1) != 0) {
            sb.append("RS_Closed ");
        }
        sb.append(']');
        return sb.toString();
    }

    public String getPartBufferBinary() {
        String result = new String(Tracer.Hex2String(this.mem.getBytes(this.PartOffset + 16, this.mem.getInt4(this.PartOffset + 8))));
        return result;
    }

    public String getPartBuffer() {
        byte partKind = this.mem.getInt1(this.PartOffset + 0);
        StringBuffer result = new StringBuffer();
        switch (partKind) {
            case 3: {
                result.append(this.mem.getString(this.PartOffset + 16, this.mem.getInt4(this.PartOffset + 8)));
                break;
            }
            case 6: {
                int pos = this.PartOffset + 16;
                int errLen = this.mem.getInt4(pos + 8);
                result.append(" ErrorCode=" + this.mem.getInt4(pos + 0) + " SQLState=" + this.mem.getString(pos + 13, 5) + " ErrorPos=" + this.mem.getInt4(pos + 4) + " ErrorText=" + this.mem.getString(pos + 18, errLen) + " ErrorLevel=" + this.mem.getInt1(pos + 12));
                break;
            }
            case 47: {
                int parameterCount = this.mem.getInt2(this.PartOffset + 2);
                int pos = this.PartOffset + 16;
                int i = 1;
                while (i <= parameterCount) {
                    byte mode = this.mem.getInt1(pos + 0);
                    byte dataType = this.mem.getInt1(pos + 1);
                    int frac = this.mem.getInt2(pos + 10);
                    int len = this.mem.getInt2(pos + 8);
                    int parameterNameOffset = this.mem.getInt4(pos + 4);
                    StringBuffer ioType = new StringBuffer();
                    switch (this.mem.getInt1(pos + 2)) {
                        case 1: {
                            ioType.append("IN");
                            break;
                        }
                        case 4: {
                            ioType.append("OUT");
                            this.parameterMetaData.add(new Byte(dataType));
                            break;
                        }
                        case 2: {
                            ioType.append("INOUT");
                            this.parameterMetaData.add(new Byte(dataType));
                        }
                    }
                    boolean readOnly = (mode & 0x10) != 0;
                    boolean autoIncre = (mode & 0x20) != 0;
                    result.append(" " + i + "." + " Type=" + DataType.stringValuesC[dataType] + "(" + dataType + ")" + " Len=" + len + "," + frac + " Mode=" + ioType + (readOnly ? " READ_ONLY" : "") + (autoIncre ? " AUTO_INCR" : "") + " NameOffSet=" + parameterNameOffset + "\n        ");
                    ++i;
                    pos += 16;
                }
                break;
            }
            case 48: {
                int parameterCount = this.mem.getInt2(this.PartOffset + 2);
                int pos = this.PartOffset + 16;
                int identPos = pos + parameterCount * 24;
                int i = 1;
                while (i <= parameterCount) {
                    byte mode = this.mem.getInt1(pos + 0);
                    byte dataType = this.mem.getInt1(pos + 1);
                    int frac = this.mem.getInt2(pos + 2);
                    int len = this.mem.getInt2(pos + 4);
                    this.resultSetMetaData.add(new Byte(dataType));
                    int tableNameOffset_O = this.mem.getInt4(pos + 8);
                    int schemaNameOffset_O = this.mem.getInt4(pos + 12);
                    int columnNameOffset_O = this.mem.getInt4(pos + 16);
                    int columnDisplayNameOffset_O = this.mem.getInt4(pos + 20);
                    boolean readOnly = (mode & 0x10) != 0;
                    boolean autoIncre = (mode & 0x20) != 0;
                    String tableName = tableNameOffset_O == -1 ? "" : this.mem.getString(identPos + tableNameOffset_O + 1, this.mem.getInt1(identPos + tableNameOffset_O));
                    String schemaName = schemaNameOffset_O == -1 ? "" : this.mem.getString(identPos + schemaNameOffset_O + 1, this.mem.getInt1(identPos + schemaNameOffset_O));
                    String columnName = columnNameOffset_O == -1 ? "" : this.mem.getString(identPos + columnNameOffset_O + 1, this.mem.getInt1(identPos + columnNameOffset_O));
                    String columnDisplayName = columnDisplayNameOffset_O == -1 ? "" : this.mem.getString(identPos + columnDisplayNameOffset_O + 1, this.mem.getInt1(identPos + columnDisplayNameOffset_O));
                    result.append(" " + i + "." + " Type=" + DataType.stringValuesC[dataType] + "(" + dataType + ")" + " Len=" + len + "," + frac + (readOnly ? " READ_ONLY" : "") + (autoIncre ? " AUTO_INCR" : "") + " TableName (OffSet=" + tableNameOffset_O + ") " + tableName + " SchemaName (OffSet=" + schemaNameOffset_O + ") " + schemaName + " Columnname (OffSet=" + columnNameOffset_O + ") " + columnName + " ColumnDisplayName (OffSet=" + columnDisplayNameOffset_O + ") " + columnDisplayName + "\n        ");
                    ++i;
                    pos += 24;
                }
                break;
            }
            case 15: {
                int argcnt = this.mem.getInt2(this.PartOffset + 2);
                StructuredMem memory = this.mem.getPointer(this.PartOffset + 16);
                MultiLineOptionsPart mo = new MultiLineOptionsPart(memory, argcnt);
                while (true) {
                    result.append(" Option=" + Packet.TopologyInformation_String[mo.getOptionName()] + " Type=" + mo.getOptionTypeString() + " Value=" + mo.getOptionValue() + " ");
                    if (mo.nextOption()) continue;
                    result.append("\n        ");
                    if (!mo.nextLine()) break;
                }
                break;
            }
            case 42: {
                int argcnt = this.mem.getInt2(this.PartOffset + 2);
                StructuredMem memory = this.mem.getPointer(this.PartOffset + 16);
                OptionsPart mo = new OptionsPart(memory, argcnt);
                do {
                    result.append(" Option=" + Packet.ConnectOption_String[mo.getOptionName()] + " Type=" + mo.getOptionTypeString() + " Value=" + mo.getOptionValue() + " ");
                } while (mo.nextOption());
                break;
            }
            case 34: {
                int argcnt = this.mem.getInt2(this.PartOffset + 2);
                StructuredMem memory = this.mem.getPointer(this.PartOffset + 16);
                OptionsPart mo = new OptionsPart(memory, argcnt);
                do {
                    result.append(" Option=" + Packet.SessionContext_String[mo.getOptionName()] + " Type=" + mo.getOptionTypeString() + " Value=" + mo.getOptionValue() + " ");
                } while (mo.nextOption());
                break;
            }
            case 64: {
                int argcnt = this.mem.getInt2(this.PartOffset + 2);
                StructuredMem memory = this.mem.getPointer(this.PartOffset + 16);
                OptionsPart mo = new OptionsPart(memory, argcnt);
                do {
                    result.append(" Option=" + Packet.TransactionFlag_String[mo.getOptionName()] + " Type=" + mo.getOptionTypeString() + " Value=" + mo.getOptionValue() + " ");
                } while (mo.nextOption());
                break;
            }
            case 5: 
            case 41: {
                break;
            }
            default: {
                result.append("");
            }
        }
        return result.toString();
    }

    public boolean getNextSegment() {
        if (this.currentSegment == 0 && this.numberOfSegments > 0) {
            this.SegmOffset = 32;
        } else if (this.currentSegment < this.numberOfSegments) {
            int len = this.mem.getInt4(this.SegmOffset + 0);
            this.SegmOffset += len;
        } else {
            return false;
        }
        ++this.currentSegment;
        this.numberOfParts = this.mem.getInt2(this.SegmOffset + 8);
        this.currentPart = 0;
        this.parameterMetaData.clear();
        this.resultSetMetaData.clear();
        return true;
    }

    public boolean getNextPart() {
        if (this.currentPart == 0 && this.numberOfParts > 0) {
            this.PartOffset = this.SegmOffset + 24;
        } else if (this.currentPart < this.numberOfParts) {
            int len = this.mem.getInt4(this.PartOffset + 8) + 16;
            int modResult = len % 8;
            if (modResult != 0) {
                len += 8 - modResult;
            }
            this.PartOffset += len;
        } else {
            return false;
        }
        ++this.currentPart;
        return true;
    }

    public void printPacket() {
        System.out.println("<Packet " + this.getPacketHeader() + ">");
        while (this.getNextSegment()) {
            System.out.println("  <Segment " + this.getSegmentHeader() + ">");
            while (this.getNextPart()) {
                System.out.println("    <Part " + this.getPartHeader() + ">");
                System.out.println("      <PartBuffer>");
                System.out.println("        [" + this.getPartBufferBinary() + "]");
                System.out.println("        " + this.getPartBuffer());
                System.out.println("      </PartBuffer>");
                System.out.println("    </Partt>");
            }
            System.out.println("  </Segment>");
        }
        System.out.println("</Packet>");
    }
}

