/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;

abstract class ConnectionItem
extends WrapperDummy {
    protected ConnectionSapDB connection;
    protected SQLWarning warningList;

    public ConnectionItem(ConnectionSapDB connection) {
        this.connection = connection;
        this.warningList = null;
    }

    public final void addWarning(SQLWarning warning) {
        if (this.warningList == null) {
            this.warningList = warning;
        } else {
            this.warningList.setNextWarning(warning);
        }
    }

    protected final void assertOpen() throws SQLException {
        if (this.connection == null || this.connection.isClosed) {
            throw SQLExceptionSapDB.generateSQLException("error.objectisclosed", this);
        }
    }

    public final void clearWarnings() throws SQLException {
        this.warningList = null;
    }

    public final void closeDummy() throws SQLException {
    }

    public final Connection getConnection() throws SQLException {
        return this.connection;
    }

    public final ConnectionSapDB getConnectionSapDB() {
        return this.connection;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.warningList;
    }
}

