/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.util.StructuredBytes;

public class NameHandling {
    private NameHandling() {
    }

    public static String stripUsernameEscaped(String pwd) {
        if (pwd.length() > 0) {
            char firstChar = pwd.charAt(0);
            char lastChar = pwd.charAt(pwd.length() - 1);
            if (firstChar != '\"' || lastChar != '\"') {
                pwd = pwd.toUpperCase();
            } else {
                StringBuffer strippedPwd = new StringBuffer(40);
                for (int i = 1; i < pwd.length() - 1; ++i) {
                    char c = pwd.charAt(i);
                    if (c == '\"') {
                        strippedPwd.append('\"');
                    }
                    strippedPwd.append(c);
                }
                pwd = strippedPwd.toString();
            }
        }
        return pwd;
    }

    public static String stripUsername(String pwd) {
        if (pwd.length() > 0) {
            char firstChar = pwd.charAt(0);
            char lastChar = pwd.charAt(pwd.length() - 1);
            pwd = firstChar != '\"' || lastChar != '\"' ? pwd.toUpperCase() : pwd.substring(1, pwd.length() - 1);
        }
        return pwd;
    }

    static String stripPassword(String pwd) {
        if (pwd.length() > 0) {
            char firstChar = pwd.charAt(0);
            char lastChar = pwd.charAt(pwd.length() - 1);
            if (firstChar == '\"' && lastChar == '\"') {
                pwd = pwd.substring(1, pwd.length() - 1);
            }
        }
        return pwd;
    }

    static byte[] mangle(String pwd, boolean isUnicode) {
        int i;
        int vp1 = 2;
        int vp2 = 521;
        int vp3 = 133379;
        int maxPwdLen_C = 18;
        StructuredBytes pwdBytes = new StructuredBytes(18);
        String upperpwd = NameHandling.stripPassword(pwd);
        if (isUnicode) {
            pwdBytes.putBigUnicode(upperpwd.toCharArray(), 0, 18);
        } else {
            pwdBytes.putString(upperpwd, 0, 18);
        }
        int[] clearname = pwdBytes.getIntArray(0, pwdBytes.size());
        int[] crypt = new int[6];
        for (i = 1; i <= 6; ++i) {
            crypt[i - 1] = clearname[3 * i - 3] * 133379 + clearname[3 * i - 2] * 521 + clearname[3 * i - 1] * 2;
        }
        for (i = 1; i <= 6; ++i) {
            int left = i > 1 ? crypt[i - 2] : 133379;
            int n = i - 1;
            crypt[n] = crypt[n] + left % 61 * 16805753;
        }
        for (i = 6; i >= 1; --i) {
            int right = i < 5 ? crypt[i] : 521;
            int n = i - 1;
            crypt[n] = crypt[n] + right % 61 * 17072511;
        }
        for (i = 0; i < 6; ++i) {
            if ((crypt[i] & 1) == 0) continue;
            crypt[i] = -crypt[i];
        }
        StructuredBytes result = new StructuredBytes(24);
        for (i = 0; i < 6; ++i) {
            result.putInt4(crypt[i], i * 4);
        }
        return result.bytes();
    }
}

