/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.comunication.protocol.DataType;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.packet.RequestPacket;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPartNGDB
extends DataPart {
    private int fieldCount = 0;
    private int currentArgCount = 0;
    private int currentFieldCount = 0;
    private int currentPhysicalFieldLen = 0;
    private int currentRecordOffset = 0;
    private DataFormatDescription dataFormat;
    private boolean isCompleteDatatypeSupported;

    public DataPartNGDB(StructuredMem rawMem, RequestPacket requestPacket) throws SQLException {
        super(rawMem, requestPacket);
        this.argCount = 1;
    }

    public DataPartNGDB(StructuredMem rawMem, int argCount, DataFormatDescription format, boolean lastPart, boolean isClosed) throws SQLException {
        super(rawMem, lastPart, isClosed);
        this.dataFormat = format;
        this.argCount = argCount;
        this.isCompleteDatatypeSupported = format.isCompleteDatatypeSupported();
        this.reset();
    }

    public DataPartNGDB(StructuredMem rawMem, int argCount, boolean lastPart, boolean isClosed) throws SQLException {
        super(rawMem, lastPart, isClosed);
        this.argCount = argCount;
    }

    public void setDataFormatDescription(DataFormatDescription dfd) throws SQLException {
        this.dataFormat = dfd;
        this.isCompleteDatatypeSupported = dfd.isCompleteDatatypeSupported();
        this.reset();
    }

    protected void reset() throws SQLException {
        this.extent = 0;
        this.massExtent = 0;
        this.fieldCount = 0;
        this.currentArgCount = 0;
        this.currentRecordOffset = 0;
        this.resetColumn();
        this.initRecord();
    }

    protected void resetColumn() {
        this.currentFieldCount = 0;
        this.currentPhysicalFieldLen = 0;
        this.extent = this.currentRecordOffset;
    }

    protected void initRecord() {
        ++this.currentArgCount;
        this.fieldCount = this.dataFormat.getNumberOfFields();
        this.currentFieldCount = 0;
        this.currentPhysicalFieldLen = 0;
        this.currentRecordOffset = this.extent;
    }

    public boolean nextRow() throws SQLException {
        if (this.currentArgCount >= this.argCount) {
            return false;
        }
        for (int i = this.currentFieldCount; i < this.fieldCount; ++i) {
            this.nextField();
        }
        if (this.currentPhysicalFieldLen > 0) {
            this.extent += this.currentPhysicalFieldLen;
        }
        this.initRecord();
        return true;
    }

    public boolean nextField() throws SQLException {
        if (this.currentFieldCount >= this.fieldCount) {
            return false;
        }
        ++this.currentFieldCount;
        if (this.currentPhysicalFieldLen > 0) {
            this.extent += this.currentPhysicalFieldLen;
        }
        this.currentPhysicalFieldLen = this.getFieldLength();
        return true;
    }

    private int getCurrentFieldLen() {
        return this.currentPhysicalFieldLen;
    }

    public int getCurrentOffset() {
        return this.extent;
    }

    public void addArg(int pos, int len) {
    }

    public void addRow(int fieldCount) {
    }

    public int getFieldLength() throws SQLException {
        switch (this.dataFormat.getDataTypeCode(this.currentFieldCount)) {
            case 1: {
                if (0 == this.mem.getUInt1(this.extent)) {
                    ++this.extent;
                    return -1;
                }
                ++this.extent;
                if (this.isCompleteDatatypeSupported) {
                    return 1;
                }
                return 8;
            }
            case 2: {
                if (0 == this.mem.getUInt1(this.extent)) {
                    ++this.extent;
                    return -1;
                }
                ++this.extent;
                if (this.isCompleteDatatypeSupported) {
                    return 2;
                }
                return 8;
            }
            case 3: {
                if (0 == this.mem.getUInt1(this.extent)) {
                    ++this.extent;
                    return -1;
                }
                ++this.extent;
                if (this.isCompleteDatatypeSupported) {
                    return 4;
                }
                return 8;
            }
            case 64: {
                int val = this.mem.getInt4(this.extent);
                if (val == 86402 || 0 == val) {
                    this.extent += 4;
                    return -1;
                }
                return 4;
            }
            case 63: {
                int val = this.mem.getInt4(this.extent);
                if (val == 3652062 || 0 == val) {
                    this.extent += 4;
                    return -1;
                }
                return 4;
            }
            case 4: {
                if (0 == this.mem.getUInt1(this.extent)) {
                    ++this.extent;
                    return -1;
                }
                ++this.extent;
                return 8;
            }
            case 61: {
                long val = this.mem.getInt8(this.extent);
                if (val == 3155380704000000001L || val == 0L) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 62: {
                long val = this.mem.getInt8(this.extent);
                if (val == 315538070401L || val == 0L) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 5: {
                if (112 == (this.mem.getInt1(this.extent + 15) & 0x70)) {
                    this.extent += 16;
                    return -1;
                }
                return 16;
            }
            case 7: {
                if (-1L == this.mem.getInt8(this.extent)) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 6: {
                if (-1 == this.mem.getInt4(this.extent)) {
                    this.extent += 4;
                    return -1;
                }
                return 4;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 52: 
            case 55: {
                int erg = this.mem.getUInt1(this.extent);
                ++this.extent;
                if (erg > 245) {
                    if (erg == 246) {
                        erg = this.mem.getInt2(this.extent);
                        this.extent += 2;
                    } else if (erg == 247) {
                        erg = this.mem.getInt4(this.extent);
                        this.extent += 4;
                    } else if (erg == 255) {
                        erg = -1;
                    } else {
                        throw SQLExceptionSapDB.generateSQLException("error.internal.illegalFieldLength");
                    }
                }
                return erg;
            }
            case 15: {
                if (this.isCompleteDatatypeSupported) {
                    int timeNull = this.mem.getInt1(this.extent) & 0x80;
                    if (0 == timeNull) {
                        this.extent += 4;
                        return -1;
                    }
                    return 4;
                }
                int dateNull = this.mem.getInt1(this.extent + 1) & 0x80;
                int timeNull = this.mem.getInt1(this.extent + 4) & 0x80;
                if (0 == dateNull && 0 == timeNull) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 14: {
                if (this.isCompleteDatatypeSupported) {
                    byte val = this.mem.getInt1(this.extent + 1);
                    int dateNull = this.mem.getInt1(this.extent + 1) & 0x80;
                    if (0 == dateNull) {
                        this.extent += 4;
                        return -1;
                    }
                    return 4;
                }
                int dateNull = this.mem.getInt1(this.extent + 1) & 0x80;
                int timeNull = this.mem.getInt1(this.extent + 4) & 0x80;
                if (0 == dateNull && 0 == timeNull) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 16: {
                int dateNull = this.mem.getInt1(this.extent + 1) & 0x80;
                int timeNull = this.mem.getInt1(this.extent + 4) & 0x80;
                if (0 == dateNull && 0 == timeNull) {
                    this.extent += 8;
                    return -1;
                }
                return 8;
            }
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 51: 
            case 53: {
                byte nullByte = this.mem.getInt1(this.extent + 1);
                if (nullByte == 1) {
                    this.extent += 2;
                    return -1;
                }
                int chunkLen = this.mem.getInt4(this.extent + 28);
                return 32 + chunkLen;
            }
        }
        throw SQLExceptionSapDB.generateSQLException("error.conversion.sqljava", DataType.stringValuesC[this.dataFormat.getDataTypeCode(this.currentFieldCount)], "unsupported evaluation type");
    }

    public int putBigUnicode(char[] value, int offsetInBytes, int lenInBytes) {
        int vallen = value.length * 2;
        int erg = super.putBigUnicode(value, this.extent, vallen);
        this.extent += vallen;
        return erg;
    }

    public int putBytes(byte[] value, int offset, int len) {
        int vallen = value.length;
        int erg = super.putBytes(value, this.extent, vallen);
        this.extent += vallen;
        return erg;
    }

    public int putBytes(byte[] value, int offset) {
        int len = value.length;
        int erg = super.putBytes(value, this.extent);
        this.extent += len;
        return erg;
    }

    public int putInt1(int value, int offset) {
        int erg = super.putInt1(value, this.extent);
        ++this.extent;
        return erg;
    }

    public int putInt2(int value, int offset) {
        int erg = super.putInt2(value, this.extent);
        this.extent += 2;
        return erg;
    }

    public int putInt4(int value, int offset) {
        int erg = super.putInt4(value, this.extent);
        this.extent += 4;
        return erg;
    }

    public int putInt8(long value, int offset) {
        int erg = super.putInt8(value, this.extent);
        this.extent += 8;
        return erg;
    }

    public int putString(String value, int offset, int length) {
        int len = value.length();
        int result = super.putString(value, this.extent, length);
        this.extent += len;
        return result;
    }

    public int putString(String value, int offset) {
        int len = value.length();
        int result = super.putString(value, this.extent, len);
        this.extent += len;
        return result;
    }

    public int putStringBytes(byte[] value, int offset, int length) {
        int len = value.length;
        int erg = super.putStringBytes(value, this.extent, len);
        this.extent += len;
        return erg;
    }

    public int putUnicodeBytes(byte[] value, int offset, int length) {
        int len = value.length;
        int erg = super.putUnicodeBytes(value, this.extent, len);
        this.extent += len;
        return erg;
    }

    public int putNull(int pos, int len, int datatypecode) {
        switch (datatypecode) {
            case 55: {
                int erg = super.putInt1(136, this.extent);
                ++this.extent;
                this.addArg(pos, len);
                return erg;
            }
            case 61: 
            case 62: {
                int erg = super.putInt1(144, this.extent);
                ++this.extent;
                this.addArg(pos, len);
                return erg;
            }
            case 63: {
                int erg = super.putInt1(142, this.extent);
                ++this.extent;
                this.addArg(pos, len);
                return erg;
            }
            case 64: {
                int erg = super.putInt1(143, this.extent);
                ++this.extent;
                this.addArg(pos, len);
                return erg;
            }
        }
        int erg = super.putInt1(datatypecode + 128, this.extent);
        ++this.extent;
        this.addArg(pos, len);
        return erg;
    }

    public void putDefault(int pos, int len) {
        super.putInt1(253, this.extent);
        ++this.extent;
        this.addArg(pos, len);
    }

    public StructuredMem putDescriptor(int pos, byte[] descriptor) {
        int offset = this.extent + 1;
        if (-1 == this.putBytes(descriptor, this.extent)) {
            return null;
        }
        return this.mem.getPointer(offset);
    }

    public boolean fillWithOMSReader(Reader stream, int rowSize) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithOMSReader");
    }

    public boolean fillWithProcedureReader(Reader reader, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithProcedureReader");
    }

    public boolean fillWithProcedureStream(InputStream stream, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithProcedureStream");
    }

    public void fillWithOMSReturnCode(int returncode) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithOMSReturnCode");
    }

    public boolean fillWithOMSStream(InputStream stream, boolean asciiForUnicode) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithOMSStream");
    }

    public boolean fillWithOMSStream(InputStream stream, short rowCount) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "DataPartVariable", "fillWithOMSStream");
    }

    public void putRawData(byte[] value, int offset) {
        int len = value.length;
        super.putBytes(value, this.extent);
        this.extent += len;
    }

    public void moveRecordPointer(int offset, int recordSize) throws SQLException {
        int destRecord = this.currentArgCount + offset;
        if (destRecord < this.currentArgCount) {
            this.reset();
        }
        while (this.currentArgCount < destRecord && this.nextRow()) {
        }
    }

    public DataPart getRecordPointer() throws SQLException {
        return new DataPartNGDB(this.getPointer(this.extent), this.argCount, this.dataFormat, this.isLastPart(), this.isResultSetClosedOnServer());
    }

    public boolean isNull(SQLParamController controller, int bufpos) throws SQLException {
        this.moveColumnPointer(bufpos);
        boolean erg = this.getCurrentFieldLen() == -1;
        controller.setLastWasNull(erg);
        return erg;
    }

    private void moveColumnPointer(int colindex) {
        try {
            if (colindex < this.currentFieldCount) {
                this.resetColumn();
            } else if (colindex > this.fieldCount) {
                // empty if block
            }
            while (this.currentFieldCount < colindex && this.nextField()) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] getBytesFillUp(int offset, int len) {
        this.moveColumnPointer(offset);
        byte[] erg = new byte[len];
        this.mem.getBytes(erg, this.getCurrentOffset(), this.getCurrentFieldLen());
        return erg;
    }

    public byte[] getBytes(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getBytes(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public StructuredMem getLOBDataPointer(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getPointer(this.getCurrentOffset() + 32);
    }

    public byte getBoolean(int offset) {
        this.moveColumnPointer(offset);
        if (this.getCurrentFieldLen() == 0) {
            return 0;
        }
        return this.mem.getInt1(this.getCurrentOffset());
    }

    public byte getInt1(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt1(this.getCurrentOffset());
    }

    public int getUInt1(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getUInt1(this.getCurrentOffset());
    }

    public int getInt2(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt2(this.getCurrentOffset());
    }

    public int getInt4(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt4(this.getCurrentOffset());
    }

    public long getInt8(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getInt8(this.getCurrentOffset());
    }

    public String getString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public byte[] getStrippedBytes(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedBytes(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public String getStrippedUnicodeString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedUnicodeString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public String getStrippedString(int offset, int len) {
        this.moveColumnPointer(offset);
        return this.mem.getStrippedString(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public char getBigUnicodeChar(int offset) {
        this.moveColumnPointer(offset);
        return this.mem.getBigUnicodeChar(this.getCurrentOffset());
    }

    public char[] getBigUnicode(int offset, int lenInBytes) {
        this.moveColumnPointer(offset);
        return this.mem.getBigUnicode(this.getCurrentOffset(), this.getCurrentFieldLen());
    }

    public int checkDefineByte(SQLParamController controller, DataPart mem, int bufpos) {
        this.moveColumnPointer(bufpos);
        int defByte = this.getCurrentFieldLen();
        switch (defByte) {
            case -1: {
                controller.setLastWasNull(true);
                return 1;
            }
            case -2: {
                controller.setLastWasNull(false);
                return 2;
            }
        }
        controller.setLastWasNull(false);
        return -1;
    }
}

