/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.topology;

import com.sap.db.jdbc.topology.Host;
import com.sap.db.jdbc.topology.System;
import java.io.PrintStream;
import java.util.Iterator;

public class Location {
    private int m_volumeID;
    private Host m_host;
    private String m_tenantName;
    private double m_Loadfactor;
    private boolean isMaster;
    private boolean isStandby;
    private int serviceType;
    private System m_system;
    private boolean isAvailable;

    public Location(int m_volumeID, Host ahost, String m_tenantName, double m_Loadfactor, boolean isMaster, boolean isStandby, int serviceType, System system) {
        this.m_system = system;
        this.m_volumeID = m_volumeID;
        this.m_host = ahost;
        this.m_tenantName = m_tenantName;
        this.m_Loadfactor = m_Loadfactor;
        this.isMaster = isMaster;
        this.isStandby = isStandby;
        this.serviceType = serviceType;
        this.isAvailable = true;
    }

    public int getVolumeID() {
        return this.m_volumeID;
    }

    public Host getPrimarayHostPort() {
        return this.m_host;
    }

    public String getPrimaryHostName() {
        return this.m_host.host;
    }

    public Iterator getHostNames() {
        return this.m_host.hostList.iterator();
    }

    public int getPortNumber() {
        return this.m_host.port;
    }

    public String getTenantName() {
        return this.m_tenantName;
    }

    public double getLoadfactor() {
        return this.m_Loadfactor;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public boolean isStandby() {
        return this.isStandby;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isIndexServer() {
        return this.serviceType == 3;
    }

    public boolean isStatisticServer() {
        return this.serviceType == 4;
    }

    public boolean equals(Object obj) {
        Location loc = (Location)obj;
        return this.m_volumeID == loc.getVolumeID() && this.m_host.equals(loc.getPrimarayHostPort()) && this.m_tenantName.equals(loc.getTenantName()) && this.isMaster == loc.isMaster();
    }

    public boolean isSameTarget(Location host) {
        return this.m_host.equals(host.getPrimarayHostPort());
    }

    public int hashCode() {
        return this.m_host.host.hashCode() * this.m_host.port;
    }

    public String getAsString() {
        return "System=" + (this.m_system == null ? "null" : this.m_system.toString()) + " VolumeID=" + this.m_volumeID + " HostName=" + this.m_host.host + " PortNumber=" + this.m_host.port + " TenantName=" + this.m_tenantName + " Loadfactor=" + this.m_Loadfactor + " isMaster=" + this.isMaster + " serviceType=" + this.serviceType + " isAvailable=" + this.isAvailable;
    }

    public String getAsShortString() {
        return this.m_host.host + ":" + this.m_host.port + " [Volume=" + this.m_volumeID + "]";
    }

    public System getSystem() {
        return this.m_system;
    }

    public void setSystem(System sys) {
        this.m_system = sys;
    }

    public void dump(PrintStream out) {
        out.println(this.getAsString());
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public void setVolumeID(int m_volumeID) {
        this.m_volumeID = m_volumeID;
    }

    public void setTenantName(String m_tenantName) {
        this.m_tenantName = m_tenantName;
    }

    public void setLoadfactor(double m_Loadfactor) {
        this.m_Loadfactor = m_Loadfactor;
    }

    public void update(Location loc) {
        this.m_volumeID = loc.m_volumeID;
        this.m_tenantName = loc.m_tenantName;
        this.m_Loadfactor = loc.m_Loadfactor;
        this.isMaster = loc.isMaster;
        this.m_system = loc.m_system;
        this.isAvailable = loc.isAvailable;
    }
}

