/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.topology;

import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.topology.Host;
import com.sap.db.jdbc.topology.Location;
import com.sap.db.jdbc.topology.System;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.rte.comm.JdbcCommFactory;
import com.sap.db.rte.comm.JdbcCommunication;
import com.sap.db.rte.comm.RTEException;
import com.sap.db.rte.comm.SecureCommunication;
import com.sap.db.rte.comm.SocketComm;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.UniqueID;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;

public class Topology {
    static final String initialSystemID = "unknownSystem";
    public static Random m_random;
    private static UniqueID UniqueID;
    static Hashtable m_systems;

    public static Enumeration getSystems() {
        return m_systems.elements();
    }

    public static int getNumberOfRegisteredSystems() {
        return m_systems.size();
    }

    public static System addSystem(String sid) {
        System erg = Topology.getSystem(sid);
        if (Topology.getSystem(sid) != null) {
            return erg;
        }
        erg = new System(sid);
        m_systems.put(sid, erg);
        return erg;
    }

    public static System getSystem(String sid) {
        return (System)m_systems.get(sid);
    }

    public static System getSystemByHost(Host hostNameAndPort) {
        Enumeration en = m_systems.elements();
        while (en.hasMoreElements()) {
            System sys = (System)en.nextElement();
            Location loc = sys.getLocation(hostNameAndPort);
            if (loc == null) continue;
            return sys;
        }
        return null;
    }

    public static synchronized JdbcCommunication getSession(ArrayList preferedHostList, Properties info, boolean connectionRoutingEnabled, TraceControl mytrc) throws RTEException {
        Location loc;
        JdbcCommFactory factory;
        String transport = Driver.getBooleanProperty(info, "encrypt", false) ? "secure" : info.getProperty("transport", "socket");
        if (transport.equals("socket")) {
            factory = SocketComm.factory;
        } else if (transport.equals("secure")) {
            factory = SecureCommunication.factory;
        } else {
            throw new RTEException(MessageTranslator.translate("error.invalid.transport", transport), -10899, mytrc.tracer, 1);
        }
        StringBuffer errorMsg = new StringBuffer();
        int tryCnt = 0;
        RTEException catchedRTE = null;
        ArrayList<Location> locations = new ArrayList<Location>();
        Iterator iter = preferedHostList.iterator();
        while (iter.hasNext()) {
            Host host = (Host)iter.next();
            loc = new Location(0, host, "", 0.0, false, false, 3, null);
            locations.add(loc);
        }
        System tmpSys = null;
        for (int i = 0; i < preferedHostList.size(); ++i) {
            tmpSys = Topology.getSystemByHost((Host)preferedHostList.get(i));
            if (null == tmpSys) continue;
            tmpSys.getLocationsList(locations, connectionRoutingEnabled);
        }
        Iterator iter2 = locations.iterator();
        while (iter2.hasNext()) {
            loc = (Location)iter2.next();
            try {
                return factory.open(loc, info, mytrc.tracer);
            }
            catch (UnsatisfiedLinkError linkErr) {
                throw new RTEException(MessageTranslator.translate("error.library.notloaded", "jniauthentication", linkErr.toString()), -10899, mytrc.tracer, 1);
            }
            catch (RTEException rteex) {
                if (tryCnt == 0) {
                    errorMsg.append(rteex.getMessage());
                } else {
                    errorMsg.append("host = ");
                    errorMsg.append(loc.getPrimaryHostName() + ":" + loc.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(rteex.getMessage());
                    errorMsg.append("; ");
                }
                loc.setAvailable(false);
                ++tryCnt;
                if (catchedRTE != null) continue;
                catchedRTE = rteex;
            }
            catch (Exception e) {
                if (tryCnt == 0) {
                    errorMsg.append(e.getMessage());
                } else {
                    errorMsg.append("host = ");
                    errorMsg.append(loc.getPrimaryHostName() + ":" + loc.getPortNumber());
                    errorMsg.append(" error = ");
                    errorMsg.append(e.getMessage());
                    errorMsg.append("; ");
                }
                loc.setAvailable(false);
                ++tryCnt;
            }
        }
        if (tryCnt > 1) {
            throw new RTEException("None of the hosts could be reached. [" + errorMsg + "]", mytrc.tracer, 1);
        }
        if (catchedRTE == null) {
            throw new RTEException(errorMsg.toString(), mytrc.tracer, 1);
        }
        throw catchedRTE;
    }

    static {
        UniqueID = new UniqueID();
        m_random = new Random(java.lang.System.currentTimeMillis());
        m_systems = new Hashtable();
    }
}

