/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.VariableDataLengthTranslator;
import com.sap.db.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;

public class BytesTranslator
extends VariableDataLengthTranslator {
    BytesTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (this.isNull(controller, mem)) {
            return 0;
        }
        result = mem.getBytes(this.bufpos_output, 1);
        return result[0];
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getBytes(this.bufpos_output, this.logicalLength);
        }
        return result;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBytes(controller, mem);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] rawResult = this.getBytes(controller, mem);
        String result = rawResult == null ? null : new String(rawResult);
        return result;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        String clazzName;
        Object result = null;
        Class<?> clazz = obj.getClass();
        if (clazz.isArray() && (clazzName = clazz.getName()).equals("[B")) {
            result = this.transBytesForInput((byte[])obj);
        }
        return result;
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        byte[] asBytes = this.getBytes(controller, mem);
        if (asBytes == null) {
            return null;
        }
        ByteArrayInputStream result = new ByteArrayInputStream(asBytes);
        return result;
    }
}

