/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.DBTechTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.TimestampTranslator;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class Date2Translator
extends TimestampTranslator {
    public Date2Translator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public Date2Translator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out);
    }

    public Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date result = null;
        if (!this.isNull(controller, mem)) {
            byte[] buffer = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte day = buffer[3];
            byte month = buffer[2];
            int year = buffer[0] & 0xFF | buffer[1] << 8 & 0xFF00;
            if ((year & 0x8000) != 0) {
                year &= Short.MAX_VALUE;
            }
            if ((year & 0x4000) != 0) {
                year |= 0x8000;
            }
            if (cal == null) {
                result = new Date(year - 1900, month, day);
            } else {
                cal.clear();
                cal.set(year, month, day, 0, 0, 0);
                result = DBTechTranslator.CalendarUtil.getDateFromCalendar(cal);
            }
        }
        return result;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Date dateValue = this.getDate(controller, mem, cal);
        if (dateValue == null) {
            return null;
        }
        return new Timestamp(dateValue.getTime());
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Date dateVal = Date.valueOf(val);
            return this.transDateForInput(dateVal, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.generateSQLException("error.invalid.argumentvalue", val);
        }
    }

    public int getPrecision() {
        return 10;
    }
}

