/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataPart;
import com.sap.db.jdbc.translators.NumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DoubleTranslator
extends NumericTranslator {
    DoubleTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, frac, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public BigDecimal getBigDecimal(int scale, SQLParamController controller, DataPart mem) throws SQLException {
        return this.getBigDecimal(controller, mem);
    }

    public BigDecimal getBigDecimal(SQLParamController controller, DataPart mem) throws SQLException {
        BigDecimal result = null;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        double val = this.getDouble(controller, mem);
        result = BigDecimal.valueOf(val);
        return result;
    }

    public boolean getBoolean(SQLParamController controller, DataPart mem) throws SQLException {
        double val = this.getDouble(controller, mem);
        return val != 0.0;
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        return (byte)this.getDouble(controller, mem);
    }

    public double getDouble(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NaN;
            }
        }
        byte[] buffer = mem.getBytes(this.bufpos_output, 8);
        double value = Double.longBitsToDouble((long)buffer[0] & 0xFFL | (long)buffer[1] << 8 & 0xFF00L | (long)buffer[2] << 16 & 0xFF0000L | (long)buffer[3] << 24 & 0xFF000000L | (long)buffer[4] << 32 & 0xFF00000000L | (long)buffer[5] << 40 & 0xFF0000000000L | (long)buffer[6] << 48 & 0xFF000000000000L | (long)buffer[7] << 56 & 0xFF00000000000000L);
        return value;
    }

    public float getFloat(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return Float.NaN;
            }
        }
        return (float)this.getDouble(controller, mem);
    }

    public int getInt(SQLParamController controller, DataPart mem) throws SQLException {
        return (int)this.getDouble(controller, mem);
    }

    public long getLong(SQLParamController controller, DataPart mem) throws SQLException {
        long result = 0L;
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return result;
            }
            case 2: {
                throw SQLExceptionSapDB.generateSQLException("error.conversion.SpecialNullValue");
            }
        }
        return (long)this.getDouble(controller, mem);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        if (this.isNull(controller, mem)) {
            return null;
        }
        return new Double(this.getDouble(controller, mem));
    }

    public int getPrecision() {
        return this.logicalLength;
    }

    public short getShort(SQLParamController controller, DataPart mem) throws SQLException {
        return (short)this.getDouble(controller, mem);
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            result = this.transBigDecimalForInput((BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            result = this.transBooleanForInput((Boolean)obj);
        } else if (obj instanceof Byte) {
            result = this.transByteForInput((Byte)obj);
        } else if (obj instanceof Double) {
            result = this.transDoubleForInput((Double)obj);
        } else if (obj instanceof Float) {
            result = this.transFloatForInput(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            result = this.transIntForInput((Integer)obj);
        } else if (obj instanceof Long) {
            result = this.transLongForInput((Long)obj);
        } else if (obj instanceof Short) {
            result = this.transShortForInput((Short)obj);
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.checkDefineByte(controller, mem)) {
            case 1: {
                return null;
            }
            case 2: {
                return "NaN";
            }
        }
        return String.valueOf(this.getDouble(controller, mem));
    }

    private static boolean isNull(byte[] buffer) {
        return buffer[0] == -1 && buffer[1] == -1 && buffer[2] == -1 && buffer[3] == -1 && buffer[4] == -1 && buffer[5] == -1 && buffer[6] == -1 && buffer[7] == -1;
    }
}

