/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.translators.AbstractSimpleGetval;
import com.sap.db.util.MessageTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class GetvalChar
extends AbstractSimpleGetval
implements Clob {
    String data;

    public GetvalChar(String datavalue) {
        this.data = datavalue;
    }

    public long length() throws SQLException {
        return this.data.length();
    }

    public String getSubString(long pos, int length) throws SQLException {
        if ((long)length + pos - 1L > (long)this.data.length()) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(pos)));
        }
        String erg = null;
        try {
            erg = this.data.substring((int)pos - 1, (int)pos - 1 + length);
        }
        catch (Exception e) {
            throw new SQLException(MessageTranslator.translate("error.invalid.blob.position", String.valueOf(pos)));
        }
        return erg;
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.data);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(this.data);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (start > Integer.MAX_VALUE || start < 1L) {
            throw SQLExceptionSapDB.generateSQLException("error.valueoverflow", new Integer(2));
        }
        long erg = this.data.indexOf(searchstr, (int)start - 1);
        return erg == -1L ? -1L : erg + 1L;
    }

    public long position(Clob lob, long start) throws SQLException {
        String val = lob.getSubString(1L, (int)lob.length());
        return this.position(val, start);
    }
}

