/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.translators.FixedDataLengthTranslator;

public abstract class NumericTranslator
extends FixedDataLengthTranslator {
    int fraction = 0;

    protected NumericTranslator(int mode, int ioType, int dataType, int len, int frac, int ioLen, int bufposIn, int bufposOut, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufposIn, bufposOut, readOnly, autoIncre);
        this.fraction = frac;
    }

    protected static long parseLong(byte[] buffer, int offset) {
        return (long)buffer[offset] & 0xFFL | (long)buffer[offset + 1] << 8 & 0xFF00L | (long)buffer[offset + 2] << 16 & 0xFF0000L | (long)buffer[offset + 3] << 24 & 0xFF000000L | (long)buffer[offset + 4] << 32 & 0xFF00000000L | (long)buffer[offset + 5] << 40 & 0xFF0000000000L | (long)buffer[offset + 6] << 48 & 0xFF000000000000L | (long)buffer[offset + 7] << 56 & 0xFF00000000000000L;
    }

    public int getScale() {
        switch (this.dataType) {
            case 5: {
                return this.fraction == Short.MAX_VALUE ? 0 : this.fraction;
            }
        }
        return this.fraction;
    }

    public int getColumnDisplaySize() {
        switch (this.dataType) {
            case 1: {
                return new Byte(127).toString().length();
            }
            case 2: {
                return new Short(Short.MAX_VALUE).toString().length();
            }
            case 3: {
                return new Integer(Integer.MAX_VALUE).toString().length();
            }
            case 4: {
                return new Long(Long.MAX_VALUE).toString().length();
            }
            case 6: {
                return new Float(Float.MAX_VALUE).toString().length();
            }
            case 7: {
                return new Double(Double.MAX_VALUE).toString().length();
            }
            case 5: {
                return this.logicalLength + 1 + (this.fraction > 0 ? 1 : 0) + (this.logicalLength < this.fraction ? 1 : 0);
            }
        }
        return this.logicalLength;
    }
}

